#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/chan.c,v 1.18 89/09/02 02:35:46 mr-frog Exp $";
#endif /* not lint */

/*
 * chan.c
 *
 * change rep name et al.
 *
 * from PSL Empire, 1985
 */

#include <ctype.h>
#include "misc.h"
#include "player.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "news.h"

chan()
{
	s_char	*temp;
	struct	natstr *natp;
	register s_char *p;
	natid	cn;
	int	charge;
	int	nonb;
	int	btucost;
	s_char	buf[1024];
	struct	natstr *us;

	if ((p = getstarg(player->argp[1], "country name or representative? ", buf)) == 0)
		return RET_SYN;
	us = getnatp(player->cnum);
	switch (*p) {
	case 'c':
		charge = 0;
		btucost = 0;
		if (!player->god && (us->nat_stat & STAT_NORM)) {
			if (us->nat_btu < 254) {
				pr("You need 254 btus to change your country name!\n");
				return RET_FAIL;
			}
#ifndef BLITZ
			pr("Warning, this command costs 254 BTU's and 10% of your money.\n");
			charge = 2000;
			btucost = 254;
			if (us->nat_money < charge*10)
				charge = us->nat_money / 10;
			if (us->nat_money < 0)
				charge = 0;
#endif /* BLITZ */
		}
		if ((p = getstarg(player->argp[2], "New country name -- ", buf)) == 0)
			return RET_SYN;
		p[sizeof(us->nat_cnam)-1] = 0;
		for (cn = 0; natp = getnatp(cn); cn++) {
			if (same(p, natp->nat_cnam)) {
				pr("Country #%d is already called `%s'!\n",
					cn, p);
				return RET_FAIL;
			}
		}
		nonb = 0;
		for (temp = p; *temp != '\0'; temp++) {
			if (iscntrl(*temp)) {
				pr("No control characters allowed in country names!\n");
				return RET_FAIL;
			} else if (*temp != ' ')
				nonb = 1;
		}
		if (!nonb) {
			pr("Must have a non-blank name!\n");
			return RET_FAIL;
		}
#ifndef BLITZ
		player->dolcost += charge;
		player->btused += btucost;
#endif /* BLITZ */
		strcpy(us->nat_cnam, p);
		putnat(us);
		nreport(player->cnum, N_NAME_CHNG, 0, 1);
		break;
	case 'r':
		pr("(note: these are stored in plain text.)\n");
		if ((p = getstarg(player->argp[2],
			"New representative name -- ", buf)) == 0)
			return RET_SYN;
		p[8] = 0;
		strcpy(us->nat_pnam, p);
		putnat(us);
		break;
	default:
		pr("Only \"country\" or \"representative\" can change.\n");
		return RET_SYN;
	}
	return RET_OK;
}

