#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/carg.c,v 1.7 89/07/30 08:24:32 jeffw Exp $";
#endif /* not lint */

/*
 * carg.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "land.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"
#include "deity.h"

carg()
{
	int	nships;
	struct	nstr_item ni;
	struct	shpstr ship;
	int	vec[I_MAX+1];

	if (!snxtitem(&ni, EF_SHIP, player->argp[1]))
		return RET_SYN;
	nships = 0;
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_own == 0)
			continue;
		if ((player->cnum != ship.shp_own) && !player->god)
			continue;
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr("bad ship type %d (#%d)\n", ship.shp_type,
			       ni.cur);
			continue;
		}
		if (nships++ == 0)
			pr("shp# ship type           x,y   flt  eff  sh gun pet irn dst bar oil lcm hcm rad\n");
		pr("%4d ", ni.cur);
		pr("%-16.16s ", mchr[ship.shp_type].m_name);
		prxy("%4d,%-4d ", ship.shp_x, ship.shp_y, player->cnum);
		pr(" %1c", ship.shp_fleet);
		pr("%4d%%", ship.shp_effic);
		getvec(VT_ITEM, vec, (s_char *)&ship, EF_SHIP);
		pr("%4d", vec[I_SHELL]);
		pr("%4d", vec[I_GUN]);
		pr("%4d", vec[I_PETROL]);
		pr("%4d", vec[I_IRON]);
		pr("%4d", vec[I_DUST]);
		pr("%4d", vec[I_BAR]);
		pr("%4d", vec[I_OIL]);
		pr("%4d", vec[I_LCM]);
		pr("%4d", vec[I_HCM]);
		pr("%4d\n", vec[I_RAD]);
#ifdef	SHIPNAMES
		if (ship.shp_name[0] != 0) {
			pr("       %s\n",ship.shp_name);
		}
#endif	SHIPNAMES
	}
	if (nships == 0) {
		if (player->argp[1])
			pr("%s: No ship(s)\n", player->argp[1]);
		else
			pr("No ship(s)\n");
	}
	if (nships == 0) {
		if (player->argp[1])
			pr("%s: No ship(s)\n", player->argp[1]);
		else
			pr("%s: No ship(s)\n", "");
		return RET_FAIL;
	}else
       		pr("%d ship%s\n", nships, splur(nships));
	return RET_OK;
}

lcarg()
{
	int	nunits;
	struct	nstr_item ni;
	struct	lndstr land;
	int	vec[I_MAX+1];

	if (!snxtitem(&ni, EF_LAND, player->argp[1]))
		return RET_SYN;
	nunits = 0;
	while (nxtitem(&ni, (s_char *)&land)) {
		if ((player->cnum != land.lnd_own) && !player->god)
			continue;
		if (land.lnd_type < 0 || land.lnd_type > shp_maxno) {
			pr("bad unit type %d (#%d)\n", land.lnd_type,
			       ni.cur);
			continue;
		}
		if (nunits++ == 0)
			pr("lnd# unit type           x,y    a   eff  sh gun pet irn dst bar oil lcm hcm rad\n");
		pr("%4d ", ni.cur);
		pr("%-16.16s ", lchr[land.lnd_type].l_name);
		prxy("%4d,%-4d ", land.lnd_x, land.lnd_y, player->cnum);
		pr(" %1c", land.lnd_army);
		pr("%4d%%", land.lnd_effic);
		getvec(VT_ITEM, vec, (s_char *)&land, EF_LAND);
		pr("%4d", vec[I_SHELL]);
		pr("%4d", vec[I_GUN]);
		pr("%4d", vec[I_PETROL]);
		pr("%4d", vec[I_IRON]);
		pr("%4d", vec[I_DUST]);
		pr("%4d", vec[I_BAR]);
		pr("%4d", vec[I_OIL]);
		pr("%4d", vec[I_LCM]);
		pr("%4d", vec[I_HCM]);
		pr("%4d\n", vec[I_RAD]);
	}
	if (nunits == 0) {
		if (player->argp[1])
			pr("%s: No unit(s)\n", player->argp[1]);
                else
			pr("No unit(s)\n");
		return RET_FAIL;
	}else
		pr("%d unit%s\n", nunits, splur(nunits));
	return RET_OK;
}
