#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/buil.c,v 1.32 89/09/17 21:58:04 mr-frog Exp $";
#endif /* not lint */

/*
 * buil.c
 *
 * version 3.0
 * build ships, nukes, bridges, planes, land units.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "retreat.h"
#include "ship.h"
#include "land.h"
#include "nuke.h"
#include "plane.h"
#include "xy.h"
#include "nsc.h"
#include "treaty.h"
#include "deity.h"
#include "file.h"
#include "path.h"

static	int build_nuke();
static	int build_ship();
static	int build_land();
static	int build_bridge();
static	int build_plane();

static	int cash;	/* static ok */

/*
 * build <WHAT> <SECTS> <TYPE|DIR|MEG> [NUMBER]
 */
buil()
{
	extern  double buil_bt;
	struct	sctstr sect;
	struct	nstr_sect nstr;
	struct	natstr *natp;
	int	rqtech;
	int	tlev;
#ifdef DRNUKE
	int	rlev;
#endif /* DRNUKE */
	int	n;
	int	type;
	int	what;
	struct	lchrstr *lp;
	struct	mchrstr *mp;
	struct	plchrstr *pp;
	struct	nchrstr *np;
	s_char	*p;
	int	vec[I_MAX+1];
	s_char	*buildtech;
	int	gotsect = 0;
	int	built;
	int	hold,found,number=1,x;
#ifdef DRNUKE
	extern	float drnuke_const;
#endif /* DRNUKE */
	s_char	buf[1024];

	natp = getnatp(player->cnum);
	if ((p = getstarg(player->argp[1], "Build (ship, nuke, bridge, plane, land unit)? ", buf)) == 0)
		return RET_SYN;
	what = *p;
	buildtech = player->argp[4];

	if (player->argp[5])
		number=atoi(player->argp[5]);

for(x=0;x<number;x++){
	if (!snxtsct(&nstr, player->argp[2])) {
		pr("Bad sector specification.\n");
		return RET_SYN;
	}
ask_again:
	tlev = (int) natp->nat_level[NAT_TLEV];
#ifdef DRNUKE
	rlev = (int) natp->nat_level[NAT_RLEV];
#endif /* DRNUKE */
	switch (what) {
	case 'p':
		p = getstarg(player->argp[3], "Plane type? ", buf);
		if (p == 0 || *p == 0)
			return RET_SYN;
		n = strlen(p);
		for (found=0,type=0,pp=plchr; type <= pln_maxno; type++,pp++) {
			if (pp->pl_tech > tlev)
				continue;
			if(pp->pl_name && strncmp(p, pp->pl_name, n) == 0) {
				found++;
				hold = type;
				break;
			}
		}
		if (found != 1) {
			pr("Possible plane types are:\n");
			show_plane_build (tlev);
			player->argp[3] = 0;
			goto ask_again;
		}
		type = hold;
		pp = &(plchr[type]);
		rqtech = pp->pl_tech;
		break;
	case 's':
		p = getstarg(player->argp[3], "Ship type? ", buf);
		if (p == 0 || *p == 0)
			return RET_SYN;
		n = strlen(p);
		for (found=0,mp=mchr,type=0; type <= shp_maxno; type++, mp++) {
			if (mp->m_tech > tlev)
				continue;
			if(mp->m_name && strncmp(p, mp->m_name, n) == 0) {
				found++;
				hold = type;
				break;
			}
		}
		if (found != 1) {
			pr("Possible ship types are:\n");
			show_ship_build (tlev);
			player->argp[3] = 0;
			goto ask_again;
		}
		type = hold;
		mp = &(mchr[type]);
		rqtech = mp->m_tech;
		break;
	case 'l':
		p = getstarg(player->argp[3], "Land unit type? ", buf);
		if (p == 0 || *p == 0)
			return RET_SYN;
		n = strlen(p);
		for (found=0,lp=lchr,type=0; type <= lnd_maxno; type++, lp++) {
			if (lp->l_tech > tlev)
				continue;
			if(lp->l_name && strncmp(p, lp->l_name, n) == 0) {
				found++;
				hold = type;
				break;
			}
		}
		if (found != 1) {
			pr("Possible land unit types are:\n");
			show_land_build (tlev);
			player->argp[3] = 0;
			goto ask_again;
		}
		type = hold;
		lp = &(lchr[type]);
		rqtech = lp->l_tech;
		break;
	case 'b':
		if (natp->nat_level[NAT_TLEV]+0.005 < buil_bt) {
			pr("Building a span requires a tech of %.0f\n",
				buil_bt);
			return 2;
		}
		break;
	case 'n':
		player->argp[3] = p = getstarg(player->argp[3], "Nuke type? ", buf);
		if (p == 0 || *p == 0)
			return RET_SYN;
		n = strlen(p);
		for (found=0,np=nchr,type=0; type < N_MAXNUKE; type++, np++) {
#ifdef DRNUKE
                        if ((np->n_tech > tlev) || ((np->n_tech*drnuke_const) > rlev))
#else
			if (np->n_tech > tlev)
#endif /* DRNUKE */
				continue;
			if(np->n_name && strncmp(p, np->n_name, n) == 0) {
				found++;
				hold = type;
				break;
			}
		}
		if (found != 1) {
			int	tt;
			pr("Possible nuke types are:\n");
#ifdef DRNUKE
			tt = (tlev < (rlev/drnuke_const) ? (int)tlev :
				(int)(rlev/drnuke_const));

			show_nuke_build(tt);
#else
			show_nuke_build(tlev);
#endif /* DRNUKE */
			player->argp[3] = 0;
			goto ask_again;
		}
		type = hold;
		np = &(nchr[type]);
		rqtech = np->n_tech;
		break;
	default:
		pr("You can't build that!\n");
		return RET_FAIL;
	}
	if (what != 'b' && what != 'n') {
		s_char bstr[45];
		(void) sprintf(bstr,"Build at what tech (%d)? ",
			(int) natp->nat_level[NAT_TLEV]);
		p = getstarg(buildtech, bstr, buf);
		if (p == 0)
			return RET_FAIL;
		if (*p != '\0') {
			tlev = atopi(p);
			if (tlev > natp->nat_level[NAT_TLEV] && !player->god) {
				pr("Your tech level is only %d.\n",
					(int)natp->nat_level[NAT_TLEV]);
				buildtech = (s_char *)0;
				tlev = 0;
				goto ask_again;
			}
			if (rqtech > tlev) {
				pr("Required tech is %d.\n",rqtech);
				buildtech = (s_char *)0;
				tlev = 0;
				goto ask_again;
			}
			pr("building with tech level %d.\n", tlev);
		}else
			tlev = (int)natp->nat_level[NAT_TLEV];
	}
	cash = natp->nat_money;
	while (nxtsct(&nstr, &sect)) {
		gotsect++;
		if (!player->owner)
			continue;
		if (sect.sct_effic < 60 && !player->god)
			continue;
		getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		switch (what) {
		case 'l':
			built = build_land(&sect, lp, vec, tlev);
			break;
		case 's':
			built = build_ship(&sect, mp, vec, tlev);
			break;
		case 'b':
			built = build_bridge(&sect, vec);
			break;
		case 'n':
			built = build_nuke(&sect, np, vec);
			break;
		case 'p':
			built = build_plane(&sect, pp, vec, tlev);
			break;
		default:
			pr("internal error in build (%d)\n", what);
			return RET_FAIL;
		}
		if (built) {
			putvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
			putsect(&sect);
		}
	}
}
	if (!gotsect) {
		pr("Bad sector specification.\n");
	}
	return RET_OK;
}

static int
build_ship(sp, mp, vec, tlev)
	register struct sctstr *sp;
	register struct mchrstr *mp;
	register int *vec;
	int	tlev;
{
	struct	shpstr ship;
	struct	nstr_item nstr;
	int	cost, i;
	int	w_p_eff,x;
	float	eff=((float)SHIP_MINEFF/100.0);
	int	points, lcm, hcm;
	int	freeship = 0;

	hcm = roundavg(((double)mp->m_hcm * (double)eff));
	lcm = roundavg(((double)mp->m_lcm * (double)eff));

	if (sp->sct_type != SCT_HARBR)
		return 0;

	if (vec[I_LCM] < lcm || vec[I_HCM] < hcm) {
		pr("Not enough materials in %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum));
		return 0;
	}
	w_p_eff = (mp->m_lcm + (mp->m_hcm * 2));
	points = sp->sct_avail * 100 / w_p_eff;
	if (points < SHIP_MINEFF) {
		pr("Not enough available work in %s to build a %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum), mp->m_name);
		pr(" (%d available work required)\n",
			1 + (w_p_eff * SHIP_MINEFF)/100);
		return 0;
	}
	cost = mp->m_cost * eff;
	if (cash < cost) {
		pr("Not enough money left to build a %s\n", mp->m_name);
		return 0;
	}
	if (!trechk(player->cnum, 0, NEWSHP))
		return 0;
	sp->sct_avail = (sp->sct_avail * 100 - w_p_eff * SHIP_MINEFF) / 100;
	player->dolcost += cost;
	cash -= cost;
	snxtitem_all(&nstr, EF_SHIP);
	while (nxtitem(&nstr, (s_char *)&ship)) {
		if (ship.shp_own == 0) {
			freeship++;
			break;
		}
	}
	if (freeship == 0) {
		ef_extend(EF_SHIP, 50);
	}
	ship.shp_x = sp->sct_x;
	ship.shp_y = sp->sct_y;
        ship.shp_destx[0] = sp->sct_x;
        ship.shp_desty[0] = sp->sct_y;
        ship.shp_destx[1] = sp->sct_x;
        ship.shp_desty[1] = sp->sct_y;
        ship.shp_autonav = 0;
/* new code for autonav, Chad Zabel 1-15-94 */
	for (i=0;i<TMAX;++i) {
		ship.shp_tstart[i] = ' ';
		ship.shp_tend[i]   = ' ';
		ship.shp_lstart[i] = 0;
		ship.shp_lend[i]   = 0;
	}
	ship.shp_mission = 0;
	ship.shp_own = player->cnum;
	ship.shp_type = mp - mchr;
	ship.shp_effic = SHIP_MINEFF;
	ship.shp_mobil = 0;
	ship.shp_uid = nstr.cur;
	ship.shp_nplane = 0;
	ship.shp_nland = 0;
	ship.shp_nxlight = 0;
	ship.shp_nchoppers = 0;
	ship.shp_fleet = ' ';
	ship.shp_nv = 0;
	ship.shp_sell = 0;
	ship.shp_tech = tlev;
#ifdef	SAIL
	ship.shp_mobquota = 0;
	*ship.shp_path = 0;
	ship.shp_follow = nstr.cur;
#endif	SAIL
#ifdef	SHIPNAMES
	ship.shp_name[0] = 0;
#endif	SHINAMES
#ifdef TRADESHIPS
	ship.shp_orig_own = player->cnum;
	ship.shp_orig_x = sp->sct_x;
	ship.shp_orig_y = sp->sct_y;
#endif /* TRADESHIPS */
#ifdef FUEL
	ship.shp_fuel = mchr[ship.shp_type].m_fuelc;
#endif /* FUEL */
	ship.shp_rflags = 0;
	for(x=0;x<10;x++)
		ship.shp_rpath[x]=0;

	vec[I_LCM] -= lcm;
	vec[I_HCM] -= hcm;

	if (getvar(V_PSTAGE, (s_char *)sp, EF_SECTOR) == PLG_INFECT)
		putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&ship, EF_SHIP);
	putship(ship.shp_uid, &ship);
	pr("%s #%d", mp->m_name, nstr.cur);
	pr(" built in sector %s\n", xyas(sp->sct_x, sp->sct_y, player->cnum));
	return 1;
}

static int
build_land(sp, lp, vec, tlev)
	register struct sctstr *sp;
	register struct lchrstr *lp;
	register int *vec;
	int	tlev;
{
	extern  double eatrate;
	extern	int etu_per_update;
	int	food_needed;
	struct	lndstr land;
	struct	nstr_item nstr;
	int	cost;
	int	w_p_eff;
	int	points;
	int	lvec[I_MAX+1], max_amt;
	struct  natstr *natp;
	float	eff=((float)LAND_MINEFF/100.0);
	double	techfact();
	int	mil, lcm, hcm, gun, shell;
	int	freeland = 0;

	mil = roundavg(((double)lp->l_mil * (double)eff));
	gun = roundavg(((double)lp->l_gun * (double)eff));
	shell = roundavg(((double)lp->l_shell * (double)eff));
	hcm = roundavg(((double)lp->l_hcm * (double)eff));
	lcm = roundavg(((double)lp->l_lcm * (double)eff));

	natp = getnatp(player->cnum);

	if (sp->sct_type != SCT_HEADQ)
		return 0;
	if (sp->sct_effic < 60)
		return 0;

	if (vec[I_LCM] < lcm || vec[I_HCM] < hcm) {
		pr("Not enough materials in %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum));
		return 0;
	}
	if (vec[I_SHELL] < shell){
		pr("Not enough shells in %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum));
		return 0;
	}
	if (vec[I_GUN] < gun){
		pr("Not enough guns in %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum));
		return 0;
	}
	if (vec[I_MILIT] < mil){
		pr("Not enough military in %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum));
		return 0;
	}
	w_p_eff = (lp->l_lcm + (lp->l_hcm * 2));
	points = sp->sct_avail * 100 / w_p_eff;
	if (points < LAND_MINEFF) {
		pr("Not enough available work in %s to build a %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum), lp->l_name);
		pr(" (%d available work required)\n",
			1 + (w_p_eff * LAND_MINEFF)/100);
		return 0;
	}
	cost = ((float)lp->l_cost * eff);
	if (cash < cost) {
		pr("Not enough money left to build a %s\n", lp->l_name);
		return 0;
	}
	sp->sct_avail = (sp->sct_avail * 100 - w_p_eff * LAND_MINEFF) / 100;
	player->dolcost += cost;
	cash -= cost;
	snxtitem_all(&nstr, EF_LAND);
	while (nxtitem(&nstr, (s_char *)&land)) {
		if (land.lnd_own == 0) {
			freeland++;
			break;
		}
	}
	if (freeland == 0) {
		ef_extend(EF_LAND, 50);
	}
	land.lnd_x = sp->sct_x;
	land.lnd_y = sp->sct_y;
	land.lnd_own = player->cnum;
	land.lnd_mission = 0;
	land.lnd_type = lp - lchr;
	land.lnd_effic = LAND_MINEFF;
	land.lnd_mobil = 0;
	land.lnd_sell = 0;
	land.lnd_tech = tlev;
	land.lnd_uid = nstr.cur;
	land.lnd_army = ' ';
	land.lnd_spare = 0;
	land.lnd_ship = -1;
	land.lnd_harden = 0;
	land.lnd_retreat = 75 - (int)natp->nat_level[NAT_HLEV];
	if (land.lnd_retreat < 0)
		land.lnd_retreat = 0;
#ifdef FUEL
	land.lnd_fuel = lp->l_fuelc;
#endif /* FUEL */
	land.lnd_nxlight = 0;
	land.lnd_rflags = 0;
	bzero(land.lnd_rpath,10);
	land.lnd_rad_max = lp->l_rad;
	land.lnd_nv = 0;
	vec[I_LCM] -= lcm;
	vec[I_HCM] -= hcm;
	vec[I_MILIT] -= mil;
	vec[I_GUN] -= gun;
	vec[I_SHELL] -= shell;

	max_amt = vl_find(V_FOOD, lp->l_vtype, lp->l_vamt, (int) lp->l_nv);
	food_needed = (etu_per_update * eatrate) *
		(vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW])+1;
	if ((vec[I_FOOD]-max_amt) < food_needed)
		max_amt = (vec[I_FOOD]-food_needed);

	if (max_amt < 0)
		max_amt = 0;

	vec[I_FOOD] -= max_amt;

	bzero(lvec, sizeof(lvec));
	getvec(VT_ITEM, lvec, (s_char *)&land, EF_LAND);
	lvec[I_FOOD] += max_amt;
	putvec(VT_ITEM, lvec, (s_char *)&land, EF_LAND);

	if (getvar(V_PSTAGE, (s_char *)sp, EF_SECTOR) == PLG_INFECT)
		putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&land, EF_LAND);
	putland(nstr.cur, &land);
	pr("%s #%d", lp->l_name, nstr.cur);
	pr(" built in sector %s\n", xyas(sp->sct_x, sp->sct_y, player->cnum));
	return 1;
}

static
int
build_bridge(sp, vec)
	register struct sctstr *sp;
	register int *vec;
{
	extern  int buil_bh;
	extern	double buil_bc;
	struct	sctstr sect;
	int	val;
	int	newx, newy;
	int	w_p_eff;
	int	points;

#ifndef EASY_BRIDGES
	if (sp->sct_type != SCT_BHEAD)
		return 0;
	if (sp->sct_newtype != SCT_BHEAD)
		return 0;
#else
        int     nx,ny,i,j,good=0,nx2,ny2;

        for (i = 1; i <= 6; i++) {
                struct sctstr s2;
                nx = sp->sct_x + diroff[i][0];
                ny = sp->sct_y + diroff[i][1];
                getsect(nx, ny, &sect);
        	for (j = 1; j <= 6; j++) {
                	nx2 = sect.sct_x + diroff[j][0];
                	ny2 = sect.sct_y + diroff[j][1];
                	getsect(nx2, ny2, &s2);
                	if ((s2.sct_type != SCT_WATER) && (s2.sct_type != SCT_BSPAN))
                        	good=1;
        	}

        }

	if (!good){
		pr("Bridges must be built adjacent to land.\n");
		pr("No eligible sectors adjacent to this sector.\n");
		return 0;
	}
#endif /* EASY_BRIDGES */
	if (vec[I_HCM] < buil_bh) {
		pr("%s only has %d unit%s of hcm,\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum),
			vec[I_HCM], vec[I_HCM] > 1 ? "s" : "");
		pr("(a bridge span requires %d)\n", buil_bh);
		return 0;
	}
	if (cash < buil_bc) {
		pr("A span costs $%f to build; ", buil_bc);
		pr("you only have %d.\n", cash);
		return 0;
	}
	w_p_eff = buil_bh * 2;
	points = sp->sct_avail * 100 / w_p_eff;
	if (points < 20) {
		pr("Not enough available work in %s to build a bridge\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum));
		pr(" (%d available work required)\n",
			1 + (w_p_eff * 20)/100);
		return 0;
	}
	pr("Bridge head at %s; ", xyas(sp->sct_x, sp->sct_y, player->cnum));
	if ((val = getdir("build span in what direction? ",
		(s_char *)0, (s_char *)0, (s_char *)0)) <= 0)
		return 0;
	newx = sp->sct_x + diroff[val][0];
	newy = sp->sct_y + diroff[val][1];
	if (getsect(newx, newy, &sect) == 0 || sect.sct_type != SCT_WATER) {
		pr("%s is not a water sector\n",
			xyas(newx, newy, player->cnum));
		return 0;
	}
#ifdef EASY_BRIDGES
        good=0;

        for (i = 1; i <= 6; i++) {
                struct sctstr s2;
                nx = sect.sct_x + diroff[i][0];
                ny = sect.sct_y + diroff[i][1];
                getsect(nx, ny, &s2);
                if ((s2.sct_type != SCT_WATER) && (s2.sct_type != SCT_BSPAN))
                        good=1;
        }
	if (!good){
		pr("Bridges must be built adjacent to land.\n");
		pr("That sector is not adjacent to land.\n");
		return 0;
	}
#endif /* EASY_BRIDGES */
	sp->sct_avail = (sp->sct_avail * 100 - w_p_eff * 20) / 100;
	player->dolcost += buil_bc;
	cash -= buil_bc;
	sect.sct_type = SCT_BSPAN;
	sect.sct_newtype = SCT_BSPAN;
	sect.sct_effic = 20;
	sect.sct_effic = 20;
	putvar(V_MINE,0,(s_char *)&sect,EF_SECTOR);
	putsect(&sect);
	pr("Bridge span built over %s\n",
		xyas(sect.sct_x, sect.sct_y, player->cnum));
	vec[I_HCM] -= buil_bh;
	return 1;
}

static
int
build_nuke(sp, np, vec)
	register struct sctstr *sp;
	register struct nchrstr *np;
	register int *vec;
{
	int	val;
	struct	nukstr nuke;
	struct	nstr_item nstr;
	int	old;
	int	free;
	int	w_p_eff;
	int	points;

	if (sp->sct_type != SCT_NUKE && !player->god)
		return 0;
	if (vec[I_HCM] < np->n_hcm || vec[I_LCM] < np->n_lcm ||
	    vec[I_OIL] < np->n_oil || vec[I_RAD] < np->n_rad) {
		pr("Not enough materials for a %s bomb in %s\n",
			np->n_name, xyas(sp->sct_x, sp->sct_y, player->cnum));
		pr("(%d hcm, %d lcm, %d oil, & %d rads).\n",
			np->n_hcm, np->n_lcm, np->n_oil, np->n_rad);
		return 0;
	}
	if (cash < np->n_cost) {
		pr("You need $%d, you only have %d.\n", np->n_cost, cash);
		return 0;
	}
	w_p_eff = np->n_rad + np->n_oil + np->n_lcm + np->n_hcm * 2;
	points = sp->sct_avail * 100 / w_p_eff;
	/*
	 * XXX when nukes turn into units (or whatever), then
	 * make them start at 20%.  Since they don't have efficiency
	 * now, we choose 20% as a "big" number.
	 */
	if (points < 20) {
		pr("Not enough available work in %s to build a %s;\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum), np->n_name);
		pr(" (%d available work required)\n",
			1 + w_p_eff*20/100);
		return 0;
	}
	if (!trechk(player->cnum, 0, NEWNUK))
		return 0;
	sp->sct_avail = (sp->sct_avail * 100 - w_p_eff * 20) / 100;
	player->dolcost += np->n_cost;
	cash -= np->n_cost;
	snxtitem_all(&nstr, EF_NUKE);
	free = -1;
	while (old = nxtitem(&nstr, (s_char *)&nuke)) {
		if (nuke.nuk_own != player->cnum)
			continue;
		if (nuke.nuk_x == sp->sct_x && nuke.nuk_y == sp->sct_y) {
			val = nstr.cur;
			break;
		}
		if (nuke.nuk_own == 0 && free < 0)
			free = nstr.cur;
	}
	if (old == 0) {
		/* not found; use a free slot, or expand file */
		if (free >= 0) {
			val = free;
		} else {
			ef_extend(EF_NUKE, 50);
			val = nstr.cur;
		}
		bzero((s_char *)&nuke, sizeof(nuke));
	} else {
		if (!getnuke(val, &nuke)) {
			logerror("Couldn't get nuke #%d\n", val);
			return 0;
		}
	}
	if (nuke.nuk_own == 0) {
		nuke.nuk_x = sp->sct_x;
		nuke.nuk_y = sp->sct_y;
		nuke.nuk_n = 0;
		nuke.nuk_own = player->cnum;
		nuke.nuk_uid = val;
		nuke.nuk_ship = -1;
	}
	nuke.nuk_types[np - nchr]++;
	nuke.nuk_n++;
	putnuke(val, &nuke);
	vec[I_HCM] -= np->n_hcm;
	vec[I_LCM] -= np->n_lcm;
	vec[I_OIL] -= np->n_oil;
	vec[I_RAD] -= np->n_rad;
	pr("%s warhead created in stockpile #%d at %s\n", np->n_name,
		nuke.nuk_uid, xyas(sp->sct_x, sp->sct_y, player->cnum));
	return 1;
}

static
int
build_plane(sp, pp, vec, tlev)
	register struct sctstr *sp;
	register struct plchrstr *pp;
	register int *vec;
	int	tlev;
{
	struct	plnstr plane;
	int	cost;
	int	n;
	struct	nstr_item nstr;
	float	eff=((float)PLANE_MINEFF/100.0);
	int	points;
	int	w_p_eff;
	int	hcm, lcm, mil;
	int	freeplane = 0;

	mil = roundavg(((double)pp->pl_crew * (double)eff));
	hcm = roundavg(((double)pp->pl_hcm * (double)eff));
	lcm = roundavg(((double)pp->pl_lcm * (double)eff));
	if (sp->sct_type != SCT_AIRPT && !player->god) {
		pr("Planes must be built in airports.\n");
		return 0;
	}
	if (vec[I_LCM] < lcm || vec[I_HCM] < hcm) {
		pr("Not enough materials in %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum));
		return 0;
	}
	w_p_eff = 5 * (pp->pl_lcm + (pp->pl_hcm * 2));
	points = sp->sct_avail * 100 / w_p_eff;
	if (points < PLANE_MINEFF) {
		pr("Not enough available work in %s to build a %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum), pp->pl_name);
		pr(" (%d available work required)\n",
			1 + PLANE_MINEFF * w_p_eff/100);
		return 0;
	}
	cost = pp->pl_cost * eff;
	if (cash < cost) {
		pr("Not enough money left to build a %s\n", pp->pl_name);
		return 0;
	}
	if (vec[I_MILIT] < mil) {
		pr("Not enough military for crew in %s\n",
			xyas(sp->sct_x, sp->sct_y, player->cnum));
		return 0;
	}
	if (!trechk(player->cnum, 0, NEWPLN))
		return 0;
	sp->sct_avail = (sp->sct_avail * 100 - w_p_eff * PLANE_MINEFF) / 100;
	player->dolcost += cost;
	cash -= cost;
	snxtitem_all(&nstr, EF_PLANE);
	freeplane = 0;
	while (nxtitem(&nstr, (s_char *)&plane)) {
		if (plane.pln_own == 0) {
			freeplane++;
			break;
		}
	}
	if (freeplane == 0) {
		ef_extend(EF_PLANE, 50);
	}
	plane.pln_x = sp->sct_x;
	plane.pln_y = sp->sct_y;
	plane.pln_own = sp->sct_own;
	plane.pln_type = pp - plchr;
	plane.pln_effic = PLANE_MINEFF;
	plane.pln_mobil = 0;
	plane.pln_mission = 0;
	plane.pln_opx = 0;
	plane.pln_opy = 0;
	plane.pln_radius = 0;
	n = (int) (pp->pl_range * (0.75 + techfact(tlev - pp->pl_tech, 2.0)));
	if (n > 127)
		n = 127;
	plane.pln_range = n;
	plane.pln_range_max = n;
	n = (int) (pp->pl_att * (0.75 + techfact(tlev - pp->pl_tech, 2.0)));
	if (n > 127)
		n = 127;
	plane.pln_att = n;
	n = (int) (pp->pl_def * (0.75 + techfact(tlev - pp->pl_tech, 2.0)));
	if (n > 127)
		n = 127;
	if (n < pp->pl_def)
		n = pp->pl_def;
	plane.pln_def = n;
	plane.pln_wing = ' ';
	plane.pln_tech = tlev;
	plane.pln_ship = -1;
	plane.pln_land = -1;
	plane.pln_uid = nstr.cur;
	plane.pln_nukeamt = 0;
	plane.pln_nuketype = 0;
	plane.pln_harden = 0;
	plane.pln_sell = 0;
	plane.pln_flags = 0;
	putplane(nstr.cur, &plane);
	pr("%s #%d built in sector %s\n", pp->pl_name, nstr.cur,
		xyas(sp->sct_x, sp->sct_y, player->cnum));
	vec[I_LCM] -= lcm;
	vec[I_HCM] -= hcm;
	vec[I_MILIT] -= mil;
	return 1;
}
