/*
 * treaty.h
 *
 * things having to do with treaties
 *
 * from PSL Empire, 1985
 * $Revision: 1.3 $ $Date: 89/06/01 14:19:09 $
 */

struct	trtstr {
	natid	trt_cna;	/* proposer */
	natid	trt_cnb;	/* acceptor */
	s_char	trt_status;	/* treaty status */
	s_char	trt_fill;
	short	trt_acond;	/* conditions for proposer */
	short	trt_bcond;	/* conditions for accepter */
	float	trt_bond;	/* amount of bond involved */
	time_t	trt_exp;	/* expiration date */
};

struct	tchrstr {
	int	t_cond;		/* bit to indicate this clause */
	s_char	*t_name;	/* description of clause */
};

#define TS_FREE		0
#define TS_PROPOSED	1
#define TS_SIGNED	2

	/* treaty clauses */
#define	LNDATT	bit(0)		/* no attacks on land units */
#define	SEAATT	bit(1)		/* no attacks on ships */
#define	SEAFIR	bit(2)		/* no shelling ships */
#define	LANATT	bit(3)		/* no attacks on sectors */
#define	LANFIR	bit(4)		/* no shelling sectors */
#define	NEWSHP	bit(5)		/* no new ships */
#define	NEWNUK	bit(6)		/* no new nuclear weapons */
#define	NEWPLN	bit(7)		/* no new planes */
#define	TRTENL	bit(8)		/* no enlistment */


/* global treaty variables */

#define gettre(n, p) \
	ef_read(EF_TREATY, n, (caddr_t)p)
#define puttre(n, p) \
	ef_write(EF_TREATY, n, (caddr_t)p)
#define gettrep(n) \
	(struct trtstr *) ef_ptr(EF_TREATY, n)

extern  struct tchrstr tchr[];
