/*
 * plane.h
 *
 * defines and plane types
 *
 * Dave Pare, 1986
 * $Revision: 1.5 $ $Date: 89/08/17 21:48:24 $
 */

#include "queue.h"

#define	PLANE_MINEFF	10

/*
 * some routines assume that from pln_x to pln_wing remains
 * exactly equivalent with shp_x to shp_fleet
 */
struct plnstr {
	coord	pln_x;		/* plane x-y */
	coord	pln_y;
	natid	pln_own;	/* owning country */
	s_char	pln_type;	/* fighter, bomber, etc */
	s_char	pln_effic;	/* actually "training" */
	s_char	pln_mobil;	/* plane mobility */
	short	pln_sell;	/* index into trade file */
	short	pln_tech;	/* plane's tech level */
	short	pln_uid;	/* plane unit id */
	s_char	pln_wing;	/* like fleet */
	coord	pln_opx;	/* Op sector coords */
	coord	pln_opy;	/* Op sector coords */
	short	pln_mission;	/* mission code */
	short	pln_radius;	/* mission radius */
	u_char	pln_range;	/* total distance, not radius */
	u_char	pln_range_max;	/* max range for this plane */
	short	pln_ship;	/* pointer to carrier */
	short	pln_land;	/* pointer to carrier */
	int	pln_att;	/* plane air-air attack/defense values */
	int	pln_def;
	s_char	pln_harden;	/* for missiles */
	s_char	pln_nuketype;	/* type of nuclear armament (if any) */
	s_char	pln_nukeamt;	/* # of nukes */
	s_char	pln_flags;	/* State of the plane */
#ifdef	ORBIT
	float	pln_theta;	/* position in orbital sine wave */
#endif	ORBIT
};

#define	PLN_LAUNCHED	bit(0)	/* A satellite that's in orbit */
#ifdef	ORBIT
#define	PLN_SYNCHRONOUS	bit(1)	/* A satellite in geo-synchronous orbit */
#endif	ORBIT

struct plchrstr {
	s_char	*pl_name;	/* plane unit name */
	int	pl_lcm;		/* costs to build */
	int	pl_hcm;
	int	pl_cost;
	int	pl_tech;	/* tech needed to build */
	int	pl_acc;		/* bombing accuracy (higher the better) */
	int	pl_load;	/* bomb load, also for carrying cargo */
	int	pl_att;		/* air-air attack/defense strengths */
	int	pl_def;
	int	pl_range;	/* how many sectors it can fly */
	int	pl_crew;	/* number of mil to crew it */
	int	pl_fuel;	/* fuel consumption */
	int	pl_stealth;	/* how stealthy is it? */
	int	pl_flags;	/* description of capability */
};

#define P_B	bit(0)	/* bombing factor only for bombing */
#define P_T	bit(1)	/* tactical bombing ability */
#define P_F	bit(2)	/* interceptor/escort */
#define P_C	bit(3)	/* bombing factor for transport only */
#define P_V	bit(4)	/* vtol ability */
#define P_M	bit(5)	/* missile, used only once, can't be intercepted */
#define P_L	bit(6)	/* light plane, lands on carriers */
#define P_S	bit(7)	/* Spy ability */
#define P_I	bit(8)	/* Imaging ability (advanced spying) */
#define P_O	bit(9)	/* Orbital ability (a satellite) */
#define P_X	bit(10)	/* Stealth ability */
#define P_N	bit(11) /* Nuclear RV interceptor (abm) */
#define	P_H	bit(12)	/* Half stealthy */
#define P_E	bit(13)
#define P_K	bit(14)
#define P_A	bit(15)
#define P_P	bit(16)
#define P_ESC	bit(17)
#define P_MINE	bit(18)
#define P_SWEEP	bit(19)

#define PM_R	bit(0) /* Recon mission */
#define PM_S	bit(1) /* Mine-sweeping mission */

#define PLN_MAXDEF	50

	/* internal to "fly" module -- really shouldn't be here */

struct plist {
	struct qelem queue;	/* list of planes */
	int state;		/* state of plane */
	int bombs;		/* bombs carried for bombing mission */ 
	int misc;		/* amount of random item being transported */
	struct plchrstr *pcp;	/* pointer to desc of plane */
	struct plnstr plane;	/* struct plane */
};

#define	P_OK		0
#define P_FIRED		1
#define P_DEL		2

#define getplane(n, p) \
	ef_read(EF_PLANE, n, (caddr_t)p)
#define putplane(n, p) \
	ef_write(EF_PLANE, n, (caddr_t)p)
#define getplanep(n) \
	(struct plnstr *) ef_ptr(EF_PLANE, n)

extern  struct plchrstr plchr[];
extern	int pln_maxno;

	struct  shiplook{
		short		uid;
		u_char		looked;
		u_char		found;
		struct shiplook	*next;
	};
