#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/drop.c,v 1.5 89/09/18 00:02:40 mr-frog Exp $";
#endif

/*
 * drop.c
 *
 * air-drop commodities into a sector
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "news.h"
#include "file.h"
#include "nat.h"
#include "path.h"

drop()
{
#ifdef	DROPANY
	int 	rel;
#endif	DROPANY
	extern	char *argp[];
	char	*p;
	int	mission_flags;
	coord	tx, ty;
	coord	ax, ay;
	int	ap_to_target;
	struct	ichrstr *ip;
	char	flightpath[256];
	struct	nstr_item ni_bomb;
	struct	nstr_item ni_esc;
	coord	x, y;
	struct	sctstr target;
	struct	qelem bomb_list;
	struct	qelem esc_list;
	int	wantflags;
	struct	sctstr ap_sect;

	wantflags = 0;
	if (!snxtitem(&ni_bomb, EF_PLANE, argp[1]))
		return RET_SYN;
	if (!snxtitem(&ni_esc, EF_PLANE, argp[2]))
		pr("No escorts...\n");
	if ((p = getstarg(argp[3], "assembly point? ")) == 0 || *p == 0)
		return RET_SYN;
	if (!sarg_xy(p, &x, &y) || !getsect(x, y, &ap_sect))
		return RET_SYN;
	if (ap_sect.sct_own && ap_sect.sct_own != cnum) {
		pr("Assembly point not owned by you!\n");
		return RET_SYN;
	}
	ax = x;
	ay = y;
	if ((p = getpath(argp[4], ax, ay, 0, 0, 0)) == 0 || *p == 0)
		return RET_SYN;
	(void)strcpy(flightpath, p);
	tx = ax;
	ty = ay;
	(void) pathtoxy(flightpath, &tx, &ty, fcost);
	pr(fmt("target is %s\n", xyas(tx, ty, cnum)));
	getsect(tx, ty, &target);

#ifdef	DROPANY
	rel = getrel(getnatp(target.sct_own), cnum);
	if (rel != ALLIED && target.sct_own != cnum) {
		pr(fmt("You don't own %s!\n", xyas(tx,ty,cnum)));
		return RET_FAIL;
	}
#else
	if (target.sct_own != cnum) {
		pr(fmt("You don't own %s!\n", xyas(tx, ty, cnum)));
		return RET_FAIL;
	}
#endif	DROPANY

	if ((ip = whatitem(argp[5], "Drop off what? ")) == 0)
		return RET_SYN;
	ap_to_target = strlen(flightpath);
	pr(fmt("range to target is %d\n", ap_to_target));
	/*
	 * select planes within range
	 */
	pln_sel(&ni_bomb, &bomb_list, &ap_sect, ap_to_target,
		2, wantflags, P_M|P_O);
	pln_sel(&ni_esc, &esc_list, &ap_sect, ap_to_target,
		2, P_F|wantflags, P_M|P_O);
	/*
	 * now arm and equip the bombers, transports, whatever.
	 * tech is stored in high 16 bits of mission_flags.
	 * yuck.
	 */
	mission_flags = 0x7fff0000;
	mission_flags |= P_X;		/* stealth (shhh) */
	mission_flags = pln_arm(&bomb_list, 'd', ip, 0, mission_flags);
	if (QEMPTY(&bomb_list)) {
		pr("No planes could be equipped for the mission.\n");
		return RET_FAIL;
	}
	mission_flags = pln_arm(&esc_list, 'd', ip, P_F, mission_flags);
	ac_encounter(&bomb_list, &esc_list, ax, ay, flightpath, mission_flags);
	if (QEMPTY(&bomb_list)) {
		pr(fmt("No planes got through fighter defenses\n"));
	} else {
		getsect(tx, ty, &target);
		pln_dropoff(&bomb_list, ip, tx, ty, (char *)&target,
			EF_SECTOR);
	}
	pln_put(&bomb_list);
	pln_put(&esc_list);
	return RET_OK;
}
