static char *RCSid = "$Header: /sequent2/empire/EMP/lib/global/RCS/constants.c,v 1.2 89/09/03 17:23:55 mr-frog Exp $";

/*
 * constglb.c
 *
 * Global constants file.  This should probably be redone.  Note that
 * the "hours" file can override some of these, so be careful.
 *
 */

#include "gamesdef.h"
#include "misc.h"
#include "xy.h"

char    *privname   = PRVNAM;	/* name of priv user */
char    *privlog    = PRVLOG;	/* logname of priv user */

int	m_m_p_d     = 1000;	/* max mins of play per day (per country) */
long    s_p_etu     = 86400;	/* seconds per Empire time unit */
int	etu_per_update = 65;	/* # of etu's to perform per update */
long    adj_update  = 0;	/* update time adjustment */

int	sect_mob_max = 127;	/* sector mobility limits */
int	sect_mob_scale = 1;	/* accumulation multiplier */
int	ship_mob_max = 127;	/* ship mobility limits */
int	ship_mob_scale = 2;	/* accumulation multiplier */
int	plane_mob_max = 127;	/* plane mobility limits */
int	plane_mob_scale = 1;	/* accumulation multiplier */

double   fgrate      = 0.0012;	/* food growth rate (dt * fert) */
double   fcrate      = 0.0013;	/* food cultivate rate (dt * workforce) */
/*double   eatrate     = 0.0010;	/* food eating rate (dt * people) */
double   eatrate     = 0.0001;	/* food eating rate (dt * people) */
double   babyeat     = 0.0120;	/* food to mature 1 baby into a civilian */

double   obrate      = 0.005;	/* other sectors birth rate */
double	 uwbrate     = 0.0035;	/* uncompensated worker birth rate */
				/* values > 0.25 for either will overflow */

#ifdef	FALLOUT
/* these are the radioactive decay constants */
/* fraction of commodity destroyed is
   etus*fallout/(1000*melt_item_denom[item])
   higher denominators for tougher commodities */
int	 melt_item_denom[] = 
	/*   civ mil shell gun pet iron dust bar*/
	{ 0, 4,  20, 80,   100,50, 100, 100, 200,
	   2,  50, 100,100,2, 1000 };
	/*food oil lcm hcm UW rads */
double	 decay_per_etu = 0.003, /* This gives a half life of ? etus,
				   about ? days.
				   half life in etus =
					 log(.5) / log(1-decay_per_etu)
				   Calculate your own if you don't like it.
				   If you want a specific half life you can
				   calc it with this formula:
				   decay_per_etu = 1 - (.5)^(1/etus)
				   due to the discrete nature of empire
				   you can not get a precise number
				   without intensive simulation
				   (more than 3 digits). */
	 fallout_spread = 0.005;  /* fraction of fallout that leaks into 
				    each surrounding sector */
#endif	FALLOUT

double   bankint     = 0.25;	/* bank interest rate (dt * bars) */

double	 minmult     = 0.5;	/* minimum trade mulitple */
double	 maxmult     = 10.0;	/* maximum trade multiple */
double	 tradetax    = 0.95;	/* Tax charged on trade */
				/*   Seller gets this times the price */
				/*   (should be 1.0 or less) */
double	 buytax	     = 1.0;	/* Tax charged on market purchases */
				/*   Buyer pays this times the price */
				/*   (should be 1.0 or greater) */
int	 startmob    = 127;	/* Sanctuary starting mobility */
double	 flakscale   = 1.0;	/* Scale factor for flak damage */
#ifdef	MISSINGMISSILES
int	 miss_inacc_thresh = 20;	/* distance at which missile */
					/* accuracy comes into play */
int	 miss_miss_chance = 25;		/* Percent chance of a missile */
					/* which is past the above thresh */
					/* missing by one sector */
#endif	MISSINGMISSILES

/* money gained from taxes, paid to military, and reservists */
double	money_civ	= 0.0083333;
double	money_uw	= 0.0037777;
double	money_mil	= -0.0833333;
double	money_res	= -0.0083333;

/* pct cost per ETU for maintaining a ship or plane */
double	money_plane	= -0.001;
double	money_ship	= -0.001;

/* edu and hap consumption factors -- hap_cons civs need 1 hap --> hlev++ */
double	hap_cons        = 5000.0;
double	edu_cons        = 4000.0;

/* hap and edu avg mean that the weight on current happiness is
 *  (cur_hap * hap_avg + hap_prod * etu) / (hap_avg + etu);  		*/
float   hap_avg = 48.0 * 1.0;
float   edu_avg = 48.0 * 4.0;


/* tech build limitations.  Tech limits only apply after easy_tech.
 * Two ways of limiting tech: asymptotic or logrithmic:
 * tech_hard is asymptopic limitation, tech_log_base is the logrithmic
 * limitation.  set tech_log_base > 1.0 to have it take effect,
 * set hard_tech > 0 to have it take effect
 * for log based, only tech values where the slop is < 1 are used	*/

float	easy_tech = 0.75;	/* amount of tech built with no penality */
float	hard_tech = 0.0;	/* amount of in-efficiently built tech */
float	tech_log_base = 1.9;	/* base of log to take of in-efficient tech */

float   ally_factor = 64.0;	/* shared tech with allies = 1/factor */
float	level_age_rate = 96.0;	/* 1% per 96 etu's; 0 -> no decline */


int	players_at_00 = 0;	/* players coord system on deity 0,0? */
int	at_least_one_100 = 1;	/* init player with 100/100/100/100 sector? */



float	btu_build_rate = 0.0004;/* etu * civ * eff * btu_build_rate */
				/* 8 * 999 * 100 * 0.0004 = 319 */
int	max_btus = 512;		/* maximum # of btu's */
double	powe_cost = 10.0;	/* btu cost to gen a power report */

double	buil_bt = 80.0;		/* tech level required to build a bridge */
int	buil_bh = 200;		/* hcm required to build a bridge */
double	buil_bc = 5000.0;	/* cash required to build a bridge */
