.de AB
.in 0.3i
.ti -0.3i
..
.TH Concept "Command Syntax"
.s1
The Empire Shell (command interpreter)
expects input in the form:
.EX VERB ARG1 ARG2 ...
VERB is any one of the command words in \*Qcommand list\*U
(\*Qmap\*U, \*Qmove\*U, \*Qinfo\*U, etc).
.s1
The number of ARGs varies from command to command.
In most cases the ARGs need not be supplied on the command line;
any that are not supplied will be obtained by prompting.
The exception to this rule are those
that are enclosed in [square brackets]
in the command list.
The presence of these ARGs changes the way the command is carried out.
.s1
Certain basic argument types recur often and are abbreviated in the
following ways.
.s1
.AB
<CNUM/CNAME> ::= either a country number or a country name
.s1
.AB
<ITEM> ::= any one, (or unambiguous abbreviation), of:
.in +\w'uncompensated workers\0\0'u
.L xloc
x coordinate
.L yloc
y coordinate
.L owner
owner of the sector
.L oldown
original owner of captured sector
.L des
sector designation
.L newtype
new sector designation
.L efficiency
efficiency
.L work
work/loyalty
.L mobility
mobility units
.L minerals
sector contents
.L ocontent
oil content
.L pcontent
oil content
.L fertility
food fertility
.L "uranium content"
uranium
.L civilians
civilians
.L military
military
.L uw
uncompensated workers
.L "uncompensated workers"
uncompensated workers
.L shells
number of shells
.L guns
number of guns
.L petroleum
amount of petrol
.L "iron ore"
amount of iron ore
.L "dust (gold)"
amount of gold dust
.L "bars of gold"
number of gold bars
.L food
quantity of food
.L oil
amount of crude oil
.L rad
amount of radioactive materials
.L lcm
light construction materials
.L hcm
heavy construction materials
.L distpath
distribution path
.L s_delivery
product delivery routes (shells)
.L g_delivery
gun delivery routes
.L p_delivery
petroleum delivery routes
.L i_delivery
iron ore delivery routes
.L d_delivery
gold dust delivery routes
.L b_delivery
gold bar delivery routes
.L f_delivery
food delivery routes
.L o_delivery
oil delivery routes
.L r_delivery
radioactive material delivery routes
.L l_delivery
lcm delivery routes
.L h_delivery
hcm delivery routes
.L u_delivery
uncompensated worker delivery routes
.L s_dist
product distribution thresholds (shells)
.L g_dist
guns distribution thresholds
.L p_dist
petroleum distribution thresholds
.L i_dist
iron ore distribution thresholds
.L d_dist
gold dust distribution thresholds
.L b_dist
gold bar distribution thresholds
.L f_dist
food distribution thresholds
.L o_dist
oil distribution thresholds
.L r_dist
radioactive material distribution thresholds
.L l_dist
lcm distribution thresholds
.L h_dist
hcm distribution thresholds
.L u_dist
uncompensated worker distribution thresholds
.in -\w'uncompensated workers\0\0'u
Note that some of these properties have less than useful values.
For instance the value of distpath is not generally meaningful
but zero (0) indicates no distribution path.
.AB
<LOAN> ::= loan number
.AB
<SECT> ::= sector coordinates in the form: x,y
.AB
.ne 4
<SECTS> ::= sector(s) in the form:
.NF +0i
lox:hix,loy:hiy ?cond&cond&...
.FI
\*Qlox\*U, \*Qhix\*U, \*Qloy\*U, \*Qhiy\*U are coordinates bounding
the rectangular area to be considered
.s3
\*Qcond\*U is a condition of the form:
.NF +0i
<VALUE><OPERATOR><VALUE>
.FI
<VALUE> is either an <ITEM>, as above,
a number in the range 0 to 65536,
or a sector designation,
(\*Qm\*U for mine, \*Qc\*U for capital, etc),
.br
<OPERATOR> can be any one of:
.in +\w'#\0\0'u
.L <
less than
.L =
equal
.L >
greater than
.L #
not equal
.in
.s1
Thus \*Qmob=100\*U, \*Qore#0\*U, \*Q7=guns\*U, \*Qciv#mil\*U,
\*Qdes=b\*U are examples of legitimate conditions,
(note lack of embedded spaces),
and
.EX census -3:3,-3:3 ?des=+&gun=5&mil>civ
will list all highways
within 3 of your capital
with exactly 5 guns and more military than civilians.
.sp
Similarly,
.EX deliver f -9:9,-9:9 ?f_del=0
will allow you to set up food delivery
in all the sectors that don't already
have food delivery.
.sp
Note that \*Qhix\*U, \*Qhiy\*U, and \*Q?cond\*U are all optional.
Also, the entire \*Qlox:hix,loy:hiy\*U section may be replaced
by either \*Q#\*U, \*Q#0\*U, \*Q#1\*U, \*Q#2\*U,
or \*Q#3\*U which refer to the four
\*Qrealm\*Us that you can define.
(See \*Qinfo realm\*U.)
Note that \*Q#\*U and \*Q#0\*U are equivalent.
.AB
<SHIP> ::= one ship number
.AB
<FLEET> ::= fleet designation,
which may be a list of ships separated by slashes (`/'),
a fleet letter,
the character tilde (`~') which means all ships not in a specific fleet,
or a rectangular sector area.
.AB
<SHIP/FLEET> ::= either a single ship number or a fleet designation.
.sp
Note that <FLEET> specifications may have an optional ?cond&cond...
argument like that used for <SECTS> arguments.
For instance:
.EX ship ~ ?des=d&mil>5
will list all destroyers that have more than 5 military
which are not currently in any fleet.
.s3
.in \\n(in
.s1
The output from commands may also be sent to a file or another
process by utilizing these alternate syntaxes:
.s3
.ne 2
.EX VERB ARG1 ... > FILE
which sends the output to the file \*QFILE\*U.
.s3
.ne 2
.EX VERB ARG1 ... >> FILE
which appends the output to the file \*QFILE\*U.
.s3
.ne 2
.EX VERB ARG1 ... >! FILE
which sends the output to the file \*QFILE\*U,
replacing the file it if it already exists.
.s3
.ne 2
.EX VERB ARG ... | PROGRAM [ARGS...]
which send the output of the command to the program \*QPROGRAM\*U
with optional arguments \*QARGS\*U.
This is most useful when \*QPROGRAM\*U is some type of
pager like \*(iFmore\*(pF(1) or \*(iFless\*(pF(1).
.s1
The Empire shell also recognizes a few control characters:
.s3
.in +\w'interrupt\0\0'u
.L \f2name\fP
\f2meaning\fP
.L interrupt
Abort command and return to Empire command level
.L quit
Exit Empire
.L EOT
Exit Empire
.in
.s3
See also : realm, command
