#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/subs/RCS/radmap.c,v 1.11 89/09/10 21:03:16 mr-frog Exp $";
#endif

/*
 * radmap.c
 *
 * do a radar map given an x,y location, effic,
 * and other things.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "xy.h"
#include "nat.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "file.h"
#include "nsc.h"
#include "deity.h"

radmap(cx, cy, eff, range, seesub)
	int	cx;
	int	cy;
	int	eff;
	int	range;
	double	seesub;
{
	char	rad[WORLD_Y][WORLD_X+1];
	char	vis[WORLD_Y][WORLD_X+1];
	int	rng;
	struct	sctstr sect;
	struct	shpstr ship;
	struct	plnstr plane;
	struct	nstr_sect ns;
	struct	nstr_item ni;
	int	x, y;
	int	row;
	int	n;

	bzero((char *)vis, sizeof(vis));
	range = (int) (range * (eff / 100.0));
	pr(fmt("%s efficiency %d%%, max range %d\n",
		xyas(cx, cy, cnum), eff, range));
	snxtsct_dist(&ns, cx, cy, range);
	blankfill((char *)rad, &ns.range, 1);
	while (nxtsct(&ns, &sect)) {
		if (god || sect.sct_own == cnum ||
		    (sect.sct_type <= SCT_RURAL && sect.sct_type != SCT_SANCT)
		    || ns.curdist <= range/3)
			rad[ns.dy][ns.dx] = dchr[sect.sct_type].d_mnem;
		else
			rad[ns.dy][ns.dx] = '?';
	}
	snxtitem_dist(&ni, EF_PLANE, cx, cy, range);
	while (nxtitem(&ni, (caddr_t)&plane)) {
		if (plane.pln_own == 0)
			continue;
		x = deltax((int)plane.pln_x, ns.range.lx);
		y = deltay((int)plane.pln_y, ns.range.ly);
		if ((plane.pln_flags & PLN_LAUNCHED) &&
		    plane.pln_own != cnum) {
			vis[y][x] = (char) 100;
			rad[y][x] = '$';
		}
	}
	snxtitem_dist(&ni, EF_SHIP, cx, cy, range);
	while (nxtitem(&ni, (caddr_t)&ship)) {
		if (ship.shp_own == 0)
			continue;
		x = deltax((int)ship.shp_x, ns.range.lx);
		y = deltay((int)ship.shp_y, ns.range.ly);
		rng = (int) (range * mchr[ship.shp_type].m_visib / 20.0);
		if (ni.curdist > rng)
			continue;
		if ((mchr[ship.shp_type].m_flags & M_SUB) &&
		    ni.curdist > rng * seesub)
			continue;
		if (mchr[ship.shp_type].m_visib > vis[y][x]) {
			vis[y][x] = mchr[ship.shp_type].m_visib;
			/* &~0x20 makes it a cap letter */
			rad[y][x] = (*mchr[ship.shp_type].m_name) & ~0x20;
		}
	}
	/* 
	 * make the center of the display 0
	 * so ve et al can find it.
	 */
	rad[deltay(cy, ns.range.ly)][deltax(cx, ns.range.lx)] = '0';
	/* won't work for radar maps > WORLD_Y/2 */
	n = deltay(ns.range.hy, ns.range.ly);
	for (row=0; row < n; row++)
		pr(fmt("%s\n", rad[row]));
	pr("\n");
}
