#ifndef lint
static char *RCSid = "$Header: laun.c,v 1.9 89/12/01 20:46:19 mr-frog Exp $";
#endif /* not lint */

/*
 * laun.c
 *
 * Launch missiles from land or sea.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "xy.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "news.h"
#include "ship.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "file.h"


/*
 * These are needed by the various launch routines below.
 */
static	struct	plnstr plane;	/* current missile we're lauinching */
static	struct	plchrstr *pcp;	/* characteristics of this missile */
static	int	shiplaunch;	/* launched from a ship? */
static	struct	sctstr sect;	/* sector from which we're launching */
static	struct	shpstr ship;	/* ship from which we're launching */

static	int launch_nuke();
static	int launch_sat();
static	int launch_conv();

/*
 * laun <PLANES>
 */
laun()
{
	extern	char *argp[];
	struct	nstr_item nstr;
	int	n;

	if (!snxtitem(&nstr, EF_PLANE, argp[1]))
		return RET_SYN;
	while (nxtitem(&nstr, (char *)&plane)) {
		if (plane.pln_own != cnum)
			continue;
		pcp = &plchr[plane.pln_type];
		if ((pcp->pl_flags & (P_M|P_O)) == 0) {
			pr(fmt("%s #%d isn't a missile!\n", pcp->pl_name,
				plane.pln_uid));
			continue;
		}
 		if (pcp->pl_flags & P_F) {
 			pr(fmt("%s #%d is a surface-to-air missile!\n",
 				pcp->pl_name, plane.pln_uid));
 			continue;
 		}
		if ((plane.pln_flags & PLN_LAUNCHED) && (pcp->pl_flags & P_O)) {
			pr(fmt("%s #%d already in orbit!\n",
				pcp->pl_name, plane.pln_uid));
			continue;
		}
		if (plane.pln_ship >= 0) {
			getship(plane.pln_ship, &ship);
			shiplaunch = 1;
			if (ship.shp_own != cnum){
				continue;
			}
			plane.pln_x = ship.shp_x;
			plane.pln_y = ship.shp_y;
		} else {
			shiplaunch = 0;
			getsect(plane.pln_x, plane.pln_y, &sect);
			if (sect.sct_own && sect.sct_own != cnum) {
				pr(fmt("%s #%d: someone else owns %s!\n",
					pcp->pl_name, plane.pln_uid,
					xyas(plane.pln_x, plane.pln_y, cnum)));
				continue;
			}
		}
		if (plane.pln_effic < 60) {
			pr(fmt("%s #%d is damaged (%d%%)\n",
				pcp->pl_name, plane.pln_uid, plane.pln_effic));
			continue;
		}
		if (plane.pln_nukeamt == 0 &&
		    (pcp->pl_flags & (P_M|P_O)) == (P_M|P_O)) {
			pr(fmt("%s #%d isn't armed with a nuclear device!\n",
				pcp->pl_name, plane.pln_uid));
			continue;
		}
		pr(fmt("%s #%d at %s; range %d, eff %d%%", pcp->pl_name,
			plane.pln_uid,
			xyas(plane.pln_x, plane.pln_y, cnum),
			plane.pln_range,
			plane.pln_effic));
		n = plane.pln_nukeamt;
		if (!(pcp->pl_flags & P_O) && (n == 0)) { /* conventional */
			if (launch_conv() < 0)
				continue;
		} else if (n == 0) {			/* satellites */
			if (launch_sat() < 0)
				continue;
		} else {				/* nukes */
			if (launch_nuke(n) < 0)
				continue;
		}
		putplane(plane.pln_uid, &plane);
		if (shiplaunch) {
			ship.shp_nplane -= 1;
			if (ship.shp_nplane < 0)	/* shouldn't happen */
				ship.shp_nplane = 0;
			putship(plane.pln_ship, &ship);
		}
	}
	return RET_OK;
}

/*
 * Launch a conventional warhead missile.
 * Return -1 on failure, 0 on success (even if missile explodes).
 */
static int
launch_conv()
{
	coord	sx, sy;
	float	damage;
	int	dam;
	int	shell;
	int	bombs;
	int	needed;
	int	i;
	char	*cp;

	pr(", carrying conventional warhead\n");
	if (shiplaunch) {
		shell = getvar(V_SHELL, (char *)&ship, EF_SHIP);
	} else {
		shell = getvar(V_SHELL, (char *)&sect, EF_SECTOR);
	}
	needed = pcp->pl_load - 1;
	if (shell < needed) {
		pr(fmt("(#%d) %s not enough shells!\n",
			plane.pln_uid, pcp->pl_name));
		return -1;
	}
	bombs = pcp->pl_load;
	if (shiplaunch) {
		putvar(V_SHELL, shell - needed, (char *)&ship, EF_SHIP);
	} else {
		putvar(V_SHELL, shell - needed, (char *)&sect, EF_SECTOR);
	}
	for (;;) {
		cp = getstarg(argp[2], "Target sector? ");
		if (cp == 0)
			return (-1);
		if (!sarg_xy(cp, &sx, &sy)) {
			pr("Bad sector designation; try again!\n");
			continue;
		}
		if (mapdist(plane.pln_x, plane.pln_y, sx, sy) >
		    plane.pln_range) {
			pr("Range too great; try again!\n");
			continue;
		}
		break;
	}
	pr("Launching!\n");
	if (chance(0.02 + (100 - plane.pln_effic)/100.0)) {
		pr("KABOOOOM!  Missile explodes on launch pad!\n");
		return 0;
	}
	dam = 100;
	i = roll(100);
	if (i <= 10) {
		damage = 0.92;	/* 8% */
		pr("BLAM");
	} else if (i < 100 - pcp->pl_acc) {	/* small pl_acc is better */
		damage = 0.95;	/* 5% */
		pr("Blam");
	} else {
		damage = 0.98;	/* 2% */
		pr("blam");
	}
	pr("\n");
	for (i = 0; i < bombs; i++)
		dam *= damage;
	plane.pln_own = 0;
	getsect(sx, sy, &sect);
	sectdamage(&sect, 100 - dam);
	putsect(&sect);
	nreport(cnum, N_SCT_BOMB, sect.sct_own, 1);
	pr(fmt("did %d%% damage in %s\n", 100 - dam, xyas(sx, sy, cnum)));
	wu(0, sect.sct_own,
		fmt("%s missile attack did %d%% damage in %s",
		cname(cnum), 100 - dam, xyas(sx, sy, sect.sct_own)));
	return 0;
}


/*
 * Launch a satellite.
 * Return -1 on error, 0 on success (even if the satellite fails).
 */
static int
launch_sat()
{
	coord	sx, sy;
	int	i;
	int	dist;
	int	dir;
	char	*cp;

	pr("\n");
	while (1) {
		cp = getstring("Target sector? ");
		if (cp == 0)
			return -1;
		if (!sarg_xy(cp, &sx, &sy)) {
			pr("Bad sector designation; try again!\n");
			continue;
		}
		if ((dist = mapdist(plane.pln_x, plane.pln_y, sx, sy)) >
		    plane.pln_range) {
			pr("Range too great; try again!\n");
			continue;
		}
		break;
	}
	pr("3... 2... 1... Blastoff!!!\n");
	if (chance(0.07 + (100 - plane.pln_effic)/100.0)) {
		pr(fmt("KABOOOOM!  Range safety officer detonates booster!\n"));
		plane.pln_own = 0;
		return 0;
	}
	i = plane.pln_tech + plane.pln_effic;
	if (chance(1.0 - (i/(i+50.0)))) {
		dir = (random() % 6) + 1;
		sx += diroff[dir][0];
		sy += diroff[dir][1];
		pr("Your trajectory was a little off.\n");
	}
	nreport(cnum, N_LAUNCH, 0, 1);
	pr(fmt("%s #%d positioned over %s, ",
		pcp->pl_name, plane.pln_uid, xyas(sx, sy, cnum)));
	plane.pln_x = sx;
	plane.pln_y = sy;
	plane.pln_flags |= PLN_LAUNCHED;
	plane.pln_mobil = (plane.pln_mobil > dist) ? 
		(plane.pln_mobil - dist) : 0;
	pr(fmt("will be ready for use in %d time units\n",
		127 - plane.pln_mobil));
	return 0;
}

#define	MAXRV	30

struct target {
	int x, y;
	int airburst;
};

/*
 * Launch a nuke.
 * Return -1 on error, 0 on success (even if nuke fails).
 */
static int
launch_nuke(n)
	int	n;
{
	coord	sx, sy;
	struct	target xy[MAXRV];
	char	*p;
	int	i;
	int	dir;

	pr(fmt(", payload %dx%s\n", plane.pln_nukeamt,
			nchr[plane.pln_nuketype].n_name));
	if (n > MAXRV)
		n = MAXRV;
	for (i = 0; i < n;) {
		p = getstring(fmt("RV #%d, target sector? ", i+1));
		if (p == 0)
			return (-1);
		if (!sarg_xy(p, &sx, &sy)) {
			pr("Bad sector designation; try again!\n");
			continue;
		}
		if (mapdist(plane.pln_x, plane.pln_y, sx, sy) >
		    plane.pln_range) {
			pr("Range too great; try again!\n");
			continue;
		}
		if (pcp->pl_flags & P_O) {
			dir = plane.pln_tech + plane.pln_effic;
			if (chance(1.0 - dir/(dir+50.0)))
				dir = (random() % 6) + 1;
			else
				dir = 0;
			xy[i].x = sx + diroff[dir][0];
			xy[i].y = sy + diroff[dir][1];
			xy[i].airburst = 2;
		} else {
			p = getstring("Air-burst? ");
			if (p == 0)
				return -1;
			xy[i].x = sx;
			xy[i].y = sy;
			xy[i].airburst = 1;
			if (*p == 0 || *p == 'n')
				xy[i].airburst = 0;
		}
		i++;
	}

	plane.pln_own = 0;
	plane.pln_nukeamt = 0;
	pr("Launching!\n");
	if (chance(0.02 + (100 - plane.pln_effic)/100.0)) {
		pr(fmt("KABOOOOM!  Missile explodes on launch pad!\n"));
		return 0;
	}
	pr("Arming warheads...\n");
	pr("Releasing RV's...\n");
	for (i = 0; i < n; i++) {
		detonate(plane.pln_nuketype, xy[i].x, xy[i].y,
			xy[i].airburst, cnum);
	}
	return 0;
}
