#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/lib/gen/RCS/parse.c,v 1.3 89/09/17 22:16:31 mr-frog Exp $";
#endif

/*
 * parse.c
 *
 * parse empire command line, chop into argp
 * If values argpp and spacep passed, parse will use them.
 * otherwise, parse will use static space and global argp.
 * parse assumes that argpp is a char *buf[16], and that spacep
 * points to a buf of at least 256 bytes.
 *
 * from PSL Empire, 1985
 */

#include <ctype.h>

static char static_space[512];

int
parse(buf, argpp, condp, space, redir)
	register char *buf;	/* register r11 */
	char	**argpp;
	char	**condp;
	char	*space;
	char	**redir;
{
	register char *bp2;
	register char *bp1;
	register char **arg;
	int	fs;
	int	argnum;

	if (redir)
		*redir = 0;
	bp1 = space == 0 ? static_space : space;
	arg = argpp;
	if (condp != 0)
		*condp = 0;
	for (argnum=0; *buf && argnum < 64; ) {
		arg[argnum] = bp1;
		argnum++;
		while (isspace(*buf))
			buf++;
		if (*buf == '>' || *buf == '|' && redir != 0) {
			*redir = buf;
			argnum--;
			arg[argnum] = 0;
			break;
		}
		fs = ' ';
		if (*buf == '"') {
			fs = '"';
			buf++;
		}
		for (bp2 = bp1; *buf; ) {
			if ((fs == ' ' && isspace(*buf)) || *buf == fs) {
				buf++;
				break;
			}
			*bp1++ = *buf++;
		}
		*bp1++ = 0;
		if (*bp2 == '?' && condp != 0) {
			*condp = bp2 + 1;
			argnum--;
		}
	}
	for (fs = argnum; fs < 16; fs++)
		arg[fs] = 0;
	return argnum;
}
