#ifndef lint
static char *RCSid = "$Header: /u/dhay/bemp/kent/update/RCS/nav_ship.c,v 1.1 91/03/28 00:36:05 dhay Exp Locker: dhay $";
#endif

/*
 * nav_util.c
 *
 * Utilities for autonav and sail.
 *
 */

#include "misc.h"

#ifdef	AUTONAV
#define WANT_THIS
#endif	AUTONAV

#ifdef	SAIL
#undef WANT_THIS
#define WANT_THIS
#endif	SAIL

#ifdef	WANT_THIS

#include <ctype.h>
#include "var.h"
#include "ship.h"
#include "plane.h"
#include "land.h"
#include "nuke.h"
#include "sect.h"
#include "news.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "deity.h"
#include "file.h"

 /* return codes from check_nav */
#define CN_LANDLOCKED	(1)
#define CN_CONSTRUCTION	(2)
#define CN_ERROR	(-1)
#define CN_NAVIGABLE	(0)


/* Format a ship name */
s_char *
nav_nameship(sp, mcp)
        register struct shpstr *sp;
	register struct mchrstr *mcp;
{
	static s_char buf[100];

#ifdef	SHIPNAMES
	sprintf(buf, "%s %s(#%d)", mcp->m_name, sp->shp_name, sp->shp_uid);
#else
	sprintf(buf, "%s #%d", mcp->m_name, sp->shp_uid);
#endif	SHIPNAMES
	return(buf);
}


int 
check_nav(sect)
	struct	sctstr *sect;
{
	extern struct dchrstr dchr[];

	switch (dchr[sect->sct_type].d_flg & 03) {
	case NAVOK:
		break;

	case NAV_02:
		if (sect->sct_effic < 2)
			return CN_CONSTRUCTION;
		break;
	case NAV_60:
		if (sect->sct_effic < 60)
			return CN_CONSTRUCTION;
		break;
	default:
		return CN_LANDLOCKED;
	}
	return CN_NAVIGABLE;
}

int
nav_chkdir(dir_char, min_dir, max_dir)
        s_char    dir_char;
        int     min_dir;
        int     max_dir;
{
        register int i;

        for (i = min_dir; i <= max_dir; i++)
                if (dir_char == dirch[i])
                        return i;
        return -1;
}

int
nav_shiprad(sp, cx, cy)
	struct shpstr *sp;
	int	cx, cy;
{
	int	range;
	struct	sctstr *sectp, *nxtsctp();
	struct	nstr_sect ns;

	range = (int) techfact(sp->shp_tech,
			(double) mchr[sp->shp_type].m_vrnge);
	range = (int) (range * (sp->shp_effic / 100.0));
	/* JNP 12/15/89  radar always can see at least 1 distant */
	if (range < 1) range = 1;
	snxtsct_dist(&ns, cx, cy, range);
	while ((sectp=nxtsctp(&ns))) {
		if (sectp->sct_own == sp->shp_own ||
		    (sectp->sct_type <= SCT_RURAL && sectp->sct_type != SCT_SANCT)
		    || ns.curdist <= range/3 || ns.curdist == 1)
			setbigmap(ns.x, ns.y, dchr[sectp->sct_type].d_mnem);
		else
			setbigmap(ns.x, ns.y, '?');
	}
}
#endif	WANT_THIS
