static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/SUBS/RCS/list.c,v 1.9 89/09/02 01:41:16 jeffw Exp $";

/*
 * list.c
 *
 * list ships, planes at a given x,y.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "news.h"
#include "ship.h"
#include "land.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"
#include "nat.h"
#include "item.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

int
shipsatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	extern	s_char *effadv();
	int	first;
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;

	first = 1;
	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_effic < SHIP_MINEFF || ship.shp_own == 0)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		if (first) {
			pr(" #          owner           eff        type\n");
			first = 0;
		}
#ifdef	SHIPNAMES
		pr(fmt("(#%3d) %10.10s  %12.12s  %s %s\n", ni.cur,
#else
		pr(fmt("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
#endif	SHIPNAMES
			cname(ship.shp_own),
#ifdef	SHIPNAMES
			effadv(ship.shp_effic), mp->m_name, ship.shp_name));
#else
			effadv(ship.shp_effic), mp->m_name));
#endif	SHIPNAMES
		ships++;
	}
	return ships;
}

/* This one only shows owned or allied ships */

int
carriersatxy(x, y, wantflags, nowantflags, own)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
	natid	own;
{
	extern	s_char *effadv();
	int	first;
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;
	int	allied;

	first = 1;
	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_effic < SHIP_MINEFF || ship.shp_own == 0)
			continue;
		allied = (getrel(getnatp(ship.shp_own), own) == ALLIED);
		if ((ship.shp_own != own) & !allied)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		if (first) {
			pr(" #          owner           eff        type\n");
			first = 0;
		}
#ifdef	SHIPNAMES
		pr(fmt("(#%3d) %10.10s  %12.12s  %s %s\n", ni.cur,
#else
		pr(fmt("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
#endif	SHIPNAMES
			cname(ship.shp_own),
#ifdef	SHIPNAMES
			effadv(ship.shp_effic), mp->m_name, ship.shp_name));
#else
			effadv(ship.shp_effic), mp->m_name));
#endif	SHIPNAMES
		ships++;
	}
	return ships;
}

int
unitsatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	extern	s_char *effadv();
	int	first;
	int	units;
	struct	nstr_item ni;
	struct	lchrstr *lp;
	struct	lndstr land;

	first = 1;
	units = 0;
	snxtitem_xy(&ni, EF_LAND, x, y);
	while (nxtitem(&ni, (s_char *)&land)) {
		if (land.lnd_effic < 20 || land.lnd_own == 0)
			continue;
		lp = &lchr[land.lnd_type];
		if (wantflags) {
			if ((lp->l_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (lp->l_flags & nowantflags)
				continue;
		}
		if (first) {
			pr(" #          owner           eff        type\n");
			first = 0;
		}
		pr(fmt("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
			cname(land.lnd_own),
			effadv(land.lnd_effic), lp->l_name));
		units++;
	}
	return units;
}

int
planesatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	int	first;
	int	planes;
	struct	plnstr plane;
	struct	nstr_item ni;
	struct	plchrstr *plp;

	planes = 0;
	first = 1;
	snxtitem_xy(&ni, EF_PLANE, x, y);
	while (nxtitem(&ni, (s_char *)&plane)) {
		if (plane.pln_effic < PLANE_MINEFF || plane.pln_own == 0)
			continue;
		if (plane.pln_flags & PLN_LAUNCHED)
			continue;
		plp = &plchr[plane.pln_type];
		if (first) {
			pr(" #          owner        eff       type\n");
			first = 0;
		}
		if (wantflags) {
			if ((plp->pl_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (plp->pl_flags & nowantflags)
				continue;
		}
		pr(fmt("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
			cname(plane.pln_own),
			effadv(plane.pln_effic), plp->pl_name));
		planes++;
	}
	return planes;
}

#ifdef ASW_PLANES
int
asw_shipsatxy(x, y, wantflags, nowantflags, acc, head)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
	int	acc;
	struct	shiplook *head;
{
	extern	s_char *effadv();
	int	first;
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;
	double	detect;

	first = 1;
	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_effic < SHIP_MINEFF || ship.shp_own == 0)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		if (mp->m_flags & M_SUB){
			detect = (100.0 - (double)acc);
			detect -= (4.0 - (double)mp->m_visib) * 10.0;
			detect += ((100-ship.shp_effic)/5);
			detect /= 100.0;
			if (!chance(detect))
				continue;
		}
		set_have_found(ship.shp_uid,head);
		if (first) {
			pr(" #          owner           eff        type\n");
			first = 0;
		}
#ifdef	SHIPNAMES
		pr(fmt("(#%3d) %10.10s  %12.12s  %s %s\n", ni.cur,
#else
		pr(fmt("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
#endif	SHIPNAMES
			cname(ship.shp_own),
#ifdef	SHIPNAMES
			effadv(ship.shp_effic), mp->m_name, ship.shp_name));
#else
			effadv(ship.shp_effic), mp->m_name));
#endif	SHIPNAMES
		ships++;
	}
	return ships;
}

int
num_shipsatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	extern	s_char *effadv();
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;

	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_effic < SHIP_MINEFF || ship.shp_own == 0)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		ships++;
	}
	return ships;
}
#endif /* ASW_PLANES */

/*
 * is p a list of ships/planes/units?
 *
 */

islist(p)
s_char *p;
{
	register int x;

	x=0;

	while(*(p+x)){
		if (!isdigit(*(p+x)) && (*(p+x) != '/'))
			return 0;

		x++;
	}

	return 1;
}
