static char *RCSid = "$Header: signals.c,v 1.7 90/03/20 11:27:16 mr-frog Exp $";

/*
 * signals.c
 *
 * Deals with fatal signals
 *
 * Dave Pare, 1986
 */

#include "proto.h"
#include "misc.h"

#include <stdio.h>
#include <signal.h>

extern int getconstants();
extern int quit();
 
reset_hours()
{
        getconstants();
        pr("\n");
        pr("The Deity has reset the Game Configuration - Type update\n");
        pr("to view the new configuration\n");
}
 
kill_player()
{
        pr("\n");
        pr("Oh No!!! Deity guns locking on to Internet Connection.\n");
        pr("AHHHH!!!! They're firing ... Connection Terminated!!\n");
        quit();
}

/*
 * gencore lets the player know empire puked, then drops a core
 * in the empire home directory.
 *
 * I won't natter about how this should never happen...
 */
gencore(sig)
	int	sig;
{
	(void) signal(SIGILL, SIG_DFL);
	(void) signal(SIGIOT, SIG_DFL);
	pr("\n");
	outid(C_EXIT);
	pr(fmt("Empire died on signal %d!\n", sig));
	(void) fflush(stdout);
	_cleanup();
	abort();
}

sigsetup()
{
	(void) signal(SIGPIPE, SIG_IGN);
	(void) signal(SIGFPE, gencore);
	(void) signal(SIGILL, gencore);
	(void) signal(SIGBUS, gencore);
	(void) signal(SIGSEGV, gencore);
	(void) signal(SIGQUIT, gencore);
        (void) signal(SIGUSR1, reset_hours);
        (void) signal(SIGUSR2, kill_player);
        (void) signal(SIGALRM, kill_player);
	alarm((unsigned int)60*60);
}

