#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/shi.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * shi.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

shi()
{
	extern	s_char *argp[];
	int	nships;
	struct	nstr_item ni;
	struct	shpstr ship;
	int	vec[I_MAX+1];

	if (!snxtitem(&ni, EF_SHIP, argp[1]))
		return RET_SYN;

	nships = 0;
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (!owner || ship.shp_own == 0)
			continue;
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n",
				ship.shp_type, ni.cur));
			continue;
		}
		count_planes(&ship);
		count_units(&ship);

		if (nships++ == 0) {
			if (god)
				pr("own ");
pr("shp#     ship type       x,y   fl  eff civ mil  uw  fd pn");
#ifdef SHIPCHOPPERS
			pr(" he");
#endif /* SHIPCHOPPERS */
#ifdef XLIGHT
			pr(" xl");
#endif /* XLIGHT */
			pr(" ln");
			pr(" mob");
#ifdef FUEL
			pr(" fuel");
#endif /* FUEL */
			pr(" tech\n");
		}
		if (god)
			pr(fmt("%3d ", ship.shp_own));
		pr(fmt("%4d ", ni.cur));
		pr(fmt("%-16.16s ", mchr[ship.shp_type].m_name));
		pr(fmt("%s ", xyfmt("%4d,%-4d", ship.shp_x,
			ship.shp_y, cnum)));
		pr(fmt("%1c", ship.shp_fleet));
		pr(fmt("%4d%%", ship.shp_effic));

		getvec(VT_ITEM, vec, (s_char *)&ship, EF_SHIP);
		pr(fmt("%4d", vec[I_CIVIL]));
		pr(fmt("%4d", vec[I_MILIT]));
		pr(fmt("%4d", vec[I_UW]));
		pr(fmt("%4d", vec[I_FOOD]));

		pr(fmt("%3d", ship.shp_nplane));
#ifdef SHIPCHOPPERS
		pr(fmt("%3d",ship.shp_nchoppers));
#endif /* SHIPCHOPPERS */
#ifdef XLIGHT
		pr(fmt("%3d",ship.shp_nxlight));
#endif /* XLIGHT */
		pr(fmt("%3d", ship.shp_nland));
		pr(fmt("%4d", ship.shp_mobil));
#ifdef FUEL
		pr(fmt("%5d",ship.shp_fuel));
#endif /* FUEL */
		pr(fmt("%4d\n", ship.shp_tech));
#ifdef	SHIPNAMES
		if (ship.shp_name[0] != 0) {
			if (god)
				pr("    ");
			pr(fmt("       %s\n",ship.shp_name));
		}
#endif	SHIPNAMES
	}
	if (nships == 0) {
		if (argp[1])
			pr(fmt("%s: No ship(s)\n", argp[1]));
		else
			pr(fmt("%s: No ship(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d ship%s\n", nships, splur(nships)));
	return RET_OK;
}
