#ifndef lint
static char *RCSid = "$Header: sate.c,v 1.5 90/03/19 11:07:15 mr-frog Exp $";
#endif

/*
 * sate.c
 *
 * do satellite maps/reports
 *
 * Edward M. Rynes Esq, 1988
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "plane.h"
#include "sect.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

sate()
{
	extern int plane_mob_max;
	extern s_char *argp[];
	double tech;
	struct nstr_item np;
	struct plnstr plane;

	if (!snxtitem(&np, EF_PLANE, argp[1]))
		return RET_SYN;

	while (nxtitem(&np, (s_char *)&plane)) {
		if (!owner)
			continue;
		if ((plane.pln_flags & PLN_LAUNCHED) == 0 ||
		    plane.pln_mobil < plane_mob_max)
			continue;
		if (plchr[plane.pln_type].pl_flags & P_S)
			pr("Satellite Spy Report:\n");
		else
			pr("Satellite Map Report:\n");
		pr(fmt("%s #%d at ", plchr[plane.pln_type].pl_name, np.cur));
		tech = techfact(plane.pln_tech, 20.0);
		satmap(plane.pln_x, plane.pln_y, plane.pln_effic,
			(int)tech, plchr[plane.pln_type].pl_flags);
	}
	return RET_OK;
}
