#ifndef lint
static char *RCSid = "$Header: leve.c,v 1.3 89/05/29 14:38:38 emp-src Exp $";
#endif /* not lint */

/*
 * leve.c
 *
 * do a distribution threshold level report
 *
 * David Muir Sharnoff, 1987
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "path.h"

leve()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	int	nsect;
	struct	nstr_sect nstr;
	int	dist[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0) {
			pr("DISTRIBUTION LEVELS\n");
			if (god) 
				pr(fmt("own"));
			pr("  sect      dst    civ mil  uw food  sh gun pet iron dust bar oil lcm hcm rad\n");
		}
		if (god)
			pr(fmt("%2d ", sect.sct_own));
		getvec(VT_DIST, dist, (s_char *)&sect, EF_SECTOR);
		pr(xyfmt("%3d,%-3d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c ", dchr[sect.sct_type].d_mnem));
		pr(xyfmt("%3d,%-3d", sect.sct_dist_x,sect.sct_dist_y,cnum));
		pr(fmt(" %4d", dist[I_CIVIL]));
		pr(fmt("%4d", dist[I_MILIT]));
		pr(fmt("%4d", dist[I_UW]));
		pr(fmt("%5d", dist[I_FOOD]));
		pr(fmt("%4d", dist[I_SHELL]));
		pr(fmt("%4d", dist[I_GUN]));
		pr(fmt("%4d", dist[I_PETROL]));
		pr(fmt("%5d", dist[I_IRON]));
		pr(fmt("%5d", dist[I_DUST]));
		pr(fmt("%4d", dist[I_BAR]));
		pr(fmt("%4d", dist[I_OIL]));
		pr(fmt("%4d", dist[I_LCM]));
		pr(fmt("%4d", dist[I_HCM]));
		pr(fmt("%4d", dist[I_RAD]));
		pr("\n");
	}
	if (nsect == 0) {
		if (argp[1])
			pr(fmt("%s: No sector(s)\n", argp[1]));
		else
			pr(fmt("%s: No sector(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d sector%s\n", nsect, splur(nsect)));
	return 0;
}
