#ifndef lint
static char *RCSid = "$Header: /u/dhay/bemp/src3/player/subs/RCS/snxtsct.c,v 1.1 91/01/11 00:30:36 dhay Exp Locker: dhay $";
#endif

/*
 * snxtsct.c
 *
 * arrange sector selection using either
 * distance or area.
 *
 * XXX we can *almost* treat sectors as items, but not quite.
 * Items are retrieved using id's, and sectors still use x,y.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "file.h"

struct	range worldrange = {
	-WORLD_X/2, -WORLD_Y/2, WORLD_X/2, WORLD_Y/2, 0, 0
};

snxtsct_all(np)
	struct	nstr_sect *np;
{
	snxtsct_area(np, &worldrange);
}

snxtsct_area(np, range)
	register struct nstr_sect *np;
	struct	range *range;
{
	bzero(np, sizeof(*np));
	np->range = *range;
	np->ncond = 0;
	np->type = NS_AREA;
	np->read = ef_read;
	np->x = np->range.lx - 1;
	np->y = np->range.ly;
	np->dx = -1;
	np->dy = 0;
	xysize_range(&np->range);
	ef_zapcache(EF_SECTOR);
}

snxtsct_rewind(np)
	struct	nstr_sect *np;
{
	np->x = np->range.lx - 1;
	np->y = np->range.ly;
	np->dx = -1;
	np->dy = 0;
	np->id = -1;
	ef_zapcache(EF_SECTOR);
}

snxtsct_dist(np, cx, cy, dist)
	register struct nstr_sect *np;
	coord	cx, cy;
	int	dist;
{
	bzero(np, sizeof(*np));
	xydist_range(cx, cy, dist, &np->range);
	np->cx = cx;
	np->cy = cy;
	np->ncond = 0;
	np->dist = dist;
	np->type = NS_DIST;
	np->read = ef_read;
	np->x = np->range.lx - 1;
	np->y = np->range.ly;
	np->dx = -1;
	np->dy = 0;
#if 0
	/* This function is now done elsewhere. */
	/* It was not doing the right thing when the world was small */
	xysize_range(&np->range);
#endif
	ef_zapcache(EF_SECTOR);
}

xysize_range(rp)
	register struct range *rp;
{
	if (rp->lx >= rp->hx)
		rp->width = WORLD_X + rp->hx - rp->lx;
	else
		rp->width = rp->hx - rp->lx;
#ifndef HAY
	/* This is a necessary check for small, hitech worlds. */
	if (rp->width > WORLD_X)
		rp->width = WORLD_X;
#endif
	if (rp->ly >= rp->hy)
		rp->height = WORLD_Y + rp->hy - rp->ly;
	else
		rp->height = rp->hy - rp->ly;
#ifndef HAY
	/* This is a necessary check for small, hitech worlds. */
	if (rp->height > WORLD_Y)
		rp->height = WORLD_Y;
#endif
}

/* This is called also called in snxtitem.c */
xydist_range(x, y, dist, rp)
	coord	x;
	coord	y;
	register int	dist;
	struct	range *rp;
{
	if (dist < WORLD_X/4) {
		rp->lx = xnorm((coord)(x - 2 * dist));
		rp->hx = xnorm((coord)(x + 2 * dist) + 1);
		rp->width = 4 * dist + 1;
	} else {
		/* Range is larger than the world */
		/* Make sure we get lx in the right place. */
		rp->lx = xnorm((coord)(x - WORLD_X/2));
		rp->hx = xnorm((coord)(rp->lx + WORLD_X - 1));
		rp->width = WORLD_X;
	}

	if (dist < WORLD_Y/2) {
		rp->ly = ynorm((coord)(y - dist));
		rp->hy = ynorm((coord)(y + dist) + 1);
		rp->height = 2 * dist + 1;
	} else {
		/* Range is larger than the world */
		rp->ly = ynorm((coord)(y - WORLD_Y/2));
		rp->hy = ynorm((coord)(rp->ly + WORLD_Y - 1));
		rp->height = WORLD_Y;
	}
}
