#ifndef lint
static char *RCSid = "$Header: navi.c,v 1.1 89/12/14 08:20:15 jay Exp $";
#endif

/*
 * marc.c
 *
 * march units and such.
 *
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "land.h"
#include "sect.h"
#include "news.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "deity.h"
#include "file.h"
#include "map.h"

static	void land_mess();
static	int remote=0;
#define PR(x)	{ if (!remote) pr(x); }

march()
{
	double techfact();
	extern s_char *argp[];
	struct sctstr sect, d_sect;
	register n;
	s_char   *cp;
	int     dir;
	int     nunits, moved;
	coord     newx, oldx;
	coord     newy, oldy;
	coord     dx;
	coord     dy;
	coord     destx;
	coord     desty;
	coord     allx;
	coord     ally;
	double	move_cost;
	int	first=1, together=1;
	s_char	*BestLandPath();
	int     stopping;
	int     viewing;
	int     lnums[NS_LSIZE];
	double  mobcost, d;
	double  mobils[NS_LSIZE];
	double  minmob, keepmob;
	struct nstr_item nb;
	struct lndstr lands[NS_LSIZE];
	struct lndstr *lndq;
	struct lndstr *lndp;
	struct lchrstr *lcp;
	int	time_to_stop;
	int	skip=0;
	int	dam;

	if (!snxtitem(&nb, EF_LAND, argp[1]))
		return RET_SYN;
	minmob = 9999.0;
	n = 0;

	if (remote)
		nb.flags &= ~(EFF_OWNER);

	while (nxtitem(&nb, (s_char *)&lands[n])) {
		if (!remote && (lands[n].lnd_own != cnum))
			continue;

		lnums[n] = lands[n].lnd_uid;
		lndp = &lands[n];
		mobils[n] = (double) lndp->lnd_mobil;
		if (mobils[n] < minmob)
			minmob = mobils[n];

		if (!getsect(lndp->lnd_x, lndp->lnd_y, &sect))
			return RET_SYN;

		if (sect.sct_own != lands[n].lnd_own)
			continue;

		if (lndp->lnd_ship >= 0)
			continue;
#ifdef RETREAT
		lndp->lnd_rflags = 0;
		bzero(lndp->lnd_rpath,RET_LEN);
#endif /* RETREAT */
		n++;			    /* good unit - keep it */

		if (first){
			allx = lndp->lnd_x;
			ally = lndp->lnd_y;
			first = 0;
		}
		if (lndp->lnd_x != allx)
			together = 0;
		if (lndp->lnd_y != ally)
			together = 0;

		/* Once you move, your fortifications go away */
		lndp->lnd_harden=0;

		/* Once you move, your mission goes away */
		lndp->lnd_mission=0;
		putland(lndp->lnd_uid,lndp);
	}
	if (n == 0) {
		PR("No units\n");
		return RET_SYN;
	}
	nunits = n;
	lndq = lands;
	stopping = 0;
	time_to_stop = 0;
	if (argp[2] && sarg_xy(argp[2], &destx, &desty) &&
		getsect(destx, desty, &d_sect)){
		if (!together){
			pr("Cannot go to a destination sector if not all starting in the same sector\n");
			return RET_FAIL;
		}
		
		cp = BestLandPath(&sect,&d_sect,&move_cost);
		if (cp == (s_char *)0){
			pr(fmt("No path from %s to %s!\n",
				xyas(allx,ally,cnum),
				xyas(d_sect.sct_x,d_sect.sct_y,cnum)));
			return RET_FAIL;
		}
		pr(fmt("Using path '%s'\n",cp));
	}else
		cp = argp[2];

	while (!stopping) {
		s_char    *bp,dp[80];
		dx = dy = viewing = 0;
		if (cp == 0 || *cp == 0){
			if (!remote){
				if (!skip)
					nav_map(lndq->lnd_x, lndq->lnd_y,
						(*lchr[lndq->lnd_type].l_name)
						& ~0x20);
				else
					skip=0;
			}
			cp = getstring(fmt("<%.1f:%.1f: %s> ", mobils[0],
				minmob, xyas(lndq->lnd_x, lndq->lnd_y, cnum)));
		}
		if (cp == 0 || *cp == 0)
			cp = &dirch[DIR_STOP];
		if (*cp == 'r' || *cp == 'l' | *cp == 'm'){
			if (*cp == 'r')
				skip=1;
			argp[1] = ++cp;
			argp[1] = 0;
			for (n = 0; n < nunits; n++)
				if (lnums[n] != -1)
					putland(lnums[n], &lands[n]);
			/* Make it default to the current unit, but */
			/* Malso allow them to specify the unit on the */
			/* same line */
			bp=cp;
			while((*bp != ' ') && (*bp)) bp++;
			while((*bp == ' ') && (*bp)) bp++;
			if ((bp != (s_char *)0) && (*bp))
				argp[1] = bp;
			else{
				sprintf(dp,"%d",lnums[0]);
				argp[1] = dp;
			}
			if (cp[-1] == 'r') {
				lrada();
				NAT_DELTA(nat_btu, cnum, -1);
			} else if (cp[-1] == 'l') {
				llook();
				NAT_DELTA(nat_btu, cnum, -1);
			} else {
				struct nstr_item ni;
				struct lndstr lnp, *lp;

				if (!snxtitem(&ni, EF_LAND, argp[1]))
					continue;
				while (nxtitem(&ni, (s_char *)&lnp)) {
					struct	lchrstr *lcp;
					int	lnpnum=(-1), z;

					for (z = 0; z < nunits; z++)
						if (lnums[z] == lnp.lnd_uid){
							lp = &lands[z];
							lnpnum=z;
						}

					if (lnpnum < 0)
						continue;

					lcp = &lchr[lp->lnd_type];
					if (!(lcp->l_flags & L_ENGINEER)){
						pr(fmt("%s #%d is not an engineer!\n",
							lcp->l_name,
							lp->lnd_uid));
						continue;
					}
					if (lp->lnd_mobil < 0){
						pr(fmt("%s #%d is out of mobility!\n",
							lcp->l_name,
							lp->lnd_uid));
						continue;
					}
					/* minesweeping costs 1 sects mob */
					mobcost = lp->lnd_effic * 0.01 *
						lcp->l_spd;
					mobcost = 480.0 / (mobcost +
						techfact(lp->lnd_tech,mobcost));

					lp->lnd_mobil -= mobcost;
					mobils[lnpnum] -= mobcost;
					if (mobils[n] < minmob)
						minmob = mobils[n];
					putland(lp->lnd_uid,lp);
					sweep_landmines(lp);
					if (check_landmines(lp,lnums,lnpnum,
						&time_to_stop))
                                                cp = 0;
				}
			}
			cp = 0;
			continue;
		} else {
			dir = chkdir(*cp++, DIR_STOP, DIR_VIEW);
			if (dir == -1) {
				PR(fmt("\"%c\" is not legal...", cp[-1]));
				direrr("`%c' to stop", " & `%c' to view\n", 0);
				cp = "";
				continue;
			}
			if (dir == DIR_VIEW)
				viewing++;
			else if (dir == DIR_STOP)
				stopping++;
			else {
				dx = diroff[dir][0];
				dy = diroff[dir][1];
			}
		}
		moved = 0;
		keepmob = minmob;
		minmob = 9999.0;
		for (n = 0; n < nunits; n++) {
			if (lnums[n] == -1)
				continue;
			lndp = &lands[n];
			lcp = &lchr[lndp->lnd_type];
			oldx = lndp->lnd_x;
			oldy = lndp->lnd_y;
			newx = xnorm(lndp->lnd_x + dx);
			newy = ynorm(lndp->lnd_y + dy);
			getsect(newx, newy, &sect);
			if (viewing || stopping || god)
				mobcost = 0.0;
			else {
				if (mobils[n] <= 0.0) {
					if (mobils[n] < minmob)
						minmob = mobils[n];
					land_mess("out of mobility", lnums[n], lndp);
					continue;
				}
				mobcost = (double)lndp->lnd_effic * 0.01 *
					(double)lcp->l_spd;
				d = (mobcost+techfact(lndp->lnd_tech,mobcost));
				mobcost = 480.0 / d;
				d = sector_mcost(sect.sct_type,sect.sct_effic);
				mobcost *= (d * 5.0);
				mobcost = roundavg(mobcost);
			}
			if (sect.sct_own != lndp->lnd_own){
				PR(fmt("%s #%d can't go to %s\n",
				       lcp->l_name, lnums[n], 
				       xyas(newx, newy, cnum)));
				cp = 0;
				if (mobils[n] < minmob)
					minmob = mobils[n];
				continue;
			}
			if (viewing) {
/*
				if (lcp->l_flags & L_FOOD)
					PR(fmt("[fert:%d] ", sect.sct_fertil));
				if (lcp->l_flags & L_OIL)
					PR(fmt("[oil:%d] ", sect.sct_oil));
*/
				PR(fmt("%s #%d @ %s %d%% %s\n", lcp->l_name,
				       lnums[n], xyas(newx, newy, cnum),
				       sect.sct_effic,
				       dchr[sect.sct_type].d_name));
			}

			if ((lndp->lnd_x != newx) || (lndp->lnd_y != newy))
				moved = 1;

			lndp->lnd_x = newx;
			lndp->lnd_y = newy;
			if ((mobils[n]-ldround(mobcost,1)) < -127)
				mobils[n] = -127;
			else
				mobils[n] -= ldround(mobcost,1);
			lndp->lnd_mobil = (int) mobils[n];
			if (mobils[n] <= 0.0 || stopping) {
				PR(fmt("%s #%d stopped at %s\n", lcp->l_name,
				       lnums[n],
				       xyas(lndp->lnd_x, lndp->lnd_y, cnum)));
				lndp->lnd_mobil = (int) mobils[n];
				putland(lnums[n], lndp);
				lnums[n] = -1;
				time_to_stop = 1;
				cp = &dirch[DIR_STOP];
			}
			if (mobils[n] < minmob)
				minmob = mobils[n];
			if (viewing || stopping)
				continue;
			
			sweep_landmines(lndp);
			if (check_landmines(lndp,lnums,n,&time_to_stop))
				cp = 0;
		}
		if (time_to_stop)
			stopping = 1;

		for (n = 0; n < nunits; n++)
			if (lnums[n] != -1)
				putland(lnums[n], &lands[n]);

		/*
		 * Check and see if anyone will interdict us
		 */
		if (((newx != oldx) || (newy != oldy)) &&
			moved && (keepmob != 9999.0) && (keepmob > 0)){
			dam = interdict(newx,newy,cnum,"land units");
			if (dam > 0){
				int	mydam, nu=0;

				for (n = 0; n < nunits; n++)
					if ((lnums[n] != -1) && 
						(lands[n].lnd_x == newx) &&
						(lands[n].lnd_y == newy))
						nu++;

				mydam = ldround(((double)dam/(double)nu),1);
				for (n = 0; n < nunits; n++){
					if ((lnums[n] != -1) &&
						(lands[n].lnd_x == newx) &&
						(lands[n].lnd_y == newy)){
						landdamage(&lands[n],mydam);
						putland(lnums[n], &lands[n]);
						if (lands[n].lnd_own == 0)
							lnums[n] = -1;
					}
				}
			}
		}
	}
	for (n = 0; n < nunits; n++) {
		if (lnums[n] == -1)
			continue;
		lndp = &lands[n];
		if (lndp->lnd_own == 0)
			continue;
		lcp = &lchr[lndp->lnd_type];
		PR(fmt("%s #%d stopped at %s\n", lcp->l_name, lnums[n],
		       xyas(lndp->lnd_x, lndp->lnd_y, cnum)));
		if (mobils[n] < 0)
			mobils[n] = 0;
		lndp->lnd_mobil = mobils[n];
		putland(lnums[n], lndp);
	}
	return RET_OK;
}

static void 
land_mess(str, n, lnd)
	s_char   *str;
	int     n;
	struct lndstr *lnd;
{
	extern struct lchrstr lchr[];

	PR(fmt("%s #%d is %s & stays in %s\n",
	       lchr[lnd->lnd_type].l_name, n,
	       str, xyas(lnd->lnd_x, lnd->lnd_y, lnd->lnd_own)));
}

sweep_landmines(lp)
struct	lndstr *lp;
{
	struct	sctstr sect;
	struct	lchrstr *lcp;
	int	mines, m, max, shells;

	lcp = &lchr[lp->lnd_type];
	if (!(lcp->l_flags & L_ENGINEER))
		return;

	getsect(lp->lnd_x, lp->lnd_y, &sect);
	mines = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
	if (mines>0 && (sect.sct_oldown != lp->lnd_own)) {
		max = vl_find(V_SHELL, lcp->l_vtype,
			lcp->l_vamt, (int) lcp->l_nv);
		shells = getvar(V_SHELL, (s_char *)lp, EF_LAND);
		for (m=0; mines > 0 && m < 5; m++) {
			if (chance(0.66)) {
				PR("Sweep...\n");
				mines--;
				shells = min(max, shells + 1);
			}
		}
		putvar(V_MINE, mines, (s_char *)&sect, EF_SECTOR);
		putvar(V_SHELL, shells, (s_char *)lp, EF_LAND);
		putsect(&sect);
	}

	putland(lp->lnd_uid,lp);
}

hit_landmine(lp)
struct lndstr *lp;
{
	struct	lchrstr *lcp;
	double	m;

	lcp = &lchr[lp->lnd_type];

	pr(fmt("\007Blammo! Mine detected by %s #%d in %s!\n",
		lcp->l_name, lp->lnd_uid,
		xyas(lp->lnd_x, lp->lnd_y, cnum)));

	nreport(cnum, N_LHIT_MINE, 0, 1);
	m = roll(50) + 15 * ((double)(101-lcp->l_vul)/100.0);

	if (lcp->l_flags & L_ENGINEER)
		m /= 2.0;

	landdamage(lp, ldround(m,1));

	return (int)m;
}

check_landmines(lp,lnums,n,time_to_stop)
struct	lndstr *lp;
int     lnums[NS_LSIZE];
int	n;
int	*time_to_stop;
{
	struct	sctstr sect;
	int	mines, m;

	getsect(lp->lnd_x,lp->lnd_y,&sect);
	mines = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
	if (mines > 0 && (sect.sct_oldown != lp->lnd_own)
		&& chance(((double)mines/((double)mines+50.0)))){
		m=hit_landmine(lp);
		mines--;
		putvar(V_MINE,mines,(s_char *)&sect,EF_SECTOR);
		putsect(&sect);
		if (lp->lnd_effic < 20) {
			*time_to_stop = 1;
			lnums[n] = -1;
		}
		putland(lp->lnd_uid, (s_char *)lp);
		pr(fmt("%d%% damage sustained\n",m));

		return 1;
	}
	return 0;
}
