#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/grin.c,v 1.0 90/06/12 00:03:21 bailey Exp $";
#endif /* not lint */

/*
 * grin.c
 *
 * Grind gold bars into dust
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "product.h"

#ifdef	GRIND

grin()
{
	extern	s_char *argp[];
	struct	nstr_sect nstr;
	int	vec[I_MAX+1];
	struct	sctstr sect;
	s_char	*p;
	int	i,n,qty;
#ifdef MERC
	int	avail;
#endif

	if ((p = getstarg(argp[1], "Sectors? ")) == 0)
		return RET_SYN;
	if (!snxtsct(&nstr, p))
		return RET_SYN;
	if ((p = getstarg(argp[2], "amount :  ")) == 0 || *p == 0)
		return RET_SYN;
	qty = atoi(p);
	if(qty < 0)
		return RET_SYN;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
/*		getsect(item.sct_x, item.sct_y, &sect); */
		if (sect.sct_effic < 60 || sect.sct_own != cnum)
			continue;
		getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		n = (vec[I_BAR] >= qty) ? qty : vec[I_BAR];
#ifdef MERC
		avail = n * 5.0;
		if(avail > sect.sct_avail) {
			n = sect.sct_avail / 5;
			avail = sect.sct_avail;
			if(n == 0)
				continue;
		}
#endif
		if (n) {
			vec[I_BAR] -= n;
			pr(fmt("%d bars ground up in %s\n", n,
				xyas(sect.sct_x, sect.sct_y, cnum)));
			for (i = 0; i < pchr[P_BAR].p_nv; i++) {
			    vec[unitem(pchr[P_BAR].p_vtype[i])] += (int)((n *
			    	pchr[P_BAR].p_vamt[i]) * 0.8);
			}
			putvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
#ifdef MERC
			sect.sct_avail -= avail;
#endif
			putsect(&sect);
		}
	}
	return RET_OK;
}

#endif	GRIND
