#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/chan.c,v 1.18 89/09/02 02:35:46 mr-frog Exp $";
#endif /* not lint */

/*
 * chan.c
 *
 * change rep name et al.
 *
 * from PSL Empire, 1985
 */

#include <ctype.h>
#include "misc.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "news.h"

chan()
{
	extern	s_char *argp[];
	s_char	*temp;
	struct	natstr *natp;
	register s_char *p;
	natid	cn;
	int	charge;
	int	nonb;
	int	btucost;

	if ((p = getstarg(argp[1], "country name or representative? ")) == 0)
		return RET_SYN;
	natp = getnatp(cnum);
	switch (*p) {
	case 'c':
		charge = 0;
		btucost = 0;
		if (!god && (natp->nat_stat & STAT_NORM)) {
			if (natp->nat_btu < 254) {
				pr("You need 254 btus to change your country name!\n");
				return RET_FAIL;
			}
#ifndef BLITZ
			pr("Warning, this command costs 254 BTU's and 10% of your money.\n");
			charge = 2000;
			btucost = 254;
			if (natp->nat_money < charge*10)
				charge = natp->nat_money / 10;
			if (natp->nat_money < 0)
				charge = 0;
#endif /* BLITZ */
		}
		if ((p = getstarg(argp[2], "New country name -- ")) == 0)
			return RET_SYN;
		p[19] = 0;
		for (cn = 0; natp = getnatp(cn); cn++) {
			if (same(p, natp->nat_cnam)) {
				pr(fmt("Country #%d is already called `%s'!\n",
					cn, p));
				return RET_FAIL;
			}
		}
		nonb = 0;
		for (temp = p; *temp != '\0'; temp++) {
			if (iscntrl(*temp)) {
				pr("No control characters allowed in country names!\n");
				return RET_FAIL;
			} else if (*temp != ' ')
				nonb = 1;
		}
		if (!nonb) {
			pr("Must have a non-blank name!\n");
			return RET_FAIL;
		}
#ifndef BLITZ
		NAT_DELTA(nat_money, cnum, -charge);
		NAT_DELTA(nat_btu, cnum, -btucost);
#endif /* BLITZ */
		NAT_SET(nat_cnam[0], cnum, p);
		nreport(cnum, N_NAME_CHNG, 0, 1);
		break;
	case 'r':
		pr("(note: these are stored in plain text.)\n");
		if ((p = getstarg(argp[2],
			"New representative name -- ")) == 0)
			return RET_SYN;
		p[8] = 0;
		NAT_SET(nat_pnam[0], cnum, p);
		break;
	default:
		pr("Only \"country\" or \"representative\" can change.\n");
		return RET_SYN;
	}
	return RET_OK;
}

