.TH Command QORDER
.SY "qorder <SHIP/FLEET>"
.SY "order <SHIP/FLEET> [c|r|s|d dest1 [[com1] [[dest2] [com2]]]]"
You use the \*Qorder\*U command to give sailing orders to ships.
At each update, ships sailing under orders \*Qautonavigate\*U toward a
specific destination sector.  Telegrams notify you of arrivals.
.s3
Any ship can be given sailing orders, but in order to move during the
update a ship must have at least one crew (which may be civilian or military,
but not an uncompensated worker).
.s1
.EX qorder <SHIP/FLEET>
.s1
\*Qqorder\*U shows current sailing orders.
Ships with no orders are not listed.
The report indicates:
.NF
     shp#          ship number
     ship type     type of ship (cargo ship, destroyer, etc)
     x,y           ship's current position
     flt           fleet association
     destination1  primary destination sector and cargo to be loaded
     destination2  secondary destination sector and cargo to be loaded
     loading       indicates that ship is taking aboard cargo
     stdby         indicates that ship is on standby

shp#     ship type       x,y    flt  destination1  destination2  loading  stdby
   6 cargo ship          0,-22         10,10
  14 cargo ship        -12,0          -12,0    c    -16,-8   f      *
  71 destroyer          53,-27   c     40,-28                               *
  76 destroyer         100,-30   c     40,-28  s
4 ship(s)
.FI
.EX order <SHIP/FLEET> \*Qc[ancel]\*U
.s1
The \*Qcancel\*U option causes a ship to stop autonavigating and its
current sailing orders to be canceled.  Canceled orders cannot be resumed,
and the ship will no longer appear in the orders list.
.s1
.EX order <SHIP/FLEET> \*Qs[tandby]\*U
.s1
The \*Qstandby\*U option causes a ship to stop autonavigating, but maintains
its orders (so that it shows up in the orders list).
.s1
.EX order <SHIP/FLEET> \*Qr[esume]\*U
.s1
The \*Qresume\*U option countermands a \*Qstandby\*U order, causing
autonavigation to resume.
.s1
.EX order <SHIP/FLEET> d \*Q<dest>\*U
.s1
Specifying a single destination orders a ship to autonavigate until
the destination is reached.  When the ship arrives, or if the trip is
not possible, you will be notified by telegram, and the ship's orders
will be canceled.
.s1
.EX order <SHIP/FLEET> d <dest> \*Q<cargo>\*U
.s1
This is the same as the previous case, except that upon arrival the ship
will not cancel its orders until it has loaded itself with the specified
cargo.
.s1
.EX order <SHIP/FLEET> d <dest> <cargo> \*Q<dest>\*U
.s1
Here the ship will sail to the first destination, where it then waits,
attempting at each update to load the specified cargo, until it becomes
full.  It then departs for the second destination.  Upon arrival, the
cargo will be unloaded, and its orders will be canceled.
.s1
.EX order <SHIP/FLEET> d <dest> <cargo> <dest> \*Q<cargo>\*U
.s1
This sets up an \*Qautomatic trade route\*U.  The ship is ordered
to continuously sail round-trip between the two destinations,
unloading one cargo, then loading the other.
.s1
Whenever a ship is autoloading cargo, it will always wait until it loads
to capacity.  The ship will also automatically load food, if necessary,
so as to have aboard a minimal amount for its next trip.  Autoloading is
never complete until the ship contains either as much food as there are
passengers (civ + mil + unc), or its maximum food capacity, whichever
is smaller.  When unloading cargo, it always unloads the entire amount.
.s1
At update time, the most direct path from ship to destination
is calculated, and each ship is then autonavigated along that path to
the best of its mobility.  The path is calculated from what the player
knows of the world (what you can see using the \*Qbmap\*U command).
Open sea, bridges, and unexplored regions of the world
are considered to be navigable; harbors are not.
.s1
Radar operates continuously as the ship moves along the path, constantly
adding sector information to the known world map.  When a ship encounters
an obstacle that was previously unknown, it will, if it still has any
mobility, use the newly-gained information to find a new route and try
moving again.
.s1
Autonav movement is performed before mobility is increased.
This insures that after the update, ships with orders will still
have some mobility so that you can always manually navigate
to some extent.
.s3
See also : autonav, bmap, nav, ship
