#ifndef lint
static char *RCSid = "$Header: /u/dhay/stan/kent/update/RCS/ship.c,v 1.2 91/03/19 17:57:38 dhay Exp Locker: dhay $";
#endif

/*
 * ship.c
 *
 * do "production" for ships -- make more efficient,
 * charge for military, etc.
 *
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "ship.h"
#include "var.h"
#include "news.h"
#include "file.h"
#include "product.h"
#include "land.h"
#include "xy.h"
#include "nsc.h"

#define MIN(x,y)        (x > y ? y : x)

#ifdef BUDGET
prod_ship(etus,natnum,build)
	int	etus;
	int	natnum;
	int	build;	/* build = 1, maintain = 0 */
#else
int
prod_ship(etus)
	int	etus;
#endif /* BUDGET */
{
	register struct shpstr *sp;
	struct	natstr *np;
	int	n;
	extern	long sea_money[MAXNOC];
	int	start_money;

	for (n=0; sp = getshipp(n); n++) {
		if (sp->shp_own == 0)
			continue;
#ifdef BUDGET
		if (sp->shp_own != natnum)
			continue;
#endif /* BUDGET */
		np = getnatp(sp->shp_own);
		start_money = np->nat_money;
#ifdef BUDGET
		upd_ship(sp, n, etus, np, build);
#else
		upd_ship(sp, n, etus, np);
#endif /* BUDGET */
#ifdef	AUTONAV
#ifdef BUDGET
		if (build) /* make sure to only autonav once */
#endif /* BUDGET */
		nav_ship(sp, n, np);		/* autonav the ship */
#endif	AUTONAV
		sea_money[sp->shp_own] += np->nat_money - start_money;
	}
#ifdef	SAIL
#ifdef BUDGET
	if (build) /* make sure to only sail once */
#endif /* BUDGET */
	sail_ship();
#endif	SAIL
}

#ifdef BUDGET
upd_ship(sp, shipno, etus, np, build)
#else
upd_ship(sp, shipno, etus, np)
#endif /* BUDGET */
	register struct shpstr *sp;
	int	shipno;
	register int etus;
	struct	natstr *np;
#ifdef BUDGET
	int	build; /* build = 1, maintain = 0 */
#endif /* BUDGET */
{
	extern	long pops[];
	extern  double money_mil;
	struct	sctstr *sectp;
	struct	mchrstr *mp;
	int	vec[I_MAX+1];
	int	cvec[I_MAX+1];
	int	oil_gained;
	int	max_oil;
	int	max_food;
	struct	pchrstr *product;
	s_char	*resource;
	int	n;
#ifdef BUDGET
	int	mult;
	extern	double money_ship;
#endif /* BUDGET */

	mp = &mchr[sp->shp_type];
	getvec(VT_ITEM, vec, (s_char *)sp, EF_SHIP);
#ifdef BUDGET
if (build == 1){
	if (np->nat_priorities[PRI_SBUILD] == 0)
		return;
#endif /* BUDGET */
	if (sp->shp_effic < SHIP_MINEFF || !shiprepair(sp, vec, np, etus)) {
		sp->shp_own = 0;
		return;
	}
#ifdef BUDGET
}else{
	mult = 1;
	if (np->nat_level[NAT_TLEV] < sp->shp_tech * 0.85)
		mult = 2;
	np->nat_money += (int) (mult * etus *
		dmin(0.0, money_ship * mp->m_cost));
#endif /* BUDGET */

	sectp = getsectp(sp->shp_x, sp->shp_y);
	if ((mp->m_flags & M_OIL) && (sectp->sct_type == SCT_WATER)){
		/*
		 * take care of oil production
		 */
		oil_gained = roundavg((vec[I_CIVIL] * etus / 10000.0)
			* sectp->sct_oil);
		vec[I_OIL] += oil_gained;
		max_oil = vl_find(V_OIL, mp->m_vtype, mp->m_vamt, MAXMCHV);
		if (vec[I_OIL] > max_oil)
			vec[I_OIL] = max_oil;
		product = &pchr[P_OIL];
		if (product->p_nrdep != 0 && oil_gained > 0) {
			resource = ((s_char *) sectp) + product->p_nrndx;
			*resource -=
				roundavg(oil_gained * product->p_nrdep / 100.0);
		}
	} else if ((mp->m_flags & M_FOOD) && (sectp->sct_type == SCT_WATER)){
		sectp = getsectp(sp->shp_x, sp->shp_y);
#ifdef NEWFISH
		vec[I_FOOD] += ((vec[I_CIVIL] * etus) / 1000.0)
#else
		vec[I_FOOD] += ((vec[I_CIVIL] * etus) / 10000.0)
#endif /* NEWFISH */
			* sectp->sct_fertil;
	}
	np->nat_money += (int) (etus * vec[I_MILIT] * money_mil);
	if ((n = feed_ship(sp,vec,etus)) > 0) {
#ifdef	SHIPNAMES
		wu(0, sp->shp_own, fmt("%d starved on %s %s(#%d)\n",
			n, mp->m_name, sp->shp_name, shipno));
#else
		wu(0, sp->shp_own, fmt("%d starved on %s #%d\n",
			n, mp->m_name, shipno));
#endif	SHIPNAMES
		if (n > 10)
			nreport(sp->shp_own, N_DIE_FAMINE, 0, 1);
	}
	max_food = vl_find(V_FOOD, mp->m_vtype, mp->m_vamt, MAXMCHV);
	if (vec[I_FOOD] > max_food)
		vec[I_FOOD] = max_food;
	/*
	 * do plague stuff.  plague can't break out on ships,
	 * but it can still kill people.
	 */
	getvec(VT_COND, cvec, (s_char *)sp, EF_SHIP);
	if (cvec[C_PSTAGE] > 0) {
		n = plague_people(np, vec, cvec, etus);
		switch (n) {
		case PLG_DYING:
			wu(0, sp->shp_own,
#ifdef	SHIPNAMES
				fmt("PLAGUE deaths reported on %s %s(#%d)\n",
				mp->m_name, sp->shp_name, sp->shp_uid));
#else
				fmt("PLAGUE deaths reported on %s #%d\n",
				mp->m_name, sp->shp_uid));
#endif	SHIPNAMES
			nreport(sp->shp_own, N_DIE_PLAGUE, 0, 1);
			break;
		case PLG_EXPOSED:
#ifdef	SHIPNAMES
			wu(0, sp->shp_own, fmt("%s %s(#%d) battling PLAGUE\n",
				mp->m_name, sp->shp_name, sp->shp_uid));
#else
			wu(0, sp->shp_own, fmt("%s #%d battling PLAGUE\n",
				mp->m_name, sp->shp_uid));
#endif	SHIPNAMES
			break;
		case PLG_INCUBATE:
			if (n == cvec[C_PSTAGE])
				break;
#ifdef	SHIPNAMES
			wu(0, sp->shp_own, fmt("Outbreak of PLAGUE on %s %s(#%d)!\n",
				mp->m_name, sp->shp_name, sp->shp_uid));
#else
			wu(0, sp->shp_own, fmt("Outbreak of PLAGUE on %s #%d!\n",
				mp->m_name, sp->shp_uid));
#endif	SHIPNAMES
			nreport(sp->shp_own, N_OUT_PLAGUE, 0, 1);
			break;
		default:
			break;
		}
		putvec(VT_COND, cvec, (s_char *)sp, EF_SHIP);
	}
	putvec(VT_ITEM, vec, (s_char *)sp, EF_SHIP);
	pops[sp->shp_own] += vec[I_CIVIL];
#ifdef BUDGET
}
#endif /* BUDGET */
}

/*
 * idea is: a sector full of workers can fix up eight
 * battleships +8 % eff each etu.  This will cost around
 * 8 * 8 * $40 = $2560!
 */
int
shiprepair(ship, vec, np, etus)
	register struct shpstr *ship;
	int	*vec;
	struct	natstr *np;
	int	etus;
{
	extern	int ship_grow_scale;
	extern	double money_ship;
	register int delta;
	struct	sctstr *sp;
	struct	mchrstr *mp;
	float	leftp, buildp;
	int	left, build;
	int	lcm, hcm, keeplcm, keephcm, lcm_needed, hcm_needed;
	int	wf;
	int	avail;
	int	w_p_eff;
	int	mult;
	int	svec[I_MAX+1];
#ifdef ALLYHARBORWORK
	int	rel;
#endif /* ALLYHARBORWORK */

	mp = &mchr[ship->shp_type];
	sp = getsectp(ship->shp_x, ship->shp_y);
#ifdef STOP
	if (sp->sct_off)
		return;
#endif /* STOP */
	getvec(VT_ITEM, svec, (s_char *)sp, EF_SECTOR);
	mult = 1;
	if (np->nat_level[NAT_TLEV] < ship->shp_tech * 0.85)
		mult = 2;
#ifndef BUDGET
	np->nat_money += (int) (mult * etus *
		dmin(0.0, money_ship * mp->m_cost));
#endif /* BUDGET */
	if (ship->shp_effic == 100) {
		/* ship is ok; no repairs needed */
		return 1;
	}
	if ((sp->sct_own != ship->shp_own) && (sp->sct_own != 0)) {
#ifdef ALLYHARBORWORK
		rel=getrel(getnatp(sp->sct_own),ship->shp_own);

		if (rel != ALLIED)
			return 1;
#else
		/* not our harbor -> shore leave; no eff gain */
		return 1;
#endif /* ALLYHARBORWORK */
	}
	left = 100 - ship->shp_effic;
	wf = 0;
	/* only military can work on a military boat */
	if (mp->m_glim > 0)
		wf = etus * vec[I_MILIT]/2;
	else
		wf = etus * (vec[I_CIVIL]/2 + vec[I_MILIT]/5);
	if (sp->sct_type != SCT_HARBR)
		wf /= 3;
	avail = wf + sp->sct_avail * 100;
	w_p_eff = 20 + (mp->m_lcm + 2 * mp->m_hcm);
	delta = roundavg((double)avail/w_p_eff);
	if (delta <= 0)
		return 1;
	if (delta > etus*ship_grow_scale)
		delta = etus*ship_grow_scale;
	if (delta > left)
		delta = left;

	/* delta is the max amount we can grow */

        left = 100 - ship->shp_effic;
	if (left > delta)
		left = delta;

        leftp = ((float)left/100.0);
        lcm_needed = ldround((double)(mp->m_lcm * leftp),1);
        hcm_needed = ldround((double)(mp->m_hcm * leftp),1);

#ifdef GRAB_THINGS
	/* try_supply_commod will get from this sect first, then look
	 * elsewhere until it finds what it needs. It'll return the
	 * number of mil/lcm/hcm/etc it finds available without
	 * actually getting it
	 */

	getvec(VT_ITEM, vec, (s_char *)ship, EF_SHIP);
	lcm = vec[I_LCM];
	hcm = vec[I_HCM];

	lcm += try_supply_commod(sp->sct_own,sp->sct_x,sp->sct_y,I_LCM,
		lcm_needed-lcm);
	hcm += try_supply_commod(sp->sct_own,sp->sct_x,sp->sct_y,I_HCM,
		hcm_needed-hcm);
#else
	lcm = svec[I_LCM];
	hcm = svec[I_HCM];
#endif /* GRAB_THINGS */

        if (lcm>=lcm_needed)
                buildp=leftp;
        else
                buildp=((float)lcm/(float)mp->m_lcm);
        if (hcm < hcm_needed)
                buildp = MIN(buildp,((float)hcm/(float)mp->m_hcm));

	build=ldround((double)(buildp*100.0),1);

        lcm_needed = roundavg((double)(mp->m_lcm * buildp));
        hcm_needed = roundavg((double)(mp->m_hcm * buildp));

#ifdef GRAB_THINGS
	/*
	 * Now that we know how much we can actually use, get it.
	 * supply_commod will actually subtract the commod off the
	 * sector/ship/supply unit
	 */
	lcm = vec[I_LCM];
	hcm = vec[I_HCM];

	/* Take the commods off so supply_commod doesn't grab them */
	/* keepmil, etc are how many they should have afterwards   */

	keeplcm=(lcm-lcm_needed > 0 ? lcm-lcm_needed : 0);
	keephcm=(hcm-hcm_needed > 0 ? hcm-hcm_needed : 0);

	vec[I_LCM]=0;
	vec[I_HCM]=0;

	putvec(VT_ITEM, vec, (s_char *)ship, EF_SHIP);

	lcm += supply_commod(sp->sct_own,sp->sct_x,sp->sct_y,I_LCM,
		lcm_needed-lcm);
	hcm += supply_commod(sp->sct_own,sp->sct_x,sp->sct_y,I_HCM,
		hcm_needed-hcm);

	vec[I_LCM]=keeplcm;
	vec[I_HCM]=keephcm;
	putvec(VT_ITEM, vec, (s_char *)ship, EF_SHIP);

	/*
	 * get the sect again, so we don't
	 * overwrite it if supply_commod changed it
	 */
	sp = getsectp(ship->shp_x, ship->shp_y);
#else
	if ((svec[I_LCM] - lcm_needed) < 0)
		svec[I_LCM] = 0;
	else
		svec[I_LCM] -= lcm_needed;
	if ((svec[I_HCM] - hcm_needed) < 0)
		svec[I_HCM] = 0;
	else
		svec[I_HCM] -= hcm_needed;
	putvec(VT_ITEM, svec, (s_char *)sp, EF_SECTOR);
#endif /* GRAB_THINGS */

	if (sp->sct_type != SCT_HARBR)
		build = delta;
	wf -= build * w_p_eff;
	if (wf < 0) {
		/*
		 * I didn't use roundavg here, because I want to penalize
		 * the player with a large number of ships.
		 */
		avail = (sp->sct_avail * 100 + wf) / 100;
		if (avail < 0)
			avail = 0;
		sp->sct_avail = avail;
	}
	if (sp->sct_type != SCT_HARBR)
		if ((build+ship->shp_effic)>80){
			build = 80 - ship->shp_effic;
			if (build < 0)
				build = 0;
		}
	np->nat_money -= mult * mp->m_cost * build / 100.0;
	ship->shp_effic += (s_char)build;
	return 1;
}

/*
 * returns the number who starved, if any.
 */
int
feed_ship(sp, vec, etus)
struct shpstr *sp;
register int vec[I_MAX+1];
int	etus;
{
#ifndef	NOFOOD
	extern	double eatrate;
	double	food_eaten, land_eaten;
	double	people_left;
	int	ifood_eaten;
	int	can_eat, need;
	int	total_people;
	int	to_starve;
	int	starved, lvec[I_MAX+1];
	struct	mchrstr *mcp;
	struct	nstr_item ni;
	struct	lndstr *lp;

	mcp = &mchr[sp->shp_type];

	food_eaten = (etus * eatrate) * (vec[I_CIVIL]+vec[I_MILIT]+vec[I_UW]);
	ifood_eaten = (int)food_eaten;
	if ((food_eaten-ifood_eaten) > 0)
		ifood_eaten++;
	starved = 0;

	if (food_eaten > vec[I_FOOD])
		vec[I_FOOD] += supply_commod(sp->shp_own,sp->shp_x,sp->shp_y,
				I_FOOD,(ifood_eaten-vec[I_FOOD]));

	if (food_eaten > vec[I_FOOD]){
		if (sp->shp_nland > 0){
			snxtitem_all(&ni,EF_LAND);
			while((lp=(struct lndstr *)nxtitemp(&ni)) &&
				(food_eaten > vec[I_FOOD])){
				if (lp->lnd_ship != sp->shp_uid)
					continue;
				need = ifood_eaten - vec[I_FOOD];
				getvec(VT_ITEM, lvec, (s_char *)lp, EF_LAND);
				land_eaten = (etus * eatrate) *
                			(((double)lp->lnd_effic/100.0) *
					(double)lchr[lp->lnd_type].l_mil);
				if (lvec[I_FOOD]-need > land_eaten){
					vec[I_FOOD] += need;
					lvec[I_FOOD] -= need;
				}else if ((lvec[I_FOOD]-land_eaten) > 0){
					vec[I_FOOD]+= (lvec[I_FOOD]-land_eaten);
					lvec[I_FOOD]-=(lvec[I_FOOD]-land_eaten);
				}
				putvec(VT_ITEM, lvec, (s_char *)lp, EF_LAND);
			}
		}
	}

	if (food_eaten > vec[I_FOOD]){
#ifdef NEW_STARVE
		can_eat = (vec[I_FOOD] / (etus * eatrate));
		total_people = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];

		/* only want to starve off at most 1/2 the populace. */
		if (can_eat < (total_people/2))
			can_eat = total_people/2;

		to_starve = total_people - can_eat;	
		while(to_starve && vec[I_UW]){
			to_starve--;
			starved++;
			vec[I_UW]--;
		}
		while(to_starve && vec[I_CIVIL]){
			to_starve--;
			starved++;
			vec[I_CIVIL]--;
		}
		while(to_starve && vec[I_MILIT]){
			to_starve--;
			starved++;
			vec[I_MILIT]--;
		}
		
		vec[I_FOOD] = 0;
#else
		people_left = (vec[I_FOOD] + 0.01) / (food_eaten + 0.01);
		starved = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
		/* only want to starve off at most 1/2 the populace. */
		if (people_left < 0.5)
			people_left = 0.5;
		vec[I_CIVIL] = (int) (vec[I_CIVIL] * people_left);
		vec[I_MILIT] = (int) (vec[I_MILIT] * people_left);
		vec[I_UW] = (int) (vec[I_UW] * people_left);
		starved -= vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
		vec[I_FOOD] = 0;
#endif /* NEW_STARVE */
	} else {
		vec[I_FOOD] -= roundavg(food_eaten);
	}
	return starved;
#else
	return 0;
#endif	NOFOOD
}
