#ifndef lint
static char *RCSid = "$Header: wu.c,v 1.4 89/11/12 22:52:36 mr-frog Exp $";
#endif

/*
 * wire.c
 *
 * write a announcement to a user from another.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include <fcntl.h>
#include <sys/uio.h>
#include "nat.h"
#include "tel.h"
#include "file.h"


#ifdef WIRE
int
typed_wire(from, to, buf, type)
	natid	from;
	natid	to;
	s_char	*buf;
	int	type;
{
	register s_char *bp;
	int	len;
	struct	telstr tel;
	struct	natstr *np;
	struct	iovec iov[2];
	int	fd;

	if ((np = getnatp(to)) == 0 ||
		((np->nat_stat & STAT_NORM) == 0 &&
		(np->nat_stat & STAT_SANCT) == 0))
		return 0;
	if ((fd = open(wirebox(to), O_WRONLY|O_APPEND, 0)) < 0) {
		logerror("telegram 'open' of %s (#%d) failed", wirebox(to), to);
		return 0;
	}
	if (!file_lock(fd)) {
		logerror("telegram lock %s (fd %d) failed", wirebox(to), fd);
		return 0;
	}
	tel.tel_from = from;
	(void) time(&tel.tel_date);
	bp = buf;
	while (*bp++)
		;
	len = bp - buf;
	if (len >= MAXTELSIZE)
		len = MAXTELSIZE;
	buf[len] = 0;
	tel.tel_length = len;
	tel.tel_type = type;
	iov[0].iov_base = (caddr_t) &tel;
	iov[0].iov_len = sizeof(tel);
	iov[1].iov_base = buf;
	iov[1].iov_len = len;
	if (writev(fd, iov, 2) < iov[0].iov_len + iov[1].iov_len)
		logerror("telegram 'write' to #%d failed", to);
	else
		NAT_DELTA(nat_ann, to, 1);
	(void) file_unlock(fd);
	(void) close(fd);
	return 0;
}
#endif
