#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/SUBS/RCS/caploss.c,v 1.3 89/08/01 11:24:37 jeffw Exp $";
#endif

/*
 * caploss.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "var.h"
#include "sect.h"
#include "file.h"

caploss(sp, coun, msg)
	struct	sctstr *sp;
	natid	coun;
	s_char	*msg;
{
	struct	natstr *natp;
	long	lose;
	long	gain;

	natp = getnatp(coun);
	if ((xrel(natp,natp->nat_xcap) != xrel(natp,sp->sct_x)) ||
	      (yrel(natp,natp->nat_ycap) != yrel(natp,sp->sct_y)))
	     return;
	pr(fmt(msg, natp->nat_cnam));
	if (coun == cnum) {
		nstat &= ~CAP;
		return;
	}
	if (sp->sct_updated == 1){
		lose = natp->nat_money / 2;
		if (lose < 3000)
			lose = 3000;
		NAT_DELTA(nat_money, coun, -lose);
		gain = lose;
		if (gain > natp->nat_money)
			gain = natp->nat_money; 
		if (gain >= 0)  {
			/*
		 	* since we "caused" the event to occur, that means
		 	* we might benefit as long as the cap effic is
		 	* decent.  (the cap being decent means that we
		 	* don't gain if we nuked it) 
		 	*/
			dolcost -= (sp->sct_effic / 100.0) * gain;
		}
		wu(0, 0, fmt("%s just took %s's capitol and gained $%f\n",cname(cnum),
			cname(coun),-dolcost));
		wu(0, 0, fmt("sct_updated = %d\n",(int)sp->sct_updated));
		sp->sct_updated = 0;
	}
}
