#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/work.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * work.c
 *
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "land.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

work()
{
	extern	s_char *argp[];
	int	nunits;
	struct	nstr_item ni;
	struct	sctstr sect;
	struct	lndstr land;
	int	vec[I_MAX+1];
	int	work_amt, eff_amt, w;
	s_char	*p;
	int	can;
	extern	int land_mob_max;

	if (!snxtitem(&ni, EF_LAND, argp[1]))
		return RET_SYN;

	p = getstarg(argp[2], "Amount: ");
	if (p == 0 || *p == 0)
		return RET_SYN;
	work_amt = atoi(p);

	if ((work_amt<0) || (work_amt > land_mob_max)){
		pr(fmt("Mobility used must be from 0 to %d\n",land_mob_max));
		return RET_FAIL;
	}

	nunits = 0;
	while (nxtitem(&ni, (s_char *)&land)) {
		if (!owner || land.lnd_own == 0)
			continue;
		if (land.lnd_type < 0 || land.lnd_type > lnd_maxno) {
			pr(fmt("bad unit type %d (#%d)\n",
				land.lnd_type, ni.cur));
			continue;
		}
		if (!(lchr[land.lnd_type].l_flags & L_ENGINEER))
			continue;

		getsect(land.lnd_x,land.lnd_y,&sect);
		nunits++;

		eff_amt= min(land.lnd_mobil,work_amt);
		can = eff_amt;

		w = ldround(((double)eff_amt/6.0),1);

		eff_amt=buildeff(&sect,w,&dolcost);
		land.lnd_mission = 0;
		land.lnd_mobil -= can;

		pr(fmt("%s #%d raised efficiency at %s to %d\n",
			lchr[land.lnd_type].l_name,
			land.lnd_uid,
			xyas(land.lnd_x,land.lnd_y,cnum),
			(int)sect.sct_effic));

		putland(land.lnd_uid,&land);
		putsect(&sect);
	}
	if (nunits == 0) {
		if (argp[1])
			pr(fmt("%s: No unit(s)\n", argp[1]));
		else
			pr(fmt("%s: No unit(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d unit%s\n", nunits, splur(nunits)));
	return RET_OK;
}

buildeff(sp,work,money)
struct	sctstr *sp;
int	work;
double	*money;
{
	int	vec[I_MAX+1];
	register int work_cost;
	int	n, hcms, lcms;

	getvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR);

	work_cost = 0;
	if (sp->sct_type != sp->sct_newtype) {
		/*
		 * Tear down existing sector.
		 * Easier to destroy than to build.
		 */
		work_cost = (sp->sct_effic + 3) / 4;
		if (work_cost > work)
			work_cost = work;
		n = sp->sct_effic - work_cost * 4;
		if (n <= 0) {
			n = 0;
			sp->sct_type = sp->sct_newtype;
		}
		sp->sct_effic = n;
		work -= work_cost;
		*money += work_cost;
	}
	if (sp->sct_type == sp->sct_newtype) {
		work_cost = 100 - sp->sct_effic;
		if (work_cost > work)
			work_cost = work;

		if (dchr[sp->sct_type].d_lcms>0){
			lcms = vec[I_LCM];
			lcms /= dchr[sp->sct_type].d_lcms;
			if (work_cost > lcms)
				work_cost = lcms;
		}
		if (dchr[sp->sct_type].d_hcms>0){
			hcms = vec[I_HCM];
			hcms /= dchr[sp->sct_type].d_hcms;
			if (work_cost > hcms)
				work_cost = hcms;
		}

		sp->sct_effic += work_cost;
		*money += work_cost*dchr[sp->sct_type].d_build;

		if ((dchr[sp->sct_type].d_lcms>0) || 
			(dchr[sp->sct_type].d_hcms>0)){
			vec[I_LCM] -= work_cost * dchr[sp->sct_type].d_lcms;
			vec[I_HCM] -= work_cost * dchr[sp->sct_type].d_hcms;
		}
	}
	putvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR);
	return work_cost;
}
