#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/supp.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * supp.c
 *
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "land.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

supp()
{
	extern	s_char *argp[];
	int	nunits;
	struct	nstr_item ni;
	struct	lndstr land;
	int	vec[I_MAX+1];

	if (!snxtitem(&ni, EF_LAND, argp[1]))
		return RET_SYN;

	nunits = 0;
	while (nxtitem(&ni, (s_char *)&land)) {
		if (!owner || land.lnd_own == 0)
			continue;
		nunits++;
		resupply_all(&land,1);
		putland(land.lnd_uid,&land);
		if (has_supply(&land))
			pr(fmt("%s #%d has supplies\n",
				lchr[land.lnd_type].l_name, land.lnd_uid));
		else
			pr(fmt("%s #%d is out of supply\n",
				lchr[land.lnd_type].l_name, land.lnd_uid));
	}
	if (nunits == 0) {
		if (argp[1])
			pr(fmt("%s: No unit(s)\n", argp[1]));
		else
			pr(fmt("%s: No unit(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d unit%s\n", nunits, splur(nunits)));
	return RET_OK;
}
