#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/reso.c,v 1.7 89/08/05 03:24:52 jeffw Exp $";
#endif /* not lint */

/*
 * reso.c
 *
 * display natural resources; stolen from cens
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"

static	reso_hdr();

reso()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	int	nsect;
	struct	nstr_sect nstr;

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0)
			reso_hdr();
		if (god)
			pr(fmt("%3d ", sect.sct_own));
		pr(xyfmt("%4d,%-4d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c", dchr[sect.sct_type].d_mnem));
		if (sect.sct_newtype != sect.sct_type)
			pr(fmt("%c", dchr[sect.sct_newtype].d_mnem));
		else
			pr(" ");
		pr(fmt("%4d%%", sect.sct_effic));
		pr(fmt(" %4d", sect.sct_min));
		pr(fmt("%5d", sect.sct_gmin));
		pr(fmt("%5d", sect.sct_fertil));
		pr(fmt("%4d", sect.sct_oil));
		pr(fmt("%5d", sect.sct_uran));
/*		pr(fmt("%5d", sect.sct_elev));*/
		if (!god && sect.sct_terr > 0)
			pr(fmt("%4d", sect.sct_terr));
		pr("\n");
	}
	if (nsect == 0) {
		if (argp[1])
			pr(fmt("%s: No sector(s)\n", argp[1]));
		else
			pr(fmt("%s: No sector(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d sector%s\n", nsect, splur(nsect)));
	return 0;
}

static
reso_hdr()
{
	if (god)
		pr("    ");
	pr("RESOURCE\n");
	if (god)
		pr("own ");
	pr("  sect        eff  min gold fert oil uran ");
	if (!god)
		pr("ter");
	pr("\n");
}
