#ifndef lint
static char *RCSid = "$Header: move.c,v 1.13 89/10/29 15:23:33 mr-frog Exp $";
#endif

/*
 * move.c
 *
 * move commodities around
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "file.h"
#include "deity.h"
#include "xy.h"
#include "nat.h"
#include "nsc.h"
#include "land.h"

static	int move_map();

move()
{
	extern	s_char *argp[];
	register int amount;
	struct	sctstr sect;
	struct	sctstr endsect;
	struct	sctstr start;
	int     packing;
	double	weight;
	int	left;
	int     mcost, dam;
	int     infected;
	int     stype;
	int     vtype;
	int     amt_src;
	int     amt_dst;
	struct	dchrstr *dp;
	struct	ichrstr *ip;
	int     work;
	int     loyal;
	int     own, mob;
	int	istest=0;
	coord	x, y;
	s_char	*p;

	istest = *argp[0] == 't';
	if ((ip = whatitem(argp[1], "move what? ")) == 0)
		return RET_SYN;
	vtype = ip->i_vtype;
	if ((p = getstarg(argp[2], "from sector : ")) == 0)
		return RET_SYN;
	if (!sarg_xy(p, &x, &y))
		return RET_SYN;
	if (!getsect(x, y, &sect) || !owner) {
		pr("Not yours\n");
		return RET_FAIL;
	}
	/*
         * military control necessary to move
         * goodies in occupied territory.
         */
	if ((sect.sct_oldown != cnum) && (vtype != V_MILIT)){
		int     tot_mil=0;
		struct  nstr_item ni;
		struct  lndstr land;
		snxtitem_xy(&ni, EF_LAND, sect.sct_x, sect.sct_y);
		while (nxtitem(&ni, (s_char *)&land)){
			if (land.lnd_own == cnum)
				tot_mil += total_mil(&land);
		}
		if ((getvar(V_MILIT, (s_char *)&sect, EF_SECTOR)+tot_mil) * 10
			< getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR)) {
			pr("Military control required to move goods.\n");
			return RET_FAIL;
		}
	}
	stype = sect.sct_type;
	dp = &dchr[stype];
	infected = getvar(V_PTIME, (s_char *)&sect, EF_SECTOR) == PLG_INFECT;
	if ((amt_src = getvar(vtype, (s_char *)&sect, EF_SECTOR)) <= 0) {
		pr(fmt("No %s in %s\n", ip->i_name, 
			xyas(sect.sct_x, sect.sct_y, cnum)));
		return RET_SYN;
	}
	own = sect.sct_own;
	mob = (int)sect.sct_mobil;
	if (vtype == V_CIVIL && sect.sct_oldown != own) {
		pr("You can't move conquered populace!\n");
		return RET_SYN;
	}
	if (vtype == V_CIVIL) {
		work = sect.sct_work;
		if (work != 100)
			pr("Warning: civil unrest\n");
		loyal = sect.sct_loyal;
	} else if (vtype == V_MILIT) {
		work = 100;
		loyal = 0;
	}
	amount = onearg(argp[3], fmt("Quantity? (max %d) ", amt_src));
	if (amount > amt_src) {
		amount = amt_src;
		pr(fmt("Only moving %d.\n", amount));
	}
	if (amount <= 0)
		return RET_SYN;
	packing = ip->i_pkg[dp->d_pkg];
	if (packing > 1 && sect.sct_effic < 60)
		packing = 1;
	weight = (double)amount * (double)ip->i_lbs / (double)packing;
	/*
	 * First remove commodities from source sector
	 */
	if (!istest){
		getsect(x, y, &start);
		amt_src = getvar(vtype, (s_char *)&start, EF_SECTOR);
		if (amt_src < amount) {
			pr(fmt("Only %d %s left in %s!\n", amt_src,
				ip->i_name,xyas(start.sct_x,start.sct_y,cnum)));
			amount = amt_src;
			amt_src = 0;
		}else
			amt_src -= amount;

		putvar(vtype, amt_src, (s_char *)&start, EF_SECTOR);
		putsect(&start);
	}

	/*
	 * Now parse the path and return ending sector.
	 */
	dam = (istest ? 0 : 1);
	if (dam && !chance((double)weight/200.0))
		dam = 0;
	mcost = move_ground((s_char *)ip, &sect, &endsect,
		(double)sect.sct_mobil, weight, argp[4], move_map, 0, &dam);
if (dam > 0)
filelogerror("%s took %d dam moving %d %s\n",cname(cnum),dam,
	amount, ip->i_name);

	if (dam > 100)
		dam = 100;

	amount = ((float)amount * (100.0 - (float)dam) / 100.0);
if (dam > 0)
filelogerror("\t%s took %d dam now has %d %s\n",cname(cnum),dam,
	amount, ip->i_name);

	if (mcost > 0)
		pr(fmt("Total movement cost = %d\n",mcost));
	else
		pr("No mobility used\n");

	left=0;
	if (mcost < 0) {
		pr("Move aborted\n");
		getsect(x,y,&sect);
		sect.sct_mobil = (u_char)mob;
		left = mob;
	}else if (!istest){
		/*
	 	* decrement mobility appropriately.
	 	*/
		getsect(x, y, &start);
		if (mob < mcost)
			mob = 0;
		else
			mob -= mcost;
		start.sct_mobil = (u_char)mob;
		left = start.sct_mobil;
		putsect(&start);
		getsect(endsect.sct_x, endsect.sct_y, &sect);
	}

	/*
	 * Check for lotsa stuff
	 */
	if (getvar(V_CIVIL, (s_char *)&endsect, EF_SECTOR)+10 < amount/50) {
		pr("Too much traffic for workers in this sector\n");
		getsect(x,y,&sect);
		sect.sct_mobil = (u_char)mob;
		sect.sct_own = own;
		if (sect.sct_oldown == 0)
			sect.sct_oldown = own;
		left = mob;
	}
	if(sect.sct_own != cnum) {
		if (sect.sct_own != 0)
			pr("Somebody has captured that sector!\n");
		getsect(x,y,&sect);
		sect.sct_mobil = (u_char)mob;
		sect.sct_own = own;
		if (sect.sct_oldown == 0)
			sect.sct_oldown = own;
		left = mob;
	}
	if (vtype == V_CIVIL && getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR) &&
	    sect.sct_oldown != cnum) {
		pr("Your civilians don't want to stay!\n");
		getsect(x,y,&sect);
		sect.sct_mobil = (u_char)mob;
		sect.sct_own = own;
		if (sect.sct_oldown == 0)
			sect.sct_oldown = own;
		left = mob;
	}

	if (!istest)
		pr(fmt("%d mob left in %s\n", left,
			xyas(start.sct_x,start.sct_y,cnum)));

	amt_dst = getvar(vtype, (s_char *)&sect, EF_SECTOR);
	if (32767 - amt_dst < amount) {
		amount = 32767 - amt_dst;
		pr(fmt("Only %d can be left there.\n", amount));
	}
	if (istest)
		return RET_OK;
	if (putvar(vtype, amount + amt_dst, (s_char *)&sect, EF_SECTOR) < 0) {
		pr(fmt("No more room in %s.\n", 
			xyas(sect.sct_x, sect.sct_y, cnum)));
		/* charge the player mobility anyway */
		amount = 0;
	}
	/*
	 * Now add commodities to destination sector,
	 * along with plague that came along for the ride.
	 * Takeover unowned sectors if not deity.
	 */
	if (infected && getvar(V_PTIME, (s_char *)&sect, EF_SECTOR) == 0)
		putvar(V_PTIME, PLG_EXPOSED, (s_char *)&sect, EF_SECTOR);
	if (vtype == V_CIVIL) {
#ifdef NEW_WORK
		sect.sct_loyal =( (amt_dst * sect.sct_loyal) + 
				  (amount * loyal) ) / (amt_dst+amount);
		sect.sct_work =( (amt_dst * sect.sct_work) + 
				  (amount * work) ) / (amt_dst+amount);
#else
		/* It only takes one bad apple... */
		if (sect.sct_loyal < loyal)
			sect.sct_loyal = loyal;
		if (sect.sct_work > work)
			sect.sct_work = work;
#endif /* NEW_WORK */
	}
	putsect(&sect);
	return RET_OK;
}

/*
 * Pretty tacky, but it works.
 * If more commands start doing this, then
 * rewrite map to do the right thing.
 */
/*ARGSUSED*/
static
move_map(what, curx, cury, arg)
	s_char	*what;
	int	curx, cury;
	s_char	*arg;
{
	extern	s_char *argp[];
	extern	s_char *condarg;

	argp[1] = arg;
	argp[2] = "";
	argp[3] = "";
	argp[4] = "";
	argp[5] = "";
	condarg = 0;
	map();
}
