#ifndef lint
static char *RCSid = "$Header: load.c,v 1.15 90/03/19 11:09:53 mr-frog Exp $";
#endif /* not lint */

/*
 * load.c
 *
 * load (unload) goods from a sector onto a ship
 *
 * from PSL Empire, 1985
 *
 * hacked to allow planes/missiles to be loaded onto carriers/subs
 * by David Sharnoff 1987 
 * XXX needs to be told "plane" or commodity before amount.
 */

#include "misc.h"
#include "xy.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"	
#include "land.h"	
#include "item.h"
#include "nsc.h"
#include "nat.h"

/*
 * The values 1 and -1 are important below, don't change them.
 */
#define	LOAD	1
#define	UNLOAD	-1

int
load()
{
	extern	s_char *argp[];
	register struct ichrstr *ich;
	register int item;
	register int max_amt;
	register int move_amt;
	register int ship_amt;
	register int sect_amt;
	struct shpstr ship;
	struct sctstr sect;
	struct plnstr pln;	/* for nuke subs */
	struct lndstr land;	/* for nuke subs */
	int     load_unload;
	int     ship_num;
	int     amount;
	int     is_fleet=0,is_plane, is_land;
	int     nplanes, nunits;
	struct nstr_item nbst;
	s_char	*p;
	s_char	*i;
	int	nships;
	struct natstr *np;
	int	rel, upto=0, abs_max;
#ifdef WING_LOAD
	struct nstr_item pl;
	struct nstr_item ln;
#endif /* WING_LOAD */

	if (!(p = getstarg(argp[1], "Ship(s): ")))
		return RET_SYN;
	if (!snxtitem(&nbst, EF_SHIP, p))
		return RET_SYN;
	if (isalpha(*p))
		is_fleet=1;
#ifdef	ALLYHARBOR
	nbst.flags &= ~(EFF_OWNER);
#endif	ALLYHARBOR
	load_unload = **argp == 'l' ? LOAD : UNLOAD;
	p = getstarg(argp[2], "Amount or plane/unit #: ");
	if (p == 0 || *p == 0)
		return RET_SYN;

	amount = atoi(p);
	if (amount < 0) {	/* plane/unit 0 is a valid plane number */
		/* We want to load up to this amount */
		upto = -(amount);
		load_unload = LOAD;
	}

	i = getstarg(argp[3], "What commodity (or 'plane' or 'land'): ");
	if (i == 0 || i[0] == '\0')
		return RET_SYN;

	is_plane = !strncmp(i, "plane", 5);	/* XXX */
	is_land = !strncmp(i, "land", 4);	/* XXX */

	if ((!is_plane) && (!is_land)){
		ich = whatitem(i, (s_char *)0);
		if (ich == 0) {
			pr("Bad commodity.\n");
			return RET_SYN;
		}
		if (amount == 0) {
			pr("Amount must be non-zero!\n");
			return RET_SYN;
		}
	}
#ifndef WING_LOAD
	if (is_plane) {	/* plane sanity */
		if (!getplane(amount, &pln))
			return RET_SYN;
		if (pln.pln_own != cnum) {
			pr("Not your plane\n");
			return RET_FAIL;
		}
		if (!(plchr[pln.pln_type].pl_flags & P_L)
#ifdef XLIGHT
		&&  !(plchr[pln.pln_type].pl_flags & P_E)
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
		&&  !(plchr[pln.pln_type].pl_flags & P_K)
#endif /* SHIPCHOPPERS */
		) {
			pr(fmt(
	"You can only load light planes %s %s onto ships.\n"
#ifdef SHIPCHOPPERS
		,"or helos",
#else
		,"",
#endif /* SHIPCHOPPERS */
#ifdef XLIGHT
		"or xtra-light planes"
#else
		""
#endif /* XLIGHT */
			));
			return RET_FAIL;
		}
		if (load_unload == LOAD && pln.pln_ship > -1) {
			pr(fmt("Plane #%d is already on ship #%d!\n",
				pln.pln_uid, pln.pln_ship));
			return RET_FAIL;
		}
		if (load_unload == LOAD && pln.pln_land > -1) {
			pr(fmt("Plane #%d is already on land unit #%d!\n",
				pln.pln_uid, pln.pln_land));
			return RET_FAIL;
		}
	}
#endif /* WING_LOAD */
#ifndef WING_LOAD
	if (is_land) {	/* land sanity */
		if (!getland(amount, &land))
			return RET_SYN;
		if (land.lnd_own != cnum) {
			pr("Not your unit\n");
			return RET_FAIL;
		}
		if (load_unload == LOAD && land.lnd_ship > -1) {
			pr(fmt("Unit #%d is already on ship #%d!\n",
				land.lnd_uid, land.lnd_ship));
			return RET_FAIL;
		}
	}
#endif /* WING_LOAD */

	nships = 0;
	while (nxtitem(&nbst, (s_char *)&ship)) {
#ifdef	ALLYHARBOR
		if (!ship.shp_own)
#else
		if (!owner)
#endif	ALLYHARBOR
			continue;
#ifdef	ALLYHARBOR
		if (!owner && (load_unload == UNLOAD)) {
			continue;
		}
		if (ship.shp_own != cnum){
			if (is_fleet)
				continue;
			np=getnatp(cnum);
			rel=getrel(np,ship.shp_own);
			if (rel != ALLIED)
				continue;
		}
#endif	ALLYHARBOR
		ship_num = ship.shp_uid;
#ifdef	ALLYHARBOR
		if (!getsect(ship.shp_x, ship.shp_y, &sect)) /* XXX */
			continue;
		if ((sect.sct_own != cnum) && (ship.shp_own != cnum))
			continue;
		if (!owner && (sect.sct_type != SCT_HARBR))
			continue;
		if (!sect.sct_own)
			continue;
#endif	ALLYHARBOR
#ifdef	SHIPNAMES
		pr(fmt("\t%s %s(#%d) at %s\n", mchr[ship.shp_type].m_name,
			ship.shp_name, ship_num, xyas(ship.shp_x, ship.shp_y,
			cnum)));
#else
		pr(fmt("\t%s #%d at %s\n", mchr[ship.shp_type].m_name,
			ship_num, xyas(ship.shp_x, ship.shp_y, cnum)));
#endif	SHIPNAMES
#ifdef	ALLYHARBOR
		if ((sect.sct_own != cnum) && (load_unload == LOAD)) {
			pr(fmt("You don't own %s \n",
#else
		if (!getsect(ship.shp_x, ship.shp_y, &sect)) /* XXX */
			continue;
		if (sect.sct_own != ship.shp_own) {
			pr(fmt("Sector %s is not yours.\n",
#endif	ALLYHARBOR
				xyas(ship.shp_x, ship.shp_y, cnum)));
			continue;
		}
		if (sect.sct_type != SCT_HARBR) {
			pr(fmt("Sector %s is not a harbor.\n",
				xyas(ship.shp_x, ship.shp_y, cnum)));
			continue;
		}
		if (sect.sct_effic < 2) {
			pr(fmt("The harbor at %s is not 2%% efficient yet.\n",
				xyas(ship.shp_x, ship.shp_y, cnum)));
			continue;
		}
		if (is_plane) {
#ifdef WING_LOAD
		        if (!snxtitem(&pl, EF_PLANE, p))
                		return RET_SYN;

			while(nxtitem(&pl, (s_char *)&pln)) {
#endif /* WING_LOAD */
			
#ifndef WING_LOAD
			/* Note that there is only one plane per transaction */
#endif /* WING_LOAD */
#ifdef WING_LOAD
                		if (pln.pln_own != cnum)
                        		continue;
                		if (!(plchr[pln.pln_type].pl_flags & P_L)
#ifdef XLIGHT
                		&&  !(plchr[pln.pln_type].pl_flags & P_E)
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
                		&&  !(plchr[pln.pln_type].pl_flags & P_K)
#endif /* SHIPCHOPPERS */
                		) {
                        		pr(fmt(
        	"You can only load light planes %s %s onto ships.\n"
#ifdef SHIPCHOPPERS
                			,"or helos",
#else
                			,"",
#endif /* SHIPCHOPPERS */
#ifdef XLIGHT
                			"or xtra-light planes"
#else
                			""
#endif /* XLIGHT */
                        		));
                        		continue;
                		}
                		if (load_unload == LOAD && pln.pln_ship > -1) {
                        		pr(fmt("Plane #%d is already on ship #%d!\n",
                                		pln.pln_uid, pln.pln_ship));
                        		continue;
	                	}
                		if (load_unload == LOAD && pln.pln_land > -1) {
                        		pr(fmt("Plane #%d is already on land unit #%d!\n",
                                		pln.pln_uid, pln.pln_land));
                        		continue;
	                	}
#endif /* WING_LOAD */
			/* Plane sanity done */
			/* Find the right ship */
			if (load_unload == UNLOAD) {
				if (pln.pln_ship != ship.shp_uid)
					continue;
			} else if (ship.shp_x != pln.pln_x
			    	|| ship.shp_y != pln.pln_y)
				continue;

			/* ship to (plane or missle) sanity */
#if defined (XLIGHT) || defined (SHIPCHOPPERS)
#else
			if (plchr[pln.pln_type].pl_flags & P_M) {
				if (!(mchr[ship.shp_type].m_flags &
					M_MSL)) {
#ifdef	SHIPNAMES
					pr(fmt("%s %s(#%d) cannot carry missles.\n",
						mchr[ship.shp_type].m_name,
						ship.shp_name,
#else
					pr(fmt("%s #%d cannot carry missles.\n",
						mchr[ship.shp_type].m_name,
#endif	SHIPNAMES
						ship.shp_uid));
					continue;
				}
			} else if (plchr[pln.pln_type].pl_flags & P_L) {
				if (!(mchr[ship.shp_type].m_flags & M_FLY)) {
#ifdef	SHIPNAMES
					pr(fmt("%s %s(#%d) cannot carry planes.\n",
						mchr[ship.shp_type].m_name,
						ship.shp_name,
#else
					pr(fmt("%s #%d cannot carry planes.\n",
						mchr[ship.shp_type].m_name,
#endif	SHIPNAMES
						ship.shp_uid));
					continue;
				}
			} /* else cannot happen */
#endif
			/* Fit plane on ship */
                        count_planes(&ship);
			if (load_unload == LOAD){
				if (!put_plane_on_ship(&pln,&ship)){
					pr(fmt("Can't put plane %d on this ship!\n",pln.pln_uid));
					continue;
				}
				gift(ship.shp_own,cnum,(s_char *)&pln,EF_PLANE,
					fmt("loaded on your ship #%d at %s",
					ship.shp_uid,xyas(ship.shp_x,ship.shp_y,
					ship.shp_own)));
				pln.pln_own = ship.shp_own;
				pln.pln_mission = 0;
				putplane(pln.pln_uid,&pln);
			}else{
				if (!take_plane_off_ship(&pln,&ship)){
					pr(fmt("Unable to take plane off ship!\n"));
					logerror("load: plane %d could not be taken off ship %d\n",pln.pln_uid,ship.shp_uid);
					continue;
				}
				gift(sect.sct_own,cnum,(s_char *)&pln,EF_PLANE,
					fmt("unloaded in your harbor at %s",
					xyas(sect.sct_x,sect.sct_y,
					sect.sct_own)));
				pln.pln_own = sect.sct_own;
				putplane(pln.pln_uid,&pln);
			}
			pr(fmt("%s #%d %s ship #%d.\n",
				plchr[pln.pln_type].pl_flags & P_M ?
					"Missile" : "Plane",
				pln.pln_uid,
				(load_unload==UNLOAD)?
					"unloaded from":"loaded onto",
				ship.shp_uid,
				xyas(ship.shp_x, ship.shp_y, cnum)));
#ifdef WING_LOAD
			}
#endif /* WING_LOAD */
			return RET_OK;
		}
		if (is_land) {
#ifdef WING_LOAD
		        if (!snxtitem(&ln, EF_LAND, p))
                		return RET_SYN;

			while(nxtitem(&ln, (s_char *)&land)) {
#endif /* WING_LOAD */
			
#ifndef WING_LOAD
			/* Note that there is only one unit per transaction */
#endif /* WING_LOAD */
#ifdef WING_LOAD
                		if (land.lnd_own != cnum)
                        		continue;

                		if (load_unload == LOAD && land.lnd_ship > -1) {
                        		pr(fmt("Unit #%d is already on ship #%d!\n",
                                		land.lnd_uid, land.lnd_ship));
                        		continue;
	                	}
#endif /* WING_LOAD */
			/* Unit sanity done */
			/* Find the right ship */
			if (load_unload == UNLOAD) {
				if (land.lnd_ship != ship.shp_uid)
					continue;
			} else if (ship.shp_x != land.lnd_x
			    	|| ship.shp_y != land.lnd_y)
				continue;

			if ((!(lchr[land.lnd_type].l_flags & L_LIGHT)) &&
				(!((mchr[ship.shp_type].m_flags & M_SUPPLY) &&
				(!(mchr[ship.shp_type].m_flags & M_SUB))))){
				pr(fmt("You can only load light units onto ships,\n"));
				pr(fmt("unless the ship is a non-sub supply ship.\n"));
				pr(fmt("%s #%d not loaded\n", lchr[land.lnd_type].l_name, land.lnd_uid));
				continue;
			}
			/* Fit unit on ship */
                        getship(ship.shp_uid,&ship);
			if (load_unload == LOAD){
				struct plnstr pi;
				struct nstr_item ni;

				if (ship.shp_nland >= mchr[ship.shp_type].m_nland){
					pr(fmt("Can't put unit %d on this ship!\n",land.lnd_uid));
					continue;
				}
				gift(ship.shp_own,cnum,(s_char *)&land,EF_LAND,
					fmt("loaded on your ship #%d at %s",
					ship.shp_uid,xyas(ship.shp_x,ship.shp_y,
					ship.shp_own)));
				land.lnd_own = ship.shp_own;
				land.lnd_ship = ship.shp_uid;
				land.lnd_harden = 0;
				land.lnd_mission = 0;
				ship.shp_nland++;
				putland(land.lnd_uid,&land);
				putship(ship.shp_uid,&ship);
				snxtitem_xy(&ni,EF_PLANE,land.lnd_x,land.lnd_y);
				while (nxtitem(&ni, (s_char *)&pi)){
					if (pi.pln_flags & PLN_LAUNCHED)
						continue;
					if (pi.pln_land != land.lnd_uid)
						continue;
					gift(ship.shp_own,cnum,(s_char *)&pi,
						EF_PLANE,
						fmt("loaded on ship #%d",
						ship.shp_uid));
					pi.pln_own = ship.shp_own;
					pi.pln_mission = 0;
					putplane(pi.pln_uid,&pi);
				}
			}else{
				struct plnstr pi;
				struct nstr_item ni;

				gift(sect.sct_own,cnum,(s_char *)&land,EF_LAND,
					fmt("unloaded in your harbor at %s",
					xyas(sect.sct_x,sect.sct_y,
					sect.sct_own)));
				land.lnd_own = sect.sct_own;
				land.lnd_ship = (-1);
				ship.shp_nland--;
				putland(land.lnd_uid,&land);
				putship(ship.shp_uid,&ship);
				snxtitem_xy(&ni,EF_PLANE,land.lnd_x,land.lnd_y);
				while (nxtitem(&ni, (s_char *)&pi)){
					if (pi.pln_flags & PLN_LAUNCHED)
						continue;
					if (pi.pln_land != land.lnd_uid)
						continue;
					gift(sect.sct_own,cnum,(s_char *)&pi,
						EF_PLANE,
						fmt("unloaded at %s",
						xyas(pi.pln_x,pi.pln_y,
						sect.sct_own)));
					pi.pln_own = sect.sct_own;
					pi.pln_mission = 0;
					putplane(pi.pln_uid,&pi);
				}
			}
			pr(fmt("%s #%d %s ship #%d.\n",
				lchr[land.lnd_type].l_name, land.lnd_uid,
				(load_unload==UNLOAD)?
					"unloaded from":"loaded onto",
				ship.shp_uid,
				xyas(ship.shp_x, ship.shp_y, cnum)));
#ifdef WING_LOAD
			}
#endif /* WING_LOAD */
			return RET_OK;
		}
		item = ich->i_vtype;
		ship_amt = getvar(item, (s_char *)&ship, EF_SHIP);
		sect_amt = getvar(item, (s_char *)&sect, EF_SECTOR);
		if (sect.sct_oldown != cnum && item == V_CIVIL) {
			pr(fmt("%s civilians refuse to %s at %s!\n",
				load_unload == UNLOAD ? "Your" : "Foreign",
				load_unload == UNLOAD ?
					"disembark" : "board",
				xyas(sect.sct_x, sect.sct_y, cnum)));
			continue;
		}
		if (load_unload == UNLOAD) {
			abs_max = max_amt = min(999 - sect_amt, ship_amt);
		} else {
			struct mchrstr *vbase;
			vbase = &mchr[ship.shp_type];
			abs_max = max_amt = vl_find(item, vbase->m_vtype,
				vbase->m_vamt, (int) vbase->m_nv);
			max_amt = min(sect_amt, max_amt - ship_amt);
		}
		if ((max_amt <= 0) && (upto == 0))
			continue;
		if (upto){
			move_amt = upto - ship_amt;
			if (move_amt > sect_amt)
				move_amt = sect_amt;
			if (ship_amt+move_amt > abs_max)
				move_amt = abs_max - ship_amt;
		}else
			move_amt = load_unload * min(amount, max_amt);
		if (move_amt == 0)
			continue;
		putvar(item, sect_amt - move_amt, (s_char *)&sect, EF_SECTOR);
		putvar(item, ship_amt + move_amt, (s_char *)&ship, EF_SHIP);
		/* load/unload plague */
		if (getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) == PLG_INFECT &&
		    getvar(V_PSTAGE, (s_char *)&ship, EF_SHIP) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&ship, EF_SHIP);
		if (getvar(V_PSTAGE, (s_char *)&ship, EF_SHIP) == PLG_INFECT &&
		    getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&sect, EF_SECTOR);

		putsect(&sect);
		putship(ship_num, &ship);
		nships++;
	}
	if (nships == 0)
		pr("No ships affected\n");
	else
		pr(fmt("%d ship%s %sloaded\n", nships, splur(nships),
			load_unload == UNLOAD ? "un" : ""));
	return RET_OK;
}

int
lload()
{
	extern	s_char *argp[];
	register struct ichrstr *ich;
	register int item;
	register int max_amt;
	register int move_amt;
	register int land_amt;
	register int sect_amt;
	struct lndstr land;
	struct sctstr sect;
	struct plnstr pln;	/* for nuke subs */
	int     load_unload;
	int     land_num;
	int     amount;
	int     is_army=0,is_plane;
	int     nplanes;
	struct nstr_item nbst;
	s_char	*p;
	s_char	*i;
	int	nunits;
	struct natstr *np;
	int	rel, upto=0, abs_max;
#ifdef WING_LOAD
	struct nstr_item pl;
#endif /* WING_LOAD */

	if (!(p = getstarg(argp[1], "Unit(s): ")))
		return RET_SYN;
	if (!snxtitem(&nbst, EF_LAND, p))
		return RET_SYN;
	if (isalpha(*p))
		is_army=1;

	load_unload = *(*argp+1) == 'l' ? LOAD : UNLOAD;
	p = getstarg(argp[2], "Amount or plane #: ");
	if (p == 0 || *p == 0)
		return RET_SYN;
#ifdef WING_LOAD
	if (isalpha(*p))
		is_plane=1;
	else{
#endif /* WING_LOAD */
	amount = atoi(p);
	if (amount < 0) {	/* plane/unit 0 is a valid plane number */
		/* We want to load up to this amount */
		upto = -(amount);
		load_unload = LOAD;
	}
#ifdef WING_LOAD
	}
#endif /* WING_LOAD */
	i = getstarg(argp[3], "What commodity ('plane' for a plane): ");
	if (i == 0 || i[0] == '\0')
		return RET_SYN;
#ifdef WING_LOAD
	is_plane = (is_plane == 1 ? 1 : !strncmp(i, "plane", 5));/* XXX */
#else
	is_plane = !strncmp(i, "plane", 5);	/* XXX */
#endif /* WING_LOAD */
	if (!is_plane) {
		ich = whatitem(i, (s_char *)0);
		if (ich == 0) {
			pr("Bad commodity.\n");
			return RET_SYN;
		}
		if (amount == 0) {
			pr("Amount must be non-zero\n");
			return RET_SYN;
		}
	}
#ifndef WING_LOAD
	if (is_plane) {	/* plane sanity */
		if (!getplane(amount, &pln))
			return RET_SYN;
		if (pln.pln_own != cnum) {
			pr("Not your plane\n");
			return RET_FAIL;
		}
#ifdef XLIGHT
		if (!(plchr[pln.pln_type].pl_flags & P_E))
		) {
pr(fmt("You can only load xlight planes %s %s onto units.\n"));
			return RET_FAIL;
		}
#else
		pr(fmt("You can't load planes onto units!\n"));
		return RET_FAIL;
#endif /* XLIGHT*/
		if (load_unload == LOAD && pln.pln_land > -1) {
			pr(fmt("Plane #%d is already on land unit #%d!\n",
				pln.pln_uid, pln.pln_land));
			return RET_FAIL;
		}
		if (load_unload == LOAD && pln.pln_ship > -1) {
			pr(fmt("Plane #%d is already on ship #%d!\n",
				pln.pln_uid, pln.pln_ship));
			return RET_FAIL;
		}
	}
#endif /* WING_LOAD */
	nunits = 0;
	while (nxtitem(&nbst, (s_char *)&land)) {
		if (!owner)
			continue;

		land_num = land.lnd_uid;

		pr(fmt("\t%s #%d at %s\n", lchr[land.lnd_type].l_name,
			land_num, xyas(land.lnd_x, land.lnd_y, cnum)));

		if (!getsect(land.lnd_x, land.lnd_y, &sect)) /* XXX */
			continue;

		if (sect.sct_own != land.lnd_own) {
			pr(fmt("Sector %s is not yours.\n",
				xyas(land.lnd_x, land.lnd_y, cnum)));
			continue;
		}

#ifdef XLIGHT
		if (is_plane) {
#ifdef WING_LOAD
		        if (!snxtitem(&pl, EF_PLANE, p))
                		return RET_SYN;

			while(nxtitem(&pl, (s_char *)&pln)) {
#endif /* WING_LOAD */
			
#ifndef WING_LOAD
			/* Note that there is only one plane per transaction */
#endif /* WING_LOAD */
#ifdef WING_LOAD
                		if (pln.pln_own != cnum)
                        		continue;

                		if (!(plchr[pln.pln_type].pl_flags & P_E)) {
pr(fmt("You can only load xlight planes onto units.\n"));
                        		continue;
                		}

                		if (load_unload == LOAD && pln.pln_ship > -1) {
                        		pr(fmt("Plane #%d is already on ship #%d!\n",
                                		pln.pln_uid, pln.pln_ship));
                        		continue;
	                	}
                		if (load_unload == LOAD && pln.pln_land > -1) {
                        		pr(fmt("Plane #%d is already on unit #%d!\n",
                                		pln.pln_uid, pln.pln_land));
                        		continue;
	                	}
#endif /* WING_LOAD */
			/* Plane sanity done */
			/* Find the right unit */
			if (load_unload == UNLOAD) {
				if (pln.pln_land != land.lnd_uid)
					continue;
			} else if (land.lnd_x != pln.pln_x
			    	|| land.lnd_y != pln.pln_y)
				continue;

			/* unit to (plane or missle) sanity */
			if (!(lchr[land.lnd_type].l_flags & L_XLIGHT)){
				pr(fmt("%s #%d cannot carry planes.\n",
					lchr[land.lnd_type].l_name,
						land.lnd_uid));
				continue;
				}
			/* Fit plane on unit */
                        count_land_planes(&land);
			if (load_unload == LOAD){
				if (!put_plane_on_land(&pln,&land)){
					pr(fmt("Can't put plane %d on this unit!\n",pln.pln_uid));
					continue;
				}
				gift(land.lnd_own,cnum,(s_char *)&pln,EF_PLANE,
					fmt("loaded on your unit #%d at %s",
					land.lnd_uid,
					xyas(land.lnd_x,land.lnd_y,
					land.lnd_own)));
				pln.pln_own = land.lnd_own;
				putplane(pln.pln_uid,&pln);
			}else{
				if (!take_plane_off_land(&pln,&land)){
					pr(fmt("Unable to take plane off unit!\n"));
					logerror("load: plane %d could not be taken off unit %d\n",pln.pln_uid,land.lnd_uid);
					continue;
				}
				gift(sect.sct_own,cnum,(s_char *)&pln,EF_PLANE,
					fmt("unloaded at your sector at %s",
					xyas(sect.sct_x,sect.sct_y,
					sect.sct_own)));
				pln.pln_own = sect.sct_own;
				putplane(pln.pln_uid,&pln);
			}
			pr(fmt("%s #%d %s unit #%d.\n",
				plchr[pln.pln_type].pl_flags & P_M ?
					"Missile" : "Plane",
				pln.pln_uid,
				(load_unload==UNLOAD)?
					"unloaded from":"loaded onto",
				land.lnd_uid,
				xyas(land.lnd_x, land.lnd_y, cnum)));
#ifdef WING_LOAD
			}
#endif /* WING_LOAD */
			return RET_OK;
		}
#endif /* XLIGHT */
		item = ich->i_vtype;
		land_amt = getvar(item, (s_char *)&land, EF_LAND);
		sect_amt = getvar(item, (s_char *)&sect, EF_SECTOR);
		if (sect.sct_oldown != cnum && item == V_CIVIL) {
			pr(fmt("%s civilians refuse to %s at %s!\n",
				load_unload == UNLOAD ? "Your" : "Foreign",
				load_unload == UNLOAD ?
					"disembark" : "board",
				xyas(sect.sct_x, sect.sct_y, cnum)));
			continue;
		}
		if (load_unload == UNLOAD) {
			abs_max = max_amt = min(999 - sect_amt, land_amt);
		} else {
			struct lchrstr *vbase;
			vbase = &lchr[land.lnd_type];
			abs_max = max_amt = vl_find(item, vbase->l_vtype,
				vbase->l_vamt, (int) vbase->l_nv);
			max_amt = min(sect_amt, max_amt - land_amt);
		}
		if ((max_amt <= 0) && (upto == 0))
			continue;
		if (upto){
			move_amt = upto - land_amt;
			if (land_amt+move_amt > abs_max)
				move_amt = abs_max - land_amt;
			if (move_amt > sect_amt)
				move_amt = sect_amt;
		}else
			move_amt = load_unload * min(amount, max_amt);
		if (move_amt == 0)
			continue;
		putvar(item, sect_amt - move_amt, (s_char *)&sect, EF_SECTOR);
		putvar(item, land_amt + move_amt, (s_char *)&land, EF_LAND);
		/* load/unload plague */
		if (getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) == PLG_INFECT &&
		    getvar(V_PSTAGE, (s_char *)&land, EF_LAND) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&land, EF_LAND);
		if (getvar(V_PSTAGE, (s_char *)&land, EF_LAND) == PLG_INFECT &&
		    getvar(V_PSTAGE, (s_char *)&sect, EF_SECTOR) == PLG_HEALTHY)
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&sect, EF_SECTOR);

		putsect(&sect);
		putland(land_num, &land);
		nunits++;
	}
	if (nunits == 0)
		pr("No units affected\n");
	else
		pr(fmt("%d unit%s %sloaded\n", nunits, splur(nunits),
			load_unload == UNLOAD ? "un" : ""));
	return RET_OK;
}

gift(givee, giver, ptr, type, mesg)
int   givee, giver;
s_char  *ptr;
int     type;
s_char  *mesg;
{
	struct	shpstr *sp = (struct shpstr *)ptr;
	struct	plnstr *pp = (struct plnstr *)ptr;
	struct	lndstr *lp = (struct lndstr *)ptr;
	struct	mchrstr *mcp;
	struct	plchrstr *pcp;
	struct	lchrstr *lcp;
	s_char	buf[80], line[256];

	if (giver == givee)
		return;

	bzero(buf,80);
	bzero(line,256);
	switch(type){
		case EF_SHIP:	mcp = &mchr[sp->shp_type];
				sprintf(buf,"%s #%d",mcp->m_name,sp->shp_uid);
				break;
		case EF_PLANE:	pcp = &plchr[pp->pln_type];
				sprintf(buf,"%s #%d",pcp->pl_name,pp->pln_uid);
				break;
		case EF_LAND:	lcp = &lchr[lp->lnd_type];
				sprintf(buf,"%s #%d",lcp->l_name,lp->lnd_uid);
				break;
	}

	sprintf(line,"%s %s %s\n",cname(giver),buf,mesg);
	wu(0,givee,line);
}
