#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/land.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * land.c
 *
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "land.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"

land()
{
	extern	s_char *argp[];
	int	nunits;
	struct	nstr_item ni;
	struct	lndstr land;
	int	vec[I_MAX+1];

	if (!snxtitem(&ni, EF_LAND, argp[1]))
		return RET_SYN;

	nunits = 0;
	while (nxtitem(&ni, (s_char *)&land)) {
		if (land.lnd_own == 0)
			continue;
		if (!owner && !god)
			continue;
		if (land.lnd_type < 0 || land.lnd_type > lnd_maxno) {
			pr(fmt("bad unit type %d (#%d)\n",
				land.lnd_type, ni.cur));
			continue;
		}
		count_land_planes(&land);

		if (nunits++ == 0) {
			if (god)
				pr("own ");
pr("   # unit type             x,y   a  eff fort  mu food");
#ifdef FUEL
		pr(" fuel");
#endif /* FUEL */
		pr(" tech retr rad");
#ifdef XLIGHT
			pr(" xl");
#endif /* XLIGHT */
		pr(" ship\n");
		}
		if (god)
			pr(fmt("%3d ", land.lnd_own));
		pr(fmt("%4d ", ni.cur));
		pr(fmt("%-16.16s ", lchr[land.lnd_type].l_name));
		pr(fmt("  %s", xyfmt("%4d,%-4d", land.lnd_x,
			land.lnd_y, cnum)));
		pr(fmt("%c", land.lnd_army));
		pr(fmt("%4d%%", land.lnd_effic));
		pr(fmt("%5d", land.lnd_harden));
		pr(fmt("%4d", land.lnd_mobil));
		getvec(VT_ITEM, vec, (s_char *)&land, EF_LAND);
		pr(fmt("%5d", vec[I_FOOD]));
#ifdef FUEL
		pr(fmt("%5d",land.lnd_fuel));
#endif /* FUEL */
		pr(fmt("%5d ", land.lnd_tech));
		pr(fmt("%3d%%", land.lnd_retreat));
		pr(fmt("%4d%", land.lnd_rad_max));
#ifdef XLIGHT
		pr(fmt("%3d",land.lnd_nxlight));
#endif /* XLIGHT */
		if (land.lnd_ship >= 0)
			pr(fmt("%5d\n",land.lnd_ship));
		else
			pr("\n");
	}
	if (nunits == 0) {
		if (argp[1])
			pr(fmt("%s: No unit(s)\n", argp[1]));
		else
			pr(fmt("%s: No unit(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d unit%s\n", nunits, splur(nunits)));
	return RET_OK;
}
