#ifndef lint
static char *RCSid = "$Header: cede.c,v 1.13 89/08/04 20:10:39 jeffw Exp $";
#endif /* not lint */

/*
 * cede.c
 *
 * give a sector to a neighbor
 *
 * (idea for this command blatantly stolen from Dave Pare's Empire 2.0 --ts :-)
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"
#include "plane.h"
#include "land.h"
#include "ship.h"
#include "item.h"

static	cede_hdr();

cede()
{
	extern	s_char *argp[];
	natid	to, n;
	int	is_sector=0,is_ship=0;
	s_char	*p;
	struct	nstr_sect ns;
	struct	nstr_item ni;
	s_char	buf[80];

	bzero(buf,80);
	if (argp[1] == (s_char *)0){
		if ((p = getstarg((s_char *)0, "Cede what? ")) == 0)
			return RET_SYN;
		bcopy(p,buf,strlen(p));
	}else
		bcopy(argp[1],buf,strlen(argp[1]));

	if (snxtsct(&ns, buf))
		is_sector = 1;

	if (snxtitem(&ni, EF_SHIP, buf))
		is_ship = 1;
	
	if (!is_sector && !is_ship)
		return RET_SYN;

	if (is_sector && is_ship){
		int	type;

		if ((p = getstarg((s_char *)0, "Cede sectors or ships (se, sh)? ")) == 0)
			return RET_FAIL;

		type = ef_byname(p);

		if (type == EF_SECTOR)
			is_ship = 0;
		else if (type == EF_SHIP)
			is_sector = 0;
		else{
			pr("Please type 'sector' or 'ship'!\n");
			return RET_FAIL;
		}
	}

	if ((n = natarg(argp[2], "to which country? ")) < 0)
		return RET_SYN;

	if (n == cnum){
		pr("Giving to yourself? Better see a doctor for that split personality!\n");
		return RET_FAIL;
	}
	to = n;

	if (is_sector)
		return cede_sect(&ns,to);
	else
		return cede_ship(&ni,to);
}

cede_sect(ns, to)
struct  nstr_sect *ns;
natid	to;
{
	struct	sctstr sect, osect;
	int	nsect;
	int	n, bad;
	s_char	dirstr[20];
	int	vec[I_MAX+1], off_x, off_y;
	struct	nstr_item ni;
	struct	shpstr ship;

	prdate();
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	dirstr[0] = '.';
	dirstr[7] = '$';
	dirstr[8] = '\0';
	nsect = 0;
	while (nxtsct(ns, &sect)) {
		if (!owner)
			continue;
		if (sect.sct_mobil == 0){
			pr(fmt("%s has no mobility and cannot be ceded\n",
				xyas(sect.sct_x,sect.sct_y,cnum)));
			continue;
		}

		bad = 1;
		for (n = 1; n <= 6; n++) {      /* Directions */
			off_x = sect.sct_x + diroff[n][0];
			off_y = sect.sct_y + diroff[n][1];

			if (!getsect(off_x, off_y, &osect))
				continue;
			if ((osect.sct_own == to) && (osect.sct_mobil>0))
				bad=0;
		}
		snxtitem_all(&ni,EF_SHIP);
		while (nxtitem(&ni, (s_char *)&ship)){
			if ((ship.shp_own == to) &&
				((ship.shp_x == sect.sct_x) &&
				(ship.shp_y == sect.sct_y)))
				bad = 0;
		}
		if (bad){
			pr(fmt("%s has no sector with mobility adjacent to or ship in %s!\n",
				cname(to), xyas(sect.sct_x,sect.sct_y,cnum)));
			continue;
		}

		if (nsect++ == 0)
			cede_hdr();

		grab_sect(&sect,to);
		putsect(&sect);
		pr(fmt("  %s %d%% ceded\n",xyas(sect.sct_x,sect.sct_y,cnum),
			(int)sect.sct_effic));
		wu(0,(natid)to,fmt("%s ceded to you by %s\n",
			xyas(sect.sct_x,sect.sct_y,to), cname(cnum)));
	}
	pr(fmt("%d sector%s\n", nsect, splur(nsect)));
	return RET_OK;
}

static
cede_hdr()
{
	if (god)
		pr("own ");
	pr("  sect eff\n");
}



int
grab_sect(sp, to)
register struct sctstr *sp;
natid	to;
{
	register struct plnstr *pp;
	register struct lndstr *lp;
	int	civ;
	int	che;
	int	che_count;
	int	oldche;
	int	n;
	struct	nstr_item ni;
	struct	plnstr p;
	struct	lndstr l;
	struct	nstr_sect nstr;
	int	vec[I_MAX+1];

	/* Wipe all the distribution info */
	bzero(vec, sizeof(vec));
	putvec(VT_DIST, vec, (s_char *)sp, EF_SECTOR);
	putvec(VT_DEL, vec, (s_char *)sp, EF_SECTOR);
	sp->sct_dist_x = sp->sct_x;
	sp->sct_dist_y = sp->sct_y;

	pp = &p;
	snxtitem_xy(&ni, EF_PLANE, sp->sct_x, sp->sct_y);
	while (nxtitem(&ni, (caddr_t)pp)) {
		if (pp->pln_own == 0)
			continue;

		if (pp->pln_flags & PLN_LAUNCHED)
			continue;

		wu(0,to,fmt("\t%s #%d ceded to you by %s\n",
			plchr[pp->pln_type].pl_name,
			pp->pln_uid, cname(cnum)));
		pp->pln_own = to;
		pp->pln_mobil = 0;
		pp->pln_mission = 0;
		putplane(ni.cur, pp);
	}

	lp = &l;
	snxtitem_xy(&ni, EF_LAND, sp->sct_x, sp->sct_y);
	while (nxtitem(&ni, (caddr_t)lp)) {
		if (lp->lnd_own == 0)
			continue;

		wu(0,to,fmt("\t%s #%d ceded to you by %s\n",
			lchr[lp->lnd_type].l_name,
			lp->lnd_uid, cname(cnum)));
		lp->lnd_own = to;
		lp->lnd_mobil = 0;
		lp->lnd_mission = 0;
		putland(ni.cur, lp);
	}

	sp->sct_avail = 0;

	if (sp->sct_oldown == to){
		oldche = get_che_value(getvar(V_CHE, (s_char *)sp, EF_SECTOR));
		set_che_value(che, 0);
		set_che_cnum(che, 0);
		(void) putvar(V_CHE, che, (s_char *)sp, EF_SECTOR);
		sp->sct_loyal = 0;
	}

	if (sp->sct_oldown == to)
		sp->sct_loyal = 0;
	else /* people don't like being given away */
		sp->sct_loyal = 50;

	sp->sct_dist_x = sp->sct_x;
	sp->sct_dist_y = sp->sct_y;
	if (sp->sct_oldown == sp->sct_own)
		sp->sct_oldown = to;
	sp->sct_own = to;
	sp->sct_mobil = 0;
}

cede_ship(ni,to)
struct	nstr_item *ni;
natid	to;
{
	struct	shpstr ship;
	struct	shpstr tship;
	struct	sctstr sect;
	struct	nstr_item tni;
	int	nships=0;
	int	bad=0;
	
	while (nxtitem(ni, (s_char *)&ship)) {

		if (!owner || ship.shp_own == 0)
			continue;

		bad = 1;
		snxtitem_xy(&tni,EF_SHIP,ship.shp_x,ship.shp_y);
		while (nxtitem(&tni, (s_char *)&tship) && bad)
			if (tship.shp_own == to)
				bad = 0;

		getsect(ship.shp_x,ship.shp_y,&sect);
		if (bad && (sect.sct_own != to)){
			pr(fmt("%s #%d isn't in a %s sector, and is not with a %s ship!\n",
				mchr[ship.shp_type].m_name, ship.shp_uid,
				cname(to), cname(to)));
			continue;
		}
		grab_ship(&ship,to);
		putship(ship.shp_uid,&ship);
		nships++;
		wu(0,to,fmt("%s #%d ceded to you by %s\n",
			mchr[ship.shp_type].m_name,
			ship.shp_uid, cname(cnum)));
		pr(fmt("%s #%d ceded to %s\n",
			mchr[ship.shp_type].m_name,
			ship.shp_uid, cname(to)));
	}
	pr(fmt("    %d ship%s\n", nships, splur(nships)));

	return RET_OK;
}

int
grab_ship(sp, to)
register struct shpstr *sp;
natid	to;
{
	register struct plnstr *pp;
	register struct lndstr *lp;
	int	n;
	struct	nstr_item ni;
	struct	plnstr p;
	struct	lndstr l;

	pp = &p;
	snxtitem_xy(&ni, EF_PLANE, sp->shp_x, sp->shp_y);
	while (nxtitem(&ni, (caddr_t)pp)) {
		if (pp->pln_own == 0)
			continue;

		if (pp->pln_flags & PLN_LAUNCHED)
			continue;

		if (pp->pln_ship != sp->shp_uid)
			continue;

		wu(0,to,fmt("\t%s #%d ceded to you by %s\n",
			plchr[pp->pln_type].pl_name,
			pp->pln_uid, cname(cnum)));
		pp->pln_own = to;
		pp->pln_mobil = 0;
		pp->pln_mission = 0;
		putplane(ni.cur, pp);
	}

	lp = &l;
	snxtitem_xy(&ni, EF_LAND, sp->shp_x, sp->shp_y);
	while (nxtitem(&ni, (caddr_t)lp)) {
		if (lp->lnd_own == sp->shp_uid)
			continue;
		if (lp->lnd_ship != sp->shp_uid)
			continue;

		wu(0,to,fmt("\t%s #%d ceded to you by %s\n",
			lchr[lp->lnd_type].l_name,
			lp->lnd_uid, cname(cnum)));
		lp->lnd_own = to;
		lp->lnd_mobil = 0;
		lp->lnd_mission = 0;
		putland(ni.cur, lp);
	}

	sp->shp_own = to;
}
