#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/buy.c,v 1.7 89/09/10 19:22:42 mr-frog Exp $";
#endif /* not lint */

/*
 * buy.c
 *
 * engage in inter-nation trading of commodities.
 * each nation has a list of prices, and multipliers for
 * other nations.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "xy.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"
#include "deity.h"

/*
 * format: buy <COMMODITY>
 *
 */
buy()
{
	extern	s_char *argp[];
	struct sctstr sect;
	struct natstr *natp;
	int	qty;
	natid	seller;
	int	sellers;
	float	price, newprice;
	int	amt, new_amt;
	int	n;
	natid	cn;
	coord	x, y;
	s_char	*p;
	struct	ichrstr *ip;
	int	product;
	extern double	buytax;

	natp = getnatp(cnum);
	ip = whatitem(argp[1], "which commodity : ");
	if (ip == 0)
		return RET_SYN;
	if (ip->i_sell == 0) {
		pr(fmt("%s cannot be traded!\n", ip->i_name));
		return RET_FAIL;
	}
	product = ip - ichr;
	if (commread() < 0) {
		pr("Cannot read commodity file; get help!\n");
		logerror("buy: commread failed");
		return RET_SYS;
	}
	n = 0;
	if (argp[2] == 0) {
		/*
		 * if user didn't supply arg, then show what's on sale
		 */
		sellers = 0;
		for (cn=0; cn<MAXNOC; cn++) {
			if ((amt = commamt(cn, product, &price)) <= 0)
				continue;
			if (sellers == 0) {
				pr(fmt("Trade report : %s\n", ip->i_name));
				pr(" cnum      country   amount  item price\n");
			}
			pr(fmt("#%3d: %12.12s %7d %7.2f", cn, cname(cn),
				amt, price));
			if (cn == cnum && !god)
				pr(" (your own lot)\n");
			else
				pr("\n");
			sellers++;
		}
		if (sellers == 0) {
			pr(fmt("Trade report:  No one is selling %s.\n",
				ip->i_name));
			return RET_FAIL;
		}
	}
	if ((n = natarg(argp[2], "Buy from : ")) < 0)
		return RET_SYN;
	seller = n;
	if (seller == cnum) {
		pr("You cannot buy from yourself!\n");
		return RET_FAIL;
	}
	if ((amt = commamt(seller, product, &price)) < 0) {
		pr(fmt("%s isn't selling %s\n", cname(seller), ip->i_name));
		return RET_FAIL;
	}
	p = getstarg(argp[3],
		fmt("Number of %s to buy (max %d) @ %7.2f per : ",
			ip->i_name, amt, price));
	if (p == 0 || *p == 0)
		return RET_SYN;
	if ((qty = atoi(p)) < 0 || qty > amt) {
		pr("Invalid quantity\n");
		return RET_FAIL;
	}
	if (natp->nat_money < (price * qty * buytax)) {
		pr(fmt(
		"This purchase would cost %.2f, %.2f more than you have.\n",
			price * qty,  price * qty - natp->nat_money));
		return RET_FAIL;
	}
	if (!(p = getstarg(argp[4], "destination sector : ")))
		return RET_SYN;
	if (!sarg_xy(p, &x, &y))
		return RET_SYN;
	if (!getsect(x, y, &sect)) {
		pr("Could not access sector");
		return RET_FAIL;
	}
	if (!god && (sect.sct_type != SCT_WAREH || !owner)) {
		pr("The destination sector is not a warehouse.\n");
		return RET_FAIL;
	}
	if (!god && sect.sct_effic < 60) {
		pr("That sector is under construction.\n");
		return RET_FAIL;
	}
	n = getvar(ip->i_vtype, (s_char *)&sect, EF_SECTOR);
	if (qty + n > 9990) {
		pr(fmt(
		"That sector cannot hold %d more %s. It currently holds %d.\n",
			qty, ip->i_name, n));
		return RET_FAIL;
	}
	if (!commlock()) {
		pr("The transaction file cannot be locked.\n");
		return RET_SYS;
	}
	if (commread() < 0) {
		(void) communlock();
		pr("Unable to re-read commodity file; get help!\n");
		logerror("buy: commread (reread) failed");
		return RET_SYS;
	}
	if (!(new_amt = commamt(seller, product, &newprice))) {
		(void) communlock();
		pr(fmt(
		"All %s from %s has been bought!  Transaction aborted.\n",
			ip->i_name, cname(seller)));
		return RET_FAIL;
	}
	if (price < newprice) {
		(void) communlock();
		pr(
	"The market price has increased under you!  Transaction aborted.\n");
		return RET_FAIL;
	}
	if (new_amt < qty) {
		pr(fmt("%s going fast!  Got only %d.\n", ip->i_name, new_amt));
		qty = new_amt;
	}
	if (price > newprice) {
		pr(fmt("A bargain!  New price %.2f, total price %.2f\n",
			newprice, qty * newprice));
	}
	if (putvar(ip->i_vtype, n + qty, (s_char *)&sect, EF_SECTOR) <= 0) {
		(void) communlock();
		pr(fmt("No room to store %s in %s\n",
			ip->i_name, xyas(sect.sct_x, sect.sct_y, cnum)));
		return RET_FAIL;
	}
	putsect(&sect);
	commset(seller, product, -qty);
	if (commwrite() < 0) {
		pr("Unable to write commodity file to disk; get help!\n");
	}
	(void) communlock();
	NAT_DELTA(nat_money, seller, (int) ((newprice*qty) + 0.5));
	nreport(seller, N_MAKE_SALE, cnum, 1);
	wu(0, seller, fmt("%s bought %d %s from you for $%.2f\n",
		cname(cnum), qty, ip->i_name, newprice * qty));
	dolcost += (newprice * qty * buytax) + 0.5;
	return RET_OK;
}
