#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/prod.c,v 1.12 89/09/10 17:24:57 mr-frog Exp $";
#endif

/*
 * budg.c
 *
 * calculate production levels, prioritize
 *
 * Thomas Ruschak, 1992
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "nsc.h"
#include "sect.h"
#include "product.h"
#include "nat.h"
#include "tm.h"
#include "item.h"
#include "file.h"
#include "deity.h"
#include "ship.h"
#include "land.h"
#include "plane.h"

#define MIN(x,y)	(x > y ? y : x)

int	HCM[WORLD_X][WORLD_Y];
int	LCM[WORLD_X][WORLD_Y];
int	MIL[WORLD_X][WORLD_Y];
int	GUN[WORLD_X][WORLD_Y];
int	SHELL[WORLD_X][WORLD_Y];
int	AVAIL[WORLD_X][WORLD_Y];
int	UPDATED[WORLD_X][WORLD_Y];

int
budg()
{
	register int a, b;
	extern  s_char *argp[];
	s_char	stype=0, *pq, buf[80];
	int	priority, x, y, z;
	int	costs[SCT_MAXDEF+1], taxes=0, bars=0, mil=0, cap=0;
	int	amounts[SCT_MAXDEF+1], delta=0;
	int	sbuild=0,smaint=0,pbuild=0,pmaint=0, ships=0,planes=0;
	int	nsbuild=0,npbuild=0, which=0;
	int	lbuild=0,lmaint=0,units=0,nlbuild=0;
	struct	natstr *np;

	bzero(costs,sizeof(costs));
	bzero(amounts,sizeof(amounts));
	bzero(UPDATED,sizeof(UPDATED));

	for (a=0;a<WORLD_X;a++)
		for(b=0;b<WORLD_Y;b++){
			AVAIL[a][b] = (-1);
			SHELL[a][b] = (-1);
			GUN[a][b] = (-1);
			HCM[a][b] = (-1);
			LCM[a][b] = (-1);
			MIL[a][b] = (-1);
		}

	np=getnatp(cnum);
	if (argp[1] != (s_char *)0){
		if (goodsect(argp[1][0]))
			stype=argp[1][0];
		else switch(argp[1][0]){
			case 'P': 
			case 'S': 
			case 'L': 
			case 'A': 
			case 'M': 
			case 'N': 
			case 'C': stype = argp[1][0]; break;
			default: return RET_SYN;
		}
	}

	if ((stype != 0) && (stype != 'C'))
		pq = getstarg(argp[2], "Priority? ");
	else
		pq = (s_char *)0;

	if (pq != (s_char *)0)
		if (isdigit(*pq)){
			priority=(atoi(pq) < 0 ? -1*atoi(pq) : atoi(pq));
			if (priority >= SCT_MAXDEF+8){
				pr(fmt("Priorities must be less than %d!\n",
					SCT_MAXDEF+8));
				return RET_FAIL;
			}
			for(x=0;x<SCT_MAXDEF+8;x++)
				if (priority &&
					(np->nat_priorities[x] == priority)){
					pr("Priorities must be unique!\n");
					return RET_FAIL;
				}
		}
		else if (*pq == '~')
			priority = -1;
		else
			return RET_SYN;

	if ((stype) && !god){
		if (!isupper(stype)){
			which=0;
			while ((which<SCT_MAXDEF+2) &&
				(stype != dchr[which].d_mnem))
				which++;
			if (which == SCT_MAXDEF+2)
				return RET_SYN;
		}else{
			switch(stype){
				case 'P': which=PRI_PBUILD;break;
				case 'S': which=PRI_SBUILD;break;
				case 'L': which=PRI_LBUILD;break;
				case 'A': which=PRI_LMAINT;break;
				case 'M': which=PRI_SMAINT;break;
				case 'N': which=PRI_PMAINT;break;
				case 'C': which=(-1);break;
				default:  return RET_SYN;
			}
		}
		if (((which == PRI_SMAINT) || (which == PRI_PMAINT) ||
			(which == PRI_LMAINT)) && (priority == 0)){
			pr("Army, ship and plane maintenance may not be skipped!\n");
			return RET_FAIL;
		}
		if (which == -1){
			for(x=0;x<SCT_MAXDEF+8;x++){
				NAT_SETARY(nat_priorities[0],cnum,x,-1);
				np->nat_priorities[x] = -1;
			}
		}else{
			NAT_SETARY(nat_priorities[0],cnum,which,priority);
			np->nat_priorities[which] = priority;
		}
		
	}

	calc_all(costs,amounts,&taxes,&bars,&mil,&cap,&ships,&sbuild,&nsbuild,
		&smaint,&units,&lbuild,&nlbuild,&lmaint,&planes,&pbuild,
		&npbuild,&pmaint);

	pr(fmt("Current treasury:\t\t\t\t\t\t%d\n",np->nat_money));
	pr(fmt("Income from taxes+bars:\t\t\t\t\t\t%d+%d\n",taxes,bars));
	pr(fmt("Payments for Military+Capitals\t\t\t\t\t%d+%d\n\n",-1*mil,cap));
	delta=taxes+bars+mil-cap;
	pr("Sector Type\t\tAbbr\tProduction\tPriority\tTotal Cost\n");
	for(x=0;x<SCT_MAXDEF+2;x++){
		if (pchr[dchr[x].d_prd].p_cost == 0)
			if ((x != SCT_ENLIST) && (np->nat_priorities[x] == -1)){
				if (((np->nat_money+delta) > 0) &&
					(x <= SCT_MAXDEF)){
					delta -= costs[x];
				}
				continue;
			}
		pr(fmt("%-17s\t%c\t",dchr[x].d_name,dchr[x].d_mnem));
		if (x == SCT_ENLIST)
			pr(fmt("%d mil    \t",amounts[x]));
		else if (pchr[dchr[x].d_prd].p_cost != 0)
			pr(fmt("%d %-7s\t",amounts[x],
				pchr[dchr[x].d_prd].p_sname));
		else pr(fmt("\t\t"));

		if (np->nat_priorities[x] != -1){
			pr(fmt("%d",np->nat_priorities[x]));
		}
		pr(fmt("\t"));
		pr(fmt("\t"));
		if (np->nat_priorities[x] != 0){
			if ((np->nat_money+delta) > 0){
				pr(fmt("$%-3d",costs[x]));
				delta -= costs[x];
			}
			else
				pr(fmt("$[%-3d]",costs[x]));
		}else{
			if ((np->nat_money+delta) > 0)
				pr(fmt("$(%-3d)",costs[x]));
			else
				pr(fmt("$[(%-3d)]",costs[x]));
		}

		pr("\n");
		}

	sprintf(buf,"%d unit%s",nlbuild,splur(nlbuild));
	pr(fmt("Unit building\t\tL\t%-16s", buf));
	if (np->nat_priorities[PRI_LBUILD] != -1)
		pr(fmt("%d",np->nat_priorities[PRI_LBUILD]));
	if ((np->nat_money+delta) > 0){
		if (np->nat_priorities[PRI_LBUILD] != 0)
			pr(fmt("\t\t$%-4d\n",lbuild));
		else
			pr(fmt("\t\t$(%-4d)\n",lbuild));
		if (np->nat_priorities[PRI_LBUILD] != 0)
			delta -= lbuild;
	}else{
		if (np->nat_priorities[PRI_LBUILD] != 0)
			pr(fmt("\t\t$[%-4d]\n",lbuild));
		else
			pr(fmt("\t\t$[(%-4d)]\n",lbuild));
	}

	sprintf(buf,"%d unit%s",units,splur(units));
	pr(fmt("Unit maintenance\tA\t%-16s",buf));
	if (np->nat_priorities[PRI_LMAINT] != -1)
		pr(fmt("%d",np->nat_priorities[PRI_LMAINT]));
	if (np->nat_priorities[PRI_LMAINT] != 0)
		pr(fmt("\t\t$%-4d\n",-1*lmaint));
	else
		pr(fmt("\t\t$(%-4d)\n",-1*lmaint));
	if (np->nat_priorities[PRI_LMAINT] != 0)
		delta += lmaint;

	sprintf(buf,"%d ship%s",nsbuild,splur(nsbuild));
	pr(fmt("Ship building\t\tS\t%-16s", buf));
	if (np->nat_priorities[PRI_SBUILD] != -1)
		pr(fmt("%d",np->nat_priorities[PRI_SBUILD]));
	if ((np->nat_money+delta) > 0){
		if (np->nat_priorities[PRI_SBUILD] != 0)
			pr(fmt("\t\t$%-4d\n",sbuild));
		else
			pr(fmt("\t\t$(%-4d)\n",sbuild));
		if (np->nat_priorities[PRI_SBUILD] != 0)
			delta -= sbuild;
	}else{
		if (np->nat_priorities[PRI_SBUILD] != 0)
			pr(fmt("\t\t$[%-4d]\n",sbuild));
		else
			pr(fmt("\t\t$[(%-4d)]\n",sbuild));
	}

	sprintf(buf,"%d ship%s",ships,splur(ships));
	pr(fmt("Ship maintenance\tM\t%-16s",buf));
	if (np->nat_priorities[PRI_SMAINT] != -1)
		pr(fmt("%d",np->nat_priorities[PRI_SMAINT]));
	if (np->nat_priorities[PRI_SMAINT] != 0)
		pr(fmt("\t\t$%-4d\n",-1*smaint));
	else
		pr(fmt("\t\t$(%-4d)\n",-1*smaint));
	if (np->nat_priorities[PRI_SMAINT] != 0)
		delta += smaint;

	sprintf(buf,"%d plane%s",npbuild,splur(npbuild));
	pr(fmt("Plane building\t\tP\t%-16s",buf));
	if (np->nat_priorities[PRI_PBUILD] != -1)
		pr(fmt("%d",np->nat_priorities[PRI_PBUILD]));
	if ((np->nat_money+delta) > 0){
		if (np->nat_priorities[PRI_PBUILD] != 0)
			pr(fmt("\t\t$%-4d\n",pbuild));
		else
			pr(fmt("\t\t$(%-4d)\n",pbuild));
		if (np->nat_priorities[PRI_PBUILD] != 0)
			delta -= pbuild;
	}else{
		if (np->nat_priorities[PRI_PBUILD] != 0)
			pr(fmt("\t\t$[%-4d]\n",pbuild));
		else
			pr(fmt("\t\t$[(%-4d)]\n",pbuild));
	}

	sprintf(buf,"%d plane%s",planes,splur(planes));
	pr(fmt("Plane maintenance\tN\t%-16s",buf));
	if (np->nat_priorities[PRI_PMAINT] != -1)
		pr(fmt("%d",np->nat_priorities[PRI_PMAINT]));
	if (np->nat_priorities[PRI_PMAINT] != 0)
		pr(fmt("\t\t$%-4d\n",-1*pmaint));
	else
		pr(fmt("\t\t$(%-4d)\n",-1*pmaint));
	if (np->nat_priorities[PRI_PMAINT] != 0)
		delta += pmaint;
	pr(fmt("\t\t\t\t\tEstimated Delta:\t%d\n",delta));
	pr(fmt("\t\t\t\t\tNew treasury:\t\t%d\n",np->nat_money+delta));
	if ((np->nat_money+delta) < 0){
		pr("After processsing sectors, you will be broke!\n");
		pr("Sectors will not produce, distribute, or deliver!\n\n");
	}

	return RET_OK;
}

int
calc_all(costs,amounts,taxes,bars,mil,cap,ships,sbuild,nsbuild,smaint,
	units,lbuild,nlbuild,lmaint,planes,pbuild,npbuild,pmaint)
	int	costs[SCT_MAXDEF+1];
	int	amounts[SCT_MAXDEF+1];
	int	*taxes,*bars,*mil,*cap;
	int	*ships,*sbuild,*nsbuild,*smaint;
	int	*units,*lbuild,*nlbuild,*lmaint;
	int	*planes,*pbuild,*npbuild,*pmaint;
{
	register int y,z;
	struct	natstr *natp;
	extern	double money_res;
	int	sm=0,sb=0,pm=0,pb=0,lm=0,lb=0;

	natp = getnatp(cnum);

	*mil += (int) (natp->nat_reserve * money_res);

	for(y=1;y<SCT_MAXDEF+8;y++){
		for(z=0;z<SCT_MAXDEF+8;z++)
			if (natp->nat_priorities[z] == y)
				switch(z){
					case PRI_SMAINT:
						*ships=calc_ships(sbuild,
							nsbuild,smaint,0);
						sm=1;
						break;
					case PRI_SBUILD:
						calc_ships(sbuild,
							nsbuild,smaint,1);
						sb=1;
						break;
					case PRI_LMAINT:
						*units=calc_units(lbuild,
							nlbuild,lmaint,0);
						sb=1;
						break;
					case PRI_LBUILD:
						calc_units(lbuild,nlbuild,
							lmaint,1);
						lb=1;
						break;
					case PRI_PMAINT:
						*planes=calc_planes(pbuild,
							npbuild,pmaint,0);
						pm=1;
						break;
					case PRI_PBUILD:
						calc_planes(pbuild,
							npbuild,pmaint,1);
						pb=1;
						break;
					default:
						calc_prod(costs,amounts,taxes,
							bars,mil,cap,z);
						break;
				}
	}
	/* 0 is maintain, 1 is build */
	if (!sm)
		*ships=calc_ships(sbuild,nsbuild,smaint,0);
	if (!sb)
		calc_ships(sbuild,nsbuild,smaint,1);
	if (!lm)
		*units=calc_units(lbuild,nlbuild,lmaint,0);
	if (!lb)
		calc_units(lbuild,nlbuild,lmaint,1);
	if (!pm)
		*planes=calc_planes(pbuild,npbuild,pmaint,0);
	if (!pb)
		calc_planes(pbuild,npbuild,pmaint,1);

	/* produce all sects that haven't produced yet */
	calc_prod(costs,amounts,taxes,bars,mil,cap,-1);
}

int
calc_prod(costs,amounts,taxes,bars,mil,cap,sector_type)
	int	costs[SCT_MAXDEF+1];
	int	amounts[SCT_MAXDEF+1];
	int	*taxes,*bars,*mil,*cap,sector_type;
{
	struct	nstr_sect ns;
	struct	sctstr sect;
	struct	natstr *natp;
	extern	int etu_per_update;
	extern	double bankint;
	extern	double money_civ;
	extern	double money_uw;
	extern	double money_mil;
	extern	double obrate, uwbrate; 
	extern	int etu_per_update;
	struct	nstr_sect nstr;
	struct	pchrstr *pp;
	double  effic;
	double  maxr;		    /* floating version of max */
	double  prodeff;
	double  real;		    /* floating pt version of act */
	double  work;
	int     act;		    /* actual production */
	int     cost;
	int     i;
	int     max;		    /* production w/infinate materials */
	double  maxtake;
	int     nsect;
	int     take;
	int     mtake;
	int     there;
	int     totcomp;	    /* sum of component amounts */
	int     used;		    /* production w/infinite workforce */
	int     wforce;
	int     it;
	u_short	*amount;	    /* amount for component pointer */
	u_char	*comp;		    /* component pointer */
	u_char	*endcomp;
	u_char  vtype;
	s_char	*resource;
	int     c;
	s_char    maxc[3][10];
	s_char    use[3][10];
	int     items[I_MAX+1];
	int	bwork;
	int	twork;
	int	type;
	int	eff,civs,uws;
	float	t=0.0;
	int	vec[I_MAX+1], lcms, hcms;
	int	maxpop;

	natp = getnatp(cnum);

	snxtsct_all(&nstr);
	while (nxtsct(&nstr, &sect)) {
		if ((sect.sct_own != cnum) && !god)
			continue;
		if ((sect.sct_type != sector_type) && (sector_type != (-1)))
			continue;

		if (UPDATED[sect.sct_x][sect.sct_y])
			continue;

		UPDATED[sect.sct_x][sect.sct_y] = 1;

                getvec(VT_ITEM, items, (s_char *)&sect, EF_SECTOR);
                if (HCM[sect.sct_x][sect.sct_y] < 0){
                	HCM[sect.sct_x][sect.sct_y] = items[I_HCM];
                	LCM[sect.sct_x][sect.sct_y] = items[I_LCM];
                	AVAIL[sect.sct_x][sect.sct_y] = sect.sct_avail;
                	GUN[sect.sct_x][sect.sct_y] = items[I_GUN];
                	SHELL[sect.sct_x][sect.sct_y] = items[I_SHELL];
                	MIL[sect.sct_x][sect.sct_y] = items[I_MILIT];
                }

		t = 0.0;

		t += 0.5 + ((double)items[I_CIVIL] * sect.sct_effic/100.0 *
			etu_per_update * money_civ);

		t += 0.5 + ((double)items[I_UW] * sect.sct_effic/100.0 *
			etu_per_update * money_uw);

		*taxes += t;

		*mil += (items[I_MILIT] * etu_per_update * money_mil);

		civs = min(999, (int) ((obrate * (double) etu_per_update + 1.0)
		       * (double) items[I_CIVIL]));
		uws = min(999, (int) ((uwbrate * (double) etu_per_update + 1.0)
		       * (double) items[I_UW]));

		natp = getnatp(sect.sct_own);
		maxpop = max_pop((float)natp->nat_level[NAT_RLEV]);
		civs = min(civs, maxpop);
		uws = min(uws, maxpop);
		/* This isn't quite right, since research might rise/fall */
		/* during the update, but it's the best we can really do  */
		wforce = (int)
			((civs * sect.sct_work) / 100.0
			+ uws + items[I_MILIT] * 2 / 5.0);

		if ((sect.sct_type == SCT_CAPIT) && (sect.sct_effic > 60))
			*cap += etu_per_update;

		if ((sect.sct_type == SCT_BANK) && (sect.sct_effic > 60))
			*bars += items[I_BAR] * etu_per_update * bankint;

#ifdef STOP
		if (sect.sct_off)
			continue;
#endif /* STOP */
		work = roundavg((etu_per_update * wforce) / 100.0);
		bwork = work/2;

		type = sect.sct_type;
		eff = sect.sct_effic;
		if(sect.sct_newtype != type) {
			twork = (eff+3)/4;
			if(twork > bwork) {
				twork = bwork;
			}
			work -= twork;
			bwork -= twork;
			eff -= twork*4;
			costs[sect.sct_type] += twork;
			if(eff <= 0) {
				type = sect.sct_newtype;
				eff = 0;
			}

			twork = 100 - eff;
			if(twork > bwork) {
				twork = bwork;
			}

                        if (dchr[type].d_lcms>0){
                                lcms = LCM[sect.sct_x][sect.sct_y];
                                lcms /= dchr[type].d_lcms;
                                if (twork > lcms)
                                        twork = lcms;
			}
			if (dchr[type].d_hcms>0){
                                hcms = HCM[sect.sct_x][sect.sct_y];
                                hcms /= dchr[type].d_hcms;
                                if (twork > hcms)
                                        twork = hcms;
                        }

			costs[type] += twork*dchr[type].d_build;
			work -= twork;
			eff += twork;
		}
		else if(eff < 100) {
			twork = 100 - eff;
			if(twork > bwork) {
				twork = bwork;
			}
                        if (dchr[type].d_lcms>0){
                                lcms = LCM[sect.sct_x][sect.sct_y];
                                lcms /= dchr[type].d_lcms;
                                if (twork > lcms)
                                        twork = lcms;
			}
			if (dchr[type].d_hcms>0){
                                hcms = HCM[sect.sct_x][sect.sct_y];
                                hcms /= dchr[type].d_hcms;
                                if (twork > hcms)
                                        twork = hcms;
                        }

			costs[type] += twork*dchr[type].d_build;

			work -= twork;
			eff += twork;
		}

		if(eff < 60 || (type != SCT_ENLIST && eff < 61))
			continue;

		effic = eff/100.0;
		if (effic > 1.0)
			effic = 1.0;

		AVAIL[sect.sct_x][sect.sct_y] = work;
		if (dchr[type].d_prd == 0 && type != SCT_ENLIST)
			continue;

		totcomp = 0;
		pp = &pchr[dchr[type].d_prd];
		vtype = pp->p_type;
		/*
		 * sect effic  (inc improvements)
		 */
		if (type == SCT_ENLIST)
			goto is_enlist;
		if (pp->p_nrndx != 0) {
			totcomp++;
			resource = ((s_char *) &sect) + pp->p_nrndx;
			effic = (*resource * effic) / 100.0;
			if (pp->p_nrdep > 0) {
				maxtake = (*resource * 100.0) / pp->p_nrdep;
				if (effic > maxtake)
					effic = maxtake;
			}
		}
		/*
		 * production effic.
		 */
		if (pp->p_nlndx >= 0) {
			prodeff = natp->nat_level[pp->p_nlndx] - pp->p_nlmin;
			if (prodeff < 0.0) {
				prodeff = 0.0;
			}
			prodeff = prodeff / (prodeff + pp->p_nllag);
		} else {
			prodeff = 1.0;
		}
		used = 999;
		comp = pp->p_vtype;
		endcomp = pp->p_vtype + pp->p_nv;
		amount = pp->p_vamt;
		while (comp < endcomp) {
			used = min(used,
			    (int)(getvar((int)*comp, (s_char *)&sect, EF_SECTOR) /
			    	*amount));
			totcomp += *amount;
			++comp;
			++amount;
		}
		if (totcomp == 0)
			continue;
		/*
		 * is production limited by resources or
		 * workforce?
		 */
		max = (int) (work * effic / (double) totcomp) + 0.5;
		act = min(used, max);
		/*
		 * some things are easier to make..  food,
		 * pet, etc.
		 */
		act = (int) (pp->p_effic * 0.01 * act) + 0.5;

		if (vtype != 0) {
			if (real < 0.0)
				real = 0.0;
			if ((there = getvar(
				(int)vtype, (s_char *)&sect, EF_SECTOR)) >= 999) {
				/*
				 * production backlog
				 */
				there = 999;
			}
			act = min(act, 999 - there);
		}

		real = act * prodeff;

		if (prodeff != 0)
			take = real / prodeff;
		else
			take = 0.0;

		cost = take * pp->p_cost;
		take = take / ((double) pp->p_effic * 0.01);
is_enlist:
		if (type != SCT_ENLIST) {
			work -= (totcomp * (int)(real+0.5));
			AVAIL[sect.sct_x][sect.sct_y] = work;
			amounts[type] += (real+0.5);
			costs[type] += cost;
		} else {
			int	maxmil;
			int	enlisted;

			enlisted = 0;
			maxmil = (civs / 2) - items[I_MILIT];
			if (maxmil > 0) {
				enlisted = (etu_per_update * (10 + items[I_MILIT]) * 0.05);
				if (enlisted > maxmil)
					enlisted = maxmil;
			}
			if (enlisted < 0)
				enlisted = 0;

			if (sect.sct_oldown != sect.sct_own)
				enlisted = 0;

			amounts[type] += enlisted;
			costs[type] += enlisted*3;
			items[I_MILIT] += enlisted;
			continue;
		}

	}

}

calc_ships(sbuild,nsbuild,smaint,build)
int	*sbuild,*nsbuild,*smaint;
{
	extern	int etu_per_update;
	struct  nstr_item ni;
	struct	shpstr ship;
	struct	natstr *np;
	int	n, mult;
	extern	double money_ship;
	extern	long pops[];
	extern  double money_mil;
	struct	sctstr *sectp;
	struct	mchrstr *mp;
	int	vec[I_MAX+1], ships=0;
	int	cvec[I_MAX+1];


	np = getnatp(cnum);
	snxtitem_all(&ni, EF_SHIP);
	while(nxtitem(&ni, (s_char *)&ship)){
		if (ship.shp_own == 0)
			continue;
		if ((ship.shp_own != cnum) && !god)
			continue;

		if (!build){
			ships++;
			mp = &mchr[ship.shp_type];
			getvec(VT_ITEM, vec, (s_char *)&ship, EF_SHIP);
			if (vec[I_MILIT]){
				*smaint += (int)(etu_per_update * vec[I_MILIT] *
						money_mil);
			}
			mult = 1;
			if (np->nat_level[NAT_TLEV] < ship.shp_tech * 0.85)
				mult = 2;
			*smaint += (int) (mult * etu_per_update *
				dmin(0.0, money_ship * mp->m_cost));

			continue;
		}
		*sbuild += calc_shiprepair(&ship, vec, np, etu_per_update,
						nsbuild);
	}

	return(ships);
}

int
calc_shiprepair(ship, vec, np, etus, nsbuild)
	struct shpstr *ship;
	int	*vec;
	struct	natstr *np;
	int	etus, *nsbuild;
{
	extern	double money_ship;
	extern	int ship_grow_scale;
	register int delta;
	struct	sctstr *sp, sect;
	struct	mchrstr *mp;
	int	wf;
	int	left,build;
	float	leftp,buildp;
	int	lcm,hcm,lcm_needed,hcm_needed;
	int	avail;
	int	w_p_eff;
	int	svec[I_MAX+1];
	int	mult;
#ifdef ALLYHARBORWORK
	int	rel;
#endif /* ALLYHARBORWORK */

	mp = &mchr[ship->shp_type];
	getsect(ship->shp_x, ship->shp_y, &sect);
#ifdef STOP
	if (sect.sct_off)
		return 0;
#endif /* STOP */
	getvec(VT_ITEM, svec, (s_char *)&sect, EF_SECTOR);

	if (HCM[sect.sct_x][sect.sct_y] < 0){
               	HCM[sect.sct_x][sect.sct_y] = svec[I_HCM];
               	LCM[sect.sct_x][sect.sct_y] = svec[I_LCM];
               	AVAIL[sect.sct_x][sect.sct_y] = sect.sct_avail;
               	GUN[sect.sct_x][sect.sct_y] = svec[I_GUN];
               	SHELL[sect.sct_x][sect.sct_y] = svec[I_SHELL];
               	MIL[sect.sct_x][sect.sct_y] = svec[I_MILIT];
	}

	sp = &sect;
	mult = 1;
	if (np->nat_level[NAT_TLEV] < ship->shp_tech * 0.85)
		mult = 2;

	if (ship->shp_effic == 100) {
		/* ship is ok; no repairs needed */
		return 0;
	}
	if ((sp->sct_own != ship->shp_own) && (sp->sct_own != 0)) {
#ifdef ALLYHARBORWORK
		rel=getrel(getnatp(sp->sct_own),ship->shp_own);

		if (rel != ALLIED)
			return 0;
#else
		/* not our harbor -> shore leave; no eff gain */
		return 0;
#endif /* ALLYHARBORWORK */
	}
	left = 100 - ship->shp_effic;
	wf = 0;
	/* only military can work on a military boat */
	if (mp->m_glim > 0)
		wf = etus * vec[I_MILIT]/2;
	else
		wf = etus * (vec[I_CIVIL]/2 + vec[I_MILIT]/5);
	if (sp->sct_type != SCT_HARBR)
		wf /= 3;
	avail = wf + AVAIL[ship->shp_x][ship->shp_y] * 100;
	if (avail <= 0)
		return 0;
	w_p_eff = 20 + (mp->m_lcm + 2 * mp->m_hcm);
	delta = roundavg((double)avail/w_p_eff);
	if (delta <= 0)
		return 0;

	if (delta > etus*ship_grow_scale)
		delta = etus*ship_grow_scale;
	if (delta > left)
		delta = left;

	if (left > delta)
		left = delta;

	leftp = ((float)left/100.0);

	lcm_needed = mp->m_lcm * leftp;
	hcm_needed = mp->m_hcm * leftp;

	lcm = LCM[ship->shp_x][ship->shp_y];
	hcm = HCM[ship->shp_x][ship->shp_y];

	if (lcm >= lcm_needed)
		buildp = leftp;
	else	
		buildp = ((float)lcm/(float)mp->m_lcm);

	if (hcm < hcm_needed)
		buildp = MIN(buildp,((float)hcm/(float)mp->m_hcm));

	HCM[ship->shp_x][ship->shp_y] -= roundavg((double)(mp->m_hcm *
		buildp));
	LCM[ship->shp_x][ship->shp_y] -= roundavg((double)(mp->m_lcm *
		buildp));

	build = buildp * 100;

	if (build == 0)
		return 0;

	(*nsbuild)++;
	if (build > delta)
		build = delta;

	wf -= build * w_p_eff;
	if (wf < 0) {
		/*
		 * I didn't use roundavg here, because I want to penalize
		 * the player with a large number of ships.
		 */
		avail = (AVAIL[ship->shp_x][ship->shp_y] * 100 + wf) / 100;
		if (avail <= 0)
			avail = -1;
		AVAIL[ship->shp_x][ship->shp_y] = avail;
	}
	return mult * mp->m_cost * build / 100.0;
}

calc_units(lbuild,nlbuild,lmaint,build)
int	*lbuild,*nlbuild,*lmaint,build;
{
	extern	int etu_per_update;
	struct  nstr_item ni;
	struct	lndstr land;
	struct	natstr *np;
	int	n, mult;
	extern	double money_land;
	extern	long pops[];
	extern  double money_mil;
	struct	sctstr sect;
	struct	lchrstr *lp;
	int	vec[I_MAX+1], units=0;
	int	svec[I_MAX+1];


	np = getnatp(cnum);
	snxtitem_all(&ni, EF_LAND);
	while(nxtitem(&ni, (s_char *)&land)){
		if (land.lnd_own == 0)
			continue;
		if ((land.lnd_own != cnum) && !god)
			continue;

		lp = &lchr[land.lnd_type];
		if (!build){
			units++;

			mult = 1;
			if (np->nat_level[NAT_TLEV] < land.lnd_tech * 0.85)
				mult = 2;

			*lmaint += (int) (mult * etu_per_update *
				dmin(0.0, money_land * lp->l_cost));

			*lmaint += (int) (etu_per_update * lp->l_mil *
				((float)land.lnd_effic/100.0) * money_mil);

			continue;
		}

		getsect(land.lnd_x,land.lnd_y,&sect);
		getvec(VT_ITEM, svec, (s_char *)&sect, EF_SECTOR);
		if (HCM[land.lnd_x][land.lnd_y] < 0){
               		HCM[land.lnd_x][land.lnd_y] = svec[I_HCM];
               		LCM[land.lnd_x][land.lnd_y] = svec[I_LCM];
               		AVAIL[land.lnd_x][land.lnd_y] = sect.sct_avail;
               		GUN[land.lnd_x][land.lnd_y] = svec[I_GUN];
               		SHELL[land.lnd_x][land.lnd_y] = svec[I_SHELL];
               		MIL[land.lnd_x][land.lnd_y] = svec[I_MILIT];
		}
		getvec(VT_ITEM, vec, (s_char *)&land, EF_LAND);

		*lbuild += calc_landrepair(&land,vec, svec, np, etu_per_update,
						nlbuild);
	}

	return(units);
}

int
calc_landrepair(land, vec, svec, np, etus, nlbuild)
	struct lndstr *land;
	int	*vec, *svec;
	struct	natstr *np;
	int	etus, *nlbuild;
{
	register int delta;
	extern	double money_land;
	extern	int land_grow_scale;
	struct	sctstr *sp, sect;
	struct	lchrstr *lp;
	int	mil,lcm,hcm,gun,shell;
	int	mil_needed,lcm_needed,hcm_needed,gun_needed,shell_needed;
	int	left, build;
	float	leftp, buildp;
	int	avail;
	int	w_p_eff;
	int	mult;

	lp = &lchr[land->lnd_type];
	getsect(land->lnd_x, land->lnd_y, &sect);
#ifdef STOP
	if (sect.sct_off)
		return 0;
#endif /* STOP */
	sp = &sect;

	mult = 1;
	if (np->nat_level[NAT_TLEV] < land->lnd_tech * 0.85)
		mult = 2;

	if (land->lnd_effic == 100) {
		/* unit is ok; no repairs needed */
		return 0;
	}
	if (sp->sct_own != land->lnd_own)
		return 0;


	avail = AVAIL[land->lnd_x][land->lnd_y] * 100;
	if (avail <= 0)
		return 0;
	w_p_eff = 20 + (lp->l_lcm + 2 * lp->l_hcm);
	delta = roundavg((double)avail/w_p_eff);
	if (delta <= 0)
		return 0;
	if (delta > etus*land_grow_scale)
		delta = etus*land_grow_scale;
	left = 100 - land->lnd_effic;
	if (left > delta)
		left = delta;
	leftp = ((float)left/100.0);

	mil_needed = lp->l_mil * leftp;
	lcm_needed = lp->l_lcm * leftp;
	hcm_needed = lp->l_hcm * leftp;
	gun_needed = lp->l_gun * leftp;
	shell_needed = lp->l_shell * leftp;

	mil = MIL[land->lnd_x][land->lnd_y];
	lcm = LCM[land->lnd_x][land->lnd_y];
	hcm = HCM[land->lnd_x][land->lnd_y];
	gun = GUN[land->lnd_x][land->lnd_y];
	shell = SHELL[land->lnd_x][land->lnd_y];

	if (mil>=mil_needed)
		buildp=leftp;
	else
		buildp=((float)mil/(float)lp->l_mil);
	if (lcm < lcm_needed)
		buildp = MIN(buildp,((float)lcm/(float)lp->l_lcm));
	if (hcm < hcm_needed)
		buildp = MIN(buildp,((float)hcm/(float)lp->l_hcm));
	if (gun < gun_needed)
		buildp = MIN(buildp,((float)gun/(float)lp->l_gun));
	if (shell < shell_needed)
		buildp = MIN(buildp,((float)shell/(float)lp->l_shell));

	MIL[land->lnd_x][land->lnd_y] -= roundavg((double)(lp->l_mil * buildp));
	LCM[land->lnd_x][land->lnd_y] -= roundavg((double)(lp->l_lcm * buildp));
	HCM[land->lnd_x][land->lnd_y] -= roundavg((double)(lp->l_hcm * buildp));
	SHELL[land->lnd_x][land->lnd_y] -= roundavg((double)(lp->l_shell
		* buildp));
	GUN[land->lnd_x][land->lnd_y] -= roundavg((double)(lp->l_gun * buildp));

	build = buildp * 100;
	if (build == 0)
		return 0;
	(*nlbuild)++;
	if (delta > build)
		delta = build;

	if ((sp->sct_type != SCT_HEADQ) && (sp->sct_type != SCT_FORTR))
		delta /= 3;

	avail = (AVAIL[land->lnd_x][land->lnd_y] * 100 - delta * w_p_eff)/100;
	if (avail <= 0)
		avail = -1;
	AVAIL[land->lnd_x][land->lnd_y] = avail;
	return mult * lp->l_cost * delta / 100.0;
}

calc_planes(pbuild,npbuild,pmaint,build)
int	*pbuild, *npbuild, *pmaint, build;
{
	extern	int etu_per_update;
	extern	int plane_grow_scale;
	extern	double money_mil;
	extern	double money_plane;
	extern	long money[MAXNOC];
	struct	plnstr *pp, plane;
	struct	plchrstr *plp;
	struct	natstr *np;
	int	n, nplanes=0;
	struct	nstr_item ni;
	struct	shpstr *shp;
	struct	mchrstr *mp;
	struct	plchrstr *desc;
	struct  sctstr *sp, sect;
	int	delta;
	int	mult;
	int	eff;
	int	avail;
	int	w_p_eff, b;
	int	svec[I_MAX+1];
	float	leftp, buildp;
	int	left;
	int	used, mil, lcm, hcm, mil_needed, lcm_needed, hcm_needed;
	int     start_money;

	np = getnatp(cnum);
	snxtitem_all(&ni, EF_PLANE);
	while (nxtitem(&ni, (s_char *)&plane)){
		n = plane.pln_uid;
		pp = &plane;
		if (pp->pln_own == 0)
			continue;
		if ((pp->pln_own != cnum) && !god)
			continue;

		plp = &plchr[pp->pln_type];

		mult = 1;
		if (np->nat_level[NAT_TLEV] < pp->pln_tech * 0.85)
			mult = 2;
		if (!build){
			nplanes++;
			shp = 0;

			/* flight pay is 5x normal military pay */

			*pmaint += (int) (etu_per_update *
				(plp->pl_crew * money_mil * 5));

			*pmaint += (int) (mult * etu_per_update *
				dmin(0.0, plp->pl_cost * money_plane));

			continue;
		}
		if (np->nat_money < 0)
			continue;

		desc = &plchr[pp->pln_type];

		getsect(pp->pln_x, pp->pln_y, &sect);
#ifdef STOP
		if (sect.sct_off)
			continue;
#endif /* STOP */
		getvec(VT_ITEM, svec, (s_char *)&sect, EF_SECTOR);
		if (HCM[sect.sct_x][sect.sct_y] < 0){
			HCM[sect.sct_x][sect.sct_y] = svec[I_HCM];
			LCM[sect.sct_x][sect.sct_y] = svec[I_LCM];
			AVAIL[sect.sct_x][sect.sct_y] = sect.sct_avail;
			GUN[sect.sct_x][sect.sct_y] = svec[I_GUN];
			SHELL[sect.sct_x][sect.sct_y] = svec[I_SHELL];
			MIL[sect.sct_x][sect.sct_y] = svec[I_MILIT];
		}

		sp = &sect;

		if ((pp->pln_flags & PLN_LAUNCHED) == PLN_LAUNCHED)
			continue;

		left = 100 - pp->pln_effic;
		if (left <= 0)
			continue;
		avail = AVAIL[pp->pln_x][pp->pln_y] * 100;
		if (avail <= 0)
			continue;
		w_p_eff = 20 + (desc->pl_lcm + 2 * desc->pl_hcm);
		delta = roundavg((double)avail/w_p_eff);
		if (delta <= 0)
			continue;
		if (delta > etu_per_update)
			delta = etu_per_update*plane_grow_scale;
		if (delta > left)
			delta = left;
		if (left > delta)
			left = delta;

		leftp = ((float)left/100.0);

		mil_needed = desc->pl_crew * leftp;
		lcm_needed = desc->pl_lcm * leftp;
		hcm_needed = desc->pl_hcm * leftp;

		mil = MIL[pp->pln_x][pp->pln_y];
		lcm = LCM[pp->pln_x][pp->pln_y];
		hcm = HCM[pp->pln_x][pp->pln_y];

		if (mil>=mil_needed)
			buildp=leftp;
		 else
			buildp=((float)mil/(float)desc->pl_crew);

		if (lcm < lcm_needed)
			buildp = MIN(buildp,((float)lcm/(float)desc->pl_lcm));

		if (hcm < hcm_needed)
			buildp = MIN(buildp,((float)hcm/(float)desc->pl_hcm));

		b = buildp * 100;

		if (b == 0)
			continue;

		if (b > delta)
			b = delta;

		MIL[pp->pln_x][pp->pln_y] -= roundavg((double)(plp->pl_crew *
			buildp));
		HCM[pp->pln_x][pp->pln_y] -= roundavg((double)(plp->pl_hcm *
			buildp));
		LCM[pp->pln_x][pp->pln_y] -= roundavg((double)(plp->pl_lcm *
			buildp));

		(*npbuild)++;

		used = b * w_p_eff;
		/*
		 * I didn't use roundavg here, because I want to penalize
		 * the player with a large number of planes.
		 */
		avail = (AVAIL[pp->pln_x][pp->pln_y] * 100 - used) / 100;
		if (avail <= 0)
			avail = -1;
		AVAIL[pp->pln_x][pp->pln_y] = avail;
		if (sp->sct_type != SCT_AIRPT)
			b /= 3;
		*pbuild += roundavg(mult * b * desc->pl_cost / 100.0);
	}

	return nplanes;
}

goodsect(c)
char	c;
{
	register int x;

	for(x=4;x<SCT_MAXDEF+2;x++)
		if (dchr[x].d_mnem == c)
			return 1;

	return 0;
}
