#ifndef lint
static char *RCSid = "$Header: atta.c,v 1.1 89/12/14 08:19:14 jay Exp $";
#endif /* not lint */

/*
 * atta.c
 *
 * attack another sector.
 *
 * from PSL Empire, 1985
 */

#include <math.h>
#include "misc.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "path.h"
#include "news.h"
#include "treaty.h"
#include "nat.h"
#include "xy.h"
#include "land.h"
#include "nsc.h"
#include "mission.h"

#define CASUALTY_LUMP	1	/* How big casualty chunks should be */
#define DEFENDER	6

static struct	unit {
	short	x;
	short	y;
	short	troops;
	int	des;
	int	eff;
} unit[DEFENDER+1];	/* 6 for attackers, 1 (#6) for defenders */

static double calcodds();

atta()
{
	extern	s_char *argp[];
	coord	lx, ly;
	struct sctstr dsect, asect, sect;
	register int n;
	register int a_nsect;	/* number of attacking sectors */
	natid	d_cnum;
	s_char	*BestLandPath();
	int	off_x;
	int	off_y;
	int	o_mil;		/* occupation troops */
	int	origx,origy;
	int	d_mil;		/* total defending mil */
	int	mil;
	int	a_engineer=0;
	int	a_mil;
	int	a_total=0;	/* total attacking strength */
	int	d_total=0;	/* total defending strength */
	int	a_bodies=0;	/* total attacking mil */
	int	d_bodies=0;	/* total defending mil */
	int	i,l;
	int	s;
	int	mob_support;
	int	success, rel, rel2;
	int	mcst;
	int	mcost;
	int	dam;
	int	plague;
	int	a_units=0;
	int	d_cas=0, d_spy=0;
	int	a_cas=0, a_spy=0;
	int	dist;
	int	radius,mines, movein;
	double	move_cost;
	double	range, range2, asupport=1.0, dsupport=1.0;
	double	af=0.0,df=0.0, as=0.0,ds=0.0, au=0.0,du=0.0, ap=0.0,dp=0.0;
	double	landunitgun();
	float	saveodds;
	double	odds;
	double	init_cas, techfact();
	struct	dchrstr *dc;
	s_char	*p, *ppp;
	s_char	y_or_n[80];
	struct	lndstr land;
	struct	nstr_item ni;
	struct  qelem a_list, d_list, *next;
	struct	qelem *qp;
	struct	llist *llp;
	int	new, ret;
#ifdef MERC
	int	mob;
#endif
#ifdef SLOW_WAR
	struct natstr   *natp;
#endif /* SLOW_WAR */
	extern	int aborted;
	double	loss_percentage;
	double	mc, d;

	bzero((s_char *)unit,sizeof(unit));

	if (!(p = getstarg(argp[1], "Sector :  ")))
		return RET_SYN;
	if (aborted){
		pr("Attack aborted\n");
		return RET_OK;
	}
	if (!sarg_xy(p, &lx, &ly))
		return RET_SYN;
	if (neigh(lx, ly, cnum) == 0) {
		pr(fmt("You are not adjacent to %s\n", xyas(lx, ly, cnum)));
		return RET_FAIL;
	}

	getsect(lx, ly, &dsect);
	d_cnum = dsect.sct_own;
	if (dsect.sct_own == cnum) {
		pr("You can't attack your own sector.\n");
		return RET_FAIL;
	}
#ifdef SLOW_WAR
	natp = getnatp(cnum);
	rel = getrel(natp,dsect.sct_own);
#ifdef SNEAK_ATTACK
        if ((rel != AT_WAR) && (dsect.sct_own) && (dsect.sct_oldown != cnum) &&
	    (rel != SITZKRIEG) && (rel != MOBILIZATION)) {
		pr("You're not at war with them!\n");
		ppp=(s_char *)0;
		while (!ppp || ((*ppp != 'y') && (*ppp != 'n'))){
			bzero(y_or_n,80);
			if (ppp && (*ppp != 'y') && (*ppp != 'n'))
				pr("Answer y or n!\n");

			ppp=getstarg(y_or_n,fmt("Do you really want to sneak attack [yn]? "));
			if (aborted){
				pr("Attack aborted\n");
				return RET_OK;
			}
			if (isupper(*ppp))
				*ppp=tolower(*ppp);
		}
		if (*ppp != 'y'){
			pr("Sneak attack cancelled!\n");
			return RET_FAIL;
		}
	}
	if ((rel != AT_WAR) && (dsect.sct_own) && (dsect.sct_oldown != cnum) &&
	    ((rel == MOBILIZATION) || (rel == SITZKRIEG))) {
#else
	if ((rel != AT_WAR) && (dsect.sct_own) && (dsect.sct_oldown != cnum)){
#endif /* SNEAK_ATTACK */
		pr("You're not at war with them!\n");
		return RET_FAIL;
	}
#endif /* SLOW_WAR */
	dc = &dchr[dsect.sct_type];
#if	defined(BMAP) || defined(AUTONAV)
	setbigmap(lx, ly, dchr[dsect.sct_type].d_mnem);
	writebigmap();
#endif
	if (dc->d_mcst <= 0) {
		pr(fmt("You can't attack %s.\n", dchr[dsect.sct_type].d_name));
		return RET_FAIL;
	}
	if (dsect.sct_own && !trechk(cnum, dsect.sct_own, LANATT))
		return RET_FAIL;
	plague = getvar(V_PSTAGE, (s_char *)&dsect, EF_SECTOR)
		== PLG_INFECT ? 1 : 0;
	d_mil = getvar(V_MILIT, (s_char *)&dsect, EF_SECTOR);
	unit[DEFENDER].x = lx;
	unit[DEFENDER].y = ly;
	unit[DEFENDER].troops = d_mil;
	unit[DEFENDER].des = dsect.sct_type;
	unit[DEFENDER].eff = dsect.sct_effic;
	pr(fmt("%s is a %d%% %s with approximately %d military.\n",
		xyas(lx, ly, cnum), round((int)dsect.sct_effic, 10),
		dc->d_name, round(d_mil, 10)));

	a_total = 0;
	a_bodies = 0;
	a_nsect = 0;
	initque(&a_list);
	/* Determine attacking troop count */
	for (n = 1; n <= 6; n++) {	/* Directions */
		off_x = lx + diroff[n][0];
		off_y = ly + diroff[n][1];
		if (!getsect(off_x, off_y, &asect))
			continue;
		if (asect.sct_own != cnum || dchr[asect.sct_type].d_ostr < 1)
			continue;
#ifdef SNEAK_ATTACK
		if ((rel != AT_WAR) && (asect.sct_oldown == dsect.sct_own))
			continue;
#endif /* SNEAK_ATTACK */
		unit[a_nsect].x = off_x;
		unit[a_nsect].y = off_y;
		unit[a_nsect].troops = 0;
		unit[a_nsect].des = asect.sct_type;
		unit[a_nsect].eff = asect.sct_effic;
		a_nsect++;
		snxtitem_xy(&ni,EF_LAND,asect.sct_x,asect.sct_y);
		while(nxtitem(&ni,&land)){
			s_char	*mess;

			if (land.lnd_own != cnum)
				continue;

			if (land.lnd_effic <= LAND_MINEFF)
				continue;

			if (land.lnd_mobil <= 0)
				continue;

			if (land.lnd_ship >= 0){
				pr(fmt("%s #%d is on ship %d, and cannot attack\n",
					lchr[land.lnd_type].l_name,
					land.lnd_uid, land.lnd_ship));
				continue;
			}

			mc = ((double)land.lnd_effic)*0.01*
				(double)lchr[land.lnd_type].l_spd;
			if (mc < 0.01)
				mc = 0.01;
			d = (mc+techfact(land.lnd_tech,mc));
			mc = 480.0 / d;
			d = sector_mcost(dsect.sct_type,
				dsect.sct_effic);
			mc *= (d * 5.0);
			if (land.lnd_mobil < mc){
				pr(fmt("%s #%d does not have enough mobility (%d needed)\n",
					lchr[land.lnd_type].l_name,
					land.lnd_uid, ldround(mc,1)));
				continue;
				
			}
			if (!has_supply(&land)){
				pr(fmt("%s #%d is out of supply, and cannot attack\n",
					lchr[land.lnd_type].l_name,
					land.lnd_uid));
				continue;
			}

			ppp=(s_char *)0;
			while (!ppp || ((*ppp != 'y') && (*ppp != 'n'))){
				bzero(y_or_n,80);
				if (ppp && (*ppp != 'y') && (*ppp != 'n'))
					pr("Answer y or n!\n");

				ppp=getstarg(y_or_n,
					fmt("Attack with %s #%d (%d%%) in %s? ",
					lchr[land.lnd_type].l_name,
					land.lnd_uid,land.lnd_effic,
					xyas(land.lnd_x,land.lnd_y,
					land.lnd_own)));
				if (aborted){
					pr("Attack aborted\n");
					return RET_OK;
				}

				if (isupper(*ppp))
					*ppp=tolower(*ppp);
			}
			if (*ppp == 'y'){
				a_units++;
				llp = (struct llist *)
					malloc(sizeof(struct llist));
				bzero((s_char *)llp,sizeof(struct llist));
				if (llp == (struct llist *)0)
					logerror("Malloc failed in attack!\n");
				if (lchr[land.lnd_type].l_flags & L_ENGINEER)
					a_engineer = 1;
				llp->state = LL_OK;
				llp->x = land.lnd_x;
				llp->y = land.lnd_y;
				llp->lcp = &lchr[land.lnd_type];
				land.lnd_mobil -= ldround(mc,1);
				land.lnd_mission=0;
				land.lnd_harden=0;
				putland(land.lnd_uid,&land);
				bcopy((s_char *)&land,(s_char *)&llp->land,sizeof(struct lndstr));
				insque(&llp->queue,&a_list);
				if (spyval(&land) > a_spy)
					a_spy = spyval(&land);
				a_bodies += total_mil(&land);
				pr(fmt("%s #%d has a base attack value of %d\n",
					lchr[land.lnd_type].l_name,
					land.lnd_uid, attack_val(&land)));
					
			}
		}

		d = sector_mcost(dsect.sct_type,dsect.sct_effic);
		mob_support = (int)((double)asect.sct_mobil / d);
		mil = getvar(V_MILIT, (s_char *)&asect, EF_SECTOR);
		if (mil > mob_support) {
			pr(fmt("The %d mobility units in %s will only",
				asect.sct_mobil, xyas(off_x, off_y, cnum)));
			pr(fmt(" support %d troops, \n", mob_support));
		} else {
			mob_support = mil;
			if (mob_support == 0)
				pr(fmt("No troops in %s\n",
					xyas(off_x, off_y, cnum)));
		}
		if (mob_support == 0)
			continue;
		a_mil = atopi(getstring(
		    fmt("Number of troops from %s at %s (max %d) : ",
			dchr[asect.sct_type].d_name,
			xyas(off_x, off_y, cnum), mob_support)));
		if (aborted){
			pr("Attack aborted\n");
			return RET_OK;
		}
		if (a_mil <= 0)
			continue;
		getsect(off_x, off_y, &asect);
		a_mil = min(a_mil, min(mob_support, mil));

		if (a_mil <= 0)
			continue;

		mob = (int) ((double) a_mil * d);
#ifdef MERC
		/* require at least one mobility point to attack */
		if(mob < 1)
			mob = 1;
#endif
		if(mob > asect.sct_mobil)
			mob = (int)asect.sct_mobil;
		asect.sct_mobil -= (u_char) mob;

		putsect(&asect);
		unit[a_nsect-1].troops = a_mil;
		a_bodies += a_mil;
		if (getvar(V_PSTAGE, (s_char *)&asect, EF_SECTOR) == PLG_INFECT)
			plague++;
	}
	a_total = total_attack_strength(&a_list,asupport);
	if ((a_total <= 0) && (a_units == 0)){
		if (d_cnum != 0) {
			wu(0, d_cnum,
			    fmt("%s (#%d) considered attacking you @%s\n",
			    cname(cnum), cnum, xyas(lx, ly, d_cnum)));
		}
		pr("No troops for attack...\n");
		return RET_FAIL;
	}

	initque(&d_list);

	/*
	 *  Now, find all units actually in the sector.
	 *
	 */
	snxtitem_xy(&ni,EF_LAND,dsect.sct_x,dsect.sct_y);
	while(nxtitem(&ni,&land)){
		if (land.lnd_own == 0)
			continue;

		if (land.lnd_own != dsect.sct_own)
			continue;

		if (land.lnd_ship >= 0)
			continue;

		llp = (struct llist *)
			malloc(sizeof(struct llist));
		bzero((s_char *)llp,sizeof(struct llist));
		llp->state = (has_supply(&land) ? LL_OK : LL_UNSUPPLIED);
		llp->x = land.lnd_x;
		llp->y = land.lnd_y;
		llp->lcp = &lchr[land.lnd_type];
		land.lnd_mission = 0;
		putland(land.lnd_uid,&land);
		bcopy((s_char *)&land,(s_char *)&llp->land,sizeof(struct lndstr));
		insque(&llp->queue,&d_list);
		if (spyval(&land) > d_spy)
			d_spy = spyval(&land);

		intelligence_report(cnum,&land,a_spy,
			"Scouts report enemy unit:");

		d_bodies += total_mil(&land);
	}

	d_total = total_defense_strength(&d_list,dsupport);
	pr(fmt("Total attack strength = %d\n", a_total));
	pr(fmt("Initial defense strength = %d\n", d_total));

	/*
	 *
	 * All units that are within their reaction radius and not damaged
	 * below their morale value now get to react to the threatened sect.
	 * Once we've sent enough to counter the threat, stop sending them.
	 *
	 */

	snxtitem_all(&ni,EF_LAND);
	while(nxtitem(&ni,&land) && (d_total < (int)(1.2*(float)a_total))){
		double	mobcost;
		int	supply_state;

		if (land.lnd_own == 0)
			continue;

		if (dsect.sct_type == SCT_MOUNT)
			continue;

		if (land.lnd_rad_max == 0)
			continue;

		if ((land.lnd_x == dsect.sct_x) && (land.lnd_y == dsect.sct_y))
			continue;

		if (land.lnd_own != dsect.sct_own)
			continue;

		if (land.lnd_ship >= 0)
			continue;

		if (defense_val(&land) == 0)
			continue;

		if (land.lnd_effic <= land.lnd_retreat)
			continue;

		/* Only supplied units can react */
		if (!(supply_state=has_supply(&land)))
			continue;

		getsect(land.lnd_x,land.lnd_y,&sect);
		dist=mapdist(land.lnd_x,land.lnd_y,dsect.sct_x,dsect.sct_y);

		/* Units on efficient headquarters can react 1 farther */
		if ((sect.sct_type == SCT_HEADQ) && (sect.sct_effic >= 60))
			radius=land.lnd_rad_max+1;
		else
			radius=land.lnd_rad_max;

		if (land.lnd_mission == MI_RESERVE)
			radius += 2;

		if (dist>radius)
			continue;

		p = BestLandPath(&sect,&dsect,&move_cost);
		if (p == (s_char *)0)
			continue;

		mobcost = land.lnd_effic * 0.01*lchr[land.lnd_type].l_spd;
		mobcost = 480.0 / (mobcost + techfact(land.lnd_tech, mobcost));
		mobcost *= (move_cost * 5.0);

		if (land.lnd_mobil < mobcost)
			continue;

		/* move to defending sector */
		getland(land.lnd_uid,&land);
		land.lnd_mobil -= ldround(mobcost,1);
		origx = land.lnd_x;
		origy = land.lnd_y;
		land.lnd_x = dsect.sct_x;
		land.lnd_y = dsect.sct_y;
		land.lnd_mission = 0;
		wu(0,land.lnd_own,fmt("%s #%d reacts to %s.\n",
			lchr[land.lnd_type].l_name, land.lnd_uid,
			xyas(land.lnd_x,land.lnd_y,land.lnd_own)));
		putland(land.lnd_uid,&land);

		if ((land.lnd_x != dsect.sct_x) || (land.lnd_y != dsect.sct_y))
			continue;

		llp = (struct llist *)
			malloc(sizeof(struct llist));

		bzero((s_char *)llp,sizeof(struct llist));
		llp->state = (supply_state ? LL_OK : LL_UNSUPPLIED);
		llp->x = origx;
		llp->y = origy;
		llp->lcp = &lchr[land.lnd_type];

		putland(land.lnd_uid,&land);
		bcopy((s_char *)&land,(s_char *)&llp->land,sizeof(struct lndstr));
		insque(&llp->queue,&d_list);
		d_total += defense_val(&land);
		if (spyval(&land) > d_spy)
			d_spy = spyval(&land);

		intelligence_report(cnum,&land,a_spy,
			"Scouts sight new enemy unit:");

		d_bodies += total_mil(&land);
	}

	for (qp = a_list.q_forw; qp != (&a_list); qp = qp->q_forw){
		llp = (struct llist *)qp;
		intelligence_report(dsect.sct_own,&llp->land,d_spy,
			"Scouts report attacking unit:");
	}
	a_total = total_attack_strength(&a_list,asupport);
	d_total = total_defense_strength(&d_list,dsupport);
	pr(fmt("Total attack strength = %d\n", a_total));
	pr(fmt("Total defense strength = %d\n", d_total));

	ret=getsect(lx, ly, &dsect);	/* Shrink update collision window */
	d_mil = getvar(V_MILIT, (s_char *)&dsect, EF_SECTOR);
	unit[DEFENDER].troops = d_mil;
	unit[DEFENDER].eff = dsect.sct_effic;

	/*
	 * Calculate support
	 */
	/* attacker's forts & such */
	dam = dd(dsect.sct_own, cnum, landdef((int)dsect.sct_type),
		dsect.sct_x, dsect.sct_y, 0, 0);

	af = ((double)dam/100.0);
	asupport += af;

	dam = sd(dsect.sct_own, cnum, landdef((int)dsect.sct_type),
		dsect.sct_x, dsect.sct_y, 0, 0, 0);

	as = ((double)dam/100.0);
	asupport += as;

	/*
	 * find all artillery units belonging
	 * to the attacker that can fire.
	 * Each arty unit adds +1%/damage point
	 *
	 */

	snxtitem_all(&ni,EF_LAND);
	while(nxtitem(&ni,&land)){
		if ((land.lnd_x == dsect.sct_x) && (land.lnd_y == dsect.sct_y))
			continue;

		if (lchr[land.lnd_type].l_frg == 0)
			continue;

		rel = getrel(getnatp(land.lnd_own),cnum);
		rel2 = getrel(getnatp(land.lnd_own),dsect.sct_own);
		if ((land.lnd_own != cnum) &&
			((rel != ALLIED) || (rel2 != AT_WAR)))
			continue;

		if (land.lnd_ship >= 0)
			continue;

		if (land.lnd_mission > 0)
			continue;

		/* do we have supplies? */
		if (!has_supply(&land))
			continue;

		/* are we in range? */
		dist=mapdist(land.lnd_x,land.lnd_y,dsect.sct_x,dsect.sct_y);
		range=techfact((int)land.lnd_tech,
			(double)lchr[land.lnd_type].l_frg);

		range2=roundrange(range);
		if (dist>range)
			continue;

		use_supply(&land);
		nreport(land.lnd_own, N_FIRE_L_ATTACK, dsect.sct_own, 1);
		if (roll(100) > lchr[land.lnd_type].l_acc){
			au += landunitgun(land.lnd_type,land.lnd_effic)/200.0;
		}else{
			au += landunitgun(land.lnd_type,land.lnd_effic)/100.0;
		}
		if (land.lnd_own != cnum)
			wu(0,land.lnd_own,fmt("%s #%d supported %s at %s\n",
				lchr[land.lnd_type].l_name, land.lnd_uid,
				cname(cnum),
				xyas(dsect.sct_x,dsect.sct_y,land.lnd_own)));
	}
	asupport += au;

	/* attacker's planes */
	dam = support(dsect.sct_x,dsect.sct_y,dsect.sct_own,cnum);
	ap = (((double)dam)/100.0);
	asupport += ap;

	pr("\t\tsupport values\n");
	pr("\t\tforts\tships\tunits\tplanes\n");
	pr(fmt("attacker\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n",af,as,au,ap));

	if (dsect.sct_own){
		wu(0,dsect.sct_own,fmt("\t\tsupport values\n"));
		wu(0,dsect.sct_own,fmt("\t\tforts\tships\tunits\tplanes\n"));
		wu(0,dsect.sct_own,fmt("attacker\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n",
			af,as,au,ap));
	}

	a_total = total_attack_strength(&a_list,asupport);
	d_total = total_defense_strength(&d_list,dsupport);

	if  (d_total < (int)(1.2*(float)a_total))
		dam = dd(cnum, d_cnum, landdef((int)dsect.sct_type),
			dsect.sct_x, dsect.sct_y, 0, 1);
	else
		dam = 0;

	df = ((double)dam/100.0);
	dsupport += df;
	d_total = total_defense_strength(&d_list,dsupport);

	if (d_total < (int)(1.2*(float)a_total))
		dam = sd(cnum, d_cnum, landdef((int)dsect.sct_type),
			dsect.sct_x, dsect.sct_y, 0, 1, 0);
	else
		dam = 0;

	ds = ((double)dam/100.0);
	dsupport += ds;
	d_total = total_defense_strength(&d_list,dsupport);

	snxtitem_all(&ni,EF_LAND);
	while(nxtitem(&ni,&land)){

		if (land.lnd_own == 0)
			continue;

		if ((d_total >= (int)(1.2*(float)a_total)))
			continue;

		if (lchr[land.lnd_type].l_frg == 0)
			continue;

		rel = getrel(getnatp(land.lnd_own),dsect.sct_own);
		rel2 = getrel(getnatp(land.lnd_own),cnum);
		if ((land.lnd_own != dsect.sct_own) &&
			((rel != ALLIED) || (rel2 != AT_WAR)))
			continue;

		if (land.lnd_ship >= 0)
			continue;

		if (land.lnd_mission > 0)
			continue;

		/* do we have supplies? */
		if (!has_supply(&land))
			continue;

		/* are we in range? */
		dist=mapdist(land.lnd_x,land.lnd_y,dsect.sct_x,dsect.sct_y);
		range=techfact((int)land.lnd_tech,
			(double)lchr[land.lnd_type].l_frg);
		range2=roundrange(range);
		if (dist>range)
			continue;

		use_supply(&land);
		nreport(land.lnd_own, N_FIRE_BACK, cnum, 1);
		if (roll(100) > lchr[land.lnd_type].l_acc){
			du += landunitgun(land.lnd_type,land.lnd_effic)/200.0;
			dsupport += landunitgun(land.lnd_type,land.lnd_effic)/200.0;
		}else{
			du += landunitgun(land.lnd_type,land.lnd_effic)/100.0;
			dsupport += landunitgun(land.lnd_type,land.lnd_effic)/100.0;
		}
		if (land.lnd_own != dsect.sct_own)
			wu(0,land.lnd_own,fmt("%s #%d supported %s at %s\n",
				lchr[land.lnd_type].l_name, land.lnd_uid,
				cname(dsect.sct_own),
				xyas(dsect.sct_x,dsect.sct_y,land.lnd_own)));

		d_total = total_defense_strength(&d_list,dsupport);
	}

	if (dsect.sct_oldown != cnum){
		mines = getvar(V_MINE, (s_char *)&dsect, EF_SECTOR);
		mines = min(mines,20);
		if (a_engineer)
			mines = ldround(((double)mines/2.0),1);
		if (mines > 0){
			if (dsect.sct_own)
				wu(0,dsect.sct_own,fmt("Defending mines add %1.2f\n",((double)mines)*0.02));
			pr(fmt("Defending mines add %1.2f\n",
				((double)mines)*0.02));
			dsupport += ((double)mines)*0.02;
			d_total = total_defense_strength(&d_list,dsupport);
		}
	}

	/* defender's planes */
	if (d_total < (int)(1.2*(float)a_total))
		dam = support(dsect.sct_x,dsect.sct_y,cnum,dsect.sct_own);
	else
		dam = 0;

	dp = (((double)dam)/100.0);
	dsupport += dp;

	pr(fmt("defender\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n\n",df,ds,du,dp));
	if (dsect.sct_own)
		wu(0,dsect.sct_own,fmt("defender\t%1.2f\t%1.2f\t%1.2f\t%1.2f\n\n",df,ds,du,dp));

	/* Pull attackers out of attacking sectors */
	for (n=0; n < a_nsect; n++) {
		int	mm;
		getsect(unit[n].x, unit[n].y, &asect);
		mm = getvar(V_MILIT, (s_char *)&asect, EF_SECTOR);
		if (mm < unit[n].troops)
			unit[n].troops = mm;
		putvar(V_MILIT,mm-unit[n].troops,(s_char *)&asect,EF_SECTOR);
		putsect(&asect);
	}

	a_total = total_attack_strength(&a_list,asupport);
	d_total = total_defense_strength(&d_list,dsupport);

	success = 0;
	n = 0;	/* attacking sector round-robin counter */
	a_cas = 0;	/* Casualty counts */
	d_cas = 0;
	/* automatic success if no defenders */
	if (d_total == 0)
		success++;

	pr(fmt("Final attacker strength %d\n",a_total));
	pr(fmt("Final defender strength %d\n",d_total));
	odds = calcodds(a_total,d_total);
	pr(fmt("Final odds %1.2f\n",odds));
	while (!success && a_total){
		if (((a_cas + d_cas) % 70) == 69)
			pr("\n");
		odds = calcodds(a_total,d_total);
		if (chance(odds)) {
			pr("!");
			d_cas += take_defender_casualty(&d_list,dsect.sct_own);
			d_total = total_defense_strength(&d_list,dsupport,
				d_cnum);
			if (d_total == 0)
				success++;
		} else {
			pr("@");
			a_cas += take_attacker_casualty(&a_list);
			a_total = total_attack_strength(&a_list,asupport);
		}
	}

	pr("\n");
	if (success) {
#ifdef SNEAK_ATTACK
		if (rel != AT_WAR && dsect.sct_own && (dsect.sct_oldown!=cnum)){
			pr(fmt("Your sneak attack was successful\n"));
			pr(fmt("But it will cost you $5000\n"));
			pr(fmt("War has been declared!!!!\n"));
			wu(0,dsect.sct_own,
                           fmt("Country %s (#%d) has Sneak Attacked!!\n",
                               cname(cnum),cnum)); 
			wu(0,dsect.sct_own,
                           fmt("Country %s (#%d) has Declared WAR on you!!\n",
                               cname(cnum),cnum)); 
			dolcost += 5000;
			rel = MOBILIZATION;
			nreport(cnum, N_DECL_WAR, dsect.sct_own, 1);
			setrel(cnum,dsect.sct_own,rel);
		}
#endif /* SNEAK_ATTACK */
		pr(fmt("We have captured %s, sir!\n", xyas(lx, ly, cnum)));
		if (d_cnum)
			wu(0, d_cnum, fmt("%s (#%d) lost %d troops taking %s\n",
				cname(cnum), cnum, a_cas,
				xyas(lx, ly, d_cnum)));

		nreport(cnum, N_WON_SECT, d_cnum, 1);

		a_total = total_attack_strength(&a_list,asupport);

		o_mil = 0;
		for (n = 0; n < a_nsect; n++) {
			s_char bb[80];
			int m_mil;

			getsect(unit[n].x, unit[n].y, &asect);
			if (unit[n].troops <= 0)
				continue;

			sprintf(bb,"How many mil to move in from %s (%d max)? ",
				xyas(asect.sct_x,asect.sct_y,cnum),
				unit[n].troops/2);

			m_mil = (atopi(getstring(bb)));
			if (m_mil > (unit[n].troops/2))
				m_mil = unit[n].troops;
			if (m_mil < 0)
				m_mil = 0;

			o_mil += m_mil;
			if ((m_mil < unit[n].troops) && (unit[n].troops > 0)){
				/* Move back */
				/*
				 * There is a possibility that the sector
				 * might have been "lost" when no civ and
				 * no mil exist in the sector.
				 *
				 * Alternatively, it might have been
				 * conquered. If there are no troops
				 * there, have the returning mil reclaim
				 * it.. Otherwise, have the returning
				 * mil turn around and go back to the
				 * sector just conquered.
				 */
				if (((getvar(V_MILIT,(s_char *)&asect,
					EF_SECTOR) == 0) &&
					(!has_units(asect.sct_x,asect.sct_y,
					asect.sct_own))) ||
					(asect.sct_own == cnum)){

					asect.sct_own = cnum;
					if (asect.sct_oldown == 0)
						asect.sct_oldown = cnum;

					pr(fmt("%d troops return to %s\n",
						unit[n].troops-m_mil,
						xyas(unit[n].x,unit[n].y,
						cnum)));
					if (plague && !getvar(V_PTIME,
						(s_char *)&asect, EF_SECTOR))
						putvar(V_PTIME, PLG_EXPOSED,
							(s_char *)&asect,
							EF_SECTOR);
					putvar(V_MILIT, getvar(V_MILIT,
						(s_char *)&asect, EF_SECTOR) +
						unit[n].troops-m_mil,
						(s_char *)&asect,EF_SECTOR);

					putsect(&asect);
				}else{
					pr(fmt("Someone has captured %s!\n",
						xyas(asect.sct_x,asect.sct_y,
						cnum)));
					pr(fmt("Unable to return there. "));
					pr(fmt("Troops occupy %s.\n",
						xyas(dsect.sct_x,dsect.sct_y,
						cnum)));
					o_mil += unit[n].troops-m_mil;
				}
			}
		}

		movein = 0;
		for (qp=a_list.q_forw;qp!=(&a_list);qp=qp->q_forw){
			s_char bb[80];

			llp = (struct llist *)qp;

			if ((llp->state == LL_RETREATED) ||
				(llp->state == LL_DEAD) ||
				(llp->land.lnd_own == 0))
				continue;
			sprintf(bb,"Move in with  %s #%d (%d%%)? ",
				lchr[llp->land.lnd_type].l_name,
				llp->land.lnd_uid,llp->land.lnd_effic);

			ppp=(s_char *)0;
			while (!ppp || ((*ppp != 'y') && (*ppp != 'n'))){
				bzero(y_or_n,80);
				if (ppp && (*ppp != 'y') && (*ppp != 'n'))
					pr("Answer y or n!\n");

				ppp=getstarg(y_or_n,bb);

				if (isupper(*ppp))
					*ppp=tolower(*ppp);
			}
			if (*ppp == 'n'){
				pr(fmt("%s #%d returns to %s\n",
					llp->lcp->l_name,
					llp->land.lnd_uid,
					xyas(llp->x,llp->y,cnum)));
				putland(llp->land.lnd_uid,&llp->land);
			}else{
				movein++;
				llp->land.lnd_x = dsect.sct_x;
				llp->land.lnd_y = dsect.sct_y;
				pr(fmt("%s #%d occupies %s\n",
					llp->lcp->l_name,
					llp->land.lnd_uid,
					xyas(llp->land.lnd_x,llp->land.lnd_y,
						cnum)));
				putland(llp->land.lnd_uid,&llp->land);
			}
		}

		if (movein || (o_mil > 0)){
			s_char b[80];
			bzero(b,80);
			if (o_mil && !movein)
				pr(fmt("%d of your troops now occupy %s\n",
					o_mil,xyas(lx, ly, cnum)));
			if (movein && !o_mil)
				pr(fmt("%d of your units now occupy %s\n",
					movein,xyas(lx, ly, cnum)));
			if (movein && o_mil)
				pr(fmt("%d of your troops and %d of your units now occupy %s\n",
					o_mil,movein,xyas(lx, ly, cnum)));
		}else
			pr(fmt("%s left unoccupied\n", xyas(lx, ly, cnum)));
		if (dsect.sct_type == SCT_CAPIT || dsect.sct_type == SCT_MOUNT){
			caploss(&dsect, d_cnum,
				"* We have captured %s's capital, sir! *\n");
			putsect(&dsect);
		}
		o_mil = takeover(&dsect, o_mil);
		dsect.sct_mobil = 0;
	} else {
		pr("You have been defeated!\n");
		nreport(cnum, N_SCT_LOSE, d_cnum, 1);
#ifdef SNEAK_ATTACK
		if (rel != AT_WAR && dsect.sct_own && (dsect.sct_oldown!=cnum)){
			pr(fmt("Your sneak attack was unsuccessful\n"));
			pr(fmt("But it will cost you $5000\n"));
			pr(fmt("War has been declared!!!!\n"));
			wu(0,dsect.sct_own,
                           fmt("Country %s (#%d) has Sneak Attacked!!\n",
                               cname(cnum),cnum)); 
			wu(0,dsect.sct_own,
                           fmt("Country %s (#%d) has Declared WAR on you!!\n",
                               cname(cnum),cnum)); 
			dolcost += 5000;
			rel = MOBILIZATION;
			nreport(cnum, N_DECL_WAR, dsect.sct_own, 1);
			setrel(cnum,dsect.sct_own,rel);
		}
#endif /* SNEAK_ATTACK */
		o_mil = unit[DEFENDER].troops;
		if (d_cnum)
			wu(0, d_cnum,
				fmt("%s (#%d) lost %d troops attacking %s\n",
				cname(cnum), cnum, a_cas,
				xyas(lx, ly, d_cnum)));
		plague = 0;
		/*
		 * subtract defender's mobility from sector based
		 * on the number of attackers.  This way we won't get
		 * 1 attacking military zeroing the mob in the defender's
		 * sector.
		 */
		n = (dsect.sct_mobil * ((float)d_cas/(float)d_mil));
		dsect.sct_own = d_cnum;
		dsect.sct_mobil = n < 0 ? 0 : n;
	}
	pr(fmt("- Casualties -\n\tYours: %d\n", a_cas));
	pr(fmt("\tTheirs: %d\n", d_cas));
	pr(fmt("Papershuffling ... %.1f B.T.U\n", (d_cas + a_cas) * 0.15));
	NAT_DELTA(nat_btu, cnum, (int) -((d_cas + a_cas) * 0.015 + 0.5));
	/* update military in defending sector */
	putvar(V_MILIT, o_mil, (s_char *)&dsect, EF_SECTOR);

	/* Send reacting defenders back where they came from */
	for (qp=d_list.q_forw;qp!=(&d_list);qp=qp->q_forw){
		llp = (struct llist *)qp;
		if ((llp->state != LL_RETREATED) && (llp->state != LL_DEAD)
			&& (llp->land.lnd_own != 0)){
			if ((llp->land.lnd_x != llp->x) ||
				(llp->land.lnd_y != llp->y))
				wu(0,llp->land.lnd_own,
					fmt("%s #%d returns to %s\n",
					llp->lcp->l_name, llp->land.lnd_uid,
					xyas(llp->x,llp->y,llp->land.lnd_own)));
			llp->land.lnd_x = llp->x;
			llp->land.lnd_y = llp->y;
			putland(llp->land.lnd_uid,&llp->land);
		}
	}

	/* Deduct mobility from all units in battle, depending on losses */
	/* Mob cost is 10 * % losses. Defenders on reserve pay 1/2 */
	loss_percentage = ((double)a_cas)/((double)a_bodies);
	mcost = ldround((10.0 * loss_percentage),1);
	for (qp=a_list.q_forw;qp!=(&a_list);qp=qp->q_forw){
		llp = (struct llist *)qp;
		if (llp->state == LL_DEAD)
			continue;
		if (chance(loss_percentage))
			use_supply(&llp->land);
		llp->land.lnd_mobil -= mcost;
		putland(llp->land.lnd_uid,&llp->land);
	}
	loss_percentage = ((double)d_cas)/((double)d_bodies);
	mcost = ldround((10.0 * loss_percentage),1);
	for (qp=d_list.q_forw;qp!=(&d_list);qp=qp->q_forw){
		llp = (struct llist *)qp;
		if (llp->state == LL_DEAD)
			continue;
		if (chance(loss_percentage))
			use_supply(&llp->land);
		if (land.lnd_mission == MI_RESERVE)
			llp->land.lnd_mobil -= mcost/2;
		else
			llp->land.lnd_mobil -= mcost;
		putland(llp->land.lnd_uid,&llp->land);
	}

	new = dsect.sct_effic - (a_cas + d_cas)/10;
	new = (new < 0 ? 0 : new);
	dsect.sct_effic = new;
	/* update plague in defending sector */
	if (plague && !getvar(V_PSTAGE, (s_char *)&dsect, EF_SECTOR))
			putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&dsect, EF_SECTOR);
	putsect(&dsect);

	/* Free up all the lists */
	for(qp=a_list.q_forw;qp!=(&a_list);qp=next){
		next = qp->q_forw;
		free(qp);
	}
	for(qp=d_list.q_forw;qp!=(&d_list);qp=next){
		next = qp->q_forw;
		free(qp);
	}
	return RET_OK;
}

static double
calcodds(a_total,d_total)
	int	a_total,d_total;
{
	register int n, d_str;
	double	odds;
	double	eff;

	/* calculate odds */
	if (a_total <= 0.0)
		odds = 0.0;
	else
		odds = ((double)a_total) / (d_total + a_total);

/*pr(fmt("Calcodds: a=%d d=%d, odds=%1.2f\n",a_total,d_total,odds));*/
	return odds;
}

static
total_attack_strength(a_list,asupport)
struct qelem	*a_list;
double		asupport;
{
	int	x;
	double	a_total=0.0, eff;
	struct	qelem *qp;
	struct	llist *llp;
	int	attacking=0;

	/*
	 * first, total the attacking mil
	 */

	for(x=0;x<6;x++){
		eff = unit[x].eff / 100.0;
		eff = 2.0 + ((dchr[unit[x].des].d_ostr - 2.0) * eff);
		a_total += (unit[x].troops * eff);
	}

	/*
	 * next, add in the attack_values of all
	 * the attacking non-retreated units
	 */

	for (qp = a_list->q_forw; qp != a_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		if (llp->state == LL_OK){
			int	n,w;
			w=0;
			attacking++;
			for(n=0;n<6;n++)
				if ((unit[n].x == llp->land.lnd_x) &&
					(unit[n].y == llp->land.lnd_y))
					w = n;
			eff = unit[w].eff / 100.0;
			eff = 2.0 + ((dchr[unit[w].des].d_ostr - 2.0) * eff);
			a_total += (eff * attack_val(&llp->land));
		}
	}

	a_total *= asupport;


	return (int)a_total;
}

static
total_defense_strength(d_list,dsupport)
struct qelem	*d_list;
double		dsupport;
{
	int	x;
	double	d_total=0.0, eff, d_unit;
	struct	qelem *qp;
	struct	llist *llp;

	eff = unit[DEFENDER].eff / 100.0;
	eff = 2.0 + ((dchr[unit[DEFENDER].des].d_dstr - 2.0) * eff);
	d_total = unit[DEFENDER].troops * eff;

	/*
	 * next, add in the defense_values of all
	 * the defending non-retreating units
	 */

	for (qp = d_list->q_forw; qp != d_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		d_unit = 0.0;
		if (llp->state == LL_OK)
			d_unit = defense_val(&llp->land);
		else if (llp->state == LL_UNSUPPLIED)
			d_unit = ((double)defense_val(&llp->land)/2.0);
		d_unit *= ((127.0+((double)llp->land.lnd_harden)) / 127.0);
		d_unit *= eff;
		d_total += d_unit;
	}

	d_total *= dsupport;

	return (int)d_total;
}

take_attacker_casualty(a_list)
struct qelem *a_list;
{
	int	to_take = CASUALTY_LUMP;
	int	n, tot_troops=0, biggest_mil, cas;
	struct	qelem *qp, *biggest;
	struct	llist *llp;

	for(n=0;n<DEFENDER;n++)
		tot_troops += unit[n].troops;

	if (tot_troops)
		to_take -= tot_troops;

	if (to_take >= 0){
		for(n=0;n<DEFENDER;n++)
			unit[n].troops=0;
	}
	else{
		/*
		 * They can all come off mil
		 */
		to_take=CASUALTY_LUMP;
		while (to_take > 0)
			for(n=0;n<DEFENDER;n++)
				if ((unit[n].troops > 0) && to_take){
					to_take--;
					unit[n].troops--;
				}
		return CASUALTY_LUMP;
	}

	if (QEMPTY(a_list))
		return (CASUALTY_LUMP - to_take);

	/*
	 *  Need to take some casualties from attacking units
	 *  Procedure: find the biggest unit remaining (in
	 *  terms of mil) and give it the casualties.
	 */
	biggest = (struct qelem *)0;
	biggest_mil = 0;
	for (qp = a_list->q_forw; qp != a_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		
		if ((llp->state == LL_RETREATED) || (llp->state == LL_DEAD))
			continue;

		if (total_mil(&llp->land) > biggest_mil){
			biggest_mil = total_mil(&llp->land);
			biggest = qp;
		}
	}
	if (biggest == (struct qelem *)0)
		return (CASUALTY_LUMP-(to_take-cas));

	llp = (struct llist *)biggest;
	llp->state = take_casualty(llp,to_take,llp->state,&cas,ATTACKING,cnum);
	return (CASUALTY_LUMP-(to_take-cas));
}

take_defender_casualty(d_list, down)
struct qelem *d_list;
natid down;
{
	int	to_take = CASUALTY_LUMP;
	int	n, tot_troops=0, biggest_mil, cas;
	struct	qelem *qp, *biggest;
	struct	llist *llp;

	if (unit[DEFENDER].troops)
		to_take -= unit[DEFENDER].troops;
		
	if (to_take >= 0)
		unit[DEFENDER].troops = 0;
	else{
		unit[DEFENDER].troops -= CASUALTY_LUMP;
		return CASUALTY_LUMP;
	}

	if (QEMPTY(d_list))
		return (CASUALTY_LUMP - to_take);

	/*
	 *  Need to take some casualties from defending units
	 *  Procedure: find the biggest unit remaining (in
	 *  terms of mil) and give it the casualties.
	 */
	biggest = (struct qelem *)0;
	biggest_mil = 0;
	for (qp = d_list->q_forw; qp != d_list; qp = qp->q_forw){
		llp = (struct llist *)qp;
		
		if ((llp->state == LL_RETREATED) || (llp->state == LL_DEAD))
			continue;

		if (total_mil(&llp->land) > biggest_mil){
			biggest_mil = total_mil(&llp->land);
			biggest = qp;
		}
	}

	if (biggest == (struct qelem *)0)
		return (CASUALTY_LUMP-(to_take-cas));

	llp = (struct llist *)biggest;
	llp->state = take_casualty(llp,to_take,llp->state,&cas,0,down);
	return (CASUALTY_LUMP-(to_take-cas));
}
