#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/army.c,v 1.6 89/07/16 01:07:29 jeffw Exp $";
#endif /* not lint */

/*
 * army.c
 *
 * add units to army
 *
 * from PSL Empire, 1985
 * XXX should merge with wing.c.
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "land.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

army()
{
	extern	s_char *argp[];
	struct	lndstr land;
	register int count;
	s_char	*cp;
	s_char	c;
	struct	nstr_item nstr;
#ifdef RETREAT
	struct  nstr_item ni;
	struct	lndstr land2;
	int	r;
#endif /* RETREAT */

	cp = getstarg(argp[1], "army? ");
	if (cp == 0)
		return RET_SYN;
	c = *cp;
	if (!isalpha(c) && c != '~') {
		pr("Specify army, (1 alpha char or '~')\n");
		return RET_SYN;
	}
	if (c == '~')
		c = ' ';
	if (!snxtitem(&nstr, EF_LAND, argp[2]))
		return RET_SYN;
	count = 0;
	while (nxtitem(&nstr, (s_char *)&land)) {
		if (!owner)
			continue;
		land.lnd_army = c;
#ifdef RETREAT
		snxtitem(&ni, EF_LAND, cp);
		while((r=nxtitem(&ni, &land2))
			&& (land2.lnd_army != c));
		if (r){
			bcopy(land2.lnd_rpath, land.lnd_rpath,10);
			land.lnd_rflags = land2.lnd_rflags;
		}
#endif /* RETREAT */
		putland(nstr.cur, &land);
		count++;
	}
	pr(fmt("%d unit%s added to army `%c'\n", count, splur(count), c));
	return RET_OK;
}
