/*
 * ship.h
 *
 * things having to do with ships
 *
 * from PSL Empire, 1985
 * $Revision: 1.1 $ $Date: 89/12/12 17:00:32 $
 */

#define	SHIP_MINEFF	20

#ifdef	AUTONAV
/* bit masks for the autonav mode flags */

#define AN_SAILDIR  1
#define AN_AUTONAV  2
#define AN_STANDBY  4
#define AN_LOADING  8

/* list of orders to perform for each ship */

#define ORDER_CANCEL 1
#define ORDER_STOP   2
#define ORDER_RESUME 3
#define ORDER_P      4
#define ORDER_PC     5
#define ORDER_PCP    6
#define ORDER_PCPC   7
#define ORDER_ETA    8

#endif	AUTONAV

#define MAXSHPV	12

#ifdef	SAIL
#define MAXSHPPATH	28
#endif	SAIL
#ifdef	SHIPNAMES
#define	MAXSHPNAMLEN	24
#endif	SHIPNAMES

#ifdef RETREAT
#ifndef RET_LEN
#define RET_LEN 10
#endif /* RET_LEN */
#endif /* RETREAT */

struct	shpstr {
	coord	shp_x;		/* x location in abs coords */
	coord	shp_y;		/* y location in abs coords */
	natid	shp_own;	/* owner's country num */
	s_char	shp_type;	/* ship type */
	s_char	shp_effic;	/* 0% to 100% */
	s_char	shp_mobil;	/* mobility units */
	short	shp_sell;	/* pointer to trade file */
	short	shp_tech;	/* tech level ship was built at */
	short	shp_uid;	/* unit id (ship #) */
	s_char	shp_fleet;	/* group membership */
	coord	shp_opx,shp_opy;/* Op sector coords */
	short	shp_mission;	/* mission code */
	short	shp_radius;	/* mission radius */
	u_char	shp_nplane;	/* number of planes on board */
	u_char	shp_nland;	/* number of land units on board */
#ifdef	AUTONAV
	coord	shp_destx[2];	/* location for ship destination */
	coord	shp_desty[2];
	u_char	shp_trdtype[2];	/* commodity to trade at destination */
	u_char	shp_autonav;	/* autonavigation flags */
#endif	AUTONAV
	s_char	shp_spare;	/* extra space */
	s_char	shp_nv;		/* current number of variables */
	u_char	shp_vtype[MAXSHPV];
	u_short	shp_vamt[MAXSHPV];
#ifdef	SAIL
	u_char	shp_mobquota;	/* mobility quota */
	s_char	shp_path[MAXSHPPATH];
	short	shp_follow;
#endif	SAIL
#ifdef	SHIPNAMES
	s_char	shp_name[MAXSHPNAMLEN];	/* name set with the "name" command */
#endif	SHIPNAMES
#ifdef FUEL
	u_char	shp_fuel;	/* How much fuel do we have */
#endif /* FUEL */
#ifdef SHIPCHOPPERS
	u_char	shp_nchoppers;	/* How many choppers on board? */
#endif /* SHIPCHOPPERS */
#ifdef XLIGHT
	u_char	shp_nxlight;	/* How many xlight planes on board? */
#endif /* XLIGHT */
#ifdef TRADESHIPS
	coord	shp_orig_x;
	coord	shp_orig_y;	/* Where we were built */
	natid	shp_orig_own;	/* Who built us */
#endif /* TRADESHIPS */
#ifdef RETREAT
	int	shp_rflags;	/* When do I retreat? */
	s_char	shp_rpath[RET_LEN];	/* retreat path */
#endif /* RETREAT */
};

#ifdef	SAIL
struct fltelemstr {
  int	num;
  int	own;
  double	mobil,mobcost;
  struct fltelemstr	*next;
};

struct fltheadstr {
  int		leader;
  s_char	real_q;
/* defines for the real_q member */
#define	LEADER_VIRTUAL	0
#define	LEADER_REAL	1
#define	LEADER_WRONGSECT	2
  coord		x,y;
  natid		own;
  unsigned	maxmoves;
  struct fltelemstr	*head;
  struct fltheadstr	*next;
};
#endif	SAIL


#define	MAXMCHV 8

struct	mchrstr {
	int	m_lcm;		/* units of lcm to build */
	int	m_hcm;		/* units of hcm to build */
	int	m_armor;	/* how well armored it is */
	int	m_speed;	/* how fast it can go */
	int	m_visib;	/* how well it can be seen */
	int	m_vrnge;	/* how well it can see */
	int	m_frnge;	/* how far it can fire */
	int	m_glim;		/* how many guns it can fire */
#ifdef XLIGHT
	u_char	m_nxlight;	/* maximum number of xlight planes */
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
	u_char	m_nchoppers;	/* maximum number of choppers */
#endif /* SHIPCHOPPERS */
#ifdef FUEL
	u_char	m_fuelc;	/* fuel capacity */
	u_char	m_fuelu;	/* fuel used per 10 mob */
#endif /* FUEL */
	s_char	*m_name;	/* full name of type of ship */
	int	m_tech;		/* tech required to build */
	int	m_cost;		/* how much it costs to build */
	long	m_flags;	/* what special things can this ship do */
	u_char	m_nplanes;	/* maximum number of planes this ship holds */
	u_char	m_nland;	/* maximum number of units this ship holds */
	u_char	m_nv;		/* number of variables it can hold */
	u_char	m_vtype[MAXMCHV];
	u_short	m_vamt[MAXMCHV];
};

#define M_FOOD		bit(0)	/* catch that fish! */
#define M_TORP		bit(1)	/* fire torpedoes */
#define M_DCH		bit(2)	/* drop depth charges on subs */
#define M_FLY		bit(3)	/* launch and recover planes */
#define M_MSL		bit(4)	/* launch missiles */
#define M_OIL		bit(5)	/* drill for oil */
#define M_SONAR		bit(6)	/* locate submarines */
#define M_MINE		bit(7)	/* drop mines */
#define M_SWEEP		bit(8)	/* clean up the mines */
#define M_SUB		bit(9)	/* a submarine */
#define M_SPY		bit(10)	/* gather intelligence info */
#define M_LAND		bit(11)	/* allows full landing ability */
#ifdef NEWSUBS
#define M_SUBT		bit(12)	/* allows torping of other subs */
#endif /* NEWSUBS */
#ifdef TRADESHIPS
#define M_TRADE		bit(13) /* is a trade ship */
#endif /* TRADESHIPS */
#ifdef SEMILAND
#define M_SEMILAND	bit(14) /* can land 1/4 */
#endif /* SEMILAND */
#ifdef XLIGHT
#define	M_XLIGHT	bit(15)	/* can hold xlight planes */
#endif /* XLIGHT */
#ifdef SHIPCHOPPERS
#define M_CHOPPER	bit(16)	/* can hold choppers */
#endif /* SHIPCHOPPERS */
#ifdef FUEL
#define M_OILER		bit(17)	/* can re-fuel ships */
#endif /* FUEL */
#define M_SUPPLY	bit(18)	/* Can supply units/sects/ships */
#define M_UNIT		bit(19)	/* Can carry units */


#define getship(n, p) \
	ef_nbread(EF_SHIP, n, (caddr_t)p)
#define putship(n, p) \
	ef_nbwrite(EF_SHIP, n, (caddr_t)p)
#define getshipp(n) \
	(struct shpstr *) ef_ptr(EF_SHIP, n)

extern	double seagun();

extern  struct mchrstr mchr[];
extern	int shp_maxno;
