#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/sect.c,v 1.2 89/05/28 18:12:44 emp-src Exp $";
#endif

/*
 * sect.c
 *
 * post-read and pre-write sector data massage
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "land.h"
#include "nsc.h"
#ifdef EASY_BRIDGES
#include "plane.h"
#endif /* EASY_BRIDGES */

/*ARGSUSED*/
int
sct_postread(id, ptr)
	int	id;
	s_char	*ptr;
{
	struct	sctstr *sp = (struct sctstr *) ptr;

	checksect(sp);
	owner = (god || sp->sct_own == cnum);
	return 1;
}

/*ARGSUSED*/
int
sct_prewrite(id, ptr)
	int	id;
	s_char	*ptr;
{
	struct	sctstr *sp = (struct sctstr *) ptr;

	checksect(sp);
}

checksect(sp)
struct	sctstr *sp;
{
	int	mines, mil, civs, uws, loyalcivs;
#ifdef EASY_BRIDGES
        register struct plnstr *pp;
        struct  plnstr p2;
        int     n,old=sp->sct_own;
#endif /* EASY_BRIDGES */
	struct	lndstr land;
	struct	nstr_item ni;

	mil = getvar(V_MILIT, sp, EF_SECTOR);
	civs = getvar(V_CIVIL, sp, EF_SECTOR);
	if (sp->sct_own == sp->sct_oldown)
		loyalcivs = civs;
	else
		loyalcivs = 0;
	uws = getvar(V_UW, sp, EF_SECTOR);

	if (sp->sct_type == SCT_BSPAN && sp->sct_effic < 20) {
		sp->sct_type = SCT_WATER;
		sp->sct_newtype = SCT_WATER;
		sp->sct_own = 0;
		sp->sct_mobil = 0;
		sp->sct_oldown = 0;
		pr(fmt("A bridge span at %s has collapsed\n",
			xyas((int)sp->sct_x, (int)sp->sct_y, cnum)));

                wu(0, old, fmt("Crumble... SCREEEECH!  Splash! Bridge falls at %s!\n", xyas(sp->sct_x, sp->sct_y, old)));

		snxtitem_xy(&ni,EF_LAND,sp->sct_x,sp->sct_y);
		while(nxtitem(&ni,&land)){
			land.lnd_effic = 0;
			wu(0, old, fmt("     \007AARGH! %s %d tumbles to its doom!\n",
				lchr[land.lnd_type].l_name,land.lnd_uid));
			putland(land.lnd_uid,&land);
		}
		snxtitem_xy(&ni,EF_PLANE,sp->sct_x,sp->sct_y);
		while(nxtitem(&ni,&p2)){
			wu(0, old, fmt("     \007AARGH! %s %d tumbles to its doom!\n",
				plchr[p2.pln_type].pl_name,p2.pln_uid));
			p2.pln_effic = 0;
			putplane(p2.pln_uid,&p2);
		}

		/*
		 * save only the mines; zero the rest of the
		 * commodities.
		 */
		mines = getvar(V_MINE, (caddr_t)sp, EF_SECTOR);
		sp->sct_nv = 0;
		if (mines > 0)
			(void) putvar(V_MINE, mines, (caddr_t)sp, EF_SECTOR);
	}
	if (sp->sct_own != 0 && !civs)
		sp->sct_work = 100;

	/* If they have a military unit there, they still own it */
	if (sp->sct_own != 0 && ((loyalcivs == 0) && (mil == 0) &&
		(has_units(sp->sct_x,sp->sct_y,sp->sct_own) == 0))) {
		/* more cruft! */
		if (sp->sct_type == SCT_CAPIT || sp->sct_type == SCT_MOUNT)
			caploss(sp, sp->sct_own, "");

		if (sp->sct_oldown != sp->sct_own){
			sp->sct_own = sp->sct_oldown;
		}else{
			sp->sct_own = 0;
			sp->sct_oldown = 0;
		}
		sp->sct_mobil = 0;
	}
	return 1;
}
