#ifndef lint
static char *RCSid = "$Header: aircombat.c,v 1.1 89/12/14 13:28:06 jay Exp $";
#endif

/*
 * aircombat.c
 *
 * Deal with air to air combat
 *
 * Dave Pare, 1986
 * --ts 1992
 */

#include "misc.h"
#include "var.h"
#include "news.h"
#include "land.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"
#include "ship.h"
#include "nat.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#include "path.h"

static	getilist();

#define	DOG_MAX		15
#define FLAK_MAX	15

		/*       -7    -6    -5    -4    -3    -2    -1    0 */
float flaktable[16] = {	0.20, 0.20, 0.25, 0.30, 0.35, 0.40, 0.45, 0.50,
			0.50, 0.55, 0.60, 0.65, 0.70, 0.75, 0.80, 0.85, };

ac_encounter(bomb_list, esc_list, x, y, path, mission_flags, tech, no_air_defense)
	struct	qelem *bomb_list;
	struct	qelem *esc_list;
	coord	x;
	coord	y;
	s_char	*path;
	int	mission_flags;
	int	*tech, no_air_defense;
{
	int	val;
	int	rel;
	int	dir;
	int	nats[MAXNOC];
	int	lnats[MAXNOC];
	int	gotilist[MAXNOC];
	int	unfriendly[MAXNOC];
	int	overfly[MAXNOC];
	struct	qelem ilist[MAXNOC];
	s_char	mypath[1024];
	int	myp;
	int	civ, mil;
	natid	plane_owner;
	struct	sctstr sect;
	struct	shpstr ship;
	struct	lndstr land;
	struct	nstr_item ni;
	natid	cn;
	struct	natstr *over, *mynatp;
	struct	plist *plp;
	int	evaded;
#ifdef ASW_PLANES
	struct	shiplook head;
	struct	shiplook *s,*s2;

	bzero(&head,sizeof(struct shiplook));
	head.uid = -1;
#endif /* ASW_PLANES */

	plp = (struct plist *) bomb_list->q_forw;
	plane_owner = plp->plane.pln_own;

	bzero((s_char *)mypath, 1024);
	bcopy(path,mypath,strlen(path));
	myp = 0;

	bzero((s_char *)overfly, sizeof(overfly));
	bzero((s_char *)gotilist, sizeof(gotilist));
	bzero((s_char *)unfriendly, sizeof(unfriendly));
	for (cn=1; cn<MAXNOC; cn++) {
		if ((mynatp=getnatp(cn)) == 0)
			continue;
		rel = getrel(mynatp, plane_owner);
#ifdef SLOW_WAR
		if (rel != HOSTILE && rel != AT_WAR && rel != MOBILIZATION && rel != SITZKRIEG)
                        continue;
#else
		if (rel != HOSTILE && rel != AT_WAR)
			continue;
#endif /* SLOW_WAR */
		if (plane_owner == cn)
			continue;
		unfriendly[cn]++;
	}
	if (mission_flags & PM_R) {
		if (mission_flags & P_S) {
			PR(plane_owner,"\nSPY Plane report\n");
			PRdate(plane_owner);
			sathead();
#ifdef ASW_PLANES
		} else if (mission_flags & P_A){
			PR(plane_owner,"\nAnti-Sub Patrol report\n");
#endif /* ASW_PLANES */
		} else {
			PR(plane_owner,"\nReconnaissance report\n");
			PRdate(plane_owner);
		}
	}

	pln_removedupes(bomb_list, esc_list);
	while ((dir = mypath[myp++]) && !QEMPTY(bomb_list)) {
		if ((val = chkdir(dir, DIR_STOP, DIR_LAST)) == 0)
			break;
		/* XXX using xnorm is probably bad */
		x = xnorm(x + diroff[val][0]);
		y = ynorm(y + diroff[val][1]);
		getsect(x, y, &sect);
		over = getnatp(sect.sct_own);

		evaded = do_evade(bomb_list,esc_list,mission_flags);
		if ((unfriendly[sect.sct_own]) && (!evaded))
			ac_doflak(bomb_list, &sect);

		/* mission planes aborted due to flak -- don't send escorts */
		if (QEMPTY(bomb_list))
			break;

		if ((!no_air_defense) && (!evaded))
			air_defense(x,y,plane_owner,bomb_list, esc_list);

		if (mission_flags & PM_R) {
			if (sect.sct_type == SCT_WATER) {
#ifdef SWEEP_PLANES
				plane_sweep(bomb_list,x,y,&head);
#endif /* SWEEP_PLANES */
#ifdef ASW_PLANES
				if (mission_flags & P_A){
					plane_sona(bomb_list,x,y,&head);
				}
#endif /* ASW_PLANES */
#if	defined(BMAP) || defined(AUTONAV)
				setbigmap(sect.sct_x, sect.sct_y,
					dchr[sect.sct_type].d_mnem);
#endif
				continue;
			}
			if (mission_flags & P_S) {
				satdisp(&sect, (mission_flags&P_I)?10:50);
			} else {
				/* This is borrowed from lookout */
				if (sect.sct_own == plane_owner)
					PR(plane_owner,"Your ");
				else
					PR(plane_owner,
						fmt("%s (#%d) ",
						cname(sect.sct_own),
						sect.sct_own));
				PR(plane_owner,dchr[sect.sct_type].d_name);
#if	defined(BMAP) || defined(AUTONAV)
				setbigmap(sect.sct_x, sect.sct_y,
					dchr[sect.sct_type].d_mnem);
#endif
				PR(plane_owner,fmt(" %d%% efficient ",
					owner ? sect.sct_effic :
					round((int)sect.sct_effic,25)));
				civ = getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR);
				mil = getvar(V_MILIT, (s_char *)&sect, EF_SECTOR);
				if (civ)
					PR(plane_owner,fmt("with %s%d civ ",
					    owner ? "" : "approx ",
					    owner? civ : round(civ, 25)));
				if (mil)
					PR(plane_owner,fmt("with %s%d mil ",
						owner ? "" : "approx ",
						owner? mil : round(mil, 25)));
				PR(plane_owner,
					fmt("@ %s\n", xyas(x, y, plane_owner)));
			}
		} else {
			PR(plane_owner,fmt("flying over %s at %s\n",
				dchr[sect.sct_type].d_name,
				xyas(x, y, plane_owner)));
#if	defined(BMAP) || defined(AUTONAV)
			setbigmap(sect.sct_x, sect.sct_y,
				dchr[sect.sct_type].d_mnem);
#endif
		}
                if (sect.sct_own == 0 || sect.sct_own == plane_owner)
                        continue;

		if (evaded)
			continue;

		if (unfriendly[sect.sct_own] && !gotilist[sect.sct_own]) {
			getilist(&ilist[sect.sct_own], sect.sct_own);
			gotilist[sect.sct_own]++;
		}
		if ((rel = getrel(over, plane_owner)) == ALLIED)
			continue;
		overfly[sect.sct_own]++;
		PR(sect.sct_own, fmt("%s planes spotted over %s\n",
			cname(plane_owner), xyas(x, y, sect.sct_own)));
		if (rel == NEUTRAL)
			continue;
		ac_intercept(bomb_list, esc_list, &ilist[sect.sct_own],
			sect.sct_own, x, y);

	}
#if	defined(BMAP) || defined(AUTONAV)
	writebigmap();
#endif
	if (QEMPTY(bomb_list) && QEMPTY(esc_list)){
#ifdef ASW_PLANES
		if (mission_flags & P_A){
			s=head.next;
			while (s != (struct shiplook *)0){
				s2=s;
				s=s->next;
				free(s2);
			}
		}
#endif /* ASW_PLANES */
		return;
	}

	bzero((s_char *)nats, sizeof(nats));
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (mchr[ship.shp_type].m_flags & M_SUB)
			continue;
		nats[ship.shp_own]++;
	}
	if (!evaded)
		ac_shipflak(bomb_list, x, y);

	bzero((s_char *)lnats, sizeof(lnats));
	snxtitem_xy(&ni, EF_LAND, x, y);
	while (nxtitem(&ni, (s_char *)&land)) {
		lnats[land.lnd_own]++;
	}
	if (!evaded)
		ac_landflak(bomb_list, x, y);

	for (cn=1; cn<MAXNOC && !QEMPTY(bomb_list); cn++) {
		if (plane_owner == cn)
			continue;
		if (overfly[cn] > 0)
			nreport(plane_owner, N_OVFLY_SECT, cn, overfly[cn]);
		if (nats[cn] != 0){
#ifdef MERC
			if(cn != 0)
#endif
			PR(cn, fmt("%s planes spotted over ships in %s\n",
				cname(plane_owner), xyas(x, y, cn)));
			if (unfriendly[cn]){
				if (!gotilist[cn]) {
					getilist(&ilist[cn], cn);
					gotilist[cn]++;
				}
				PR(plane_owner,	fmt("Flying over %d #%d ships...\n", nats[cn], cn));
				/* This makes going for ships in harbors tough */
				if (!evaded)
					ac_intercept(bomb_list, esc_list,
					&ilist[cn], cn, x, y);
			}
		}
		if (lnats[cn] != 0){
#ifdef MERC
			if(cn != 0)
#endif
			PR(cn, fmt("%s planes spotted over land units in %s\n",
				cname(plane_owner), xyas(x, y, cn)));
			if (unfriendly[cn]){
				if (!gotilist[cn]) {
					getilist(&ilist[cn], cn);
					gotilist[cn]++;
				}
				PR(plane_owner,fmt("Flying over %d #%d units...\n", lnats[cn], cn));
				if (!evaded)
					ac_intercept(bomb_list, esc_list,
					&ilist[cn], cn, x, y);
			}
		}
	}

#ifdef ASW_PLANES
	if ((mission_flags & P_A) && (head.uid != -1)){
		s=head.next;
		while (s != (struct shiplook *)0){
			s2=s;
			s=s->next;
			free(s2);
		}
	}
#endif /* ASW_PLANES */
}

ac_intercept(bomb_list, esc_list, def_list, def_own, x, y)
	struct	qelem *bomb_list;
	struct	qelem *esc_list;
	struct	qelem *def_list;
	natid	def_own;
	coord	x;
	coord	y;
{
	register struct plnstr *pp;
	register struct plchrstr *pcp;
	int	gas;
	struct	plist *ip;
	int	icount;
	struct	shpstr ship;
	struct	lndstr land;
	struct	sctstr sect;
	struct	qelem *next;
	struct	qelem *qp;
	struct	qelem int_list;
	s_char	*ptr;
	int	type;
	int	att_count;
	natid	plane_owner;

	ip = (struct plist *)bomb_list->q_forw;
	plane_owner = ip->plane.pln_own;

	icount = 0;
	att_count = 0;
	for (qp = bomb_list->q_forw; qp != bomb_list; qp = qp->q_forw)
		att_count++;
	for (qp = esc_list->q_forw; qp != esc_list; qp = qp->q_forw)
		att_count++;
	initque(&int_list);
	for (qp = def_list->q_forw; qp != def_list; qp = next) {
		next = qp->q_forw;
		ip = (struct plist *) qp;
		pp = &ip->plane;
		pcp = ip->pcp;
		if (pp->pln_range/2 < mapdist(x, y, pp->pln_x, pp->pln_y))
			continue;
		if (pp->pln_ship >= 0) {
			getship(pp->pln_ship, &ship);
			type = EF_SHIP;
			ptr = (s_char *) &ship;
		} else
		if (pp->pln_land >= 0) {
			getland(pp->pln_land, &land);
			type = EF_LAND;
			ptr = (s_char *) &land;
		} else {
			getsect(pp->pln_x, pp->pln_y, &sect);
			type = EF_SECTOR;
			ptr = (s_char *) &sect;
		}
		gas = getvar(V_PETROL, ptr, type);
		if (((float)gas) < (((float)pcp->pl_fuel)/2.0)){
			remque(qp);
			free((s_char *)qp);
			continue;
		}
		/* got one; delete from def_list, add to int_list */
		remque(qp);
		insque(qp, &int_list);
		pp->pln_mobil -= 10;
		putplane(pp->pln_uid, pp);
		putvar(V_PETROL, gas - (pcp->pl_fuel/2), ptr, type);
		if (pp->pln_ship >= 0) {
			putship(pp->pln_ship, &ship);
		}
		if (pp->pln_land >= 0) {
			putland(pp->pln_land, &land);
		}
		else
			putsect(&sect);
		icount++;
		if (icount > att_count)
			break;
	}
	if (icount == 0)
		return;
	PR(plane_owner,fmt("%d %s fighter%s rising to intercept!\n", icount,
		cname(def_own), icount == 1 ? " is" : "s are"));
	ac_airtoair(esc_list, &int_list, def_own);
	ac_airtoair(bomb_list, &int_list, def_own);
}

/*
 * air-to-air combat.
 * The interceptors aren't affected by efficiency loss; they
 * always engage at 1:1 odds.
 */
ac_airtoair(att_list, int_list, def_own)
	struct	qelem *att_list;
	struct	qelem *int_list;
	natid	def_own;
{
	register struct plist *attacker;
	register struct plist *interceptor;
	struct	qelem *att;
	struct	qelem *in;
	int	nplanes;
	int	adam;
	int	idam;
	int	more_att;
	int	more_int;
	s_char	*mesg;
	struct	qelem *att_next;
	struct	qelem *in_next;
	natid	att_own;

	att = att_list->q_forw;
	in = int_list->q_forw;
	more_att = 1;
	more_int = 1;
	if (QEMPTY(att_list) || QEMPTY(int_list)) {
		more_att = 0;
		more_int = 0;
	}
	while (more_att || more_int) {
		in_next = in->q_forw;
		att_next = att->q_forw;
		attacker = (struct plist *) att;
		interceptor = (struct plist *) in;
		att_own = attacker->plane.pln_own;
		def_own = interceptor->plane.pln_own;
		mesg = fmt("  %s %s (#%d) intercepts %s %s (#%d)\n",
			cname(interceptor->plane.pln_own),
			interceptor->pcp->pl_name,
			interceptor->plane.pln_uid,
			cname(attacker->plane.pln_own),
			attacker->pcp->pl_name,
			attacker->plane.pln_uid);
		PR(att_own,mesg);
#ifdef MERC
		if(def_own != 0)
#endif
		PR(def_own, mesg);
		adam = idam = 0;
		nplanes = attacker->plane.pln_effic;
		if (nplanes > interceptor->plane.pln_effic)
			nplanes = interceptor->plane.pln_effic;
		ac_dog(attacker, interceptor, &adam, &idam);
		if (interceptor->pcp->pl_flags & P_M)
			idam = 100;

		if (adam > 0)
			ac_planedamage(attacker, interceptor->plane.pln_own,
				adam, def_own, 1);
		if (idam > 0)
			ac_planedamage(interceptor, attacker->plane.pln_own,
				idam, att_own,1);
		in = in_next;
		att = att_next;
		if (att == att_list) {
			more_att = 0;
			if (QEMPTY(att_list))
				more_int = 0;
			else
				att = att->q_forw;
		}
		if (in == int_list) {
			more_int = 0;
			if (QEMPTY(int_list))
				more_att = 0;
			else
				in = in->q_forw;
		}
	}
}

#define MIN(x,y) (x < y ? x : y)
#define MAX(x,y) (x < y ? y : x)
int
ac_dog(ap, dp, adam, ddam)
	register struct plist *ap;
	register struct plist *dp;
	int *adam, *ddam;
{
	int	n;
	float	mult;
	int	diff, att, def;
	double	odds;
	int	intensity, a_cas, d_cas;
	natid	att_own, def_own;
	
	att_own = ap->plane.pln_own;
	def_own = dp->plane.pln_own;

	if (ap->plane.pln_att == 0){
		att = ap->plane.pln_def * ap->plane.pln_effic / 100;
		att = MAX(att,ap->pcp->pl_def/2);
	}else{
		att = ap->plane.pln_att * ap->plane.pln_effic / 100;
		att = MAX(att,ap->pcp->pl_att/2);
	}

	def = dp->plane.pln_def * dp->plane.pln_effic / 100;
	def = MAX(def,dp->pcp->pl_def/2);

        if ((ap->pcp->pl_flags & P_F) && ap->bombs != 0)
                att -= 2;
        if ((dp->pcp->pl_flags & P_F) && dp->bombs != 0)
                def -= 2;
#ifndef STEALTHV
	if (ap->pcp->pl_flags & P_X)
		att += 3;
	if (dp->pcp->pl_flags & P_X)
		def += 3;
#else
	att += ((float)ap->pcp->pl_stealth/25.0);
	def += ((float)dp->pcp->pl_stealth/25.0);
#endif /* STEALTHV */
	PR(att_own,fmt("Attacker strength %d\t",att));
	PR(att_own,fmt("Interceptor strength %d\t",def));
	PR(def_own,fmt("Attacker strength %d\t",att));
	PR(def_own,fmt("Interceptor strength %d\t",def));
	odds = ((double)att/((double)def+(double)att));
	PR(att_own,fmt("Odds are %1.2f\t",odds));
	PR(def_own,fmt("Odds are %1.2f\t",odds));
	intensity = roll(20)+roll(20)+roll(20)+roll(20)+1;

	PR(att_own,fmt("Intensity is %d\n",intensity));
	PR(def_own,fmt("Intensity is %d\n",intensity));
	a_cas = 0; d_cas = 0;
	while ((intensity--)>0){
		if (((a_cas + d_cas) % 70) == 69){
			PR(att_own,"\n");
			PR(def_own,"\n");
		}

		if (chance(odds)) {
			PR(att_own,"!");
			PR(def_own,"@");
			d_cas += 1;
			if ((dp->plane.pln_effic-d_cas) < PLANE_MINEFF)
				intensity=0;
		} else {
			PR(att_own,"@");
			PR(def_own,"!");
			a_cas += 1;
			if ((ap->plane.pln_effic-a_cas) < PLANE_MINEFF)
				intensity=0;
		}
	}
	PR(att_own,fmt("\n"));
	PR(def_own,fmt("\n"));

	*adam = a_cas;
	*ddam = d_cas;
}

/*
 * zap plane associated with plp.
 * Damaging country is "from", damage is "dam".
 * def_own is the country on the other side of the conflict from the plane
 * owner. The only time def_own != from is when the interceptor is getting
 * damaged.
 *
 * NOTE: This routine removes the appropriate plane element from the
 * queue if it gets destroyed.  That means that the caller must assume
 * that the current queue pointer is invalid on return from the ac_planedamage
 * call.  (this has caused bugs in the past)
 */
ac_planedamage(plp, from, dam, other, checkabort)
	struct	plist *plp;
	natid	from;
	int	dam;
	natid	other;
	int	checkabort;
{
	register struct plnstr *pp;
	int	disp;
	s_char	dmess[255], buf[80];
	int	eff;
	s_char	*mesg;
	struct shpstr ship;
	struct lndstr land;
	s_char *sprintf();
	natid	plane_owner;

	disp = 0;
	pp = &plp->plane;
	plane_owner = pp->pln_own;
	eff = pp->pln_effic;
	if ((dam <= 0) && (checkabort != 2))
		return;
	bzero(dmess,255);
	eff -= dam;
	if (eff < 0)
		eff = 0;
	if (eff < PLANE_MINEFF) {
		sprintf(dmess," -- shot down");
		disp = 1;
	} else if (chance((100-eff)/100.0) && checkabort){
		sprintf(dmess," -- aborted with %d%% damage", 100-eff);
		disp = 2;
	}
	if ((plp->pcp->pl_flags & P_M) == 0) {
		if (checkabort != 2){ /* not checking abort after ship flak */
			mesg = fmt("    %s %s (#%d) takes %d%s.\n",
				cname(pp->pln_own),
				plp->pcp->pl_name, pp->pln_uid, dam, dmess);
			PR(plane_owner,mesg);
			PR(other,mesg);
		} else{
			if (disp > 0){
				mesg = fmt("    %s %s (#%d)%s\n",
					cname(pp->pln_own),
					plp->pcp->pl_name, pp->pln_uid, dmess);
				PR(plane_owner,mesg);
				PR(other,mesg);
			}
		}
	}
	PR(plane_owner,"\n");
	PR(other,"\n");

	pp->pln_effic = eff;
	if (disp == 1) {
		if (from != 0 && (plp->pcp->pl_flags & P_M) == 0)
			nreport(from, N_DOWN_PLANE, pp->pln_own, 1);
		if (pp->pln_ship >= 0) {
			getship(pp->pln_ship,&ship);
			take_plane_off_ship(pp,&ship);
		}
		if (pp->pln_land >= 0) {
			getland(pp->pln_land,&land);
			take_plane_off_land(pp,&land);
		}
		pp->pln_own = 0;
		putplane(pp->pln_uid, pp);
		remque(&plp->queue);
		free((s_char *)plp);
	} else if (disp == 2) {
		putplane(pp->pln_uid, pp);
		remque(&plp->queue);
		free((s_char *)plp);
	} else
		putplane(pp->pln_uid, pp);
}

ac_doflak(list, from)
	struct	qelem *list;
	struct	sctstr *from;
{
	int	shell, add;
	int	gun;
	natid	plane_owner;
	struct	plist *plp;

	plp = (struct plist *)list->q_forw;
	plane_owner = plp->plane.pln_own;

	gun = getvar(V_GUN, (s_char *)from, EF_SECTOR);
	shell = getvar(V_SHELL, (s_char *)from, EF_SECTOR);
	add = 0;
	if (shell < (gun/2))
		add = supply_commod(from->sct_own,from->sct_x,from->sct_y,
			I_SHELL,ldround(((double)gun/2.0),1)-shell);
	shell += add;
	if (gun == 0 || shell == 0)
		return;
	if (gun > shell*2)
		gun = shell*2;
	if (gun > 14)
		gun = 14;

	shell -= (gun/2);
	putvar(V_SHELL, shell, (s_char *)from, EF_SECTOR);
	gun = 2.0 * tfact(from->sct_own, (double) gun);
	if (gun > 0) {
		PR(plane_owner,fmt("firing %d flak guns in %s...\n",
			gun, xyas(from->sct_x, from->sct_y, plane_owner)));
#ifdef MERC
		if(from->sct_own != 0)
#endif
		PR(from->sct_own, fmt("firing %d flak guns in %s...\n",
			gun, xyas(from->sct_x, from->sct_y, from->sct_own)));
		ac_fireflak(list, from->sct_own, gun);
	}
}

ac_shipflak(list, x, y)
	struct	qelem *list;
	coord	x;
	coord	y;
{
	struct	nstr_item ni;
	struct	shpstr ship;
	struct	mchrstr *mcp;
	int	firing;
	int	gun;
	int	shell;
	int	rel;
	s_char	*msg;
	struct	qelem *qp;
	struct	qelem *next;
	struct  plist *plp;
	natid	from=0, plane_owner;
	int	fired=0;

	plp = (struct plist *)list->q_forw;
	plane_owner = plp->plane.pln_own;

	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (!QEMPTY(list) && nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_own == 0 || ship.shp_own == plane_owner)
			continue;
		mcp = &mchr[ship.shp_type];
		if (mcp->m_flags & M_SUB)
			continue;
		rel = getrel(getnatp(ship.shp_own), plane_owner);
#ifdef SLOW_WAR
		if (rel != AT_WAR && rel != HOSTILE && rel != MOBILIZATION && rel != SITZKRIEG)
			continue;
#else
		if (rel != AT_WAR && rel != HOSTILE)
			continue;
#endif /* SLOW_WAR */
		gun = min(getvar(V_GUN, (s_char *)&ship, EF_SHIP), mcp->m_glim);
		shell = getvar(V_SHELL, (s_char *)&ship, EF_SHIP);
		if (shell == 0)
			shell += supply_commod(ship.shp_own,ship.shp_x,
				ship.shp_y,I_SHELL,1);
		if (gun == 0 || shell == 0)
			continue;
		firing = (int) (techfact(ship.shp_tech, (double)gun) * 4.0);
		fired=1;
#ifdef	SHIPNAMES
		msg = fmt("firing %d flak guns from %s %s(#%d)...\n",
			firing, mcp->m_name, ship.shp_name, ship.shp_uid);
#else
		msg = fmt("firing %d flak guns from %s #%d...\n",
			firing, mcp->m_name, ship.shp_uid);
#endif	SHIPNAMES
		PR(plane_owner,msg);
#ifdef MERC
		if(ship.shp_own != 0)
#endif
		PR(ship.shp_own, msg);
		from = ship.shp_own;
		ac_fireflak(list, ship.shp_own, firing);
		putvar(V_SHELL, shell - 1, (s_char *)&ship, EF_SHIP);
		putship(ni.cur, &ship);
	}

	if (fired)
		for (qp = list->q_forw; qp != list; qp = next) {
			next = qp->q_forw;
			plp = (struct plist *) qp;
			ac_planedamage(plp, plp->plane.pln_own, 0, from, 2);
		}
}

ac_landflak(list, x, y)
	struct	qelem *list;
	coord	x;
	coord	y;
{
	struct	nstr_item ni;
	struct	lndstr land;
	struct	lchrstr *lcp;
	int	firing;
	int	gun;
	int	shell;
	int	rel;
	s_char	*msg;
	struct	qelem *qp;
	struct	qelem *next;
	struct  plist *plp;
	natid	from=0;
	int	fired=0;
	natid	plane_owner;

	plp = (struct plist *)list->q_forw;
	plane_owner = plp->plane.pln_own;

	snxtitem_xy(&ni, EF_LAND, x, y);
	while (!QEMPTY(list) && nxtitem(&ni, (s_char *)&land)) {
		if (land.lnd_own == 0 || land.lnd_own == plane_owner)
			continue;
		lcp = &lchr[land.lnd_type];

		if (lcp->l_aaf == 0)
			continue;

		rel = getrel(getnatp(land.lnd_own), plane_owner);
#ifdef SLOW_WAR
		if (rel != AT_WAR && rel != HOSTILE && rel != MOBILIZATION && rel != SITZKRIEG)
			continue;
#else
		if (rel != AT_WAR && rel != HOSTILE)
			continue;
#endif /* SLOW_WAR */
		firing = (int)(techfact(land.lnd_tech, (double)lcp->l_aaf)*3.0);
		fired=1;
		msg = fmt("firing flak guns from unit %s #%d (aa rating %d)...\n",
			lcp->l_name, land.lnd_uid, lcp->l_aaf);

		PR(plane_owner,msg);
#ifdef MERC
		if(land.lnd_own != 0)
#endif
		PR(land.lnd_own, msg);
		from = land.lnd_own;
		ac_fireflak(list, land.lnd_own, firing);
	}

	if (fired)
		for (qp = list->q_forw; qp != list; qp = next) {
			next = qp->q_forw;
			plp = (struct plist *) qp;
			ac_planedamage(plp, plp->plane.pln_own, 0, from, 2);
		}
}

/*
 * Called from shipflak, landflak, and doflak.
 */
ac_fireflak(list, from, guns)
	struct	qelem *list;
	natid	from;
	int	guns;
{
	extern	double flakscale;
	register struct plnstr *pp;
	struct	plist *plp;
	int	n;
	float	mult;
	int	diff;
	struct	qelem *qp;
	struct	qelem *next;
	natid	plane_owner;

	plp = (struct plist *)list->q_forw;
	plane_owner = plp->plane.pln_own;

	for (qp = list->q_forw; qp != list; qp = next) {
		/*
		 * fighters don't get shot at by flak
		 * non-tactical bombers are harder to hit with flak.
		 * ('Cause they're not dive-bombing?)
		 */
		next = qp->q_forw;
		plp = (struct plist *) qp;
		pp = &plp->plane;
		diff = guns - pp->pln_def;
		if ((plp->pcp->pl_flags & P_T) == 0)
			diff--;
		if (plp->pcp->pl_flags & P_X)
			diff -= 2;
#ifdef CHOPPER_STEALTH
		if (plp->pcp->pl_flags & P_X)
			diff -= 1;
#endif /* CHOPPER_STEALTH */
		if (diff > 8)
			mult = flaktable[FLAK_MAX] * 1.33;
		else if (diff < -7)
			mult = flaktable[0] * 0.66;
		else {
			diff += 7;
			mult = flaktable[diff];
		}
		mult *= flakscale;
		n = (int) ((roll(8) + 2) * mult);
		if (n > 100)
			n = 100;
		ac_planedamage(plp, from, n, from, 0);
	}
}

/*
 * Get a list of planes available for interception duties.
 */
static
getilist(list, own)
	struct	qelem *list;
	natid	own;
{
	register struct plchrstr *pcp;
	struct	plnstr plane;
	struct	shpstr ship;
	struct	lndstr land;
	struct	sctstr sect;
	struct	nstr_item ni;
	int	type;
	s_char	*ptr;
	struct	plist *ip;
	natid	plane_owner;

	initque(list);
	snxtitem_all(&ni, EF_PLANE);
	while (nxtitem(&ni, (s_char *)&plane)) {
		if (plane.pln_own != own)
			continue;
		pcp = &plchr[plane.pln_type];
		if ((pcp->pl_flags & P_F) == 0)
			continue;
		if (plane.pln_mission != 0)
			continue;
		if (plane.pln_mobil <= 0)
			continue;
		if (plane.pln_effic < 40)
			continue;
		if (plane.pln_ship >= 0) {
			if (!can_fly(plane.pln_uid))
				continue;
			getship(plane.pln_ship,&ship);
			ptr = (s_char *)&ship;
			type = EF_SHIP;
		} else
		if (plane.pln_land >= 0) {
			if (!can_fly(plane.pln_uid))
				continue;
			getland(plane.pln_land,&land);
			ptr = (s_char *)&land;
			type = EF_LAND;
		} else {
			getsect(plane.pln_x, plane.pln_y, &sect);
			ptr = (s_char *)&sect;
			type = EF_SECTOR;
#if 0
			if (sect.sct_effic < 60 && (pcp->pl_flags & P_V) == 0)
				continue;
#else
			if ((sect.sct_effic < 60 || sect.sct_type != SCT_AIRPT)
			&& (pcp->pl_flags & P_V) == 0)
				continue;
#endif
		}
		if (((float)getvar(V_PETROL, ptr, type)) <
			(((float)pcp->pl_fuel)/2.0))
			continue;
		/* got one! */
		ip = (struct plist *) malloc(sizeof(*ip));
		ip->state = P_OK;
		ip->bombs = 0;
		ip->misc = 0;
		ip->pcp = &plchr[plane.pln_type];
		bcopy((s_char *)&plane, (s_char *)&ip->plane, sizeof(plane));
		insque(&ip->queue, list);
	}
}

#ifdef	ABM

/*
 * Get a list of nuclear interceptors (not including sats).     
 *
 * Alex Shatsky (lex@ucscb.ucsc.edu)
 *
 * liberally borrowed from getilist.
 */
static
getirvlist(list, own)
	struct	qelem *list;
	natid	own;
{
	register struct plchrstr *pcp;
	struct 	plnstr plane;
	struct 	shpstr ship;
	struct 	lndstr land;
	struct 	sctstr sect;
	struct	nstr_item ni;
	int	type;
	s_char	*ptr;
	struct	plist *irv;

	initque (list);
	snxtitem_all (&ni, EF_PLANE);
	while (nxtitem (&ni, (s_char *)&plane)) {
#ifdef	BETTERABM
		/* When BETTERABM is used, own is owner of bomb */
		if (plane.pln_own == own)
			continue;

		if (plane.pln_own == 0)
			continue;
		
		if (getrel(getnatp(plane.pln_own), own) == ALLIED)
			continue;
#else
		/* When BETTERABM is not used, own is owner of target sect */
		if (plane.pln_own != own)
			continue;

		if (plane.pln_own == 0)
			continue;
#endif	BETTERABM
		pcp = &plchr[plane.pln_type];
 		if ((pcp->pl_flags & P_N) == 0)
			continue;
		/* Ignore satellites */
		if (!(pcp->pl_flags & P_O) == 0)
			continue;
		if (plane.pln_mobil <= 0)
			continue;
		if (plane.pln_effic < 100)
			continue;
		if (plane.pln_ship >= 0) {
			if (!getship(plane.pln_ship, &ship) ||
			    !can_fly(plane.pln_uid))
				continue;
			ptr = (s_char *)&ship;
			type = EF_SHIP;
		} else
		if (plane.pln_land >= 0) {
			if (!getland(plane.pln_land, &land) ||
			    !can_fly(plane.pln_uid))
				continue;
			ptr = (s_char *)&land;
			type = EF_LAND;
		} else {
			getsect (plane.pln_x, plane.pln_y, &sect);
			ptr = (s_char *)&sect;
			type = EF_SECTOR;
			if ((sect.sct_effic < 60 || sect.sct_type != SCT_AIRPT)
			&& (pcp->pl_flags & P_V) == 0)
				continue;
		}
		if (((float)getvar(V_PETROL, ptr, type)) <
			(((float)pcp->pl_fuel)/2.0))
			continue;
		/* got a valid interceptor */
		irv = (struct plist *) malloc(sizeof(*irv));
		irv->state = P_OK;
		irv->bombs = 0;
		irv->misc = 0;
		irv->pcp = &plchr[plane.pln_type];
		bcopy((s_char *)&plane, (s_char *)&irv->plane, sizeof(plane));
		insque(&irv->queue, list);
	}
}

/*
 * Attempt to intercept an incoming warhead.  Return 1 if warhead is 
 * successfully destroyed.
 * This really should not allow the safe targeting of unowned adjoining
 * sectors (water, etc.), but it does.
 *
 * Alex Shatsky (lex@ucscb.ucsc.edu)
 */
short
rv_intercept(x, y, bombown)
	coord 	x;
	coord	y;
	natid	bombown;
{
	register struct plnstr *pp;
	register struct plchrstr *pcp;
	register struct plist *interceptor;
	struct	sctstr  sect;
	struct	natstr  *over;
	struct	qelem	*irvlist;
	struct	qelem	foo;
	struct	qelem	int_list;
	struct  qelem	*qp;
	struct	qelem	*next;
	struct 	qelem	*in;
	struct  plist	*ip;
	struct	sctstr	psect;
	struct	lndstr	pland;
	struct	shpstr	pship;
	int 	icount = 0;
	int 	type;
	int	gas;
	s_char	*ptr;
	short	destroyed = 0;

	irvlist = &foo;
	getsect(x, y, &sect);
#ifdef	BETTERABM
	getirvlist(irvlist, bombown);
#else
	getirvlist(irvlist, sect.sct_own);
#endif	BETTERABM
#ifdef MERC
	if(sect.sct_own != 0)
#endif
	PR(sect.sct_own, fmt("%s warhead incoming on sector %s\n", 
		cname(bombown), xyas(x, y, sect.sct_own)));
	initque (&int_list);
	for (qp = irvlist->q_forw; qp != irvlist; qp = next) {
		next = qp->q_forw;
		ip = (struct plist *)qp;
		pp = &ip->plane;
		pcp = ip->pcp;
		if (pp->pln_range/2 < mapdist(x, y, pp->pln_x, pp->pln_y))
			continue;
		if (pp->pln_ship >= 0) {
			getship(pp->pln_ship, &pship);
			type = EF_SHIP;
			ptr = (s_char *)&pship;
		} else
		if (pp->pln_land >= 0) {
			getland(pp->pln_land, &pland);
			type = EF_LAND;
			ptr = (s_char *)&pland;
		} else {
			getsect (pp->pln_x, pp->pln_y, &psect);
			type = EF_SECTOR;
			ptr = (s_char *)&psect;
		}
		gas = getvar(V_PETROL, ptr, type);
		if (((float)gas) < (((float)pcp->pl_fuel)/2.0)){
			remque(qp);
			free((s_char *)qp);
			continue;
		}
		/* got one interceptor, delete from irv_list and   
   		 * add to  int_list.
    		 */
		remque(qp);
		insque(qp, &int_list);
		putplane(pp->pln_uid, pp);
		putvar(V_PETROL, gas - (pcp->pl_fuel/2), ptr, type);
		if (pp->pln_ship >= 0){
			putship (pp->pln_ship, &pship);
		} else
		if (pp->pln_land >= 0){
			putland (pp->pln_land, &pland);
		}
		else putsect(&psect);
		/* only allow two abms per warhead */
		if (++icount == 2)
			break;
	}
	if (icount == 0) {
#ifdef MERC
		if(sect.sct_own != 0)
#endif
 		PR(sect.sct_own, fmt("No abms launched to intercept.\n"));
		return (destroyed);
	}
	icount = 0;
	/* attempt to destroy warhead */
/*	in = &int_list->q_forw; */
	in = int_list.q_forw;
	while (!(QEMPTY(&int_list))) {
		interceptor = (struct plist *)in;
#ifdef	BETTERABM
		if (sect.sct_own == interceptor->plane.pln_own) {
			icount++;
			pr (fmt("%s abm launched in defense!\n",
			 	cname(interceptor->plane.pln_own)));
#ifdef MERC
			if(sect.sct_own != 0)
#endif
		    PR(sect.sct_own, "abm launched in defense!\n");
		}
		else
		{
#ifndef BABY_NUKES
			icount++;
			pr (fmt("%s abm launched in defense!\n",
			 	cname(interceptor->plane.pln_own)));
#ifdef MERC
			if(sect.sct_own != 0) {
#endif
		    PR(sect.sct_own, fmt("%s abm launched in defense!\n",
			cname(interceptor->plane.pln_own)));
		    PR(interceptor->plane.pln_own,
			fmt("abm launched to defend %s!\n",
				cname(sect.sct_own)));
#ifdef MERC
			}
#endif
#else
			remque(&interceptor->queue);
			free((s_char *)interceptor);
			in=in->q_forw;
			continue;
#endif /* BABY_NUKES */
		}
#endif	BETTERABM
		if (chance(((double)interceptor->plane.pln_def/100.0)) &&
			!destroyed)  {
#ifdef	BETTERABM
			pr (fmt("Warhead destroyed by %s abm!\n",
				 cname(interceptor->plane.pln_own)));
#else
			pr (fmt("Warhead device destroyed by %s abm!\n",
				 cname(sect.sct_own)));
#endif	BETTERABM
#ifdef MERC
			if(sect.sct_own != 0)
#endif
			PR(sect.sct_own, fmt("%s missile intercepted!\n",
		    	     cname(bombown)));
#ifdef	BETTERABM
			if (sect.sct_own != interceptor->plane.pln_own)
#ifdef MERC
				if(interceptor->plane.pln_own != 0)
#endif
				PR(interceptor->plane.pln_own, 
					fmt("%s missile intercepted!\n",
					     cname(bombown)));
#endif	BETTERABM
			destroyed = 1;
			/* the news knows all... */
#ifdef	BETTERABM
			nreport(bombown, N_NUKE_STOP,
			    interceptor->plane.pln_own, 1);
#else
			nreport(bombown, N_NUKE_STOP, sect.sct_own, 1);
#endif	BETTERABM
     		}
		/* zap the missile */
#ifdef	BETTERABM
		interceptor->plane.pln_own = 0;
		putplane(interceptor->plane.pln_uid, &(interceptor->plane));
		remque(&interceptor->queue);
		free((s_char *)interceptor);
#else
		ac_planedamage(interceptor, bombown, 100, cnum, 1);
#endif	BETTERABM
		in = in->q_forw;
	}
	if (destroyed) return (destroyed);
	if (icount)
		pr (fmt("Warhead made it through abm defenses!\n"));
#ifdef MERC
	if(sect.sct_own != 0)
#endif
	if (icount)
		PR(sect.sct_own, fmt("Abm interception failed.\n"));
	return (destroyed);
}

#endif	ABM

can_fly(p) /* Can this plane fly from the ship or land unit it is on? */
int	p;
{
	struct plnstr plane;
	struct shpstr ship;
	struct lndstr land;
	struct plchrstr *pcp;
	struct mchrstr *scp;
	struct lchrstr *lcp;

	getplane(p,&plane);
	pcp = &plchr[plane.pln_type];

	if (plane.pln_ship >= 0){
		if (
			!(pcp->pl_flags & P_L) && !(pcp->pl_flags & P_M)
#ifdef SHIPCHOPPERS
			&& !(pcp->pl_flags & P_K)
#endif /* SHIPCHOPPERS */
#ifdef XLIGHT
			&& !(pcp->pl_flags & P_E)
#endif /* XLIGHT */
			)
			return 0;

		getship(plane.pln_ship,&ship);
		scp = & mchr[ship.shp_type];

		if ((pcp->pl_flags & P_L) && (scp->m_flags & M_FLY)){
			return 1;
		}
	
#ifdef SHIPSAMS
		if ((pcp->pl_flags & P_M) && (scp->m_flags & M_MSL)){
			return 1;
		}
#endif /* SHIPSAMS */
	
#ifdef SHIPCHOPPERS
		if ((pcp->pl_flags & P_K) && (scp->m_flags & M_CHOPPER)){
			return 1;
		}
#endif /* SHIPCHOPPERS */
	
#ifdef XLIGHT
		if ((pcp->pl_flags & P_E) && (scp->m_flags & M_XLIGHT)){
			return 1;
		}
#endif /* XLIGHT */
	}

	if (plane.pln_land >= 0){
#ifdef XLIGHT
		if (!(pcp->pl_flags & P_E))
			return 0;
#endif /* XLIGHT */

		getland(plane.pln_land,&land);
		lcp = & lchr[land.lnd_type];

#ifdef XLIGHT
		if ((pcp->pl_flags & P_E) && (lcp->l_flags & L_XLIGHT)){
			return 1;
		}
#endif /* XLIGHT */
	}

	return 0;
}

PR(cn,s)
natid	cn;
s_char	*s;
{
	register int x,newline=0;
	static s_char longline[MAXNOC][512];
	extern int ismission;

	for(x=0;x<strlen(s);x++)
		if (*(s+x) == '\n')
			newline=1;

	sprintf(&longline[cn][strlen(longline[cn])],"%s",s);

	if (newline){
		if (ismission)
			wu(0,cn,longline[cn]);
		else if (cn == cnum)
			pr(longline[cn]);
		else
			wu(0,cn,longline[cn]);
		bzero(longline[cn],512);
	}
}
PRdate(cn)
natid	cn;
{
	extern	s_char *ctime();
	long	now;

	(void) time(&now);
	PR(cn,ctime(&now));
}

do_evade(bomb_list, esc_list, mission_flags)
struct qelem *bomb_list, *esc_list;
int mission_flags;
{
	struct qelem *qp;
	double evade;
	struct plist *plp;

#ifdef STEALTHV
	evade=100.0;
        for (qp = bomb_list->q_forw; qp != bomb_list; qp = qp->q_forw){
                plp = (struct plist *) qp;
                if (evade > ((float)plp->pcp->pl_stealth/100.0))
                	evade = (plp->pcp->pl_stealth/100.0);
	}
        for (qp = esc_list->q_forw; qp != esc_list; qp = qp->q_forw){
                plp = (struct plist *) qp;
                if (evade > plp->pcp->pl_stealth/100.0)
                	evade = (plp->pcp->pl_stealth/100.0);
	}
#else
	evade = 0;
	/* Stealth */
	if (mission_flags & P_X)
		evade = 0.88;
#ifdef CHOPPER_STEALTH
	/* Half Stealth */
	if (mission_flags & P_H)
		evade = 0.22;
#endif /* CHOPPER_STEALTH */
#endif /* STEALTHV */

	if (chance(evade))
		return 1;

	return 0;
}
