#ifndef lint
static char *RCSid = "$Header: /empire/empire/EMP/player/commands/rang.c 1.0 90/12/19 02:33:10 bailey Exp $";
#endif

/*
 * rang.c
 *
 * Edit effective range of a plane.
 * Edit reaction radius of a land unit.
 *
 * Jeff Bailey
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "plane.h"
#include "land.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"
#include "deity.h"

range()
{
	extern s_char *argp[];
	struct nstr_item np;
	struct plnstr plane;
	int	i;
	s_char	*p;

	if (!snxtitem(&np, EF_PLANE, argp[1]))
		return RET_SYN;
	while (nxtitem(&np, (s_char *)&plane)) {
		if (!owner || plane.pln_own == 0)
			continue;
		p = getstarg(argp[2],"New range? ");
		if ((i = atoi(p)) < 0)
			continue;
		plane.pln_range = (plane.pln_range_max < i) ?
			plane.pln_range_max : i;
		pr(fmt("Plane %d range changed to %d\n",plane.pln_uid,
			plane.pln_range));
		putplane(plane.pln_uid,&plane);
	}

	return RET_OK;
}

lrange()
{
	extern s_char *argp[];
	struct nstr_item np;
	struct lndstr land;
	struct lchrstr *lcp;
	int	i;
	s_char	*p;

	if (!snxtitem(&np, EF_LAND, argp[1]))
		return RET_SYN;
	while (nxtitem(&np, (s_char *)&land)) {
		if (!owner || land.lnd_own == 0)
			continue;
		lcp = &lchr[land.lnd_type];
		p = getstarg(argp[2],fmt("New range for %s #%d? ",
			lcp->l_name, land.lnd_uid));
		if ((i = atoi(p)) < 0)
			continue;
		land.lnd_rad_max = (i < lcp->l_rad) ?
			i : lcp->l_rad;
		pr(fmt("%s #%d reaction radius changed to %d\n",lcp->l_name,
			land.lnd_uid, land.lnd_rad_max));
		putland(land.lnd_uid,&land);
	}

	return RET_OK;
}
