#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/nati.c,v 1.9 89/07/02 21:05:33 mr-frog Exp $";
#endif /* not lint */

/*
 * nati.c
 *
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "file.h"
#include "xy.h"

int
nati()
{
	extern	s_char *argp[];
	extern	int etu_per_update;
	extern	double obrate, uwbrate;
	struct	natstr *natp;
	struct	sctstr sect;
	float	hap;
	int	mil;
	int	civ;
	struct	range absrange;
	struct	range relrange;
	struct	boundstr *b;
	int	i, poplimit, safepop, uwpop;

	if ((natp = getnatp(cnum)) == 0) {
		pr(fmt("Bad country number %d\n", cnum));
		return RET_SYN;
	}
	pr(fmt("\n\t%s Nation Report\t", cname(cnum)));
	prdate();
	pr(fmt("Nation status is %s", natstate(natp)));
	pr(fmt("     Bureaucratic Time Units: %d\n", natp->nat_btu));
	if (natp->nat_stat & STAT_INUSE) {
		getsect(natp->nat_xcap, natp->nat_ycap, &sect);
		if (!owner || (sect.sct_type != SCT_CAPIT &&
		    sect.sct_type != SCT_MOUNT &&
		    sect.sct_type != SCT_SANCT))
			pr(fmt("No capital. (was at %s)\n",
				xyas(sect.sct_x, sect.sct_y, cnum)));
		else {
			civ = getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR);
			mil = getvar(V_MILIT, (s_char *)&sect, EF_SECTOR);
			pr(fmt("%d%% eff %s at %s has %d civilian%s & %d military\n",
			       sect.sct_effic,
			       (sect.sct_type == SCT_CAPIT ? "capital" : "mountain capital"),
			       xyas(sect.sct_x, sect.sct_y, cnum), civ,
			       splur(civ), mil));
		}
	}
#ifdef REALM_IN_NAT
	absrange.width = 0;
	absrange.height = 0;
	for (i = 0; i < MAXNOR; i++) {
		b = &natp->nat_b[i];
		absrange.lx = b->b_xl;
		absrange.ly = b->b_yl;
		absrange.hx = b->b_xh;
		absrange.hy = b->b_yh;
		xyrelrange(natp, &absrange, &relrange);
		pr(fmt("#%2d  %d:%d,%d:%d%s", i,
			relrange.lx, relrange.hx,
			relrange.ly, relrange.hy,
		        (i % 3) != 2 ? "    " : "\n"));
	}
#endif /* REALM_IN_NAT */
	pr(fmt(" The treasury has $%.2f", (double) natp->nat_money));
	pr(fmt("     Military reserves: %d\n", natp->nat_reserve));
	pr(fmt("Education..........%6.2f       Happiness.......%6.2f\n",
		(double) natp->nat_level[NAT_ELEV],
		(double) natp->nat_level[NAT_HLEV]));
	pr(fmt("Technology.........%6.2f       Research........%6.2f\n",
		(double) natp->nat_level[NAT_TLEV],
		(double) natp->nat_level[NAT_RLEV]));
	pr(fmt("Technology factor :%6.2f%%", tfact(cnum, 100.)));
#ifndef NO_PLAGUE
	pr(fmt("     Plague factor : %6.2f%%\n",
	       ((double) natp->nat_level[NAT_TLEV] + 100.) /
	       ((double) natp->nat_level[NAT_RLEV] + 100.)));
#else
	pr(fmt("     Plague factor : 0%%\n"));
#endif NO_PLAGUE
	pr(fmt("\n"));
#ifdef RES_POP
	poplimit = max_pop(natp->nat_level[NAT_RLEV]);
	pr(fmt("Max population : %d\n", poplimit));
#else
	poplimit = 999;
#endif /* RES_POP */
	safepop = (int)((double)poplimit/(1.0 + obrate*(double)etu_per_update));
	uwpop = (int)((double)poplimit/(1.0 + uwbrate*(double)etu_per_update));
	pr(fmt("Max safe population for civs/uws: %d/%d\n",safepop,uwpop));

	hap = ((natp->nat_level[NAT_TLEV]-40)/40.0 +
			natp->nat_level[NAT_ELEV]/3.0);

	if (hap > 0.0)
		pr(fmt("Happiness needed is %f\n",hap));
	else
		pr(fmt("No happiness needed\n"));
	return RET_OK;
}
