#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/lten.c,v 1.6 89/07/12 01:55:34 jeffw Exp $";
#endif

/*
 * lten.c
 *
 * transfer from ship to a land unit it is carrying
 *
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "file.h"
#include "ship.h"
#include "item.h"
#include "nsc.h"
#include "nat.h"
#include "plane.h"
#include "nuke.h"
#include "land.h"
#include "genitem.h"

static	expose_ship();

int
ltend()
{
	extern	s_char *argp[];
	struct	nstr_item	targets;
	struct	nstr_item	tenders;
	struct	shpstr	tender;
	struct	lndstr	target;
	struct	ichrstr	*ip;
	struct	mchrstr	*vbase;
	struct	lchrstr	*lbase;
	int     amt;
	int     ontender;
	int     ontarget;
	int     maxtender;
	int     maxtarget;
	int     transfer;
	int     total;
	s_char	*p;

	if (!snxtitem(&tenders, EF_SHIP, getstarg(argp[1], "Tender(s)? ")))
		return RET_SYN;
	while (nxtitem(&tenders, (s_char *)&tender)) {
		if (!owner)
			continue;
		if ((ip = whatitem(argp[2], "Transfer what item? ")) == 0)
			break;
		if ((p = getstarg(argp[3], "Amount to transfer? ")) == 0)
			break;
		if ((amt = atoi(p)) == 0)
			break;
		ontender = getvar(ip->i_vtype, (s_char *)&tender, EF_SHIP);
		if (ontender == 0 && amt > 0) {
			pr(fmt("No %s on ship #%d\n", ip->i_name, tenders.cur));
			return RET_FAIL;
		}
		vbase = &mchr[tender.shp_type];
		maxtender = vl_find(ip->i_vtype, vbase->m_vtype,
			vbase->m_vamt, (int)vbase->m_nv);
		if (maxtender == 0) {
			pr(fmt("A %s cannot hold any %s\n",
			       mchr[tender.shp_type].m_name,
			       ip->i_name));
			break;
		}
		if (!snxtitem(&targets, EF_LAND,
		    getstarg(argp[4], "Units to be tended? ")))
			break;
		total = 0;
		while (tend_nxtitem(&targets, (s_char *)&target)) {
			if (!owner)
				continue;

			if (target.lnd_ship != tender.shp_uid)
				continue;
			ontarget = getvar(ip->i_vtype,(s_char *)&target, EF_LAND);
			if (ontarget == 0 && amt < 0) {
				pr(fmt("No %s on ship %d\n",
					ip->i_name, target.lnd_uid));
				continue;
			}
			lbase = &lchr[target.lnd_type];
			maxtarget = vl_find(ip->i_vtype, lbase->l_vtype,
				lbase->l_vamt, (int)lbase->l_nv);
			if (amt < 0) {
				if (!owner)
					amt=0;

				/* take from target and give to tender */
				transfer = min(ontarget, -amt);
				transfer = min(maxtender - ontender, transfer);
				if (transfer == 0)
					continue;
				putvar(ip->i_vtype, ontarget - transfer,
					(s_char *)&target, EF_LAND);
				ontender += transfer;
				total += transfer;
			} else {
				/* give to target from tender */
				transfer = min(ontender, amt);
				transfer = min(transfer, maxtarget - ontarget);
				if (transfer == 0)
					continue;
				putvar(ip->i_vtype, ontarget + transfer,
					(s_char *)&target, EF_LAND);
				ontender -= transfer;
				total += transfer;
			}
			expose_land(&tender, &target);
			putland(targets.cur, &target);
			if (amt > 0 && ontender == 0) {
#ifdef	SHIPNAMES
				pr(fmt("%s %s(#%d) out of %s\n",
				       mchr[tender.shp_type].m_name,
				       tender.shp_name,
#else
				pr(fmt("%s #%d out of %s\n",
				       mchr[tender.shp_type].m_name,
#endif	SHIPNAMES
				       tenders.cur, ip->i_name));
				break;
			}
		}
		pr(fmt("%d total %s transferred %s ship %d\n",
			total, ip->i_name, (amt > 0) ? "off of" : "to",
			tenders.cur));
		putvar(ip->i_vtype, ontender, (s_char *)&tender, EF_SHIP);
		tender.shp_mission = 0;
		putship(tender.shp_uid, &tender);
	}
	return RET_OK;
}

static
expose_land(s1, l1)
	struct	shpstr *s1;
	struct	lndstr *l1;
{
	if (getvar(V_PSTAGE, (s_char *)s1, EF_SHIP) == PLG_INFECT &&
	    getvar(V_PSTAGE, (s_char *)l1, EF_LAND) == PLG_HEALTHY)
		putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)l1, EF_LAND);
	if (getvar(V_PSTAGE, (s_char *)l1, EF_LAND) == PLG_INFECT &&
	    getvar(V_PSTAGE, (s_char *)s1, EF_SHIP) == PLG_HEALTHY)
		putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)s1, EF_SHIP);
}
