#ifndef lint
static char *RCSid = "$Header: bmap.c,v 1.1 89/12/14 08:20:08 jay Exp $";
#endif /* not lint */

/*
 * bmap.c
 *
 * empire bigmap: probably the second most-used command in empire.
 *
 * Dave Pare, 1986
 * With hack by Jay Phillips and Bill Frolik, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "deity.h"
#include "nat.h"
#include "map.h"
#include "ship.h"
#include "land.h"
#include "plane.h"

#if	defined(BMAP) || defined(AUTONAV)

bmap()
{
	extern	s_char getbigmap();
	extern	int aborted;
	extern	s_char *argp[];
	register s_char *ptr;
	struct	nstr_sect ns;
	struct	natstr *np;
	struct	sctstr sect;
	struct	range range;
	int	i;
	s_char	wmap[WORLD_Y][MAPWIDTH(1)];
	coord	x,y;
	s_char	what[64];
	s_char	*str, *b;
	struct	shpstr ship, origs;
	struct	lndstr land, origl;
	struct	plnstr plane, origp;
	struct	nstr_item ni;
	int	where=2, country;
	int	is_lmap = (**argp == 'l' ? 1 : 0);
	int	is_pmap = (**argp == 'p' ? 1 : 0);
	int	is_thing=0, show_plane=0, show_land=0, show_ship=0;

	country = cnum;
	np = getnatp(country);
	if(argp[1] == (s_char *) 0) {
		if ((str = getstring("(sects)? ")) == 0)
			return RET_SYN;
	}
	else {
		str = argp[1];
	}

	if(*str == '*') {
		sprintf(what, "%d:%d,%d:%d",
			-WORLD_X/2, WORLD_X/2-1,
			-WORLD_Y/2, WORLD_Y/2-1);
		if (!snxtsct(&ns, what))
			return RET_FAIL;
	}
	else
	if (!snxtsct(&ns, str)){
		i=atoi(str);
                if (is_lmap){
                	if (!getland(i, &origl) ||
                        	(origl.lnd_own != cnum && !god) ||
				(origl.lnd_own == 0))
                        	return RET_FAIL;
                	sprintf(what, "%d:%d,%d:%d",xrel(np,origl.lnd_x-10),
				xrel(np,origl.lnd_x+10),
				yrel(np,origl.lnd_y-5), yrel(np,origl.lnd_y+5));
        	}else if (is_pmap){
                	if (!getplane(i, &origp) ||
                        	(origp.pln_own != cnum && !god) || 
				(origp.pln_own == 0))
                        	return RET_FAIL;
                	sprintf(what, "%d:%d,%d:%d",xrel(np,origp.pln_x-10),
				xrel(np,origp.pln_x+10),
				yrel(np,origp.pln_y-5), yrel(np,origp.pln_y+5));
        	}else{
                	if (!getship(i, &origs) ||
                        	(origs.shp_own != cnum && !god) || 
				(origs.shp_own == 0))
                        	return RET_FAIL;
                	sprintf(what, "%d:%d,%d:%d",xrel(np,origs.shp_x-10),
				xrel(np,origs.shp_x+10),
                        	yrel(np,origs.shp_y-5), yrel(np,origs.shp_y+5));
        	}
               	if (!snxtsct(&ns, what))
                       	return RET_FAIL;
               	is_thing=1;
	}

	b = argp[2];
	while (b != (s_char *)0 && (*b)){
		where=3;
		switch(*b){
			case 's':
			case 'S':	show_ship=1; break;
			case 'l':
			case 'L':	show_land=1; break;
			case 'p':
			case 'P':	show_plane=1; break;
			case '*':	show_ship=show_plane=show_land=1;
					break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	where=2;
			default:	pr(fmt("Bad flag %c!\n",*b));
					break;
		}

		b++;
	}
	np = getnatp(cnum);
	/* zap any conditionals */
	ns.ncond = 0;
	xyrelrange(np, &ns.range, &range);
	border(&range, "     ", "");
	blankfill((s_char *)wmap, &ns.range, 1);
	while (bmnxtsct(&ns) && !aborted) {
		ptr = &wmap[ns.dy][ns.dx];
		*ptr = getbigmap(ns.x, ns.y);
	}
	if (aborted)
		return RET_OK;

	if (show_plane){
		snxtitem_all(&ni, EF_PLANE);
		while (nxtitem(&ni, (caddr_t)&plane)) {
			if (plane.pln_own == 0)
				continue;
			if (plane.pln_own != cnum && !god)
				continue;
			if (!xyinrange(plane.pln_x, plane.pln_y, &ns.range))
				continue;

			x = xnorm(plane.pln_x-ns.range.lx);
			y = ynorm(plane.pln_y-ns.range.ly);
			wmap[y][x] = (*plchr[plane.pln_type].pl_name) & ~0x20;
		}
	}
	if (show_ship){
		snxtitem_all(&ni, EF_SHIP);
		while (nxtitem(&ni, (caddr_t)&ship)) {
			if (ship.shp_own == 0)
				continue;
			if (ship.shp_own != cnum && !god)
				continue;
			if (!xyinrange(ship.shp_x, ship.shp_y, &ns.range))
				continue;

			x = xnorm(ship.shp_x-ns.range.lx);
			y = ynorm(ship.shp_y-ns.range.ly);
			wmap[y][x] = (*mchr[ship.shp_type].m_name) & ~0x20;
		}
	}
	if (show_land){
		snxtitem_all(&ni, EF_LAND);
		while (nxtitem(&ni, (caddr_t)&land)) {
			if (land.lnd_own == 0)
				continue;
			if (land.lnd_own != cnum && !god)
				continue;
			if (!xyinrange(land.lnd_x, land.lnd_y, &ns.range))
				continue;

			x = xnorm(land.lnd_x-ns.range.lx);
			y = ynorm(land.lnd_y-ns.range.ly);
			wmap[y][x] = (*lchr[land.lnd_type].l_name) & ~0x20;
		}
	}

	if (is_thing){
		if (is_lmap)
			wmap[5][10] = (*lchr[origl.lnd_type].l_name) & ~0x20;
		else if (is_pmap)
			wmap[5][10] = (*plchr[origp.pln_type].pl_name) & ~0x20;
		else
			wmap[5][10] = (*mchr[origs.shp_type].m_name) & ~0x20;
	}
	for (y=ns.range.ly, i=0; i < ns.range.height; y++, i++) {
		int yval;

		yval = yrel(np, y);
		pr(fmt("%4d %s %-4d\n", yval, wmap[i], yval));
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&range, "     ", "");
	return RET_OK;
}


/*
 * get the next sector in the range
 */
int
bmnxtsct(np)
	register struct nstr_sect *np;
{
	while (1) {
		np->dx++;
		np->x++;
		if (np->x >= WORLD_X)
			np->x = 0;
		if (np->dx >= np->range.width) {
			np->dx = 0;
			np->x = np->range.lx;
			np->dy++;
			if (np->dy >= np->range.height)
				return 0;
			np->y++;
			if (np->y >= WORLD_Y)
				np->y = 0;
		}
		if ((np->y + np->x) & 01)
			continue;
		if (np->type == NS_DIST) {
			np->curdist = mapdist(np->x, np->y, np->cx, np->cy);
			if (np->curdist > np->dist)
				continue;
		}
		np->id = sctoff(np->x, np->y);
		return 1;
	}
	/*NOTREACHED*/
}

#endif
