#ifndef lint
static char *RCSid = "$Header: best.c,v 1.1 89/12/14 08:19:39 jay Exp $";
#endif /* not lint */

/*
 * best.c
 *
 * show best path from x1,y1 to x2,y2
 *
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "xy.h"
#include "path.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "nat.h"

best()
{
	extern	s_char *argp[];
	extern	int aborted;
	register int n;
	double	cost;
	s_char	*p, *BestDistPath(), *BestLandPath(), *s;
	int	x1,y1,x2,y2;
	struct	sctstr s1, s2;
	struct	nstr_sect nstr, nstr2;
	int	dist=0;

	dist = argp[0][4] == 'd';

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;

	if (!snxtsct(&nstr2, argp[2]))
		return RET_SYN;

	while (!aborted && nxtsct(&nstr, &s1)){
		if (s1.sct_own != cnum)
			continue;
		snxtsct(&nstr2, argp[2]);
		while (!aborted && nxtsct(&nstr2, &s2)){
			if (s2.sct_own != cnum)
				continue;
			if (dist)
				s = BestDistPath(&s1,&s2,&cost);
			else
				s = BestLandPath(&s1,&s2,&cost);
			if (s != (s_char *)0)
				pr(fmt("Best %spath from %s to %s is %s (cost %1.3f)\n",
					(dist ? "dist" : ""),
					xyas(s1.sct_x,s1.sct_y,cnum),
					xyas(s2.sct_x,s2.sct_y,cnum), s, cost));
			else
				pr(fmt("No owned path from %s to %s exists!\n",
					xyas(s1.sct_x,s1.sct_y,cnum),
					xyas(s2.sct_x,s2.sct_y,cnum)));
		}
	}
	return 0;
}
