.TH Command SONAR
.SY "sonar <SHIP/FLEET>"
The sonar command allows ships to look for submarines
and submarines to look for ships.
.s3
In the current implementation, sonar works similar to 
lookout.  The major difference is that a submarines cannot use
lookout to sight ships.  Likewise, submarines cannot be sighted
by ships via lookout.
.s1
There are two aspects to sonar - passive and active sonar.
.s1
ACTIVE SONAR
.s3
This is the most visible form of sonar.  It is simply a
ship's ability to use sonar pings to detect other ships.
The range of a ship's active sonar is identical to the
range that it can sight ships via lookout.
(see \*Qinfo lookout\*U)
When you type "sonar 25", you are using active sonar.
.s1
PASSIVE SONAR
.s3
This is more subtle.  Passive sonar is a ship's ability
to hear sounds, mainly active sonar pings.  When a ship
pings you with active sonar, you can detect that ping.
If a ship with sonar gets pinged, that country receives
a telegram saying "Sonar ping from x,y detected by ship Z!"
In its current implementation, passive sonar is the ability
to detect a ping.
.s1
When a ship emits a ping, that ping has to travel out to a
target ship, reflect off of it, and then return to its source.
So, in order to detect a ship X sectors away, a sonar ping
must be able to travel 2X sectors - from the source to the
target, and back to the source.  So, if a ship can use active
sonar to detect ships X sectors away, passive sonar can detect
active sonars from 2X sectors away.  So the range at which you
can detect sonar pings is twice the range at which you can use
sonar.
.s3
The active and passive sonar modes means that you want to be
careful when you use sonar, because you will tell others where
you are long before you actually detect them.  This also gives
you some warning before you get your submarine attacked, as
enemy ships have to use sonar to find you.  The key to submarine
warfare is "run silent", meaning use your sonar only when you
have to.
.s1
On the other hand, destroyers are designed to hunt subs.  A
destroyer guarding a player's coast should use sonar often,
especially if it has other destroyers nearby to support him if
he gets in trouble.
.s3
For example:
.EX sonar 24
.NF
Groonland (#1) patrol boat #10 @-13,7
Curmudgeon (#4) heavy cruiser #36 @-14,6
Groonland (#1) oil derrick #41 @-14,6
Groonland (#1) tender #53 @-14,6
Groonland (#1) submarine #53 @-14,6
Groonland (#1) nuclear sub #53 @-14,6
.FI
.TH Concept plane-sonar
.s1
Planes with the ASW ability (if the ASW_PLANES option is enabled) can use 
sonar while on recon missions. See info recon for more details.
.s3
See also : coastwatch, ship-types, sector-types, radar, recon
