#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/resupply.c,v 1.2 89/06/27 01:33:49 griffith Exp $";
#endif

/*
 * supply.c
 *
 * supply subroutines
 *
 * This is the same as player/subs/supply.c, except that we need
 * to use getsectp here, since the sector file is in memory for the
 * update.
 */

#include "misc.h"
#include "nat.h"
#include "var.h"
#include "retreat.h"
#include "ship.h"
#include "land.h"
#include "sect.h"
#include "news.h"
#include "xy.h"
#include "nsc.h"
#include "path.h"
#include "deity.h"
#include "item.h"
#include "file.h"
#include "options.h"

/*
 * We want to get enough guns to be maxed out, enough shells to
 * 	fire once, one update's worth of food, enough fuel for
 *	one update.
 *
 * Firts, try to forage in the sector
 * Second look for a warehouse or headquarters to leech
 * Third, look for a ship we own in a harbor
 * Fourth, look for supplies in a supply unit we own
 * 		(one good reason to do this last is that the supply
 * 		 unit will then call resupply, taking more time)
 *
 */
supply(lp)
{
}

/*
 *
 * Get the Empire RDA for units :-)
 * May want to put code to resupply with SAMs here, later --ts
 *
 */

resupply_all(lp)
struct lndstr *lp;
{
#ifndef NOFOOD
	resupply_commod(lp,I_FOOD);
#endif /* NOFOOD */
	resupply_commod(lp,I_SHELL);
	resupply_commod(lp,I_PETROL);
}

/*
 * If the unit has less than it's minimum level of a
 * certain commodity, fill it, to the best of our abilities.
 */

resupply_commod(lp, type)
struct	lndstr *lp;
int	type;
{
	int	vec[I_MAX+1];

	getvec(VT_ITEM, vec, (s_char *)lp, EF_LAND);
	if (vec[type] < get_minimum(lp,type)){
		vec[type] += supply_commod(lp->lnd_x,lp->lnd_y,type,
			get_minimum(lp,type)-vec[type]);
		putvec(VT_ITEM, vec, (s_char *)lp, EF_LAND);
	}
}

/*
 * Actually get the commod
 */
supply_commod(x, y, type,total_wanted)
int x, y, type, total_wanted;
{
	if (total_wanted < 0)
		return 0;

	return s_commod(x, y, type,total_wanted,1);
}

/*
 * Just return the number you COULD get, without doing it
 */
try_supply_commod(x, y, type,total_wanted)
int x, y, type, total_wanted;
{
	if (total_wanted < 0)
		return 0;

	return s_commod(x, y, type,total_wanted,0);
}

/* Get supplies of a certain type */
s_commod(x, y, type,total_wanted,actually_doit)
int x, y, type, total_wanted,actually_doit;
{
	int	wanted=total_wanted;
	int	gotten=0, lookrange;
	struct	sctstr *sectp, *nxtsctp(), *destp;
	int	vec[I_MAX+1];
	struct	nstr_sect ns;
	struct	nstr_item ni;
	struct	lchrstr *lcp;
	struct	shpstr *sp;
	struct	lndstr *lp;
	/* leave at least 1 military in sectors/ships */
	int	minimum=(type == I_MILIT ? 1 : 0);
	int	can_move;
	double	supply_mob(), tfact(), move_cost, weight, mobcost;
	s_char	*BestLandPath();
	s_char	*itemname(), *nxtitemp();
	int	own, packing;
	extern  double eatrate;
	extern  int etu_per_update;
	extern	float land_mob_scale;
	struct	dchrstr *dp;
	struct	ichrstr *ip;

	/* try to get it from sector we're in */
	sectp=getsectp(x,y);
	destp=getsectp(x,y);
	own = sectp->sct_own;

	getvec(VT_ITEM, vec, (s_char *)sectp, EF_SECTOR);
	if ((vec[type]-minimum) >= wanted){
		vec[type] -= wanted;

		if (actually_doit){
			putvec(VT_ITEM, vec, (s_char *)sectp, EF_SECTOR);
		}
		return total_wanted;
	}else if ((vec[type]-minimum) > 0){
		gotten += (vec[type]-minimum);
		wanted -= (vec[type]-minimum);

		vec[type] = minimum;
		if (actually_doit){
			putvec(VT_ITEM, vec, (s_char *)sectp, EF_SECTOR);
		}
	}

	/* look for a headquarters or warehouse */
	lookrange = tfact(own,(double)10.0);
	snxtsct_dist(&ns, x, y, lookrange);

	while ((sectp=nxtsctp(&ns)) && wanted){
		if (sectp->sct_own != own)
			continue;

		if ((sectp->sct_type != SCT_WAREH) &&
			(sectp->sct_type != SCT_HEADQ))
			continue;

		if ((sectp->sct_type == SCT_HEADQ) &&
			(sectp->sct_dist_x == sectp->sct_x) &&
			(sectp->sct_dist_y == sectp->sct_y))
			continue;

		if (BestLandPath(destp,sectp,&move_cost) == (s_char *)0)
			continue;

		getvec(VT_ITEM, vec, (s_char *)sectp, EF_SECTOR);
#ifndef NOFOOD
		if (type == I_FOOD)
			minimum=((etu_per_update * eatrate) *
				(vec[I_CIVIL]+vec[I_MILIT]+vec[I_UW]));
#endif /* NOFOOD */

		ip = &ichr[type];
		dp = &dchr[sectp->sct_type];
		packing = ip->i_pkg[dp->d_pkg];
		if (packing > 1 && sectp->sct_effic < 60)
			packing = 1;
		weight = ((double)ip->i_lbs / (double)packing);
		mobcost = move_cost * weight;
		can_move = ((double)sectp->sct_mobil / mobcost);

		if (can_move > (vec[type]-minimum))
			can_move = (vec[type]-minimum);

		if (can_move >= wanted){
			vec[type] -= wanted;

			if (actually_doit){
				/* take off mobility for delivering sect */
				sectp->sct_mobil -= roundavg(supply_mob(type,
					total_wanted,weight,move_cost));
				putvec(VT_ITEM, vec, (s_char *)sectp, EF_SECTOR);
			}

			return total_wanted;
		}else if (can_move > 0){
			gotten += can_move;
			wanted -= can_move;
			vec[type] -= can_move;

			if (actually_doit){
				/* take off mobility for delivering sect */
				sectp->sct_mobil -= roundavg(supply_mob(type,
					can_move,weight,move_cost));

				putvec(VT_ITEM, vec, (s_char *)sectp, EF_SECTOR);
			}
		}
	}

	/* look for an owned ship in a harbor */
	snxtitem_dist(&ni, EF_SHIP, x, y, lookrange);

	while ((sp=(struct shpstr *)nxtitemp(&ni)) && wanted){
		if (sp->shp_own != own)
			continue;

		sectp=getsectp(sp->shp_x,sp->shp_y);

		if (sectp->sct_type != SCT_HARBR)
			continue;

		if (sectp->sct_effic < 2)
			continue;

		if (BestLandPath(destp,sectp,&move_cost) == (s_char *)0)
			continue;

		getvec(VT_ITEM, vec, (s_char *)sp, EF_SHIP);
#ifndef NOFOOD
		if (type == I_FOOD)
			minimum=((etu_per_update * eatrate) *
				(vec[I_CIVIL]+vec[I_MILIT]+vec[I_UW]));
#endif /* NOFOOD */
		
		ip = &ichr[type];
		dp = &dchr[sectp->sct_type];
		packing = ip->i_pkg[dp->d_pkg];
		if (packing > 1 && sectp->sct_effic < 60)
			packing = 1;
		weight = ((double)ip->i_lbs / (double)packing);
		mobcost = move_cost * weight;
		can_move = ((double)sectp->sct_mobil / mobcost);

		if (can_move > (vec[type]-minimum))
			can_move = (vec[type]-minimum);

		if (can_move >= wanted){
			vec[type] -= wanted;

			if (actually_doit){
				sectp->sct_mobil -= roundavg(supply_mob(type,
					wanted,weight,move_cost));
				putvec(VT_ITEM, vec, (s_char *)sp, EF_SHIP);
			}
			return total_wanted;
		}else if (can_move > 0){
			gotten += can_move;
			wanted -= can_move;
			vec[type] -= can_move;

			if (actually_doit){
				sectp->sct_mobil -= roundavg(supply_mob(type,
					can_move,weight,move_cost));

				putvec(VT_ITEM, vec, (s_char *)sp, EF_SHIP);
			}
		}
	}

	/* look for an owned supply unit */
	snxtitem_dist(&ni, EF_LAND, x, y, lookrange);

	while ((lp=(struct lndstr *)nxtitemp(&ni)) && wanted){
		int	min;

		if (lp->lnd_own != own)
			continue;

		lcp = &lchr[lp->lnd_type];
		if (!(lcp->l_flags & L_SUPPLY))
			continue;

		if (at_minimum(lp,type))
			continue;

		sectp = getsectp(lp->lnd_x,lp->lnd_y);
		if (BestLandPath(destp,sectp,&move_cost) == (s_char *)0)
			continue;

		if ((lp->lnd_ship >= 0) && (sectp->sct_type != SCT_HARBR))
			continue;

		if ((lp->lnd_ship >= 0) && (sectp->sct_effic < 2))
			continue;

		getvec(VT_ITEM, vec, (s_char *)lp, EF_LAND);
		ip = &ichr[type];
		weight = ((double)ip->i_lbs);
		mobcost = move_cost * weight;
		can_move = ((double)lp->lnd_mobil / mobcost);
		min = get_minimum(lp,type);
		if (can_move > (vec[type]-min))
			can_move = (vec[type]-min);

		if (can_move >= wanted){
			vec[type] -= wanted;

			/* resupply the supply unit */
			resupply_commod(lp, type);

			lp->lnd_mobil -= roundavg(supply_mob(type,
				wanted,weight,move_cost));

			if (actually_doit){
				putvec(VT_ITEM, vec, (s_char *)lp, EF_LAND);
			}
			return total_wanted;
		}else if (can_move > 0){
			gotten += can_move;
			wanted -= can_move;
			vec[type] -= can_move;

			lp->lnd_mobil -= roundavg(supply_mob(type,
				can_move,weight,move_cost));

			if (actually_doit){
				putvec(VT_ITEM, vec, (s_char *)lp, EF_LAND);
			}
		}
	}

	/* We've done the best we could */
	/* return the number gotten */
	return gotten;
}


s_char *
itemname(type)
int	type;
{
	register int t;
	register s_char *p;
	register struct ichrstr *ip;

	t=V_ITEM(type);
	for (ip = &ichr[1]; ip->i_mnem != 0; ip++) {
		if (t == ip->i_vtype)
			return ip->i_name;
	}
	return 0;
}

at_minimum(lp,type)
struct	lndstr *lp;
int	type;
{
	int	vec[I_MAX+1];

	getvec(VT_ITEM, vec, (s_char *)lp, EF_LAND);
	if (vec[type] <= get_minimum(lp,type))
		return 1;

	return 0;
}

/*
 * We want to get enough shells to fire once,
 * one update's worth of food, enough fuel for
 * one update.
 */

get_minimum(lp,type)
struct	lndstr *lp;
int	type;
{
	struct	lchrstr *lcp;
	int	max, want=0;
	extern	double eatrate;
	extern	int etu_per_update;
	extern	float land_mob_scale;

	lcp = &lchr[lp->lnd_type];
	max = vl_find(V_ITEM(type), lcp->l_vtype, lcp->l_vamt, (int) lcp->l_nv);

	switch (type){
#ifndef NOFOOD
		case I_FOOD:	want = (etu_per_update * eatrate) *
				   lcp->l_mil * ((float)lp->lnd_effic/100.0)+1;
				break;
#endif /* NOFOOD */
		case I_SHELL:	want = lcp->l_ammo;
				break;
		case I_PETROL:	want = (lcp->l_fuelu * ((float)
					((float)etu_per_update *
					land_mob_scale))/10.0);
				break;
		default:	return 1;
	}

	if (want > max)
		want = max;

	return want;
}

double
supply_mob(type,amount,weight,move_cost)
int	type, amount;
double	weight, move_cost;
{
	register int t=V_ITEM(type);
	register s_char *p;
	register struct ichrstr *ip;

	for (ip = &ichr[1]; ip->i_mnem != 0; ip++) {
		if (t == ip->i_vtype)
			return ((double)amount*weight*move_cost);
	}
	return 0;
}
