#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/update/RCS/plane.c,v 1.9 89/09/18 00:55:40 mr-frog Exp $";
#endif

/*
 * plane.c
 *
 * do "production" for planes -- make more efficient,
 * charge for military, etc.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "plane.h"
#include "ship.h"
#include "nat.h"
#include "file.h"

#define MIN(x,y)        (x > y ? y : x)

#ifdef BUDGET
int
prod_plane(etus,natnum,buildem)
	int	etus;
	int	natnum;
	int	buildem; /* Build = 1, maintain =0 */
#else
int
prod_plane(etus)
	int	etus;
#endif /* BUDGET */
{
	extern	double money_mil;
	extern	double money_plane;
	extern	int plane_grow_scale;
	extern	long money[MAXNOC];
	extern	long air_money[MAXNOC];
	register struct plnstr *pp;
	register struct plchrstr *plp;
	struct	natstr *np;
	float	leftp, buildp;
	int	left, build;
	int	lcm,hcm,keeplcm,keephcm,lcm_needed,hcm_needed;
	int	mil,keepmil,mil_needed;
	int	svec[I_MAX+1];
	int	n;
	struct	shpstr *shp;
	struct	mchrstr *mp;
	struct	plchrstr *desc;
	struct  sctstr *sp;
	int	delta;
	int	mult;
	int	eff;
	int	avail;
	int	w_p_eff;
	int	used;
	int     start_money, onship=0;

	for (n=0; pp = getplanep(n); n++) {
		if (pp->pln_own == 0)
			continue;
#ifdef BUDGET
		if (pp->pln_own != natnum)
			continue;
#endif /* BUDGET */
		if (pp->pln_effic < PLANE_MINEFF) {
			pp->pln_own = 0;
			continue;
		}
		onship = shp = 0;
		plp = &plchr[pp->pln_type];
		if (pp->pln_ship >= 0) {
			onship = 1;
			shp = getshipp(pp->pln_ship);
			if (shp == 0 || shp->shp_own != pp->pln_own) {
				if (--shp->shp_nplane < 0)
					shp->shp_nplane = 0;
				pp->pln_own = 0;
				continue;
			}
			mp = &mchr[shp->shp_type];
#if !defined (XLIGHT) && !defined (SHIPCHOPPERS)
			if ((plp->pl_flags & P_M) && !(mp->m_flags & M_MSL)) {
				if (--shp->shp_nplane < 0)
					shp->shp_nplane = 0;
				pp->pln_own = 0;
				continue;
			}
			if (!(plp->pl_flags & P_M) && !(mp->m_flags & M_FLY)) {
				if (--shp->shp_nplane < 0)
					shp->shp_nplane = 0;
				pp->pln_own = 0;
				continue;
			}
#endif
		}
		np = getnatp(pp->pln_own);
		desc = &plchr[pp->pln_type];
		sp = getsectp(pp->pln_x, pp->pln_y);
		getvec(VT_ITEM, svec, (s_char *)sp, EF_SECTOR);
		mult=1;
		if (np->nat_level[NAT_TLEV] < pp->pln_tech * 0.85)
			mult = 2;
#ifdef BUDGET
if (buildem == 0){
#endif /* BUDGET */
#ifdef	ORBIT
		if ((plp->pl_flags & P_O) && (pp->pln_flags & PLN_LAUNCHED) &&
		    !(plp->pl_flags & P_M) &&
		    !(pp->pln_flags & PLN_SYNCHRONOUS))
			move_sat(pp);
#endif	ORBIT
		/* flight pay is 5x the pay received by other military */
		start_money = np->nat_money;
		np->nat_money += (int) (etus * (plp->pl_crew * money_mil * 5));
		if (money[pp->pln_own] < 0) {
			delta = random() % (etus/2);
			eff = pp->pln_effic - delta;
			if (eff < 0)
				eff = 0;
			pp->pln_effic = eff;
			if (pp->pln_effic < PLANE_MINEFF) {
				wu(0, pp->pln_own,
				    fmt("%s #%d lost to lack of maintenance\n",
				    desc->pl_name, n));
				pp->pln_own = 0;
#ifdef NPLANES
				if (pp->pln_ship >= 0){
					shp = getshipp(pp->pln_ship);
					shp->shp_nplanes--;
				}
#endif /* NPLANES */
			}
			air_money[pp->pln_own] += np->nat_money - start_money;
			continue;
		}
		np->nat_money += (int) (mult * etus *
			dmin(0.0, desc->pl_cost * money_plane));
		air_money[pp->pln_own] += np->nat_money - start_money;
		if ((pp->pln_flags & PLN_LAUNCHED) == PLN_LAUNCHED)
			continue;
#ifdef BUDGET
}else{
		if (money[pp->pln_own] <= 0)
			continue;
		if (np->nat_priorities[PRI_PBUILD] == 0)
			continue;
#endif /* BUDGET */
		start_money = np->nat_money;
		left = 100 - pp->pln_effic;
		if (left <= 0)
			continue;
		avail = sp->sct_avail * 100;
#ifdef CARRIER_WORK
		if (pp->pln_ship >= 0) {
			int     vec[I_MAX+1];
			shp = getshipp(pp->pln_ship);
			getvec(VT_ITEM, vec, (s_char *)shp, EF_SHIP);
			avail += (etus * vec[I_MILIT]/2);
		}
#endif /* CARRIER_WORK */
		w_p_eff = 20 + (desc->pl_lcm + 2 * desc->pl_hcm);
		delta = roundavg((double)avail/w_p_eff);
		if (delta <= 0)
			continue;
		if (delta > etus*plane_grow_scale)
			delta = etus*plane_grow_scale;
		if (delta > left)
			delta = left;

		/* delta is the max amount we can grow */

        	left = 100 - pp->pln_effic;
		if (left > delta)
			left = delta;

        	leftp = ((float)left/100.0);
        	mil_needed = ldround((double)(plp->pl_crew * leftp),1);
        	lcm_needed = ldround((double)(plp->pl_lcm * leftp),1);
        	hcm_needed = ldround((double)(plp->pl_hcm * leftp),1);

#ifdef GRAB_THINGS
		/* try_supply_commod will get from this sect first, then look
	 	* elsewhere until it finds what it needs. It'll return the
	 	* number of mil/lcm/hcm/etc it finds available without
	 	* actually getting it
	 	*/

		mil = try_supply_commod(sp->sct_x,sp->sct_y,I_MILIT,mil_needed);
		lcm = try_supply_commod(sp->sct_x,sp->sct_y,I_LCM,lcm_needed);
		hcm = try_supply_commod(sp->sct_x,sp->sct_y,I_HCM,hcm_needed);
#else
		mil = svec[I_MILIT];
		lcm = svec[I_LCM];
		hcm = svec[I_HCM];
#endif /* GRAB_THINGS */

        	if (mil>=mil_needed)
                	buildp=leftp;
        	else
                	buildp=((float)mil/(float)plp->pl_crew);

        	if (lcm < lcm_needed)
                	buildp = MIN(buildp,((float)lcm/(float)plp->pl_lcm));

        	if (hcm < hcm_needed)
                	buildp = MIN(buildp,((float)hcm/(float)plp->pl_hcm));

		build=ldround((double)(buildp*100.0),1);

        	mil_needed = roundavg((double)(plp->pl_crew * buildp));
        	lcm_needed = roundavg((double)(plp->pl_lcm * buildp));
        	hcm_needed = roundavg((double)(plp->pl_hcm * buildp));

#ifdef GRAB_THINGS
		/*
	 	* Now that we know how much we can actually use, get it.
	 	* supply_commod will actually subtract the commod off the
	 	* sector/ship/supply unit
	 	*/

		mil = hcm = lcm = 0;
		mil += supply_commod(sp->sct_x,sp->sct_y,I_MILIT,mil_needed);
		lcm += supply_commod(sp->sct_x,sp->sct_y,I_LCM,lcm_needed);
		hcm += supply_commod(sp->sct_x,sp->sct_y,I_HCM,hcm_needed);

		/*
	 	* get the sect again, so we don't
	 	* overwrite it if supply_commod changed it
	 	*/
		sp = getsectp(pp->pln_x, pp->pln_y);
#else
		if ((svec[I_MILIT] - mil_needed) < 0)
			svec[I_MILIT] = 0;
		else
			svec[I_MILIT] -= mil_needed;

		if ((svec[I_LCM] - lcm_needed) < 0)
			svec[I_LCM] = 0;
		else
			svec[I_LCM] -= lcm_needed;

		if ((svec[I_HCM] - hcm_needed) < 0)
			svec[I_HCM] = 0;
		else
			svec[I_HCM] -= hcm_needed;

		putvec(VT_ITEM, svec, (s_char *)sp, EF_SECTOR);
#endif /* GRAB_THINGS */

		if (onship) build = delta;
		used = build * w_p_eff;

		/*
		 * I didn't use roundavg here, because I want to penalize
		 * the player with a large number of planes.
		 */
		avail = (sp->sct_avail * 100 - used) / 100;
		if (avail < 0)
			avail = 0;
		sp->sct_avail = avail;
		if (sp->sct_type != SCT_AIRPT)
			build /= 3;
		if (onship){
			if ((pp->pln_effic + build) > 80)
				build = 80- pp ->pln_effic;
		}
		np->nat_money -= roundavg(mult * build * desc->pl_cost / 100.0);
		air_money[pp->pln_own] += np->nat_money - start_money;
		pp->pln_effic += build;
#ifdef BUDGET
}
#endif /* BUDGET */
	}
}
