#ifndef lint
static char *RCSid = "$Header: distribute.c,v 1.5 89/09/28 01:56:18 mr-frog Exp $";
#endif

/*
 * distribute.c
 *
 * do distribution sector stuff.  
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "item.h"
#include "xy.h"
#include "path.h"
#include "file.h"
#include "distribute.h"

dodistribute(sp, local, imex)
	register struct sctstr *sp;
	register int *local;
	register int imex; /* import or export? */
{
	struct	sctstr *getdistsp();
	float	distpathcost();
	register struct ichrstr *ip;
	register struct sctstr *dist;
	int	amt;
	int	thresh;
	int	amt_dist;
	int	amt_sect;
	float	pathcost;
	int	packing;
	float	imcost;
	float	excost;
	int	dist_packing;
	int	diff;
	int	item;
	int	dists[I_MAX+1];
	int	remote[I_MAX+1];
	int	changed;
	s_char	*path;
	s_char	*BestDistPath();
	double	dist_i_cost;
	double	dist_e_cost;
	double	weight;
	int	dam;

	if ((sp->sct_dist_x == sp->sct_x) && (sp->sct_dist_y == sp->sct_y))
		return 0;

	if (getvec(VT_DIST, dists, (s_char *)sp, EF_SECTOR) <= 0)
		return 0;

	dist = getsectp(sp->sct_dist_x,sp->sct_dist_y);
	path = BestDistPath(dist,sp,&dist_i_cost);
	path = BestDistPath(sp,dist,&dist_e_cost);
	if (path == (s_char *)0){
		if (sp->sct_own != 0) {
			if (imex == EXPORT) /* only want this once */
			wu(0, sp->sct_own, fmt("No path to dist sector for %s\n",
				ownxy(sp)));
		}
		return 0;
	}

	if (dist->sct_effic >= 60)
		dist_packing = dchr[dist->sct_type].d_pkg;
	else
		dist_packing = NPKG; /* No packing */
	
	if (sp->sct_effic >= 60)
		packing = dchr[sp->sct_type].d_pkg;
	else
		packing = NPKG; /* No packing */

	if ((dist->sct_effic >= 60) && (dist->sct_type == SCT_WAREH))
		packing = dchr[dist->sct_type].d_pkg;

	getvec(VT_ITEM, remote, (s_char *)dist, EF_SECTOR);
	changed = 0;
	for (item = 1; item < I_MAX+1; item++) {
		if (dists[item] == 0)
			continue;
		ip = &ichr[item];
		thresh = dists[item];
		/*
		 * calculate costs for importing and exporting.
		 * the div 4.0 is because delivering straight through
		 * to the dist sect is cheaper than stopping at each
		 * sector along the way (processor-timewise)
		 */
		excost = (dist_e_cost/ip->i_pkg[packing] * ip->i_lbs) / 4.0;
		imcost = (dist_i_cost/ip->i_pkg[dist_packing] * ip->i_lbs)/4.0;
		amt_sect = local[item];
		amt_dist = remote[item];
		diff = amt_sect - thresh;
		if (diff < 0){
			if (imex != IMPORT)
				continue;
			diff = -diff;
			/*
			 * import.
			 * don't import if no mobility.
			 * check to make sure have enough mobility in the
			 * dist sector to import what we need.
			 */
			if (dist->sct_mobil <= 0) {
				/*logerror("  dist mobil < 0");*/
				continue;
			}
			amt = diff;
			if (item == I_CIVIL)
				amt_dist--;	/* Don't send your last civ */

			if (amt_dist < amt) {
				amt = amt_dist;
				if (amt_dist == 0)
					continue;
			}
			if (dist->sct_mobil < imcost * amt)
				amt = dist->sct_mobil / imcost;

			/* XXX replace with vector assign and putvec() */
			remote[item] -= amt;
			changed++;
			dist->sct_mobil -= (int) (imcost * amt);
			local[item] += amt;
		} else {
			if (imex != EXPORT)
				continue;
			if ((item == I_CIVIL)&&(sp->sct_work < 100))
				continue;
			if ((item == I_CIVIL)&&(sp->sct_own != sp->sct_oldown))
				continue;
			/*
			 * export.
			 * don't export if no mobility. check to make sure we
			 * have mobility enough to do the right thing.
			 * also make sure that there's enough space in the
			 * target sector to hold the required amt.
			 */
			if (sp->sct_mobil <= 0) {
				/*logerror("  sp mob is zero");*/
				continue;
			}
			amt = diff;
			if (amt > amt_sect)
				amt = amt_sect;
			if (sp->sct_mobil < excost * amt)
				amt = sp->sct_mobil / excost;
			if (amt + amt_dist > 9999)
				amt = 9999 - amt_dist;
			if (amt == 0)
				continue;
			/* XXX replace with vector assign and putvec() */

			local[item] -= amt;
			changed++;
			sp->sct_mobil -= (int) (excost * amt);
			remote[item] += amt;
		}
	}
	putvec(VT_ITEM, remote, (s_char *)dist, EF_SECTOR);
	return changed;
}
