#ifndef lint
static char *RCSid = "$Header: move.c,v 1.11 89/09/28 01:32:29 mr-frog Exp $";
#endif

/*
 * move.c
 *
 * Move something somewhere.  Has a weight,
 * returns move cost, and fills a result parameter
 * with the destination sector.
 *
 *
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "file.h"
#include "deity.h"
#include "xy.h"
#include "path.h"
#include "nat.h"
#ifdef MOVEMAP
#include "map.h"
#include "nsc.h"

extern int move_map();
#endif /* MOVEMAP */

int
move_ground(what, start, end, mobility, weight, path, map, exploring, dam)
	s_char	*what;
	struct	sctstr *start;
	struct	sctstr *end;	/* RESULT */
	double	mobility;
	double	weight;
	s_char	*path;
	int	(*map)();
	int	exploring, *dam;
{
	struct	sctstr sect, ending_sect;
	struct	sctstr next, dsect;
	struct	nstr_sect ns;
	int	vec[I_MAX+1];
	coord	curx, cury, oldx, oldy;
	coord	tmpx, tmpy;
	coord	dx, dy;
	s_char	*movstr, *BestLandPath();
	double	sect_mcost;
	double	total_mcost;
	double	detonate, mv_cost;
	int	dir;
	int	intcost;
	int	mines, d, takedam = (*dam);

	*dam = 0;

        if (path && sarg_xy(path, &dx, &dy) && getsect(dx,dy,&ending_sect)){
		pr(fmt("Looking for best path to %s\n",path));
		path=BestLandPath(start,&ending_sect,&total_mcost);
		if (exploring && (path != (s_char *)0)) /* take off the 'h' */
			*(path+strlen(path)-1) = '\0';
		if (path == (s_char *)0)
			pr("No owned path exists!\n");
		else
			pr(fmt("Using best path '%s', movement cost %1.3f\n",
				path,total_mcost));
		if ((total_mcost*weight) > mobility){
			pr("Not enough mobility to go all the way. Nothing moved.\n");
			*end = *start;
			return 0;
		}
	}
	
	movstr = path;
	tmpx = start->sct_x;
	curx = tmpx;
	tmpy = start->sct_y;
	cury = tmpy;
	total_mcost = 0.0;
	if (getsect(curx, cury, &sect) < 0) {
		logerror("move_path: getsect %d,%d", curx, cury);
		return -1;
	}
	for (;;) {
		tmpx = curx;
		tmpy = cury;
		oldx = curx;
		oldy = cury;
		if (movstr == 0 || *movstr == 0) {
#ifdef MOVEMAP
                        if (exploring) {
                                map(what, curx, cury, (s_char *)0); }
                        else {
                                move_map(what, curx, cury, (s_char *)0); }
#else
			if (exploring)
				map(what, curx, cury, (s_char *)0);
#endif /* MOVEMAP */
			movstr = getstring(fmt("<%.1f: %c %s> ", mobility,
				dchr[sect.sct_type].d_mnem,
				xyas(sect.sct_x, sect.sct_y, cnum)));
		}
		if (movstr && sarg_xy(movstr, &dx, &dy)){
			if (getsect(dx,dy,&dsect)){
				movstr=BestLandPath(&sect,&dsect,&mv_cost);
			}else{
				pr("Invalid destination sector!\n");
				movstr=(s_char *)0;
			}

			if (movstr == (s_char *)0){
				pr(fmt("Can't get to %s from here!\n",
					xyas(dx,dy,cnum)));
				movstr=(s_char *)0;
			}
			if ((mv_cost*weight) > mobility){
				pr("Not enough mobility to go all the way. Nothing moved.\n");
				movstr = (s_char *)0;
			}else
				pr(fmt("Using best path '%s', movement cost %1.3f\n",
					movstr,mv_cost));
		}
		if (movstr == 0 || *movstr == 0)
			movstr = dirch;
		if ((dir = chkdir(*movstr, DIR_STOP, DIR_MAP)) < 0) {
			pr(fmt("\"%c\" is not legal...", *movstr));
			direrr("'%c' to stop ", "'%c' to view ",
				"& '%c' to map\n");
			*movstr = 0;
			continue;
		}
		movstr++;
		if (dir == DIR_MAP) {
			if (!exploring)
				map(what, curx, cury, movstr+1);
			*movstr = 0;
			continue;
		} else if (dir == DIR_STOP)
			break;
		else if (dir == DIR_VIEW) {
			pr(fmt("%d%% %s with %d civilians.\n", sect.sct_effic,
				dchr[sect.sct_type].d_name,
				getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR)));
			continue;
		}
		/*
		 * now see if we can move into the
		 * next sector.  Mobility, terrain,
		 * or ownership may prevent us.
		 */
		tmpx += diroff[dir][0];
		tmpy += diroff[dir][1];
		if (getsect(tmpx, tmpy, &next) < 0) {
			pr("You can't go there...\n");
			*movstr = 0;
			continue;
		}
		if (!god) {
			if ((next.sct_type == SCT_SANCT) &&
						       (next.sct_own != cnum)) {
				pr("Converts, huh?\n");
				*end = next;
				intcost = (int) total_mcost;
				if (chance(total_mcost - intcost))
					intcost++;
				return intcost;
			}
			getvec(VT_ITEM, vec, (s_char *)&next, EF_SECTOR);
			sect_mcost = sector_mcost(next.sct_type,next.sct_effic);
			if ((!owner && (!exploring || 
			    (vec[I_MILIT] || vec[I_CIVIL]))) ||
			    sect_mcost == -1.0) {
				/* already-owned, or prohibited terrain */
				pr("You can't go there...\n");
				*movstr = 0;
				continue;
			}
			sect_mcost *= weight;
			if (sect_mcost > mobility) {
				pr("Not enough mobility.  ");
				pr("You can't go there...\n");
				*movstr = 0;
				continue;
			}
			mobility -= sect_mcost;
			total_mcost += sect_mcost;
		}
		curx = tmpx;
		cury = tmpy;
		sect = next;
		mines = getvar(V_MINE, (s_char *)&sect, EF_SECTOR);
		/* Only detonate if it's worth it */
		detonate = ((double)weight/100.0);
		if (takedam && mines > 0 && (sect.sct_oldown != cnum) &&
			chance(0.05 * mines) && chance(detonate)) {
			pr(fmt("\007Kawhomp! Landmines detected! in %s\n",
				xyas(sect.sct_x,sect.sct_y,cnum)));

			d = roll(20);
			(*dam) += d;
			mines--;
			putvar(V_MINE, mines, (s_char *)&sect, EF_SECTOR);
			putsect(&sect);
			pr(fmt("%d%% damage sustained.\n", d));
		}

		/*
		 * Check and see if anyone will interdict us
		 */
		if (takedam && chance(detonate) &&
			((curx != oldx) || (cury != oldy)))
			(*dam) += interdict(curx,cury,cnum,"commodities");
	}
	*end = sect;
	intcost = (int) total_mcost;
	if (intcost < 0)
		return -1;
	if (chance(total_mcost - intcost))
		intcost++;
	return intcost;
}


#ifdef MOVEMAP
/*ARGSUSED*/
int
move_map(what, curx, cury, arg)
        s_char    *what;
        coord   curx, cury;
        s_char    *arg;
{
        struct  nstr_sect ns;
        struct  natstr *np;
        struct  sctstr sect;
        coord   rel_x, rel_y;
        s_char    *range;
        s_char    view[7];
        int     i;
        int     vec[I_MAX+1];
 
        np = getnatp(cnum);
        rel_x = xrel(np, curx);
        rel_y = yrel(np, cury);
        range = fmt("%d:%d,%d:%d", rel_x-2, rel_x+2, rel_y-1, rel_y+1);
        if (!snxtsct(&ns, range))
                return RET_FAIL;

	ns.ncond = 0;
	/* This is necessary, otherwise move_map would attempt to pay */
	/* attention to the conditional arguments left behind by such */
	/* a command as "tran p -1,-1 ?eff=100".. It'd then only see  */
	/* 100% efficienct sects, and get all screwed up         --ts */

        i = 0;
        while (i < 7 && nxtsct(&ns, &sect)) {
                view[i] = dchr[sect.sct_type].d_mnem;
                switch (sect.sct_type) {
                case SCT_WATER:
                case SCT_RURAL:
                case SCT_MOUNT:
                case SCT_WASTE:
                        break;
                default:
                        if (sect.sct_own != cnum && !god)
                                view[i] = '?';
                        break;
                }
#if   defined(BMAP) || defined(AUTONAV)
                setbigmap(ns.x, ns.y, view[i]);
#endif
                i++;
        }
#if   defined(BMAP) || defined(AUTONAV)
        writebigmap();
#endif
        if (!getsect(curx, cury, &sect))
                return RET_FAIL;
        getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
        pr(fmt("    %c %c      eff   mob   civ  mil   uw food  work  avail\n",
                view[0], view[1]));
        pr(fmt("   %c %c %c     %3d   %3d  %4d %4d %4d %4d   %3d   %3d\n",
                view[2], view[3], view[4],
                sect.sct_effic, sect.sct_mobil, vec[I_CIVIL],vec[I_MILIT],
          vec[I_UW],vec[I_FOOD], sect.sct_work, sect.sct_avail));
        pr(fmt("    %c %c\n", view[5], view[6]));
        return RET_OK;
}
#endif
