#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/mission.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * mission.c
 *
 * mission subroutines for planes/ships/units
 *
 */

#include "options.h"
#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "retreat.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "path.h"
#include "mission.h"
#include "genitem.h"
#include "nuke.h"
#include "news.h"
#include "item.h"

struct airport{
	struct	qelem queue;
	coord	x,y;
	natid	own;
};

/*
 * Check to see if anyone hostile to the actor
 * is running an interdiction mission on this
 * sector. If so, return damage done.
 */
interdict(x,y,actor,s)
int     x,y,actor;
s_char	*s;
{
	struct	qelem list;
	int	dam=0,cn, newdam;
	extern	int ismission;

	for(cn=0;cn<MAXNOC;cn++){
		initque(&list);
		build_mission_list(x,y,actor,cn,&list,MI_INTERDICT);

		if (QEMPTY(&list))
			continue;

		ismission = 1;
		newdam = perform_mission(x,y,actor,&list,MI_INTERDICT,s);
		dam += newdam;
		ismission = 0;
		if (newdam)
			pr(fmt("%s interdiction mission does %d damage!\n",
				cname(cn), newdam));
	}
	return dam;
}

/*
 *  Interdict subs
 * 
 */
sub_interdict(x,y,actor,s)
int     x,y,actor;
s_char	*s;
{
	struct	qelem list;
	int	dam=0,cn, newdam;
	extern	int ismission;

	for(cn=0;cn<MAXNOC;cn++){
		initque(&list);
		build_mission_list(x,y,actor,cn,&list,MI_SINTERDICT);

		if (QEMPTY(&list))
			continue;

		ismission = 1;
		newdam = perform_mission(x,y,actor,&list,MI_SINTERDICT,s);
		dam += newdam;
		ismission = 0;
		if (newdam)
			pr(fmt("%s sub interdiction mission does %d damage!\n",
				cname(cn), newdam));
	}
	return dam;
}

/*
 *  Perform a mission against actor, on behalf of actee
 */
support(x,y,actor,actee)
int     x,y,actor,actee;
{
	struct	qelem list;
	int	dam=0, cn, rel;
	extern	int ismission;

	for(cn=0;cn<MAXNOC;cn++){
		rel = getrel(getnatp(cn),actee);
		if ((cn != actee) && (rel != ALLIED))
			continue;
		initque(&list);
		build_mission_list(x,y,actor,cn,&list,MI_SUPPORT);
	
		if (QEMPTY(&list))
			continue;
	
		ismission = 1;
		dam += perform_mission(x,y,actor,&list,MI_SUPPORT,"");
		ismission = 0;
	}
	return dam;
}

struct genlist {
	struct qelem queue;	/* list of units */
	int type;		/* type of unit */
	int x,y;		/* x,y it came from */
	s_char *cp;		/* pointer to desc of thing */
	s_char *thing;		/* thing's struct */
};

build_mission_list(x,y,actor,cn,list,mission)
int	x,y,actor;
int	cn;
struct	qelem *list;
int	mission;
{
	build_mission_list_type(x,y,actor,cn,list,mission,EF_LAND);
	build_mission_list_type(x,y,actor,cn,list,mission,EF_SHIP);
	build_mission_list_type(x,y,actor,cn,list,mission,EF_PLANE);
}

build_mission_list_type(x,y,actor,cn,list,mission,type)
int	x,y,actor;
int	cn;
struct	qelem *list;
int	mission,type;
{
	struct	nstr_item ni;
	struct	genlist *glp;
	struct	genitem *gp;
	s_char	*block;
	int	dist, size, rel;
	register int z;
	int	mineff;

	switch (type){
		case EF_LAND:	mineff = LAND_MINEFF; break;
		case EF_PLANE:	mineff = PLANE_MINEFF; break;
		case EF_SHIP:	mineff = SHIP_MINEFF; break;
	}

	rel = getrel(getnatp(cn),actor);
	if ((rel == ALLIED) || (rel == NEUTRAL))
		return;

	size = max(sizeof(struct shpstr),sizeof(struct lndstr));
	size = max(size,sizeof(struct plnstr));
	block = malloc(size);

	snxtitem_all(&ni,type);
	while(nxtitem(&ni, block)){
		gp = (struct genitem *)block;
		if (gp->own != cn)
			continue;

		if (gp->effic <= mineff)
			continue;

		if ((gp->mission != mission) && (mission != MI_SINTERDICT))
			continue;

		if ((gp->mission != mission) && (mission == MI_SINTERDICT) &&
			(gp->mission != MI_INTERDICT))
			continue;

		dist = mapdist(x, y, gp->opx, gp->opy);

		if (dist > gp->radius)
			continue;

#ifdef SLOW_WAR
		if ((rel == HOSTILE) ||
			(rel == MOBILIZATION) ||
			(rel == SITZKRIEG)){
			struct	sctstr sect;

			getsect(x,y,(s_char *)&sect);
			/*
			 * If the owner of the unit isn't at war
			 * with the actor, and doesn't own the
			 * sect being acted upon, and isn't the
			 * old owner of that sect, bounce them.
			 */
			if ((sect.sct_type != SCT_WATER) &&
				((sect.sct_own != gp->own) &&
				(sect.sct_oldown != gp->own)) &&
				(mission != MI_AIR_DEFENSE))
				continue;
		}
#endif /* SLOW_WAR */

		glp = (struct genlist *) malloc(sizeof(struct genlist));
		bzero((s_char *)glp,sizeof(struct genlist));
		glp->x = gp->x;
		glp->y = gp->y;
		glp->type = type;
		switch(type){
			case EF_LAND:	glp->cp = (s_char *)&lchr[gp->type];
					break;
			case EF_SHIP:	glp->cp = (s_char *)&mchr[gp->type];
					break;
			case EF_PLANE:	glp->cp = (s_char *)&plchr[gp->type];
					break;
		}
		glp->thing = malloc(size);
		bcopy(block,glp->thing,size);
		insque(&glp->queue, list);
	}
}

find_escorts(x,y,actor,cn,escorts)
int	x,y,actor;
natid	cn;
struct	qelem *escorts;
{
	struct	nstr_item ni;
	struct	plist *plp;
	struct	plnstr plane;
	int	dist;

	snxtitem_all(&ni,EF_PLANE);
	while(nxtitem(&ni, (s_char *)&plane)){
		if (plane.pln_own != cn)
			continue;

		if (plane.pln_mission != MI_ESCORT)
			continue;

		dist = mapdist(x,y,plane.pln_x,plane.pln_y);

		if (dist > ((int)((float)plane.pln_range/2.0)) )
			continue;

		plp = (struct plist *) malloc(sizeof(struct plist));
		bzero((s_char *)plp,sizeof(struct plist));
		plp->pcp = &plchr[plane.pln_type];
		bcopy((s_char *)&plane,(s_char *)&plp->plane,sizeof(struct plnstr));
		insque(&plp->queue, escorts);
	}
}

perform_mission(x,y,actor,list,mission,s)
int	x,y,actor;
struct	qelem *list;
int	mission;
s_char	*s;
{
	s_char	*mission_name(), *nameofitem();
	struct	qelem *qp, bombers, escorts, airp, b, e;
	struct	genlist *glp;
	struct	plist *plp;
	struct	genitem *gp;
	struct	lndstr *lp;
	struct	shpstr *sp;
	struct	sctstr sect;
	struct	lchrstr *lcp;
	struct	mchrstr *mcp;
	s_char	*bestpath();
	int	dam=0,dam2, mission_flags, tech, nap, start=1;
	natid	plane_owner;
	double	landunitgun(), detect, pingrange;
	int	gun,shell;
	double  range2, trange, prb, range, mobcost, hitchance;
	extern	int torpedo_damage;
	
	getsect(x,y,&sect);

	initque(&bombers);
	initque(&escorts);
	initque(&airp);

	for(qp = list->q_forw; qp != list; qp = qp->q_forw){
		glp = (struct genlist *)qp;
		gp = (struct genitem *)glp->thing;
		
		if (glp->type == EF_LAND){
			lp = (struct lndstr *)glp->thing;
			lcp = (struct lchrstr *)glp->cp;

			if (mission == MI_SINTERDICT)
				continue;

			if (mapdist(x,y,lp->lnd_x,lp->lnd_y) > lcp->l_frg)
				continue;

			trange = (double)mapdist(x,y,lp->lnd_x,lp->lnd_y);
			range = techfact((int)lp->lnd_tech,
				(double)lchr[lp->lnd_type].l_frg);
			range2 = (double)roundrange(range);

			if (trange > range2)
				continue;

			if (has_supply(lp)){
				use_supply(lp);
				putland(lp->lnd_uid,lp);
				dam2 = ldround(landunitgun(lp->lnd_type,lp->lnd_effic),1);
				dam += dam2;
				putland(lp->lnd_uid,lp);
				if (sect.sct_type == SCT_WATER)
					nreport(lp->lnd_own,N_SHP_SHELL,actor,1);
				else
					nreport(lp->lnd_own,N_SCT_SHELL,actor,1);
				wu(0,lp->lnd_own,fmt("%s #%d fires at %s %s at %s\n",
					lcp->l_name, lp->lnd_uid,
					cname(cnum), s,
					xyas(x,y,lp->lnd_own)));
				wu(0,cnum,fmt("%s %s #%d fires at you at %s\n",
					cname(lp->lnd_own),
					lcp->l_name, lp->lnd_uid,
					xyas(x,y,cnum)));
			}
		}else if (glp->type == EF_SHIP){
			sp = (struct shpstr *)glp->thing;
			mcp = (struct mchrstr *)glp->cp;

			if (sp->shp_effic < 60)
				continue;
			if (mcp->m_frnge == 0)
				continue;
			if (getvar(V_MILIT, (s_char *)sp, EF_SHIP) < 1)
				continue;
			if ((mcp->m_flags & M_SUB) &&
				(sect.sct_type != SCT_WATER))
				continue;

			trange = (double)mapdist(x,y,sp->shp_x,sp->shp_y);

			if (mission == MI_SINTERDICT){
				if (!(mcp->m_flags & M_SONAR))
					continue;
				range2 = techfact(sp->shp_tech,
					(double)mcp->m_vrnge);
				range2 *= (double)sp->shp_effic / 200.0;
				if (trange > range2)
					continue;
				/* can't look all the time */
				if (chance(0.5))
					continue;
				if (!(mcp->m_flags & M_DCH) && 
					!(mcp->m_flags & M_TORP))
					continue;
			}
			if (mcp->m_flags & M_SUB){
				if (sp->shp_mobil < 0)
					continue;
				gun = getvar(V_GUN,sp,EF_SHIP);
				if (gun < 1)
					continue;
				shell = getvar(V_SHELL,sp,EF_SHIP);
				if (shell < 3)
					shell += supply_commod(sp->shp_x,
						sp->shp_y, I_SHELL,3-shell);
				if (shell < 3)
					continue;
#ifdef NEWSUBS
				range = sp->shp_effic* techfact(sp->shp_tech,
       					((double)mcp->m_frnge)) / 100.0;
#else
				range = sp->shp_effic* techfact(sp->shp_tech,
					2.0) / 100.0;
#endif /* NEWSUBS */

				range2 = (double)roundrange(range);
				if (trange > range)
					continue;

				putvar(V_SHELL,shell-3,sp,EF_SHIP);
				putship(sp->shp_uid,sp);
#ifndef NEWSUBS
				sp->shp_mobil -= 20;
#else
				mobcost = sp->shp_effic * 0.01 * mcp->m_speed;
				mobcost = (480.0/(mobcost +
					techfact(sp->shp_tech, mobcost)));
				mobcost /= 2.0;
				sp->shp_mobil -= mobcost;
#endif /* NEWSUBS */
				putship(sp->shp_uid,sp);
				hitchance = 0.90 / (trange + 1);
				hitchance += ((5.0-(double)mcp->m_visib)
					*3.0)/100.0;
				if (!chance(hitchance))
					continue;
				dam2 = torpedo_damage +
					(random() % torpedo_damage);
				dam += dam2;
				nreport(sp->shp_own,N_TORP_SHIP,actor,1);
				wu(0,sp->shp_own,
					fmt("%s #%d torps at %s\n",
					mcp->m_name,sp->shp_uid,
					xyas(x,y,sp->shp_own)));
				wu(0,cnum,fmt("%s %s #%d torps you at %s\n",
					cname(sp->shp_own), mcp->m_name,
					sp->shp_uid, xyas(x,y,sp->shp_own)));
			}else{
				range = techfact(sp->shp_tech,
					(double)mcp->m_frnge/2.0);
				range2 = (double)roundrange(range);
				if (trange > range2)
					continue;
				gun = getvar(V_GUN, (s_char *)sp, EF_SHIP);
				gun = min(gun,  mcp->m_glim);
				shell = getvar(V_SHELL, (s_char *)sp, EF_SHIP);
				if (shell < gun)
					shell += supply_commod(sp->shp_x,
						sp->shp_y,I_SHELL,gun-shell);
				gun = min(gun, shell);
				gun = min(gun,((float)getvar(V_MILIT,
					(s_char *)sp,EF_SHIP)/2.0));
				if (gun ==0)
					continue;
				gun = max(gun,1);
				dam2 = shelldam(seagun(sp->shp_type,
					sp->shp_effic,gun),160);
				prb = (double)trange / range2;
				prb *= prb;
				if (chance(prb))
					dam2 = (int)((float)dam2/2.0);
				dam += dam2;
				if (sect.sct_type == SCT_WATER)
					nreport(sp->shp_own,N_SHP_SHELL,actor,1);
				else
					nreport(sp->shp_own,N_SCT_SHELL,actor,1);
				if (mission == MI_SINTERDICT)
					wu(0,sp->shp_own,
						fmt("%s #%d fires at %s %s at %s\n",
						mcp->m_name,
						sp->shp_uid,
						cname(cnum), s,
						xyas(x,y,sp->shp_own)));
				else
					wu(0,sp->shp_own,
						fmt("%s #%d fires at %s %s at %s\n",
						mcp->m_name,
						sp->shp_uid,
						cname(cnum), s,
						xyas(x,y,sp->shp_own)));
				wu(0,cnum,fmt("%s %s #%d fires at you at %s\n",
					cname(sp->shp_own), mcp->m_name,
					sp->shp_uid, xyas(x,y,cnum)));
				putvar(V_SHELL, shell-gun,(s_char *)sp, EF_SHIP);
				putship(sp->shp_uid,sp);
			}
		}else if (glp->type == EF_PLANE){
			/* save planes for later */
			plp = (struct plist *)malloc(sizeof(struct plist));
			bzero((s_char *)plp,sizeof(struct plist));
			plp->pcp = (struct plchrstr *)glp->cp;
			bcopy(glp->thing, (s_char *)&plp->plane,
				sizeof(struct plnstr));
			insque(&plp->queue, &bombers);
			plane_owner = plp->plane.pln_own;
		}
	}

	/*
	 * If there are planes performing an 
	 * interdict or support mission, find
	 * some escorts for them, if possible.
	 * Up to 2 per bomber, if possible.
	 */
	find_escorts(x,y,actor,plane_owner,&escorts);
	nap=0;

	if (mission == MI_SINTERDICT)
		mission_pln_sel(&bombers,actor,P_T|P_A,0);
	else
		mission_pln_sel(&bombers,actor,P_T,P_A);
	mission_pln_sel(&escorts,actor,P_ESC|P_F,0);

	for(qp = bombers.q_forw; qp != (&bombers); qp = qp->q_forw){
		plp = (struct plist *)qp;
		if (!find_airport(&airp,plp->plane.pln_x,plp->plane.pln_y))
			add_airport(&airp,plp->plane.pln_x,
				plp->plane.pln_y);
	}

	for(qp = airp.q_forw; qp != (&airp); qp = qp->q_forw){
        	struct	airport *air;
        	s_char	*path;

		air = (struct airport *)qp;
		
		initque(&b);
		initque(&e);

		/* Split off the bombers at this base into b */
		divide(&bombers,&b,air->x,air->y);

		/* Split off the escorts at this base into e */
		divide(&escorts,&e,air->x,air->y);

        	tech = 0;
        	mission_flags = 0;
        	mission_flags |= P_X;           /* stealth (shhh) */
#ifdef CHOPPER_STEALTH
        	mission_flags |= P_H; /* gets turned off if not all choppers */
#endif /* CHOPPER_STEALTH */

		mission_flags = mission_pln_arm(&b,air->x,air->y,'p',0,
			0,mission_flags,&tech);

		if (QEMPTY(&b)){
			continue;
		}

		mission_flags = mission_pln_arm(&e,air->x,air->y,'p',0,
			P_F|P_ESC,mission_flags,&tech);

		path = bestpath(air->x,air->y,x,y,"\0");
		wu(0,air->own,fmt("\nFlying %s mission\n",mission_name(mission)));
		ac_encounter(&b,&e,air->x,air->y,path,mission_flags,&tech,0);

		if (!QEMPTY(&b))
			dam += air_damage(&b,x,y,mission,actor,s);

		if (sect.sct_type == SCT_WATER){
			if (dam > 0)
				nreport(air->own,N_SHP_BOMB,actor,1);
		}else
			if (dam > 0)
				nreport(air->own,N_SCT_BOMB,actor,1);

		pln_put(&b);
		pln_put(&e);
	}

	/* free up all this memory */
	qp=list->q_forw;
	while(qp != list){
		glp = (struct genlist *)qp;
		qp=qp->q_forw;

		free(glp->thing);
		free((s_char *)glp);
	}

	qp=escorts.q_forw;
	while(qp != (&escorts)){
		qp=qp->q_forw;
		free(qp);
	}
	qp=bombers.q_forw;
	while(qp != (&bombers)){
		qp=qp->q_forw;
		free(qp);
	}

	return dam;
}

cando(mission,type)
int	mission, type;
{
	switch (mission){
		case MI_ESCORT:
			if (type == EF_PLANE)
				return 1;
			return 0;
		case MI_AIR_DEFENSE:
			if (type == EF_PLANE)
				return 1;
			return 0;
		case MI_SINTERDICT:
			if ((type == EF_PLANE) || (type == EF_SHIP))
				return 1;
			return 0;
		case MI_INTERDICT:
			return 1;
		case MI_SUPPORT:
			if (type == EF_PLANE)
				return 1;
			return 0;
		case MI_RESERVE:
			if (type == EF_LAND)
				return 1;
			return 0;
	}
}

s_char *nameofitem(gp,type)
struct	genitem *gp;
int	type;
{
	static	s_char buf[80];
	struct	shpstr *sp = (struct shpstr *)gp;
	struct	plnstr *pp = (struct plnstr *)gp;
	struct	lndstr *lp = (struct lndstr *)gp;

	switch(type){
		case EF_SHIP:
#ifdef SHIPNAMES
			sprintf(buf,"%s %s (#%d)", mchr[sp->shp_type].m_name,
				sp->shp_name, sp->shp_uid);
#else
			sprintf(buf,"%s #%d", mchr[sp->shp_type].m_name,
				sp->shp_uid);
#endif /* SHIPNAMES */
			break;
		case EF_PLANE:
			sprintf(buf,"%s #%d", plchr[lp->lnd_type].pl_name,
				pp->pln_uid);
			break;
		case EF_LAND:
			sprintf(buf,"%s #%d", lchr[lp->lnd_type].l_name,
				lp->lnd_uid);
			break;
	}
	return buf;
}

s_char *mission_name(mission)
{
	switch (mission){
		case MI_INTERDICT:	return "an interdiction";
		case MI_SUPPORT:	return "a support";
		case MI_RESERVE:	return "a reserve";
		case MI_ESCORT:		return "an escort";
		case MI_SINTERDICT:	return "a sub interdiction";
		case MI_AIR_DEFENSE:	return "an air defense";
	}
}

show_mission(type,np)
int	type;
struct	nstr_item *np;
{
	int	size, first=1, radius;
	s_char	*block;
	struct	genitem *gp;
	s_char	*mission_name();

	size = max(sizeof(struct lndstr),sizeof(struct plnstr));
	size = max(size,sizeof(struct shpstr));
	block = malloc(size);

	while (nxtitem(np, block)) {
		gp = (struct genitem *)block;
		if (!owner || gp->own == 0)
			continue;
		
		if (first){
			pr(fmt("Thing                         x,y   op-sect rad mission\n"));
			first=0;
		}
		pr(fmt("%-25s", nameofitem(gp,type)));
		pr(fmt(" %7s", xyas(gp->x,gp->y,cnum)));
		if (gp->mission == MI_INTERDICT || gp->mission == MI_SUPPORT ||
			gp->mission == MI_AIR_DEFENSE){
			radius = 999;
			oprange(gp,type,gp->x,gp->y,&radius);
			pr(fmt(" %7s", xyas(gp->opx,gp->opy,cnum)));
			if (radius < gp->radius)
				pr(fmt("  %4d", radius));
			else
				pr(fmt("  %4d", gp->radius));
		}else if (gp->mission == MI_RESERVE){
			struct	sctstr sect;
			int	plus=2;

			getsect(gp->x,gp->y,&sect);
			if ((sect.sct_type == SCT_HEADQ) &&
				(sect.sct_effic >= 60))
				plus++;

			pr(fmt(" %7s", xyas(gp->x,gp->y,cnum)));
			pr(fmt("  %4d", lchr[gp->type].l_rad + plus));
		}else if (gp->mission == MI_ESCORT){
			pr("        ");
			pr(fmt("  %4d", (int)
				((float)((struct plnstr *)block)->pln_range/2.0)
				));
		}else
			pr("              ");
		if (gp->mission)
			pr(fmt(" is on %s mission\n",
				mission_name(gp->mission)));
		else
			pr(fmt(" has no mission.\n"));
	}
}

oprange(gp,type,x,y,radius)
struct	genitem *gp;
int	type;
coord	x,y;
int	*radius;
{
	double	techfact();
	int	range, dist;
	struct	shpstr ship;
	struct	lndstr land;
	struct	plnstr plane;

	switch (type){
		case EF_SHIP:
			getship(gp->uid,&ship);
			range = ldround(techfact(gp->tech,
				mchr[gp->type].m_frnge / 2.0),1);
			dist = mapdist(ship.shp_x,ship.shp_y,x,y);
			break;
		case EF_LAND:
			getland(gp->uid,&land);
			range = ldround(techfact((int)land.lnd_tech,
				(double)lchr[land.lnd_type].l_frg),1);
			dist = mapdist(land.lnd_x,land.lnd_y,x,y);
			break;
		case EF_PLANE:
			getplane(gp->uid,&plane);
			range = ldround((double)plane.pln_range/2.0,1);;
			dist = mapdist(plane.pln_x,plane.pln_y,x,y);
			break;
	}

	if ((*radius) > range)
		*radius = range;

	return range;
}

/*
 *  Remove all planes who cannot go on
 *  the mission from the plane list.
 */
mission_pln_sel(list, actor, wantflags, nowantflags)
	struct	qelem *list;
	int	actor;
	int	wantflags;
	int	nowantflags;
{
	struct	qelem *qp, *next;
	struct	plnstr *pp;
	struct	shpstr ship;
	struct	lndstr land;
	struct	sctstr sect;
	int	range;
	struct	plchrstr *pcp;
	struct	plist *plp;
	register int	x,y,bad,bad1;

	for (qp = list->q_forw; qp != list; qp = next) {
		next = qp->q_forw;
		plp = (struct plist *)qp;
		pp = &plp->plane;
		pcp = plp->pcp;

		if (pp->pln_effic < 40){
			remque(qp);
			free((s_char *)qp);
			continue;
		}

		bad=0;
		bad1=0;
		if (wantflags) {
			for(x=0;x<sizeof(wantflags)*8;x++){
				y=(1<<x);
				if ((wantflags & y) == y)
					if ((pcp->pl_flags & y) != y){
						switch(y){
							case P_F:
							case P_ESC: bad1=2;
								    break;
#if defined(XLIGHT) || defined(SHIPCHOPPERS)
							case P_E:
							case P_L:
							case P_K: bad1=1;
								  break;
							default:  bad=1;
						}
#else
						}
						bad=1;
#endif
					}
			}
			if (bad){
				remque(qp);
				free((s_char *)qp);
				continue;
			}
			if (bad1 == 2){
				if ((pcp->pl_flags &  P_ESC) ||
					(pcp->pl_flags & P_F))
					bad1=0;
			}
#if defined(XLIGHT) || defined(SHIPCHOPPERS)
			if (bad1 == 1){
				if ((pcp->pl_flags &  P_E) ||
					(pcp->pl_flags & P_K) ||
					(pcp->pl_flags & P_L))
					bad1=0;
			}
			if (bad1){
				remque(qp);
				free((s_char *)qp);
				continue;
			}
#endif
		}
		bad=0;
		bad1=0;
		if (nowantflags) {
			for(x=0;x<sizeof(nowantflags)*8;x++){
				y=(1<<x);
				if ((nowantflags & y) == y)
					if ((pcp->pl_flags & y) == y)
						bad=1;
			}
			if (bad){
				remque(qp);
				free((s_char *)qp);
				continue;
			}
		}
		if (pp->pln_ship >= 0) {
			if (!getship(pp->pln_ship, &ship) ||
			    pp->pln_own != actor) {
	shipsunk:
				pp->pln_effic = 0;
				putplane(pp->pln_uid, pp);
				remque(qp);
				free((s_char *)qp);
				continue;
			}
#if defined (SHIPCHOPPERS) || defined (XLIGHT)
			if (!can_be_on_ship(pp->pln_uid,ship.shp_uid)){
				goto shipsunk;
			}
#else
			if ((mchr[ship.shp_type].m_flags & M_FLY) == 0)
				goto shipsunk;
#endif
			if (ship.shp_effic < SHIP_MINEFF){
				goto shipsunk;
			}
			if (ship.shp_effic < 50){
				remque(qp);
				free((s_char *)qp);
				continue;
			}
		}
		if (pp->pln_land >= 0) {
			if (!getland(pp->pln_land, &land) ||
			    (pp->pln_own != actor)){
	landdead:
				pp->pln_effic = 0;
				putplane(pp->pln_uid, pp);
				remque(qp);
				free((s_char *)qp);
				continue;
			}
#ifdef XLIGHT
			if (!(pcp->pl_flags & P_E))
				goto landdead;
#endif /* XLIGHT */
			if (land.lnd_effic < LAND_MINEFF)
				goto landdead;

			if (land.lnd_effic < 50){
				remque(qp);
				free((s_char *)qp);
				continue;
			}

			/* Can't fly off units in ships */
			if (land.lnd_ship >= 0){
				remque(qp);
				free((s_char *)qp);
				continue;
			}
		}
		/*
		 * if not vtol and not at an airport, you lose!
		 */
		if ((pcp->pl_flags & P_V) == 0 && (pp->pln_ship < 0) &&
			(pp->pln_land < 0)) {
			if (!getsect(pp->pln_x, pp->pln_y, &sect) ||
			    sect.sct_type != SCT_AIRPT){
				remque(qp);
				free((s_char *)qp);
				continue;
			}

			if (sect.sct_effic < 40){
				remque(qp);
				free((s_char *)qp);
				continue;
			}
		}

		putplane(pp->pln_uid, pp);
	}
}

/*
 * Arm only the planes at x,y
 *
 */
int
mission_pln_arm(list, x,y, mission, ip, flags, mission_flags, tech)
	struct	qelem *list;
	int	x,y;
	int	mission;
	struct	ichrstr *ip;
	int	flags;
	int	mission_flags;
	int	*tech;
{
	struct	qelem *qp;
	struct	qelem *next;
	struct	plist *plp;

	if (*tech == 0)
		*tech = 9999;
	for (qp = list->q_forw; qp != list; qp = next) {
		next = qp->q_forw;
		plp = (struct plist *) qp;

		if (plp->plane.pln_x != x)
			continue;
		if (plp->plane.pln_y != y)
			continue;

		if (mission_pln_equip(plp, ip, flags, mission) < 0) {
			remque(qp);
			free((s_char *)qp);
			continue;
		}
		if (flags & (P_S|P_I)) {
			if(plp->pcp->pl_flags & P_S)
				mission_flags |= P_S;
			if(plp->pcp->pl_flags & P_I)
				mission_flags |= P_I;
		}
		if (*tech > plp->plane.pln_tech)
			*tech = plp->plane.pln_tech;
#ifdef CHOPPER_STEALTH
		if (!(plp->pcp->pl_flags & P_H))
			/* no stealth on this mission */
			mission_flags &= ~P_H;
#endif /* CHOPPER_STEALTH */
		if (!(plp->pcp->pl_flags & P_X))
			/* no stealth on this mission */
			mission_flags &= ~P_X;
#ifdef ASW_PLANES
		if (!(plp->pcp->pl_flags & P_A)) {
			/* no asw on this mission */
			mission_flags &= ~P_A;
		}
#endif /* ASW_PLANES */
#ifdef MINE_PLANES
		if (!(plp->pcp->pl_flags & P_MINE)) {
			/* no asw on this mission */
			mission_flags &= ~P_MINE;
		}
#endif /* MINE_PLANES */

		/*
		 *	Mob costs for missions are 1/2 normal
		 */
#ifdef MERC
		if ((flags & P_F) || (flags & P_ESC))
			plp->plane.pln_mobil -= (s_char) (min(32 + plp->plane.pln_mobil,(12 * 100 / (s_char) plp->plane.pln_effic))/4);
		else
			plp->plane.pln_mobil -= (s_char) (min(32 + plp->plane.pln_mobil,(20 * 100 / (s_char) plp->plane.pln_effic))/4);
#else
		if ((flags & P_F) || (flags & P_ESC))
			plp->plane.pln_mobil -= 3;
		else
			plp->plane.pln_mobil -= 5;
#endif
	}
	return mission_flags;
}

int
mission_pln_equip(plp, ip, flags, mission)
	struct	plist *plp;
	struct	ichrstr *ip;
	int	flags;
	s_char	mission;
{
	register struct plchrstr *pcp;
	struct	plnstr *pp;
	int	needed;
	struct	lndstr land;
	struct	shpstr ship;
	struct	sctstr sect;
	int	type;
	s_char	*ptr;
	int	item;
	int	rval;
	int	vec[I_MAX+1];

	pp = &plp->plane;
	pcp = plp->pcp;
	if (pp->pln_ship >= 0) {
		getship(pp->pln_ship, &ship);
		type = EF_SHIP;
		ptr = (s_char *) &ship;
	} else
	if (pp->pln_land >= 0) {
		getland(pp->pln_land, &land);
		type = EF_LAND;
		ptr = (s_char *) &land;
	} else {
		getsect(pp->pln_x, pp->pln_y, &sect);
		type = EF_SECTOR;
		ptr = (s_char *) &sect;
	}
	getvec(VT_ITEM, vec, ptr, type);
	if (pcp->pl_fuel > vec[I_PETROL]) {
		return -1;
	}
	vec[I_PETROL] -= pcp->pl_fuel;
	rval = 0;
	if ((flags & P_F) == 0) {
		item = 0;
		needed = 0;
		switch (mission) {
		case 's':
		case 'p':
			item = I_SHELL;
			needed = pcp->pl_load;
			break;
		case 't':
			if ((pcp->pl_flags & P_C) == 0 || ip == 0)
				break;
			item = ip - ichr;
			needed = (pcp->pl_load * 2) / ip->i_lbs;
			break;
		case 'd':
			if ((pcp->pl_flags & P_C) == 0 || ip == 0)
				break;
			item = ip - ichr;
			needed = (pcp->pl_load * 2) / ip->i_lbs;
			break;
		case 'a':
			if ((pcp->pl_flags & (P_V|P_C)) == 0)
				break;
			item = I_MILIT;
			needed = pcp->pl_load / ip->i_lbs;
			break;
		case 'n':
			if (pp->pln_nukeamt == 0)
				rval = -1;
			break;
		default:
			break;
		}
		if (rval < 0 || (item && needed <= 0)) {
			return -1;
		}
		if ((vec[item] < needed) && (item == I_SHELL))
			vec[item] += supply_commod(plp->plane.pln_x,
					plp->plane.pln_y,I_SHELL,needed);
		if (vec[item] < needed) {
			return -1;
		} else {
			vec[item] -= needed;
		}
		if (item == I_SHELL && (mission == 's' || mission == 'p'))
			plp->bombs = needed;
		else
			plp->misc = needed;
	}
		putvec(VT_ITEM, vec, ptr, type);
	if (type == EF_SHIP)
		putship(ship.shp_uid,&ship);
	else if (type == EF_LAND)
		putland(land.lnd_uid,&land);
	else
		putsect(&sect);
	return rval;
}

/*
 *  Return 1 if this x,y pair is in the list
 */
find_airport(airp,x,y)
struct	qelem *airp;
int	x,y;
{
	struct	qelem *qp;
	struct	airport *a;

	for (qp = airp->q_forw; qp != airp; qp = qp->q_forw){
		a = (struct airport *)qp;
		if ((a->x == x) && (a->y == y))
			return 1;
	}

	return 0;
}

add_airport(airp,x,y)
struct	qelem *airp;
int	x,y;
{
	struct	airport *a;
	struct	sctstr sect;

	a = (struct airport *)malloc(sizeof(struct airport));

	a->x = x;
	a->y = y;
	getsect(x,y,&sect);
	a->own = sect.sct_own;

	insque(a,airp);
}

/*
 *  Take all the planes in list 1 that
 *  are at x,y, and put them into list 2.
 */
divide(l1,l2,x,y)
struct	qelem *l1, *l2;
int	x,y;
{
	struct	qelem *qp, *next;
	struct	plist *plp;

	for (qp = l1->q_forw; qp != l1; qp = next){
		next = qp->q_forw;
		plp = (struct plist *)qp;

		if (plp->plane.pln_x != x)
			continue;
		if (plp->plane.pln_y != y)
			continue;

		remque(qp);
		insque(qp,l2);
	}
}

air_damage(bombers,x,y,mission,hurtee,s)
struct	qelem *bombers;
int	x,y,mission;
int	hurtee;
s_char	*s;
{
	struct	qelem *qp;
	struct	plist *plp;
	struct	plnstr *pp;
	struct	sctstr sect;
	int	newdam,dam=0, acc, bombs;

	getsect(x,y,&sect);
	for(qp = bombers->q_forw; qp != bombers; qp = qp->q_forw){
		plp = (struct plist *)qp;
		pp = &plp->plane;

		if ((mission == MI_SINTERDICT) && !(plp->pcp->pl_flags & P_A))
			continue;

		if ((mission == MI_SINTERDICT) &&
			!chance((100.0-(double)plp->pcp->pl_acc)/100.0)){
			wu(0,pp->pln_own,
				fmt("\t%s #%d unable to find %s %s\n",
				plp->pcp->pl_name, pp->pln_uid,
				cname(hurtee), s));
			continue;
		}

		acc = plp->pcp->pl_acc;
		bombs = plp->bombs;
                acc += dchr[sect.sct_type].d_dstr * 2;
                newdam = 0;
                while(bombs--){
                	if (roll(100) > acc)
                                newdam += (roll(8)+6);
                	else
                                newdam += (int)((double)(roll(8)+6)/3.0);
                }
		wu(0,pp->pln_own,
			fmt("\t%s #%d does %d damage to %s %s\n",
			plp->pcp->pl_name, pp->pln_uid, newdam,
			cname(hurtee), s));
		dam += newdam;
	}

	return dam;
}

/*
 * Check to see if anyone hostile to the actor
 * is running an air defense mission on this
 * sector. If so, do air combat
 */
air_defense(x,y,actor,bomb_list,esc_list)
int     x,y,actor;
struct	qelem *bomb_list;
struct	qelem *esc_list;
{
	s_char	*mission_name(), *nameofitem();
	s_char	*path, *bestpath();
	int	dam=0,cn;
	extern	int ismission;
	int	mission_flags, tech, combat=0;
	struct	qelem *qp, interceptors, list, airp, i, empty;
	struct	plist *plp;
	struct	genlist *glp;
	struct	genitem *gp;

	for(cn=0;cn<MAXNOC;cn++){

		initque(&list);
		build_mission_list_type(x,y,actor,cn,&list,MI_AIR_DEFENSE,EF_PLANE);

		if (QEMPTY(&list))
			continue;

		initque(&interceptors);
		for(qp = list.q_forw; qp != (&list); qp = qp->q_forw){
			glp = (struct genlist *)qp;
			gp = (struct genitem *)glp->thing;

			plp = (struct plist *)malloc(sizeof(struct plist));
			bzero((s_char *)plp,sizeof(struct plist));
			plp->pcp = (struct plchrstr *)glp->cp;
			bcopy(glp->thing, (s_char *)&plp->plane,
				sizeof(struct plnstr));
			insque(&plp->queue, &interceptors);
		}

		mission_pln_sel(&interceptors,cn,P_F,0);

		if (QEMPTY(&interceptors))
			continue;

		initque(&airp);
		for(qp=interceptors.q_forw;qp!=(&interceptors);qp=qp->q_forw){
			plp = (struct plist *)qp;
			if (!find_airport(&airp,plp->plane.pln_x,
				plp->plane.pln_y))
				add_airport(&airp,plp->plane.pln_x,
					plp->plane.pln_y);
		}

		for(qp = airp.q_forw; qp != (&airp); qp = qp->q_forw){
        		struct	airport *air;

			air = (struct airport *)qp;
		
			initque(&i);

			/* Split off the interceptors at this base into i */
			divide(&interceptors,&i,air->x,air->y);

        		tech = 0;
        		mission_flags = 0;
        		mission_flags |= P_X;           /* stealth (shhh) */
#ifdef CHOPPER_STEALTH
			/* gets turned off if not all choppers */
        		mission_flags |= P_H;
#endif /* CHOPPER_STEALTH */

			mission_flags = mission_pln_arm(&i,air->x,air->y,'r',0,
				P_F,mission_flags,&tech);

			if (QEMPTY(&i)){
				continue;
			}

			path = bestpath(air->x,air->y,x,y,"\0");
			wu(0,air->own,fmt("\nFlying %s mission\n",
				mission_name(MI_AIR_DEFENSE)));
			initque(&empty);
			ac_encounter(&i,&empty,air->x,air->y,
				path,mission_flags,&tech,1);

			if (QEMPTY(&i))
				continue;

			combat = 0;
			if (!QEMPTY(esc_list)){
				pr(fmt("\n%s air defense planes intercept!\n",
					cname(cn)));
				ac_airtoair(esc_list,&i,air->own);
				combat = 1;
			}
			if (!QEMPTY(bomb_list)){
				if (!combat)
					pr(fmt("\n%s air defense planes intercept!\n",
						cname(cn)));
				ac_airtoair(bomb_list,&i,air->own);
			}

			pln_put(&i);
		}
	}
	return dam;
}
